/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.ui.internal.util;

public class PathUtils {
    public static final String PATH_SEPARATOR = "/";
    public static final String EMPTY_RELATIVE_PATH = "";

    public static String getParentFolderPath(String path) {
        int idx = (path = PathUtils.removeTrailingSlash(path)).lastIndexOf(PATH_SEPARATOR);
        if (idx == -1) {
            return PATH_SEPARATOR;
        }
        String result = path.substring(0, idx);
        if (result.equals(EMPTY_RELATIVE_PATH)) {
            result = PATH_SEPARATOR;
        }
        return result;
    }

    public static String removeTrailingSlash(String path) {
        if (path.endsWith(PATH_SEPARATOR)) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static String getBaseName(String path) {
        int index = (path = PathUtils.removeTrailingSlash(path)).lastIndexOf(PATH_SEPARATOR);
        if (index == -1) {
            return path;
        }
        return path.substring(index + 1);
    }

    public static String appendPath(String path, String name) {
        if (name.equals(EMPTY_RELATIVE_PATH)) {
            return path;
        }
        if (path.equals(EMPTY_RELATIVE_PATH)) {
            return name;
        }
        String result = path;
        if (result.endsWith(PATH_SEPARATOR)) {
            if (name.startsWith(PATH_SEPARATOR)) {
                name = name.substring(1);
            }
        } else if (!name.startsWith(PATH_SEPARATOR)) {
            result = String.valueOf(result) + PATH_SEPARATOR;
        }
        return String.valueOf(result) + name;
    }

    public static String getFirstSegment(String path) {
        int start = path.startsWith(PATH_SEPARATOR) ? 1 : 0;
        if (path.length() <= start) {
            return null;
        }
        int i = path.indexOf(PATH_SEPARATOR, start);
        if (i == -1) {
            return path.substring(start);
        }
        return path.substring(start, i);
    }

    public static String ensureRelative(String path, boolean withTrailingSlash) {
        if (path.startsWith(PATH_SEPARATOR)) {
            path = path.substring(1);
        }
        if (path.length() == 0) {
            return EMPTY_RELATIVE_PATH;
        }
        if (!withTrailingSlash) {
            path = PathUtils.removeTrailingSlash(path);
        } else if (withTrailingSlash && !path.endsWith(PATH_SEPARATOR)) {
            path = String.valueOf(path) + PATH_SEPARATOR;
        }
        return path;
    }

    public static String[] getSegments(String path) {
        return PathUtils.getSegments(path, PATH_SEPARATOR);
    }

    public static String[] getSegments(String path, String separator) {
        String[] segments = path.startsWith(separator) ? path.substring(1).split(separator) : path.split(separator);
        return segments;
    }

    public static boolean isParentFolder(String parentPath, String childPath) {
        if ((parentPath = PathUtils.ensureRelative(parentPath, true)).equals(EMPTY_RELATIVE_PATH) || parentPath.equals(PATH_SEPARATOR)) {
            return true;
        }
        childPath = PathUtils.ensureRelative(childPath, true);
        return childPath.startsWith(parentPath);
    }

    public static String getRelativePath(String parentPath, String childPath) {
        parentPath = PathUtils.ensureRelative(parentPath, false);
        childPath = PathUtils.ensureRelative(childPath, false);
        if (parentPath.equals(EMPTY_RELATIVE_PATH) || parentPath.equals(PATH_SEPARATOR)) {
            return childPath;
        }
        if (parentPath.length() == childPath.length()) {
            return EMPTY_RELATIVE_PATH;
        }
        return PathUtils.ensureRelative(childPath.substring(parentPath.length()), false);
    }

    public static String normalizePath(String path, boolean withLeadingSlash, boolean withTrailingSlash) {
        if (!withLeadingSlash) {
            if (path.startsWith(PATH_SEPARATOR)) {
                path = path.substring(1);
            }
            if (path.length() == 0) {
                return EMPTY_RELATIVE_PATH;
            }
        } else if (withLeadingSlash) {
            if (!path.startsWith(PATH_SEPARATOR)) {
                path = PATH_SEPARATOR + path;
            }
            if (path.equals(PATH_SEPARATOR)) {
                return path;
            }
        }
        if (!withTrailingSlash) {
            path = PathUtils.removeTrailingSlash(path);
        } else if (withTrailingSlash && !path.endsWith(PATH_SEPARATOR)) {
            path = String.valueOf(path) + PATH_SEPARATOR;
        }
        return path;
    }

    public static String getNextSegment(int start, String path) {
        if (start >= path.length()) {
            return null;
        }
        int end = path.indexOf(47, start);
        if (end == start) {
            return PathUtils.getNextSegment(start + 1, path);
        }
        String segment = end == -1 ? path.substring(start) : path.substring(start, end);
        if (segment.length() == 0) {
            return null;
        }
        return segment;
    }

    public static boolean isPathsEquals(String path1, String path2) {
        return PathUtils.normalizePath(path1, false, false).equals(PathUtils.normalizePath(path2, false, false));
    }

    public static boolean isParentUrl(String url, String url2) {
        return PathUtils.isParentFolder(url, url2);
    }

    public static boolean isEmptyPath(String path) {
        return path.length() == 0 || path.equals(PATH_SEPARATOR);
    }

    public static String getString(String[] segments) {
        return com.ibm.team.filesystem.client.internal.utils.PathUtils.getString((String[])segments);
    }
}

