/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.ui.internal.compare;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.rcp.core.internal.resources.ResourceUtil;
import com.ibm.team.filesystem.rcp.ui.internal.Messages;
import com.ibm.team.filesystem.rcp.ui.internal.compare.AbstractCompareEditorInput;
import com.ibm.team.filesystem.rcp.ui.internal.compare.CompareFilePropertiesState;
import com.ibm.team.filesystem.rcp.ui.internal.compare.FileStorageTypedElement;
import com.ibm.team.filesystem.rcp.ui.internal.compare.InputStreamProviderTypedElement;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.common.IRemoteFunction;
import com.ibm.team.repository.rcp.ui.internal.viewers.ConstantFunction;
import java.io.IOException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.internal.BufferedResourceNode;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalFileCompareEditorInput
extends AbstractCompareEditorInput {
    private IShareable shareable;
    private IRemoteFunction<FileState> rightFunction;
    private IRemoteFunction<FileState> ancestorFunction;

    public LocalFileCompareEditorInput(IShareable left, FileState ancestor, FileState right, boolean isExternal) {
        this(left, (IRemoteFunction<FileState>)(ancestor == null ? null : new ConstantFunction((Object)ancestor)), (IRemoteFunction<FileState>)new ConstantFunction((Object)right), isExternal);
    }

    public LocalFileCompareEditorInput(IShareable left, IRemoteFunction<FileState> right, boolean isExternal) {
        this(left, null, right, isExternal);
    }

    public LocalFileCompareEditorInput(IShareable left, IRemoteFunction<FileState> ancestor, IRemoteFunction<FileState> right, boolean isExternal) {
        super(new CompareConfiguration(), isExternal);
        this.shareable = left;
        this.rightFunction = right;
        this.ancestorFunction = ancestor;
    }

    public String getTitle() {
        if (this.shareable != null) {
            return this.shareable.getLocalPath().lastSegment();
        }
        return super.getTitle();
    }

    @Override
    public boolean canRunAsJob() {
        return true;
    }

    @Override
    protected AbstractCompareEditorInput.TypedElementAndData computeLeft(IProgressMonitor monitor) throws CoreException, TeamRepositoryException, IOException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        IEncodedStreamContentAccessor element = null;
        if (this.shareable == null) {
            element = InputStreamProviderTypedElement.createTypedElement(FileState.getDeletedState((IItemType)IFileItem.ITEM_TYPE, null), (IProgressMonitor)progress.newChild(5));
        } else {
            Object o;
            ResourceType resourceType = this.shareable.getResourceType((IProgressMonitor)progress.newChild(1));
            if (resourceType == null) {
                element = InputStreamProviderTypedElement.createTypedElement(FileState.getDeletedState((IItemType)IFileItem.ITEM_TYPE, null), (IProgressMonitor)progress.newChild(5));
            } else if (resourceType == ResourceType.FILE && (o = this.shareable.getAdapter(IResource.class)) instanceof IFile) {
                IFile file = (IFile)o;
                final String localEncoding = ResourceUtil.getEncoding((IFile)file);
                element = new BufferedResourceNode((IResource)file){

                    public String getCharset() {
                        return localEncoding;
                    }
                };
            }
            if (element == null) {
                element = FileStorageTypedElement.create(this.shareable, (IProgressMonitor)progress.newChild(1));
            }
        }
        String label = null;
        boolean editable = false;
        if (element != null && element instanceof IEditableContent) {
            IEditableContent editableContent = (IEditableContent)element;
            editable = editableContent.isEditable();
        }
        label = editable ? NLS.bind((String)Messages.LocalFileCompareEditorInput_0, (Object)element.getName()) : NLS.bind((String)Messages.LocalFileCompareEditorInput_2, (Object)element.getName());
        return new AbstractCompareEditorInput.TypedElementAndData((ITypedElement)element, label, this.shareable);
    }

    @Override
    protected AbstractCompareEditorInput.TypedElementAndData computeAncestor(IProgressMonitor monitor) throws CoreException, TeamRepositoryException, IOException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        FileLineDelimiter localLineDelimeter = null;
        if (this.shareable != null) {
            localLineDelimeter = this.shareable.getLineDelimiter((IProgressMonitor)progress.newChild(1));
        }
        InputStreamProviderTypedElement element = null;
        FileState fileState = null;
        if (this.ancestorFunction != null) {
            fileState = (FileState)this.ancestorFunction.compute((IProgressMonitor)progress.newChild(1));
            element = InputStreamProviderTypedElement.createTypedElement(fileState, localLineDelimeter, (IProgressMonitor)progress.newChild(1));
        }
        String label = null;
        return new AbstractCompareEditorInput.TypedElementAndData(element, label, fileState);
    }

    @Override
    protected AbstractCompareEditorInput.TypedElementAndData computeRight(IProgressMonitor monitor) throws CoreException, TeamRepositoryException, IOException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        FileLineDelimiter localLineDelimeter = null;
        if (this.shareable != null) {
            localLineDelimeter = this.shareable.getLineDelimiter((IProgressMonitor)progress.newChild(1));
        }
        FileState fileState = (FileState)this.rightFunction.compute((IProgressMonitor)progress.newChild(1));
        InputStreamProviderTypedElement element = InputStreamProviderTypedElement.createTypedElement(fileState, localLineDelimeter, (IProgressMonitor)progress.newChild(1));
        String label = fileState.isDeleted() ? Messages.LocalFileCompareEditorInput_1 : NLS.bind((String)Messages.LocalFileCompareEditorInput_2, (Object)element.getName());
        return new AbstractCompareEditorInput.TypedElementAndData((ITypedElement)element, label, fileState);
    }

    @Override
    protected CompareFilePropertiesState createFilePropertyState(AbstractCompareEditorInput.TypedElementAndData left, AbstractCompareEditorInput.TypedElementAndData right, AbstractCompareEditorInput.TypedElementAndData ancestor, IProgressMonitor monitor) throws FileSystemClientException {
        return new CompareFilePropertiesState(left.getShareable(), right.getFileState(), monitor);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.ancestorFunction == null ? 0 : this.ancestorFunction.hashCode());
        result = 31 * result + (this.rightFunction == null ? 0 : this.rightFunction.hashCode());
        result = 31 * result + (this.shareable == null ? 0 : this.shareable.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LocalFileCompareEditorInput other = (LocalFileCompareEditorInput)obj;
        if (this.ancestorFunction == null ? other.ancestorFunction != null : !this.ancestorFunction.equals(other.ancestorFunction)) {
            return false;
        }
        if (this.rightFunction == null ? other.rightFunction != null : !this.rightFunction.equals(other.rightFunction)) {
            return false;
        }
        return !(this.shareable == null ? other.shareable != null : !this.shareable.equals(other.shareable));
    }
}

