/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.ui.internal.compare;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.rcp.core.internal.CoreShareablesUtil;
import com.ibm.team.filesystem.rcp.core.internal.resources.ResourceUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.compare.BufferedContent;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.IModificationDate;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.swt.graphics.Image;

public class FileStorageTypedElement
extends BufferedContent
implements IEncodedStreamContentAccessor,
ITypedElement,
IEditableContent,
IModificationDate {
    private final IFileStorage file;
    private final String encoding;
    private ResourceType type;
    private String target;

    protected FileStorageTypedElement(IFileStorage fileStorage, String encoding, ResourceType type, String target) {
        this.file = fileStorage;
        this.encoding = encoding;
        this.type = type;
        this.target = target;
    }

    public static FileStorageTypedElement create(IShareable shareable, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        IFileStorage fileStorage = CoreShareablesUtil.getFileStorage((IShareable)shareable);
        ResourceType type = shareable.getResourceType((IProgressMonitor)sub.newChild(1));
        String encoding = ResourceUtil.getEncoding((IFileStorage)fileStorage, (IProgressMonitor)sub.newChild(1));
        String target = null;
        if (type == ResourceType.SYMBOLIC_LINK) {
            target = fileStorage.getTarget((IProgressMonitor)sub.newChild(1));
        }
        return new FileStorageTypedElement(fileStorage, encoding, type, target);
    }

    protected InputStream createStream() throws CoreException {
        if (this.type == ResourceType.SYMBOLIC_LINK) {
            return new ByteArrayInputStream(this.target.getBytes());
        }
        return this.file.getContents();
    }

    public String getCharset() throws CoreException {
        return this.encoding;
    }

    public Image getImage() {
        if (this.type == ResourceType.FOLDER) {
            return CompareUI.getImage((String)"FOLDER");
        }
        Path path = new Path(this.getName());
        if (path.getFileExtension() == null) {
            return null;
        }
        return CompareUI.getImage((String)path.getFileExtension());
    }

    public String getName() {
        return this.file.getName();
    }

    public String getType() {
        String fileExtension;
        if (this.type == ResourceType.FOLDER) {
            return "FOLDER";
        }
        if (this.type == ResourceType.FILE && (fileExtension = new Path(this.getName()).getFileExtension()) != null) {
            return fileExtension;
        }
        return "???";
    }

    public boolean isEditable() {
        return this.type == ResourceType.FILE;
    }

    public ITypedElement replace(ITypedElement dest, ITypedElement src) {
        throw new UnsupportedOperationException();
    }

    public long getModificationDate() {
        return this.file.getModificationStamp();
    }

    public void commit(IProgressMonitor monitor) throws FileSystemClientException {
        byte[] content = this.getContent();
        ByteArrayInputStream stream = new ByteArrayInputStream(content);
        this.file.setContents((InputStream)stream, false, monitor);
    }
}

