/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.ui.internal.compare;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.common.changemodel.FileChange;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.rcp.ui.internal.Messages;
import com.ibm.team.filesystem.rcp.ui.internal.compare.AbstractCompareEditorInput;
import com.ibm.team.filesystem.rcp.ui.internal.compare.CompareFilePropertiesState;
import com.ibm.team.filesystem.rcp.ui.internal.compare.FileStateComputer;
import com.ibm.team.filesystem.rcp.ui.internal.compare.InputStreamProviderTypedElement;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.common.IRemoteFunction;
import com.ibm.team.repository.rcp.ui.internal.viewers.ConstantFunction;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.internal.util.StateId;
import java.io.IOException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileChangeEditorInput
extends AbstractCompareEditorInput {
    private String leftLabel = null;
    private String rightLabel = null;
    private IRemoteFunction<FileState> leftFunction;
    private IRemoteFunction<FileState> rightFunction;
    private String leftFilename;
    private String rightFilename;

    protected FileChangeEditorInput(IRemoteFunction<FileState> left, IRemoteFunction<FileState> right, String leftFilename, String rightFilename, boolean isExternal) {
        super(new CompareConfiguration(), isExternal);
        this.leftFunction = left;
        this.rightFunction = right;
        this.leftFilename = leftFilename;
        this.rightFilename = rightFilename;
    }

    public static FileChangeEditorInput createFrom(ITeamRepository repo, StateId<IVersionable> left, IPath leftPath, StateId<IVersionable> right, IPath rightPath) {
        return FileChangeEditorInput.createFrom(repo, left, FileChangeEditorInput.getFilename(leftPath), right, FileChangeEditorInput.getFilename(rightPath), false);
    }

    public static FileChangeEditorInput createFrom(ITeamRepository repo, StateId<IVersionable> left, String leftFilename, StateId<IVersionable> right, String rightFilename, boolean isExternal) {
        FileStateComputer comp = new FileStateComputer(repo, left, right);
        return FileChangeEditorInput.createFrom(comp.getLeft(), comp.getRight(), leftFilename, rightFilename, false);
    }

    public static String getFilename(IPath path) {
        String result = path.lastSegment();
        if (result == null) {
            return Messages.FileChangeEditorInput_0;
        }
        return result;
    }

    public static FileChangeEditorInput createFrom(IRemoteFunction<FileState> left, IRemoteFunction<FileState> right, String leftFilename, String rightFilename, boolean isExternal) {
        return new FileChangeEditorInput(left, right, leftFilename, rightFilename, isExternal);
    }

    public static FileChangeEditorInput createFrom(FileState left, FileState right, boolean isExternal) {
        return FileChangeEditorInput.createFrom((IRemoteFunction<FileState>)new ConstantFunction((Object)left), (IRemoteFunction<FileState>)new ConstantFunction((Object)right), FileChangeEditorInput.getName(left), FileChangeEditorInput.getName(right), isExternal);
    }

    public static FileChangeEditorInput createFrom(FileChange theChange) {
        return FileChangeEditorInput.createFrom(theChange.getFinal(), theChange.getInitial(), false);
    }

    public String getTitle() {
        String beforeName = this.rightFilename;
        String afterName = this.leftFilename;
        boolean sameFile = beforeName.equals(afterName);
        if (sameFile) {
            return afterName;
        }
        return NLS.bind((String)Messages.FileChangeEditorInput_1, (Object)beforeName, (Object)afterName);
    }

    public void setLabels(String leftLabel, String rightLabel) {
        this.leftLabel = leftLabel;
        this.rightLabel = rightLabel;
    }

    public static String getExtension(FileState state) {
        return state.getPath().getFileExtension();
    }

    public static String getName(FileState state) {
        String title = state.getPath().getName();
        if (state.isDeleted()) {
            title = Messages.FileChangeEditorInput_4;
        }
        if (title == null) {
            return Messages.FileChangeEditorInput_5;
        }
        return title;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.leftFunction == null ? 0 : this.leftFunction.hashCode());
        result = 31 * result + (this.rightFunction == null ? 0 : this.rightFunction.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileChangeEditorInput other = (FileChangeEditorInput)obj;
        if (this.leftFunction == null ? other.leftFunction != null : !this.leftFunction.equals(other.leftFunction)) {
            return false;
        }
        return !(this.rightFunction == null ? other.rightFunction != null : !this.rightFunction.equals(other.rightFunction));
    }

    @Override
    public boolean canRunAsJob() {
        return true;
    }

    @Override
    protected AbstractCompareEditorInput.TypedElementAndData computeLeft(IProgressMonitor monitor) throws CoreException, TeamRepositoryException, IOException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        FileState fileState = (FileState)this.leftFunction.compute((IProgressMonitor)progress.newChild(1));
        InputStreamProviderTypedElement element = InputStreamProviderTypedElement.createTypedElement(fileState, (IProgressMonitor)progress.newChild(1));
        String label = this.leftLabel == null ? element.getName() : NLS.bind((String)Messages.FileChangeEditorInput_2, (Object)element.getName(), (Object)this.leftLabel);
        return new AbstractCompareEditorInput.TypedElementAndData((ITypedElement)element, label, fileState);
    }

    @Override
    protected AbstractCompareEditorInput.TypedElementAndData computeAncestor(IProgressMonitor monitor) throws CoreException, TeamRepositoryException, IOException {
        return new AbstractCompareEditorInput.TypedElementAndData();
    }

    @Override
    protected AbstractCompareEditorInput.TypedElementAndData computeRight(IProgressMonitor monitor) throws CoreException, TeamRepositoryException, IOException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        FileState fileState = (FileState)this.rightFunction.compute((IProgressMonitor)progress.newChild(1));
        InputStreamProviderTypedElement element = InputStreamProviderTypedElement.createTypedElement(fileState, (IProgressMonitor)progress.newChild(1));
        String label = this.rightLabel == null ? element.getName() : NLS.bind((String)Messages.FileChangeEditorInput_2, (Object)element.getName(), (Object)this.rightLabel);
        return new AbstractCompareEditorInput.TypedElementAndData((ITypedElement)element, label, fileState);
    }

    @Override
    protected CompareFilePropertiesState createFilePropertyState(AbstractCompareEditorInput.TypedElementAndData left, AbstractCompareEditorInput.TypedElementAndData right, AbstractCompareEditorInput.TypedElementAndData ancestor, IProgressMonitor monitor) throws FileSystemClientException {
        return new CompareFilePropertiesState(left.getFileState(), right.getFileState());
    }
}

