/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.ui.internal.compare;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.operations.ApplyAcceptedOperation;
import com.ibm.team.filesystem.client.internal.operations.MarkAsMergedOperation;
import com.ibm.team.filesystem.client.operations.ApplyAcceptedDilemmaHandler;
import com.ibm.team.filesystem.client.operations.AutoResolveConflictsDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IAutoResolveConflictsOperation;
import com.ibm.team.filesystem.client.operations.IFailedAutoResolveRequest;
import com.ibm.team.filesystem.client.operations.MarkAsMergedDilemmaHandler;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.filesystem.common.ILogicalConflictReport;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentConflictUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IConflictItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.resources.ResourceUtil;
import com.ibm.team.filesystem.rcp.ui.internal.ImagePool;
import com.ibm.team.filesystem.rcp.ui.internal.Messages;
import com.ibm.team.filesystem.rcp.ui.internal.compare.AbstractCompareEditorInput;
import com.ibm.team.filesystem.rcp.ui.internal.compare.CompareFilePropertiesState;
import com.ibm.team.filesystem.rcp.ui.internal.compare.FileStorageTypedElement;
import com.ibm.team.filesystem.rcp.ui.internal.compare.InputStreamProviderTypedElement;
import com.ibm.team.filesystem.rcp.ui.internal.util.StandardAutoResolveDilemmaHandler;
import com.ibm.team.filesystem.rcp.ui.internal.util.WarnApplyAcceptedUser;
import com.ibm.team.filesystem.rcp.ui.internal.util.WarnResolveAsMergedUser;
import com.ibm.team.jface.OverlayIcon;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IItemConflictReport;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.internal.BufferedResourceNode;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class ConflictCompareEditorInput
extends AbstractCompareEditorInput
implements IResourceChangeListener {
    private IConflictItem conflict;
    private IFile localFile;
    private Image conflictsImage;
    private boolean runningAutoResolve;

    public ConflictCompareEditorInput(IConflictItem conflict, boolean isExternal) {
        this(new CompareConfiguration(), conflict, null, isExternal);
    }

    public ConflictCompareEditorInput(CompareConfiguration compareConfiguration, IConflictItem conflict, IWorkbenchPage page, boolean isExternal) {
        super(compareConfiguration, isExternal);
        this.conflict = conflict;
        this.setPage(page);
    }

    public IConflictItem getConflictedItem() {
        return this.conflict;
    }

    public String getTitle() {
        return this.conflict.getName(false);
    }

    protected String getFileName() {
        return this.getTitle();
    }

    public void contentsCreated() {
        if (this.localFile != null) {
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        }
        super.contentsCreated();
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (this.localFile != null) {
            Shell shell;
            IResourceDelta delta = event.getDelta();
            if (delta != null) {
                delta = delta.findMember(this.localFile.getFullPath());
            }
            if (delta != null && ((delta.getKind() & 3) > 0 || (delta.getKind() & 4) > 0 && (delta.getFlags() & 0x40100) > 0) && (shell = this.getShell()) != null && !shell.isDisposed()) {
                shell.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        ConflictCompareEditorInput.this.fireInputChange();
                    }
                });
            }
        }
    }

    protected ITypedElement createLeftElement(IShareable shareable, IProgressMonitor monitor) throws CoreException, IOException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        IEncodedStreamContentAccessor element = null;
        if (shareable == null) {
            element = InputStreamProviderTypedElement.createTypedElement(FileState.getDeletedState((IItemType)IFileItem.ITEM_TYPE, null), (IProgressMonitor)progress.newChild(5));
        } else {
            IResource resource;
            ResourceType resourceType = shareable.getResourceType((IProgressMonitor)progress.newChild(1));
            if (resourceType == null) {
                element = InputStreamProviderTypedElement.createTypedElement(FileState.getDeletedState((IItemType)IFileItem.ITEM_TYPE, null), (IProgressMonitor)progress.newChild(5));
            } else if (resourceType == ResourceType.FILE && (resource = (IResource)shareable.getAdapter(IResource.class)) instanceof IFile) {
                this.localFile = (IFile)resource;
                element = this.createLeftElement(this.localFile);
            }
            if (element == null) {
                element = FileStorageTypedElement.create(shareable, monitor);
            }
        }
        return element;
    }

    protected ITypedElement createLeftElement(IFile localFile) throws CoreException {
        final String localEncoding = ResourceUtil.getEncoding((IFile)localFile);
        return new BufferedResourceNode((IResource)localFile){

            public String getCharset() {
                return localEncoding;
            }
        };
    }

    protected AbstractCompareEditorInput.TypedElementAndData computeLeft(IProgressMonitor monitor) throws CoreException, IOException {
        String label;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        IShareable shareable = ComponentSyncUtil.findShareable((IConflictItem)this.conflict, (boolean)true, (IProgressMonitor)progress.newChild(1));
        ITypedElement element = this.createLeftElement(shareable, (IProgressMonitor)progress.newChild(1));
        String name = this.getFileName();
        boolean isEvilTwin = this.isEvilTwin(shareable, (IProgressMonitor)progress.newChild(1));
        if (element == null) {
            label = Messages.SimpleConflictCompareEditorInput_13;
            if (shareable != null && shareable.getResourceType((IProgressMonitor)progress.newChild(1)) == ResourceType.FOLDER && isEvilTwin) {
                label = NLS.bind((String)Messages.SimpleConflictCompareEditorInput_12, (Object)name);
            }
        } else {
            boolean editable = false;
            if (element instanceof IEditableContent) {
                IEditableContent editableContent = (IEditableContent)element;
                editable = editableContent.isEditable();
            }
            label = editable ? (isEvilTwin ? NLS.bind((String)Messages.SimpleConflictCompareEditorInput_10, (Object)name) : NLS.bind((String)Messages.SimpleConflictCompareEditorInput_11, (Object)name)) : (isEvilTwin ? NLS.bind((String)Messages.ConflictCompareEditorInput_DIFFERENT_LOCATION_READ_ONLY, (Object)name) : NLS.bind((String)Messages.LocalFileCompareEditorInput_2, (Object)name));
        }
        return new AbstractCompareEditorInput.TypedElementAndData(element, label, shareable);
    }

    protected AbstractCompareEditorInput.TypedElementAndData computeRight(IProgressMonitor monitor) throws CoreException, TeamRepositoryException, IOException {
        return this.compute(true, monitor);
    }

    protected AbstractCompareEditorInput.TypedElementAndData computeAncestor(IProgressMonitor monitor) throws CoreException, TeamRepositoryException, IOException {
        return this.compute(false, monitor);
    }

    private AbstractCompareEditorInput.TypedElementAndData compute(boolean right, IProgressMonitor monitor) throws CoreException, TeamRepositoryException, IOException {
        IVersionableHandle versionableHandle;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        IItemConflictReport conflictReport = this.conflict.getItemConflictReport();
        ITeamRepository repo = this.conflict.getOutgoingActivitySource().getModel().teamRepository();
        String name = this.getFileName();
        int index = name != null ? name.lastIndexOf(46) : -1;
        String extension = index >= 0 && index < name.length() ? name.substring(index + 1) : null;
        InputStreamProviderTypedElement element = null;
        IFileItem fileItem = null;
        IVersionableHandle iVersionableHandle = versionableHandle = right ? conflictReport.getProposedContributorState() : conflictReport.getCommonAncestorState();
        if (versionableHandle instanceof IFileItemHandle) {
            IFileItemHandle handle = (IFileItemHandle)versionableHandle;
            fileItem = (IFileItem)SCMPlatform.getWorkspaceManager((ITeamRepository)repo).versionableManager().fetchCompleteState((IVersionableHandle)handle, (IProgressMonitor)progress.newChild(1));
            element = InputStreamProviderTypedElement.createTypedElement(repo, fileItem, name, extension, (IProgressMonitor)progress.newChild(1));
        } else if (versionableHandle instanceof ISymbolicLinkHandle) {
            ISymbolicLinkHandle symbolicLinkHandle = (ISymbolicLinkHandle)versionableHandle;
            ISymbolicLink symbolicLink = (ISymbolicLink)SCMPlatform.getWorkspaceManager((ITeamRepository)repo).versionableManager().fetchCompleteState((IVersionableHandle)symbolicLinkHandle, monitor);
            element = InputStreamProviderTypedElement.createTypedElement(repo, symbolicLink, name, extension, (IProgressMonitor)progress.newChild(1));
        }
        String label = null;
        if (right) {
            label = element != null ? NLS.bind((String)Messages.SimpleConflictCompareEditorInput_14, (Object)name, (Object)this.conflict.getOutgoingActivitySource().getWorkspace().getName()) : Messages.SimpleConflictCompareEditorInput_15;
        } else if (element != null) {
            label = NLS.bind((String)Messages.SimpleConflictCompareEditorInput_16, (Object)name);
        }
        return new AbstractCompareEditorInput.TypedElementAndData(element, label, fileItem);
    }

    protected CompareFilePropertiesState createFilePropertyState(AbstractCompareEditorInput.TypedElementAndData left, AbstractCompareEditorInput.TypedElementAndData right, AbstractCompareEditorInput.TypedElementAndData ancestor, IProgressMonitor monitor) throws FileSystemClientException {
        return new CompareFilePropertiesState(left.getShareable(), right.getFileItem(), ancestor.getFileItem(), monitor);
    }

    protected void createContents2(Composite top) {
        if (this.conflict.getItem() instanceof ISymbolicLinkHandle) {
            Composite resolveTrim = this.createResolveTrim(top);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)resolveTrim);
        } else if (!this.isExternal()) {
            Composite mergeTrim = this.createMergeTrim(top);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)mergeTrim);
        }
        super.createContents2(top);
    }

    protected Composite createResolveTrim(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.createConflictsImage(composite);
        Label label = new Label(composite, 64);
        label.setText(Messages.ConflictCompareEditorInput_SYMBOLIC_LINK_CONFLICT);
        GridDataFactory.defaultsFor((Control)label).grab(true, false).applyTo((Control)label);
        Button resolveMineButton = new Button(composite, 8);
        resolveMineButton.setText(Messages.ConflictCompareEditorInput_RESOLVE_WITH_MINE);
        resolveMineButton.setToolTipText(Messages.ConflictCompareEditorInput_RESOLVE_WITH_MINE_TOOLTIP);
        resolveMineButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConflictCompareEditorInput.this.resolveWithMine();
            }
        });
        Button resolveProposeButton = new Button(composite, 8);
        resolveProposeButton.setText(Messages.ConflictCompareEditorInput_RESOLVE_WITH_PROPOSED);
        resolveProposeButton.setToolTipText(Messages.ConflictCompareEditorInput_RESOLVE_WITH_PROPOSED_TOOLTIP);
        resolveProposeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConflictCompareEditorInput.this.resolveWithProposed();
            }
        });
        Point margins = LayoutConstants.getMargins();
        GridLayoutFactory.fillDefaults().margins(margins.x / 2, margins.y / 2).numColumns(4).generateLayout(composite);
        return composite;
    }

    protected Composite createMergeTrim(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.createConflictsImage(composite);
        Label label = new Label(composite, 64);
        label.setText(Messages.SimpleConflictCompareEditorInput_0);
        GridDataFactory.defaultsFor((Control)label).grab(true, false).applyTo((Control)label);
        Button autoMergeButton = new Button(composite, 8);
        autoMergeButton.setText(Messages.SimpleConflictCompareEditorInput_1);
        autoMergeButton.setToolTipText(Messages.SimpleConflictCompareEditorInput_2);
        autoMergeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConflictCompareEditorInput.this.autoResolve();
            }
        });
        Button resolveButton = new Button(composite, 8);
        resolveButton.setText(Messages.SimpleConflictCompareEditorInput_8);
        resolveButton.setToolTipText(Messages.SimpleConflictCompareEditorInput_9);
        resolveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConflictCompareEditorInput.this.resolveAsMerged();
            }
        });
        Point margins = LayoutConstants.getMargins();
        GridLayoutFactory.fillDefaults().margins(margins.x / 2, margins.y / 2).numColumns(4).generateLayout(composite);
        return composite;
    }

    private Label createConflictsImage(Composite parent) {
        Label imageLabel = new Label(parent, 0);
        ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[2];
        imageDescriptorArray[1] = ImagePool.UNRESOLVED_OVRL;
        this.conflictsImage = new OverlayIcon(ImagePool.WORKSPACE, imageDescriptorArray, 132096).createImage(true);
        imageLabel.setImage(this.conflictsImage);
        GridDataFactory.defaultsFor((Control)imageLabel).align(1, 1).applyTo((Control)imageLabel);
        return imageLabel;
    }

    private void resolveWithMine() {
        final Shell shell = this.getShell();
        IWorkbenchPart part = this.getContainer().getWorkbenchPart();
        IOperationRunner runner = UIContext.createPartContext((IWorkbenchPart)part).getUserOperationRunner();
        runner.enqueue(Messages.ConflictCompareEditorInput_RESOLVE_WITH_MINE, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ConflictCompareEditorInput_RESOLVE_WITH_MINE, (int)100);
                ComponentSyncContext context = (ComponentSyncContext)ConflictCompareEditorInput.this.conflict.getOutgoingActivitySource().getModel();
                IWorkspaceConnection wc = context.getOutgoingTeamPlace();
                ILogicalConflictReport conflictReport = context.getLogicalConflictReport();
                WarnResolveAsMergedUser problemHandler = new WarnResolveAsMergedUser(shell, Messages.ConflictCompareEditorInput_RESOLVE_WITH_MINE);
                Collection changes = ComponentConflictUtil.getChanges((ILogicalConflictReport)conflictReport, Collections.singleton(ConflictCompareEditorInput.this.conflict));
                if (changes.isEmpty()) {
                    return;
                }
                try {
                    MarkAsMergedOperation mergedOp = new MarkAsMergedOperation(wc, conflictReport, changes, (MarkAsMergedDilemmaHandler)problemHandler);
                    mergedOp.run((IProgressMonitor)progress.newChild(90));
                    ConflictCompareEditorInput.this.closeEditor(true);
                }
                catch (FileSystemClientException e) {
                    throw new OperationFailedException(StatusUtil.newStatus((Object)((Object)this), (Throwable)e));
                }
            }
        });
    }

    private void resolveWithProposed() {
        final Shell shell = this.getShell();
        IWorkbenchPart part = this.getContainer().getWorkbenchPart();
        IOperationRunner runner = UIContext.createPartContext((IWorkbenchPart)part).getUserOperationRunner();
        runner.enqueue(Messages.ConflictCompareEditorInput_RESOLVE_WITH_PROPOSED, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                Set<IConflictItem> conflictItems;
                ComponentSyncContext context = (ComponentSyncContext)ConflictCompareEditorInput.this.conflict.getOutgoingActivitySource().getModel();
                IWorkspaceConnection wc = context.getOutgoingTeamPlace();
                ILogicalConflictReport conflictReport = context.getLogicalConflictReport();
                Collection changes = ComponentConflictUtil.getChanges((ILogicalConflictReport)conflictReport, conflictItems = Collections.singleton(ConflictCompareEditorInput.this.conflict));
                if (changes.isEmpty()) {
                    return;
                }
                try {
                    ApplyAcceptedOperation op = new ApplyAcceptedOperation(wc, conflictReport, changes, (ApplyAcceptedDilemmaHandler)new WarnApplyAcceptedUser(shell, Messages.ConflictCompareEditorInput_RESOLVE_WITH_PROPOSED));
                    op.run(monitor);
                    ConflictCompareEditorInput.this.closeEditor(true);
                }
                catch (FileSystemClientException e) {
                    throw new OperationFailedException(StatusUtil.newStatus((Object)((Object)this), (Throwable)e));
                }
            }
        });
    }

    private void resolveAsMerged() {
        final Shell shell = this.getShell();
        try {
            PlatformUI.getWorkbench().getProgressService().run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor progress) throws InvocationTargetException, InterruptedException {
                    try {
                        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (String)Messages.SimpleConflictCompareEditorInput_17, (int)100);
                        if (ConflictCompareEditorInput.this.isDirty()) {
                            ConflictCompareEditorInput.this.saveChanges((IProgressMonitor)monitor.newChild(50));
                        } else {
                            monitor.setWorkRemaining(50);
                        }
                        shell.getDisplay().syncExec(new Runnable(){

                            public void run() {
                                IWorkbenchPart part = ConflictCompareEditorInput.this.getContainer().getWorkbenchPart();
                                IOperationRunner runner = UIContext.createPartContext((IWorkbenchPart)part).getUserOperationRunner();
                                runner.enqueue(Messages.SimpleConflictCompareEditorInput_18, (Operation)new RepositoryOperation(){

                                    public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                                        try {
                                            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.SimpleConflictCompareEditorInput_19, (int)100);
                                            ComponentSyncContext context = (ComponentSyncContext)ConflictCompareEditorInput.this.conflict.getOutgoingActivitySource().getModel();
                                            IWorkspaceConnection wc = context.getOutgoingTeamPlace();
                                            ILogicalConflictReport conflictReport = context.getLogicalConflictReport();
                                            final boolean[] okToClose = new boolean[1];
                                            WarnResolveAsMergedUser problemHandler = new WarnResolveAsMergedUser(shell, Messages.SimpleConflictCompareEditorInput_20){
                                                private boolean prompted;
                                                {
                                                    super($anonymous0, $anonymous1);
                                                    this.prompted = false;
                                                }

                                                @Override
                                                public int unmergedChanges(Collection<ILogicalChange> changes) {
                                                    if (!changes.isEmpty()) {
                                                        final int[] result = new int[]{1};
                                                        if (PlatformUI.isWorkbenchRunning()) {
                                                            Display display = PlatformUI.getWorkbench().getDisplay();
                                                            display.syncExec(new Runnable(){

                                                                public void run() {
                                                                    MessageDialog dialog = new MessageDialog(shell, Messages.SimpleConflictCompareEditorInput_21, null, Messages.SimpleConflictCompareEditorInput_22, 4, new String[]{Messages.SimpleConflictCompareEditorInput_23, IDialogConstants.CANCEL_LABEL}, 1);
                                                                    int r = dialog.open();
                                                                    if (r == 0) {
                                                                        result[0] = 0;
                                                                    }
                                                                }
                                                            });
                                                        }
                                                        this.prompted = true;
                                                        return result[0];
                                                    }
                                                    return 0;
                                                }

                                                public int confirmMarkAsMerged(Collection<ILogicalChange> changes) {
                                                    final int[] result = new int[]{1};
                                                    if (this.prompted) {
                                                        result[0] = 0;
                                                    } else if (PlatformUI.isWorkbenchRunning()) {
                                                        Display display = PlatformUI.getWorkbench().getDisplay();
                                                        display.syncExec(new Runnable(){

                                                            public void run() {
                                                                if (MessageDialog.openConfirm((Shell)shell, (String)Messages.SimpleConflictCompareEditorInput_24, (String)Messages.SimpleConflictCompareEditorInput_25)) {
                                                                    result[0] = 0;
                                                                }
                                                            }
                                                        });
                                                    }
                                                    if (result[0] == 0) {
                                                        okToClose[0] = true;
                                                    }
                                                    return result[0];
                                                }
                                            };
                                            Collection changes = ComponentConflictUtil.getChanges((ILogicalConflictReport)conflictReport, Collections.singletonList(ConflictCompareEditorInput.this.conflict));
                                            MarkAsMergedOperation mergedOp = new MarkAsMergedOperation(wc, conflictReport, changes, (MarkAsMergedDilemmaHandler)problemHandler);
                                            mergedOp.run((IProgressMonitor)progress.newChild(90));
                                            if (okToClose[0]) {
                                                ConflictCompareEditorInput.this.closeEditor(true);
                                            }
                                        }
                                        catch (FileSystemClientException e) {
                                            throw new OperationFailedException(StatusUtil.newStatus((Object)((Object)this), (Throwable)e));
                                        }
                                    }
                                });
                            }
                        });
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            IStatus status = StatusUtil.newStatus((Object)this, (Throwable)e.getTargetException());
            StatusUtil.log((IStatus)status);
            ErrorDialog.openError((Shell)shell, (String)Messages.SimpleConflictCompareEditorInput_26, (String)Messages.SimpleConflictCompareEditorInput_27, (IStatus)status);
        }
        catch (InterruptedException interruptedException) {}
    }

    private void autoResolve() {
        boolean result;
        final Shell shell = this.getShell();
        if (this.isDirty() && !(result = MessageDialog.openConfirm((Shell)shell, (String)Messages.SimpleConflictCompareEditorInput_3, (String)Messages.SimpleConflictCompareEditorInput_4))) {
            return;
        }
        final UIContext currentContext = UIContext.createPageContext((Shell)shell, (IWorkbenchPage)this.getPage());
        currentContext.getUserOperationRunner().enqueue(Messages.SimpleConflictCompareEditorInput_5, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                if (ConflictCompareEditorInput.this.isDirty()) {
                    try {
                        ConflictCompareEditorInput.this.saveChanges((IProgressMonitor)progress.newChild(5));
                    }
                    catch (CoreException e) {
                        final IStatus status = StatusUtil.newStatus((Object)((Object)this), (Throwable)e);
                        StatusUtil.log((IStatus)status);
                        currentContext.getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                ErrorDialog.openError((Shell)shell, null, null, (IStatus)status);
                            }
                        });
                        return;
                    }
                }
                try {
                    try {
                        StandardAutoResolveDilemmaHandler dilemmaHandler = new StandardAutoResolveDilemmaHandler(currentContext, false){

                            @Override
                            public int missingStorageMerger(Collection<IFailedAutoResolveRequest> unknownTypes, Collection<IFailedAutoResolveRequest> itemsWithNoHandlers, IProgressMonitor monitor) {
                                for (IFailedAutoResolveRequest request : unknownTypes) {
                                    request.setRetryMerge(true);
                                    request.defaultContentTypeMerger("org.eclipse.core.runtime.text");
                                }
                                for (IFailedAutoResolveRequest request : itemsWithNoHandlers) {
                                    request.setRetryMerge(true);
                                    request.defaultContentTypeMerger("org.eclipse.core.runtime.text");
                                }
                                return 0;
                            }
                        };
                        IAutoResolveConflictsOperation autoResolveOperation = IOperationFactory.instance.getAutoResolveConflictsOperation((AutoResolveConflictsDilemmaHandler)dilemmaHandler);
                        IConflictItem conflict = ConflictCompareEditorInput.this.getConflictedItem();
                        IComponentSyncContext context = conflict.getOutgoingActivitySource().getModel();
                        IWorkspaceConnection connection = context.getWorkspaceSyncContext().getLocal();
                        ILogicalConflictReport conflictReport = context.getLogicalConflictReport();
                        autoResolveOperation.autoResolveConflict(connection, conflictReport, conflict.getLogicalChange());
                        ConflictCompareEditorInput.this.runningAutoResolve = true;
                        autoResolveOperation.run((IProgressMonitor)progress.newChild(100));
                        final int successCount = autoResolveOperation.numberOfConflictsResolved();
                        currentContext.getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                if (successCount == 0) {
                                    MessageDialog.openError((Shell)shell, (String)Messages.SimpleConflictCompareEditorInput_6, (String)Messages.SimpleConflictCompareEditorInput_7);
                                } else {
                                    ConflictCompareEditorInput.this.closeEditor(false);
                                }
                            }
                        });
                    }
                    catch (FileSystemClientException e) {
                        throw new OperationFailedException(StatusUtil.newStatus((Object)((Object)this), (Throwable)e));
                    }
                }
                finally {
                    ConflictCompareEditorInput.this.runningAutoResolve = false;
                }
            }
        });
    }

    private boolean isEvilTwin(IShareable shareable, IProgressMonitor monitor) throws FileSystemClientException {
        if (shareable != null) {
            IVersionableHandle remote = shareable.getRemote(monitor);
            return remote == null || !remote.sameItemId((IItemHandle)this.conflict.getItem());
        }
        return false;
    }

    public void fireInputChange() {
        if (!this.runningAutoResolve) {
            super.fireInputChange();
        }
    }

    public boolean equals(Object other) {
        ConflictCompareEditorInput otherInput;
        IConflictItem conflictedItem;
        if (other == this) {
            return true;
        }
        if (other.getClass() == this.getClass() && (conflictedItem = (otherInput = (ConflictCompareEditorInput)other).getConflictedItem()) != null && this.conflict != null) {
            return conflictedItem.getItem().sameItemId((IItemHandle)this.conflict.getItem());
        }
        return false;
    }

    public void handleDispose() {
        if (this.localFile != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        }
        if (this.conflictsImage != null) {
            this.conflictsImage.dispose();
        }
        super.handleDispose();
    }
}

