/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.ui.internal.compare;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.operations.ChangePropertiesDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IChangeFilePropertiesOperation;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.rcp.ui.internal.Messages;
import com.ibm.team.filesystem.rcp.ui.internal.compare.CompareFilePropertiesState;
import com.ibm.team.filesystem.rcp.ui.internal.properties.ChangeFilePropertiesUtil;
import com.ibm.team.filesystem.rcp.ui.internal.util.WarnChangeFileProperties;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import java.util.ResourceBundle;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public abstract class CompareFilePropertiesViewerPane
extends ViewForm {
    private boolean propertiesDirty = false;
    private CompareFilePropertiesState fileProperties;
    private IWorkbenchPartSite site;

    public CompareFilePropertiesViewerPane(Composite parent, CompareConfiguration cc, CompareFilePropertiesState compareFileProperties, IWorkbenchPartSite site) {
        super(parent, 0x800800);
        String text;
        this.fileProperties = compareFileProperties;
        this.site = site;
        CLabel title = new CLabel((Composite)this, 0){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                return super.computeSize(wHint, Math.max(24, hHint), changed);
            }
        };
        title.setText(Messages.CompareFilePropertiesViewerPane_0);
        this.setTopLeft((Control)title);
        WidgetToolkit toolkit = WidgetToolkit.createFormToolkit();
        final Composite composite = toolkit.createComposite((Composite)this, 0);
        int COLUMNS = this.fileProperties.hasAncestor() ? 3 : 2;
        this.setContent((Control)composite);
        title.addMouseListener(new MouseListener(){

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                CompareFilePropertiesViewerPane.this.setContent((Control)(CompareFilePropertiesViewerPane.this.getContent() == null ? composite : null));
                CompareFilePropertiesViewerPane.this.getParent().layout();
            }
        });
        Composite[] controls = this.newProperties(toolkit, composite, cc.getLeftLabel(null), true, this.getColor(this.fileProperties.isLeftSameAsRightExecutable(), this.fileProperties.hasAncestor(), this.fileProperties.isRightSameAsAncestorExecutable(), this.fileProperties.isLeftSameAsAncestorExectuable()), this.getText(this.fileProperties.isLeftExecutable()), this.getColor(this.fileProperties.isLeftSameAsRightContentType(), this.fileProperties.hasAncestor(), this.fileProperties.isRightSameAsAncestorContentType(), this.fileProperties.isLeftSameAsAncestorContentType()), this.getText(this.fileProperties.getLeftContentType()), true, this.getColor(this.fileProperties.isLeftSameAsRightLineDelimiter(), this.fileProperties.hasAncestor(), this.fileProperties.isRightSameAsAncestorLineDelimiter(), this.fileProperties.isLeftSameAsAncestorLineDelimiter()), this.getText(this.fileProperties.getLeftLineDelimiter()), true, this.fileProperties.getLeftLineDelimiter());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)controls[0]);
        final Combo leftContentTypeControl = (Combo)controls[1];
        final Combo leftLineDelimiterControl = (Combo)controls[2];
        controls = this.newProperties(toolkit, composite, cc.getRightLabel(null), this.fileProperties.hasAncestor(), null, this.getText(this.fileProperties.isRightExecutable()), null, this.getText(this.fileProperties.getRightContentType()), false, null, this.getText(this.fileProperties.getRightLineDelimiter()), false, null);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)controls[0]);
        if (this.fileProperties.hasAncestor()) {
            controls = this.newProperties(toolkit, composite, cc.getAncestorLabel(null), false, null, this.getText(this.fileProperties.isAncestorExecutable()), null, this.getText(this.fileProperties.getAncestorContentType()), false, null, this.getText(this.fileProperties.getAncestorLineDelimiter()), false, null);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)controls[0]);
        }
        GridLayoutFactory.fillDefaults().margins(LayoutConstants.getMargins()).numColumns(COLUMNS).equalWidth(true).applyTo(composite);
        Action a = new Action(){

            public void run() {
                String setMime = null;
                FileLineDelimiter setLineDelimiter = null;
                if (CompareFilePropertiesViewerPane.this.fileProperties.isLeftSameAsAncestorContentType()) {
                    setMime = CompareFilePropertiesViewerPane.this.fileProperties.getRightContentType();
                    leftContentTypeControl.select(1);
                }
                if (CompareFilePropertiesViewerPane.this.fileProperties.isLeftSameAsAncestorLineDelimiter()) {
                    setLineDelimiter = CompareFilePropertiesViewerPane.this.fileProperties.getRightLineDelimiter();
                    leftLineDelimiterControl.select(1);
                }
                CompareFilePropertiesViewerPane.this.setProperties(setMime, setLineDelimiter);
            }
        };
        Utilities.initAction((IAction)a, (ResourceBundle)ResourceBundle.getBundle("org.eclipse.compare.contentmergeviewer.TextMergeViewerResources"), (String)"action.CopyRightToLeft.");
        ToolBar tb = new ToolBar((Composite)this, 0x800000);
        this.setTopCenter((Control)tb);
        final ToolBarManager toolBarManager = new ToolBarManager(tb);
        ActionContributionItem action = new ActionContributionItem((IAction)a);
        a.setEnabled(false);
        action.setVisible(true);
        toolBarManager.add((IContributionItem)action);
        toolBarManager.update(true);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                toolBarManager.removeAll();
                toolBarManager.dispose();
            }
        });
        if (this.fileProperties.getShareable() == null) {
            leftContentTypeControl.setEnabled(false);
            leftLineDelimiterControl.setEnabled(false);
            return;
        }
        if (this.fileProperties.getRightContentType() != null && !this.fileProperties.isLeftSameAsRightContentType()) {
            leftContentTypeControl.add(this.fileProperties.getRightContentType());
        }
        if (this.fileProperties.getRightLineDelimiter() != null && !this.fileProperties.isLeftSameAsRightLineDelimiter()) {
            text = this.getText(this.fileProperties.getRightLineDelimiter());
            leftLineDelimiterControl.add(text);
            leftLineDelimiterControl.setData(text, (Object)this.fileProperties.getRightLineDelimiter());
        }
        if (this.fileProperties.hasAncestor()) {
            a.setEnabled(true);
            if (this.fileProperties.getAncestorContentType() != null && !this.fileProperties.isLeftSameAsAncestorContentType() && !this.fileProperties.isRightSameAsAncestorContentType()) {
                leftContentTypeControl.add(this.fileProperties.getAncestorContentType());
            }
            if (this.fileProperties.getAncestorLineDelimiter() != null && !this.fileProperties.isLeftSameAsAncestorLineDelimiter() && !this.fileProperties.isRightSameAsAncestorLineDelimiter()) {
                text = this.getText(this.fileProperties.getAncestorLineDelimiter());
                leftLineDelimiterControl.add(text);
                leftLineDelimiterControl.setData(text, (Object)this.fileProperties.getAncestorLineDelimiter());
            }
        }
        SelectionListener listener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (e.getSource() == leftContentTypeControl) {
                    CompareFilePropertiesViewerPane.this.setProperties(leftContentTypeControl.getText(), null);
                } else if (e.getSource() == leftLineDelimiterControl) {
                    CompareFilePropertiesViewerPane.this.setProperties(null, (FileLineDelimiter)leftLineDelimiterControl.getData(leftLineDelimiterControl.getText()));
                }
            }
        };
        leftContentTypeControl.addSelectionListener(listener);
        leftLineDelimiterControl.addSelectionListener(listener);
    }

    private Color getColor(boolean leftSameAsRight, boolean hasAncestor, boolean rightSameAsAncestor, boolean leftSameAsAncestor) {
        Color color;
        Color RED = this.getDisplay().getSystemColor(3);
        Color BLUE = this.getDisplay().getSystemColor(9);
        Color color2 = color = leftSameAsRight ? null : RED;
        if (hasAncestor) {
            if (rightSameAsAncestor) {
                color = null;
            } else if (leftSameAsAncestor) {
                color = BLUE;
            }
        }
        return color;
    }

    private Composite[] newProperties(WidgetToolkit toolkit, Composite composite, String headerText, boolean hasSeparator, Color executableForeground, String isExecutableText, Color contentTypeForeground, String contentTypeText, boolean contentTypeEnabled, Color lineDelimiterForeground, String lineDelimiterText, boolean lineDelimiterEnabled, Object lineDelimiterData) {
        Composite c = toolkit.createComposite(composite, 0);
        Label header = toolkit.createLabel(c, headerText);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)header);
        if (hasSeparator) {
            Label separator = toolkit.createSeparator(c, 512);
            GridDataFactory.fillDefaults().span(1, 4).applyTo((Control)separator);
        }
        Label executableLabel = toolkit.createLabel(c, Messages.CompareFilePropertiesViewerPane_3);
        if (executableForeground != null) {
            executableLabel.setForeground(executableForeground);
        }
        toolkit.createLabel(c, isExecutableText);
        Label contentTypeLabel = toolkit.createLabel(c, Messages.CompareFilePropertiesViewerPane_4);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)contentTypeLabel);
        if (contentTypeForeground != null) {
            contentTypeLabel.setForeground(contentTypeForeground);
        }
        Combo contentType = CompareFilePropertiesViewerPane.newCombo(toolkit, c, contentTypeText, Messages.CompareFilePropertiesViewerPane_5);
        contentType.setEnabled(contentTypeEnabled);
        Label lineDelimiterLabel = toolkit.createLabel(c, Messages.CompareFilePropertiesViewerPane_6);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)lineDelimiterLabel);
        if (lineDelimiterForeground != null) {
            lineDelimiterLabel.setForeground(lineDelimiterForeground);
        }
        Combo lineDelimiter = CompareFilePropertiesViewerPane.newCombo(toolkit, c, lineDelimiterText, Messages.CompareFilePropertiesViewerPane_7);
        lineDelimiter.setEnabled(lineDelimiterEnabled);
        if (lineDelimiterData != null) {
            lineDelimiter.setData(lineDelimiterText, lineDelimiterData);
        }
        GridLayoutFactory.fillDefaults().numColumns(hasSeparator ? 3 : 2).generateLayout(c);
        return new Composite[]{c, contentType, lineDelimiter};
    }

    private static Combo newCombo(WidgetToolkit toolkit, Composite composite, String firstItem, String tooltip) {
        Combo combo = new Combo(composite, 12);
        toolkit.adapt((Control)combo, false, false);
        combo.add(firstItem);
        combo.select(0);
        combo.setToolTipText(tooltip);
        GridDataFactory.fillDefaults().applyTo((Control)combo);
        return combo;
    }

    private String getText(boolean b) {
        return b ? Messages.CompareFilePropertiesViewerPane_8 : Messages.CompareFilePropertiesViewerPane_9;
    }

    private String getText(FileLineDelimiter delimiter) {
        return ChangeFilePropertiesUtil.delimiterToString(delimiter);
    }

    private String getText(String string) {
        return string == null ? Messages.CompareFilePropertiesViewerPane_10 : string;
    }

    public static Composite createNoStreamChangesLabel(Composite parent) {
        return CompareFilePropertiesViewerPane.createNoStreamChangesLabel(parent, Messages.CompareFilePropertiesViewerPane_11);
    }

    public static Composite createUseExternalEditorLabel(Composite parent) {
        return CompareFilePropertiesViewerPane.createNoStreamChangesLabel(parent, Messages.FileChangeExternalCompareEditorInput_0);
    }

    public static Composite createNoStreamChangesLabel(Composite parent, String msg) {
        Composite composite = new Composite(parent, 64);
        Label label = new Label(composite, 0);
        label.setText(msg);
        Point margins = LayoutConstants.getMargins();
        GridLayoutFactory.fillDefaults().margins(margins.x, 0).applyTo(composite);
        return composite;
    }

    private void setProperties(String contentType, FileLineDelimiter lineDelimiter) {
        boolean oldDirty = this.propertiesDirty;
        if (contentType != null) {
            this.fileProperties.setSelectedContentType(contentType);
        }
        if (lineDelimiter != null) {
            this.fileProperties.setSelectedLineDelimiter(lineDelimiter);
        }
        this.propertiesDirty = this.fileProperties.isPropertiesDirty();
        if (oldDirty != this.propertiesDirty) {
            this.firePropertyChange(new PropertyChangeEvent((Object)this, "DIRTY_STATE", (Object)oldDirty, (Object)this.propertiesDirty));
        }
    }

    public boolean isDirty() {
        return this.propertiesDirty;
    }

    protected abstract void firePropertyChange(PropertyChangeEvent var1);

    public void flush(IProgressMonitor monitor) {
        if (!this.fileProperties.isShareableChanges()) {
            return;
        }
        final Display display = this.getDisplay();
        Job job = new Job(Messages.CompareFilePropertiesViewerPane_12){

            protected IStatus run(IProgressMonitor monitor) {
                SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.CompareFilePropertiesViewerPane_13, (int)100);
                try {
                    try {
                        sub.beginTask(Messages.CompareFilePropertiesViewerPane_13, 100);
                        WarnChangeFileProperties dilemmaHandler = new WarnChangeFileProperties(CompareFilePropertiesViewerPane.this.site.getShell(), Messages.CompareFilePropertiesViewerPane_14);
                        IChangeFilePropertiesOperation operation = IOperationFactory.instance.getChangeFilePropertiesOperation((ChangePropertiesDilemmaHandler)dilemmaHandler);
                        operation.setContentType(CompareFilePropertiesViewerPane.this.fileProperties.getShareable(), CompareFilePropertiesViewerPane.this.fileProperties.getSelectedContentType());
                        operation.setLineDelimiter(CompareFilePropertiesViewerPane.this.fileProperties.getShareable(), CompareFilePropertiesViewerPane.this.fileProperties.getSelectedLineDelimiter());
                        operation.run((IProgressMonitor)sub.newChild(90));
                        CompareFilePropertiesViewerPane.this.fileProperties.refresh((IProgressMonitor)sub.newChild(10));
                    }
                    catch (TeamRepositoryException e) {
                        IStatus iStatus = FileSystemStatus.getStatusFor((int)4, (int)603, (Throwable)e);
                        sub.done();
                        return iStatus;
                    }
                    catch (FileSystemClientException e) {
                        IStatus iStatus = FileSystemStatus.getStatusFor((int)4, (int)603, (Throwable)e);
                        sub.done();
                        return iStatus;
                    }
                }
                finally {
                    sub.done();
                }
                if (!display.isDisposed()) {
                    display.asyncExec(new Runnable(){

                        public void run() {
                            CompareFilePropertiesViewerPane.this.setProperties(null, null);
                        }
                    });
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        IWorkbenchSiteProgressService ps = (IWorkbenchSiteProgressService)this.site.getAdapter(IWorkbenchSiteProgressService.class);
        ps.schedule(job, 0L, true);
    }
}

