/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.ui.internal.compare;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.repository.rcp.common.NullUtil;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class CompareFilePropertiesState {
    private IShareable shareable;
    private String selectedContentType;
    private FileLineDelimiter selectedLineDelimiter;
    private String leftContentType;
    private String leftOriginalContentType;
    private FileLineDelimiter leftLineDelimiter;
    private FileLineDelimiter leftOriginalLineDelimiter;
    private boolean leftExecutable;
    private boolean hasRight = true;
    private String rightContentType;
    private FileLineDelimiter rightLineDelimiter;
    private boolean rightExecutable;
    private boolean hasAncestor = false;
    private String ancestorContentType;
    private FileLineDelimiter ancestorLineDelimiter;
    private boolean ancestorExecutable;

    public CompareFilePropertiesState() {
    }

    public CompareFilePropertiesState(IShareable shareable, IFileItem right, IFileItem ancestor, IProgressMonitor monitor) throws FileSystemClientException {
        this.shareable = shareable;
        if (shareable != null) {
            this.refresh(monitor);
            this.selectedContentType = this.leftContentType;
            this.selectedLineDelimiter = this.leftLineDelimiter;
        }
        if (right != null) {
            IFileContent rightContent = right.getContent();
            this.rightExecutable = right.isExecutable();
            this.rightContentType = right.getContentType();
            this.rightLineDelimiter = rightContent.getLineDelimiter();
        } else {
            this.hasRight = false;
        }
        if (ancestor != null) {
            this.hasAncestor = true;
            IFileContent ancestorContent = ancestor.getContent();
            this.ancestorExecutable = ancestor.isExecutable();
            this.ancestorContentType = ancestor.getContentType();
            this.ancestorLineDelimiter = ancestorContent.getLineDelimiter();
        }
    }

    public CompareFilePropertiesState(IShareable shareable, FileState right, IProgressMonitor monitor) throws FileSystemClientException {
        this.shareable = shareable;
        this.refresh(monitor);
        this.selectedContentType = this.leftContentType;
        this.selectedLineDelimiter = this.leftLineDelimiter;
        this.rightExecutable = right.isExectuable();
        this.rightContentType = right.getContentType();
        this.rightLineDelimiter = right.getLineDelimiter();
    }

    public void refresh(IProgressMonitor monitor) throws FileSystemClientException {
        if (this.shareable == null) {
            return;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        this.leftExecutable = this.shareable.isExecutable((IProgressMonitor)progress.newChild(20));
        this.leftContentType = this.shareable.getContentType((IProgressMonitor)progress.newChild(20));
        this.leftLineDelimiter = this.shareable.getLineDelimiter((IProgressMonitor)progress.newChild(20));
        this.leftOriginalLineDelimiter = this.shareable.getOriginalLineDelimiter((IProgressMonitor)progress.newChild(20));
        this.leftOriginalContentType = this.shareable.getOriginalContentType((IProgressMonitor)progress.newChild(20));
    }

    public CompareFilePropertiesState(FileState left, FileState right) {
        this.leftExecutable = left.isExectuable();
        this.leftContentType = left.getContentType();
        this.leftLineDelimiter = left.getLineDelimiter();
        this.rightExecutable = right.isExectuable();
        this.rightContentType = right.getContentType();
        this.rightLineDelimiter = right.getLineDelimiter();
    }

    public boolean isShareableChanges() {
        if (this.shareable == null) {
            return false;
        }
        if (this.leftContentType == null && this.leftLineDelimiter == null) {
            return false;
        }
        if (!NullUtil.equals((Object)this.leftLineDelimiter, (Object)this.leftOriginalLineDelimiter) || !NullUtil.equals((Object)this.leftContentType, (Object)this.leftOriginalContentType)) {
            return true;
        }
        if (!NullUtil.equals((Object)this.rightContentType, (Object)this.leftContentType) || !NullUtil.equals((Object)this.rightLineDelimiter, (Object)this.leftLineDelimiter) || this.rightExecutable != this.leftExecutable) {
            return true;
        }
        return this.isPropertiesDirty();
    }

    public boolean isPropertiesDirty() {
        return !NullUtil.equals((Object)this.selectedContentType, (Object)this.leftContentType) || !NullUtil.equals((Object)this.selectedLineDelimiter, (Object)this.leftLineDelimiter);
    }

    public boolean isLeftSameAsAncestorExectuable() {
        return this.leftExecutable == this.ancestorExecutable;
    }

    public boolean isLeftSameAsAncestorContentType() {
        return NullUtil.equals((Object)this.leftContentType, (Object)this.ancestorContentType);
    }

    public boolean isLeftSameAsAncestorLineDelimiter() {
        return NullUtil.equals((Object)this.leftLineDelimiter, (Object)this.ancestorLineDelimiter);
    }

    public boolean isLeftSameAsRightExecutable() {
        return this.leftExecutable == this.rightExecutable;
    }

    public boolean isLeftSameAsRightContentType() {
        return NullUtil.equals((Object)this.leftContentType, (Object)this.rightContentType);
    }

    public boolean isLeftSameAsRightLineDelimiter() {
        return NullUtil.equals((Object)this.leftLineDelimiter, (Object)this.rightLineDelimiter);
    }

    public boolean isLeftSameAsRight() {
        return this.isLeftSameAsRightContentType() && this.isLeftSameAsRightLineDelimiter() && this.isLeftSameAsRightExecutable();
    }

    public boolean isRightSameAsAncestorExecutable() {
        return this.rightExecutable == this.ancestorExecutable;
    }

    public boolean isRightSameAsAncestorContentType() {
        return NullUtil.equals((Object)this.rightContentType, (Object)this.ancestorContentType);
    }

    public boolean isRightSameAsAncestorLineDelimiter() {
        return NullUtil.equals((Object)this.rightLineDelimiter, (Object)this.ancestorLineDelimiter);
    }

    public IShareable getShareable() {
        return this.shareable;
    }

    public boolean isLeftExecutable() {
        return this.leftExecutable;
    }

    public boolean isRightExecutable() {
        return this.rightExecutable;
    }

    public boolean isAncestorExecutable() {
        return this.ancestorExecutable;
    }

    public String getSelectedContentType() {
        return this.selectedContentType;
    }

    public FileLineDelimiter getSelectedLineDelimiter() {
        return this.selectedLineDelimiter;
    }

    public String getLeftContentType() {
        return this.leftContentType;
    }

    public FileLineDelimiter getLeftLineDelimiter() {
        return this.leftLineDelimiter;
    }

    public String getRightContentType() {
        return this.rightContentType;
    }

    public FileLineDelimiter getRightLineDelimiter() {
        return this.rightLineDelimiter;
    }

    public String getAncestorContentType() {
        return this.ancestorContentType;
    }

    public FileLineDelimiter getAncestorLineDelimiter() {
        return this.ancestorLineDelimiter;
    }

    public void setSelectedContentType(String selectedContentType) {
        this.selectedContentType = selectedContentType;
    }

    public void setSelectedLineDelimiter(FileLineDelimiter selectedLineDelimiter) {
        this.selectedLineDelimiter = selectedLineDelimiter;
    }

    public boolean hasAncestor() {
        return this.hasAncestor;
    }

    public boolean hasRight() {
        return this.hasRight;
    }
}

