/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.ui.internal.compare;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.TempHelper;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.rcp.ui.internal.compare.CompareFilePropertiesState;
import com.ibm.team.filesystem.rcp.ui.internal.compare.CompareFilePropertiesViewerPane;
import com.ibm.team.filesystem.rcp.ui.internal.compare.FileStorageTypedElement;
import com.ibm.team.filesystem.rcp.ui.internal.compare.FireChangeDiffNode;
import com.ibm.team.filesystem.rcp.ui.internal.compare.ICompareEditorInput;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.utils.DisposableInputStreamProvider;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.IContentChangeListener;
import org.eclipse.compare.IContentChangeNotifier;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.internal.BufferedResourceNode;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractCompareEditorInput
extends CompareEditorInput
implements ICompareEditorInput {
    private IWorkbenchPage page;
    private boolean saving = false;
    private boolean fileStreamChanges;
    private boolean isCreateOrDelete = false;
    protected CompareFilePropertiesState fileProperties;
    private CompareFilePropertiesViewerPane compareFilePropertiesViewerPane;
    private Composite top;
    private Shell shell;
    private boolean isExternal;
    private String rightLabelOverride = null;

    public AbstractCompareEditorInput(CompareConfiguration configuration, boolean isExternal) {
        super(configuration);
        this.isExternal = isExternal;
    }

    public IWorkbenchPage getPage() {
        if (this.page == null) {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        }
        return this.page;
    }

    public void setPage(IWorkbenchPage page) {
        this.page = page;
    }

    public boolean isExternal() {
        return this.isExternal;
    }

    public void setRightLabel(String remoteName) {
        this.rightLabelOverride = remoteName;
    }

    public final Control createContents(Composite parent) {
        if (this.top != null) {
            return this.top;
        }
        this.top = new Composite(parent, 0);
        this.shell = this.top.getShell();
        GridLayoutFactory.fillDefaults().applyTo(this.top);
        this.createContents2(this.top);
        return this.top;
    }

    protected void createContents2(Composite top) {
        if (!this.fileProperties.isShareableChanges() && this.fileProperties.isLeftSameAsRight() || this.isCreateOrDelete) {
            Control c = this.superCreateComposite(top);
            GridDataFactory.fillDefaults().grab(true, true).applyTo(c);
            return;
        }
        this.compareFilePropertiesViewerPane = new CompareFilePropertiesViewerPane(top, this.getCompareConfiguration(), this.fileProperties, this.getWorkbenchPart().getSite()){

            protected void firePropertyChange(PropertyChangeEvent event) {
                AbstractCompareEditorInput.this.firePropertyChange(event);
            }
        };
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.compareFilePropertiesViewerPane);
        if (this.fileStreamChanges) {
            Object c = null;
            c = this.isExternal ? CompareFilePropertiesViewerPane.createUseExternalEditorLabel(top) : this.superCreateComposite(top);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)c);
        } else {
            Composite c = CompareFilePropertiesViewerPane.createNoStreamChangesLabel(top);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)c);
        }
    }

    protected Control superCreateComposite(Composite top) {
        return super.createContents(top);
    }

    protected boolean closeEditor(boolean checkForUnsavedChanges) {
        if (this.isSaveNeeded() && checkForUnsavedChanges) {
            return false;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                IEditorPart part = AbstractCompareEditorInput.this.getPage().findEditor(AbstractCompareEditorInput.this.getEditorInput());
                AbstractCompareEditorInput.this.getPage().closeEditor(part, false);
            }
        };
        if (Display.getCurrent() != null) {
            runnable.run();
        } else {
            Display display = this.getPage().getWorkbenchWindow().getShell().getDisplay();
            display.asyncExec(runnable);
        }
        return true;
    }

    protected IEditorInput getEditorInput() {
        return this;
    }

    public void handleDispose() {
        super.handleDispose();
        Object compareResult = this.getCompareResult();
        if (compareResult instanceof ICompareInput) {
            ICompareInput ci = (ICompareInput)compareResult;
            this.dispose(ci.getLeft());
            this.dispose(ci.getRight());
            this.dispose(ci.getAncestor());
        }
    }

    private void dispose(ITypedElement element) {
        Object adapter;
        if (element instanceof IAdaptable && (adapter = ((IAdaptable)element).getAdapter(DisposableInputStreamProvider.class)) instanceof DisposableInputStreamProvider) {
            DisposableInputStreamProvider disp = (DisposableInputStreamProvider)adapter;
            try {
                disp.dispose();
            }
            catch (IOException iOException) {}
        }
    }

    protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        return this.prepareCompareInput(monitor);
    }

    public ICompareInput prepareCompareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            CompareConfiguration cc = this.getCompareConfiguration();
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            TypedElementAndData leftElement = this.computeLeft((IProgressMonitor)progress.newChild(1));
            ITypedElement left = leftElement.getElement();
            String leftLabel = leftElement.getLabel();
            if (left != null && left instanceof IContentChangeNotifier) {
                IContentChangeNotifier ccn = (IContentChangeNotifier)left;
                ccn.addContentChangeListener(new IContentChangeListener(){

                    public void contentChanged(IContentChangeNotifier source) {
                        try {
                            if (!AbstractCompareEditorInput.this.saving) {
                                AbstractCompareEditorInput.this.saveChanges((IProgressMonitor)TempHelper.MONITOR);
                            }
                        }
                        catch (CoreException e) {
                            LoggingHelper.error((String)"com.ibm.team.filesystem.rcp.ui", (String)e.getMessage(), (Throwable)e);
                        }
                    }
                });
            }
            IShareable leftShareable = leftElement.getShareable();
            FileState leftFileState = leftElement.getFileState();
            cc.setLeftLabel(leftLabel);
            this.isCreateOrDelete = leftShareable != null ? !leftShareable.exists((IProgressMonitor)progress.newChild(1)) : (leftFileState != null ? leftFileState.isDeleted() : true);
            TypedElementAndData rightElement = this.computeRight((IProgressMonitor)progress.newChild(1));
            ITypedElement right = rightElement.getElement();
            String rightLabel = rightElement.getLabel();
            FileState rightFileState = rightElement.getFileState();
            if (this.rightLabelOverride != null) {
                cc.setRightLabel(this.rightLabelOverride);
            } else {
                cc.setRightLabel(rightLabel);
            }
            if (rightFileState != null) {
                this.isCreateOrDelete |= rightFileState.isDeleted();
            } else if (right == null) {
                this.isCreateOrDelete = true;
            }
            TypedElementAndData ancestorElement = this.computeAncestor((IProgressMonitor)progress.newChild(1));
            ITypedElement ancestor = ancestorElement.getElement();
            String ancestorLabel = ancestorElement.getLabel();
            cc.setAncestorLabel(ancestorLabel);
            boolean createFileProperty = true;
            if (leftShareable != null) {
                ResourceType resourceType = leftShareable.getResourceType((IProgressMonitor)progress.newChild(1));
                createFileProperty = resourceType != ResourceType.SYMBOLIC_LINK;
            }
            this.fileProperties = createFileProperty ? this.createFilePropertyState(leftElement, rightElement, ancestorElement, (IProgressMonitor)progress.newChild(1)) : new CompareFilePropertiesState();
            Differencer d = new Differencer(){

                protected Object visit(Object parent, int description, Object ancestor, Object left, Object right) {
                    return new FireChangeDiffNode((IDiffContainer)parent, description, (ITypedElement)ancestor, (ITypedElement)left, (ITypedElement)right);
                }
            };
            progress.setWorkRemaining(100);
            Object result = d.findDifferences(ancestor != null, (IProgressMonitor)progress.newChild(100), null, (Object)ancestor, (Object)left, (Object)right);
            boolean bl = this.fileStreamChanges = result != null;
            if (result == null && this.fileProperties.isShareableChanges()) {
                result = new FireChangeDiffNode(null, 7, ancestor, left, right);
            }
            progress.done();
            return (ICompareInput)result;
        }
        catch (TeamRepositoryException e) {
            throw new InvocationTargetException(e);
        }
        catch (IOException e) {
            throw new InvocationTargetException(e);
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
        catch (RuntimeException e) {
            StatusUtil.log((Object)this, (Throwable)e);
            throw e;
        }
    }

    public void fireInputChange() {
        Object compareResult = this.getCompareResult();
        if (compareResult instanceof FireChangeDiffNode) {
            FireChangeDiffNode diffNode = (FireChangeDiffNode)((Object)compareResult);
            diffNode.fireChange();
        }
    }

    protected abstract CompareFilePropertiesState createFilePropertyState(TypedElementAndData var1, TypedElementAndData var2, TypedElementAndData var3, IProgressMonitor var4) throws FileSystemClientException;

    protected abstract TypedElementAndData computeLeft(IProgressMonitor var1) throws CoreException, TeamRepositoryException, IOException;

    protected abstract TypedElementAndData computeRight(IProgressMonitor var1) throws CoreException, TeamRepositoryException, IOException;

    protected abstract TypedElementAndData computeAncestor(IProgressMonitor var1) throws CoreException, TeamRepositoryException, IOException;

    public boolean isSaveNeeded() {
        if (this.compareFilePropertiesViewerPane != null) {
            return this.compareFilePropertiesViewerPane.isDirty() || super.isSaveNeeded();
        }
        return super.isSaveNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveChanges(IProgressMonitor monitor) throws CoreException {
        if (this.saving) {
            return;
        }
        AbstractCompareEditorInput abstractCompareEditorInput = this;
        synchronized (abstractCompareEditorInput) {
            this.saving = true;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (this.compareFilePropertiesViewerPane != null) {
            this.compareFilePropertiesViewerPane.flush((IProgressMonitor)progress.newChild(33));
        }
        this.superSaveChanges((IProgressMonitor)progress.newChild(33));
        this.saveRequested((IProgressMonitor)progress.newChild(34));
        this.setDirty(false);
        AbstractCompareEditorInput abstractCompareEditorInput2 = this;
        synchronized (abstractCompareEditorInput2) {
            this.saving = false;
        }
    }

    protected void superSaveChanges(IProgressMonitor monitor) throws CoreException {
        super.saveChanges(monitor);
    }

    protected void saveRequested(IProgressMonitor monitor) throws CoreException {
        Object compareResult = this.getCompareResult();
        if (compareResult instanceof ICompareInput) {
            ICompareInput ci = (ICompareInput)compareResult;
            ITypedElement left = ci.getLeft();
            if (left instanceof BufferedResourceNode) {
                BufferedResourceNode node = (BufferedResourceNode)left;
                node.commit(monitor);
            } else if (left instanceof FileStorageTypedElement) {
                FileStorageTypedElement fste = (FileStorageTypedElement)left;
                fste.commit(monitor);
            }
        }
    }

    public boolean canRunAsJob() {
        return false;
    }

    public Shell getShell() {
        return this.shell;
    }

    protected static class TypedElementAndData {
        private ITypedElement element;
        private String label;
        private IShareable shareable;
        private IFileItem fileItem;
        private FileState fileState;

        public TypedElementAndData() {
        }

        public TypedElementAndData(ITypedElement element, String label, IShareable shareable) {
            this.element = element;
            this.label = label;
            this.shareable = shareable;
        }

        public TypedElementAndData(ITypedElement element, String label, IFileItem fileItem) {
            this.element = element;
            this.label = label;
            this.fileItem = fileItem;
        }

        public TypedElementAndData(ITypedElement element, String label, FileState fileState) {
            this.element = element;
            this.label = label;
            this.fileState = fileState;
        }

        public ITypedElement getElement() {
            return this.element;
        }

        public String getLabel() {
            return this.label;
        }

        public IShareable getShareable() {
            return this.shareable;
        }

        public IFileItem getFileItem() {
            return this.fileItem;
        }

        public FileState getFileState() {
            return this.fileState;
        }
    }
}

