/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.ui.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ICopyFileAreaEvent;
import com.ibm.team.filesystem.client.ICopyFileAreaListener;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.ISharingManager;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SandboxPersistence
implements ICopyFileAreaListener {
    private static final String SANDBOX_PATHS = "com.ibm.team.filesystem.rcp.core.SandboxPaths";
    private Collection<IPath> copyFileAreas;

    public SandboxPersistence() {
        this.initialize();
    }

    private void initialize() {
        new Job(Messages.SandboxPersistence_0){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                ISharingManager sharingManager = FileSystemCore.getSharingManager();
                Collection paths = SandboxPersistence.this.getPersistedCopyFileAreas();
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(paths.size() + 1));
                ArrayList<IPath> toRemove = new ArrayList<IPath>();
                for (IPath path : paths) {
                    if (this.ensureRegistererd(path, true, progress.newChild(1))) continue;
                    toRemove.add(path);
                }
                IPath workspace = ResourcesPlugin.getWorkspace().getRoot().getLocation();
                this.ensureRegistererd(workspace, false, progress.newChild(1));
                Object object = this;
                synchronized (object) {
                    sharingManager.addListener((ICopyFileAreaListener)SandboxPersistence.this);
                    boolean needsWrite = false;
                    for (ISandbox s : sharingManager.getRegisteredSandboxes()) {
                        needsWrite |= SandboxPersistence.this.addCopyFileArea(s.getRoot());
                    }
                    for (IPath path : toRemove) {
                        needsWrite |= SandboxPersistence.this.removeCopyFileArea(path);
                    }
                    if (needsWrite) {
                        SandboxPersistence.this.write();
                    }
                }
                progress.done();
                return Status.OK_STATUS;
            }

            private boolean ensureRegistererd(IPath path, boolean logFailure, SubMonitor progress) {
                ISharingManager sharingManager = FileSystemCore.getSharingManager();
                boolean registered = true;
                ISandbox sandbox = sharingManager.getSandbox(path, true);
                if (sandbox == null) {
                    registered = false;
                    try {
                        sharingManager.register(sharingManager.getSandbox(path, false), true, (IProgressMonitor)progress);
                        registered = true;
                    }
                    catch (FileSystemClientException e) {
                        if (logFailure) {
                            StatusUtil.log((Object)((Object)this), (Throwable)e);
                        }
                    }
                    catch (RuntimeException e) {
                        StatusUtil.log((Object)((Object)this), (Throwable)e);
                    }
                }
                return registered;
            }
        }.schedule();
    }

    private synchronized Collection<IPath> getPersistedCopyFileAreas() {
        if (this.copyFileAreas == null) {
            String paths = this.getPreferences().get(SANDBOX_PATHS, "");
            StringTokenizer tokenizer = new StringTokenizer(paths, "\n");
            this.copyFileAreas = new HashSet<IPath>();
            while (tokenizer.hasMoreTokens()) {
                String path = tokenizer.nextToken();
                if (path.length() <= 0) continue;
                this.copyFileAreas.add(Path.fromPortableString((String)path));
            }
        }
        return this.copyFileAreas;
    }

    public void dispose() {
        FileSystemCore.getSharingManager().removeListener((ICopyFileAreaListener)this);
    }

    public synchronized void change(ICopyFileAreaEvent[] events) {
        boolean needsWrite = false;
        ICopyFileAreaEvent[] iCopyFileAreaEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            ICopyFileAreaEvent event = iCopyFileAreaEventArray[n2];
            if (event.getReason() == 9) {
                needsWrite |= this.addCopyFileArea(event.getCopyFileAreaRoot());
            } else if (event.getReason() == 10) {
                needsWrite |= this.removeCopyFileArea(event.getCopyFileAreaRoot());
            }
            ++n2;
        }
        if (needsWrite) {
            this.write();
        }
    }

    private boolean removeCopyFileArea(IPath copyFileAreaRoot) {
        if (this.copyFileAreas.contains(copyFileAreaRoot)) {
            this.copyFileAreas.remove(copyFileAreaRoot);
            return true;
        }
        return false;
    }

    private boolean addCopyFileArea(IPath copyFileAreaRoot) {
        if (copyFileAreaRoot.equals((Object)ResourcesPlugin.getWorkspace().getRoot().getLocation())) {
            return false;
        }
        if (!this.copyFileAreas.contains(copyFileAreaRoot)) {
            this.copyFileAreas.add(copyFileAreaRoot);
            return true;
        }
        return false;
    }

    private void write() {
        try {
            Preferences preferences = this.getPreferences();
            if (this.copyFileAreas.size() == 0) {
                preferences.remove(SANDBOX_PATHS);
            } else {
                StringBuffer buffer = new StringBuffer();
                for (IPath path : this.copyFileAreas) {
                    buffer.append(path.toPortableString());
                    buffer.append('\n');
                }
                preferences.put(SANDBOX_PATHS, buffer.toString());
            }
            preferences.flush();
        }
        catch (BackingStoreException e) {
            StatusUtil.log((Object)this, (Throwable)e);
        }
    }

    private Preferences getPreferences() {
        return new InstanceScope().getNode(FileSystemResourcesPlugin.getDefault().getBundle().getSymbolicName());
    }
}

