/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.core.preferences;

import com.ibm.team.repository.rcp.core.internal.RepositoryRcpCorePlugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferenceNodeVisitor;
import org.osgi.service.prefs.BackingStoreException;

public final class RecursivePreferenceListener {
    private IEclipsePreferences.IPreferenceChangeListener toDelegateTo;
    private IEclipsePreferences.INodeChangeListener nodeListener = new IEclipsePreferences.INodeChangeListener(){

        public void added(IEclipsePreferences.NodeChangeEvent event) {
            if (event.getChild() instanceof IEclipsePreferences) {
                IEclipsePreferences prefs = (IEclipsePreferences)event.getChild();
                try {
                    RecursivePreferenceListener.this.attachTo(prefs);
                }
                catch (BackingStoreException e) {
                    RepositoryRcpCorePlugin.log(e);
                }
            }
        }

        public void removed(IEclipsePreferences.NodeChangeEvent event) {
            if (event.getChild() instanceof IEclipsePreferences) {
                IEclipsePreferences prefs = (IEclipsePreferences)event.getChild();
                try {
                    RecursivePreferenceListener.this.detachFrom(prefs);
                }
                catch (BackingStoreException e) {
                    RepositoryRcpCorePlugin.log(e);
                }
            }
        }
    };

    public RecursivePreferenceListener(IEclipsePreferences.IPreferenceChangeListener toDelegateTo) {
        this.toDelegateTo = toDelegateTo;
    }

    public void detachFrom(IEclipsePreferences prefs) throws BackingStoreException {
        if (!prefs.nodeExists("")) {
            return;
        }
        prefs.accept(new IPreferenceNodeVisitor(){

            public boolean visit(IEclipsePreferences node) throws BackingStoreException {
                RecursivePreferenceListener.this.doDetach(node);
                return true;
            }
        });
    }

    public void attachTo(IEclipsePreferences prefs) throws BackingStoreException {
        prefs.accept(new IPreferenceNodeVisitor(){

            public boolean visit(IEclipsePreferences node) throws BackingStoreException {
                RecursivePreferenceListener.this.doAttach(node);
                return true;
            }
        });
    }

    protected void doDetach(IEclipsePreferences node) {
        node.removeNodeChangeListener(this.nodeListener);
        node.removePreferenceChangeListener(this.toDelegateTo);
    }

    public int hashCode() {
        return this.toDelegateTo.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof RecursivePreferenceListener) {
            RecursivePreferenceListener listener = (RecursivePreferenceListener)obj;
            return listener.toDelegateTo.equals(this.toDelegateTo);
        }
        return super.equals(obj);
    }

    private void doAttach(IEclipsePreferences node) {
        node.addNodeChangeListener(this.nodeListener);
        node.addPreferenceChangeListener(this.toDelegateTo);
    }
}

