/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.core.preferences;

import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.preferences.ConfigElementStore;
import com.ibm.team.repository.rcp.core.preferences.EmptyPreferences;
import com.ibm.team.repository.rcp.core.preferences.StringStoreToPreferencesAdapter;
import com.ibm.team.repository.rcp.core.preferences.WritableStore;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class PreferencesUtil {
    private static final String ATTR_STATUS_SEVERITY = "severity";
    private static final String ATTR_STATUS_MESSAGE = "message";

    public static Preferences getEmptyPreferences() {
        return EmptyPreferences.getInstance();
    }

    public static void writePreference(OutputStream outStream, Preferences toWrite, IProgressMonitor monitor) throws IOException, BackingStoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Properties properties = PreferencesUtil.convertToProperties(toWrite, (IProgressMonitor)progress.newChild(50));
        properties.store(outStream, "");
    }

    public static Properties convertToProperties(Preferences toWrite, IProgressMonitor monitor) throws BackingStoreException {
        Properties result = new Properties();
        PreferencesUtil.convertToProperties(result, toWrite, (IPath)new Path(""), monitor);
        return result;
    }

    private static void convertToProperties(Properties result, Preferences toWrite, IPath path, IProgressMonitor monitor) throws BackingStoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        String[] children = toWrite.childrenNames();
        String[] keys = toWrite.keys();
        SubMonitor keyProgress = progress.newChild(1).setWorkRemaining(keys.length);
        int i = 0;
        while (i < keys.length) {
            String next = keys[i];
            result.setProperty(path.append(next).toString(), toWrite.get(next, ""));
            keyProgress.worked(1);
            ++i;
        }
        SubMonitor loopProgress = progress.newChild(99).setWorkRemaining(children.length);
        int i2 = 0;
        while (i2 < children.length) {
            String next = children[i2];
            Preferences nextPrefs = toWrite.node(next);
            PreferencesUtil.convertToProperties(result, nextPrefs, path.append(next), (IProgressMonitor)loopProgress.newChild(1));
            ++i2;
        }
    }

    static Preferences getPreferencesFor(IConfigurationElement toConvert) {
        return new StringStoreToPreferencesAdapter(new ConfigElementStore(toConvert));
    }

    public static IEclipsePreferences createPreferences() {
        return new StringStoreToPreferencesAdapter(new WritableStore());
    }

    public static void clearDescendants(Preferences toClear) throws BackingStoreException {
        toClear.clear();
        String[] children = toClear.childrenNames();
        int i = 0;
        while (i < children.length) {
            String next = children[i];
            toClear.node(next).removeNode();
            ++i;
        }
    }

    public static void copyTree(Preferences destination, Preferences source, IProgressMonitor monitor) throws BackingStoreException {
        String next;
        String[] destChildren = destination.childrenNames();
        String[] sourceChildren = source.childrenNames();
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)(sourceChildren.length * 10 + destChildren.length + 10));
        PreferencesUtil.copyValues(destination, source, (IProgressMonitor)mon.newChild(10));
        HashSet<String> sourceChildrenSet = new HashSet<String>();
        sourceChildrenSet.addAll(Arrays.asList(sourceChildren));
        int i = 0;
        while (i < destChildren.length) {
            next = destChildren[i];
            if (!sourceChildrenSet.contains(next)) {
                destination.node(next).removeNode();
            }
            mon.worked(1);
            ++i;
        }
        i = 0;
        while (i < sourceChildren.length) {
            next = sourceChildren[i];
            Preferences destChild = destination.node(next);
            Preferences sourceChild = source.node(next);
            PreferencesUtil.copyTree(destChild, sourceChild, (IProgressMonitor)mon.newChild(10));
            ++i;
        }
    }

    public static void copyValues(Preferences destination, Preferences source, IProgressMonitor monitor) throws BackingStoreException {
        String next;
        String[] destChildren = destination.keys();
        String[] sourceChildren = source.keys();
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)(sourceChildren.length + destChildren.length));
        HashSet<String> sourceChildrenSet = new HashSet<String>();
        sourceChildrenSet.addAll(Arrays.asList(sourceChildren));
        int i = 0;
        while (i < destChildren.length) {
            next = destChildren[i];
            if (!sourceChildrenSet.contains(next)) {
                destination.remove(next);
            }
            mon.worked(1);
            ++i;
        }
        i = 0;
        while (i < sourceChildren.length) {
            next = sourceChildren[i];
            String destValue = destination.get(next, null);
            String sourceValue = source.get(next, "");
            if (destValue == null || !sourceValue.equals(destValue)) {
                destination.put(next, sourceValue);
            }
            mon.worked(1);
            ++i;
        }
    }

    public static UUID getUUID(Preferences prefs, String key) throws CoreException {
        String value = PreferencesUtil.getString(prefs, key);
        try {
            return UUID.valueOf((String)value);
        }
        catch (IllegalArgumentException e) {
            throw new CoreException(StatusUtil.newStatus(PreferencesUtil.class, NLS.bind((String)"Preference {0} is not a valid UUID", (Object)key, (Object)e)));
        }
    }

    public static String getString(Preferences prefs, String key) throws CoreException {
        String result = prefs.get(key, null);
        if (result == null) {
            throw new CoreException(StatusUtil.newStatus(PreferencesUtil.class, NLS.bind((String)"Unable to find preference key {0}", (Object)key)));
        }
        return result;
    }

    public static String getString(Preferences prefs, String key, String defaultValue) {
        return prefs.get(key, defaultValue);
    }

    public static void putUUID(Preferences child, String key, UUID uuid) {
        child.put(key, uuid.getUuidValue());
    }

    public static void putStatus(Preferences prefs, IStatus status) {
        prefs.putInt(ATTR_STATUS_SEVERITY, status.getSeverity());
        prefs.put(ATTR_STATUS_MESSAGE, status.getMessage());
    }

    public static IStatus getStatus(Preferences prefs) {
        return StatusUtil.newStatus(PreferencesUtil.class, prefs.getInt(ATTR_STATUS_SEVERITY, 0), prefs.get(ATTR_STATUS_MESSAGE, ""));
    }

    public static void putBoolean(Preferences bw, String attrResolved, boolean value) {
        bw.putBoolean(attrResolved, value);
    }

    public static void putInteger(Preferences bw, String attrSegmentCount, int value) {
        bw.putInt(attrSegmentCount, value);
    }

    public static void putString(Preferences bw, String attrChildname, String lastSegment) {
        bw.put(attrChildname, lastSegment);
    }

    public static boolean getBoolean(Preferences br, String key) throws CoreException {
        if (br.get(key, null) == null) {
            throw new CoreException(StatusUtil.newStatus(PreferencesUtil.class, NLS.bind((String)"Unable to find preference key {0}", (Object)key)));
        }
        return br.getBoolean(key, false);
    }

    public static int getInteger(Preferences br, String key) throws CoreException {
        if (br.get(key, null) == null) {
            throw new CoreException(StatusUtil.newStatus(PreferencesUtil.class, NLS.bind((String)"Unable to find preference key {0}", (Object)key)));
        }
        return br.getInt(key, 0);
    }

    public static void readPreferences(FileInputStream inputStream, Preferences prefs, IProgressMonitor newChild) throws CoreException {
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
            for (Object key : properties.keySet()) {
                if (!(key instanceof String)) continue;
                String next = (String)key;
                String value = properties.getProperty(next);
                Path path = new Path(next);
                String prefKey = path.lastSegment();
                path = path.removeLastSegments(1);
                Preferences realNode = prefs;
                if (!path.isEmpty()) {
                    realNode = prefs.node(path.toString());
                }
                realNode.put(prefKey, value);
            }
        }
        catch (IOException e) {
            throw new CoreException(StatusUtil.newStatus(PreferencesUtil.class, e));
        }
    }
}

