/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.core.internal;

import com.ibm.team.repository.rcp.core.internal.Messages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class ProgressAnalyzer {
    private static Job outputJob = new Job(Messages.ProgressAnalyzer_10){

        protected IStatus run(IProgressMonitor monitor) {
            ProgressAnalyzer.showAverages();
            return Status.OK_STATUS;
        }
    };
    private static HashMap<String, ProgressAverage> averages = new HashMap();
    private long startTime;
    private Collection<ProgressSample> data = new ArrayList<ProgressSample>();
    private ProgressSample inprogress;
    private Class toanalyze;
    public static boolean internal_enable_debug = "true".equalsIgnoreCase(Platform.getDebugOption((String)"com.ibm.team.repository.rcp.core/trace.progress.reporting"));

    public ProgressAnalyzer(Class toAnalyze) {
        this.startTime = System.currentTimeMillis();
        this.toanalyze = toAnalyze;
    }

    String generateId(Class classOfInterest) {
        String classNameOfInterest = classOfInterest.getName();
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        StackTraceElement targetElement = null;
        int i = stack.length - 1;
        while (i >= 0) {
            StackTraceElement element = stack[i];
            if (element.getClassName().equals(classNameOfInterest)) break;
            targetElement = element;
            --i;
        }
        if (targetElement == null) {
            return "unknown";
        }
        return String.valueOf(targetElement.getClassName()) + ":" + targetElement.getLineNumber();
    }

    public void record(long workRemaining, double workReported) {
        if (this.startTime == 0L || this.inprogress == null) {
            return;
        }
        workReported = Math.min(workReported, (double)workRemaining);
        String id = this.generateId(this.toanalyze);
        this.data.add(new ProgressSample(System.currentTimeMillis(), workRemaining, workReported, id));
    }

    public void predictTime(long workRemaining, long workReported) {
        workReported = Math.min(workReported, workRemaining);
        String id = this.generateId(this.toanalyze);
        this.inprogress = new ProgressSample(0L, workRemaining, workReported, id);
    }

    public void endPrediction() {
        if (this.inprogress != null) {
            this.inprogress.timestamp = System.currentTimeMillis();
            this.data.add(this.inprogress);
            this.inprogress = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done() {
        if (this.startTime == 0L) {
            return;
        }
        HashMap<String, ProgressAverage> hashMap = averages;
        synchronized (hashMap) {
            long endTime = System.currentTimeMillis();
            long totalTime = endTime - this.startTime;
            long lastTime = this.startTime;
            for (ProgressSample next : this.data) {
                long delta = next.timestamp - lastTime;
                double actualRemaining = endTime - lastTime;
                double idealRatio = (double)delta / actualRemaining;
                double reportedRatio = next.workReported / (double)next.workRemaining;
                double predictedTime = reportedRatio * (double)totalTime;
                double actualTime = idealRatio * (double)totalTime;
                double error = predictedTime - actualTime;
                ProgressAverage avg = averages.get(next.identifier);
                if (avg == null) {
                    avg = new ProgressAverage(next.identifier);
                    averages.put(next.identifier, avg);
                }
                avg.addSample(error, idealRatio * (double)next.workRemaining, 1.0);
                lastTime = next.timestamp;
            }
        }
        this.startTime = 0L;
        outputJob.cancel();
        outputJob.schedule(5000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showAverages() {
        if (!internal_enable_debug) {
            return;
        }
        HashMap<String, ProgressAverage> hashMap = averages;
        synchronized (hashMap) {
            boolean isFirst = true;
            ArrayList<ProgressAverage> toSort = new ArrayList<ProgressAverage>();
            toSort.addAll(averages.values());
            Collections.sort(toSort, new Comparator<ProgressAverage>(){

                @Override
                public int compare(ProgressAverage o1, ProgressAverage o2) {
                    return -((int)(Math.abs(o1.getMean()) - Math.abs(o2.getMean())));
                }
            });
            ArrayList<ProgressAverage> unreliableAverages = new ArrayList<ProgressAverage>();
            for (ProgressAverage next : toSort) {
                double dev = next.getDev();
                if (dev > 0.0 && dev < Math.abs(next.getMean()) / 2.0) {
                    if (isFirst) {
                        System.out.println("---- Dumping averages");
                        isFirst = false;
                    }
                    System.out.println(next.toString());
                    continue;
                }
                unreliableAverages.add(next);
            }
            for (ProgressAverage next : unreliableAverages) {
                if (isFirst) {
                    System.out.println("---- Dumping averages");
                    isFirst = false;
                }
                System.out.println(next.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearAverages() {
        if (!internal_enable_debug) {
            return;
        }
        HashMap<String, ProgressAverage> hashMap = averages;
        synchronized (hashMap) {
            averages.clear();
        }
    }

    private class ProgressAverage {
        String identifier;
        long samples;
        double total;
        double dev_s;
        double recommendedWork;
        double recommendedWorkTotal;

        public ProgressAverage(String id) {
            this.identifier = id;
        }

        public void addSample(double error, double recommendedWork, double recommendedWorkWeight) {
            double oldMean = this.samples == 0L ? 0.0 : this.total / (double)this.samples;
            this.total += error;
            ++this.samples;
            double newMean = this.samples == 0L ? 0.0 : this.total / (double)this.samples;
            this.dev_s += (error - oldMean) * (error - newMean);
            this.recommendedWork += recommendedWork * recommendedWorkWeight;
            this.recommendedWorkTotal += recommendedWorkWeight;
        }

        public double getMean() {
            return this.samples == 0L ? 0.0 : this.total / (double)this.samples;
        }

        public double getDev() {
            if (this.dev_s < 0.0) {
                this.dev_s = -this.dev_s;
            }
            return this.samples < 2L ? 0.0 : Math.sqrt(this.dev_s / (double)(this.samples - 1L));
        }

        public double getRecommendedWork() {
            return this.recommendedWork / this.recommendedWorkTotal;
        }

        public String toString() {
            return String.valueOf(this.identifier) + " = " + this.getRecommendedWork() + ", error = " + this.getMean() + " +/- " + this.getDev();
        }
    }

    private class ProgressSample {
        long timestamp;
        long workRemaining;
        double workReported;
        String identifier;

        public ProgressSample(long timestamp, long workRemaining, double workReported, String identifier) {
            this.timestamp = timestamp;
            this.workRemaining = workRemaining;
            this.workReported = workReported;
            this.identifier = identifier;
        }
    }
}

