/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.core.internal;

import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.rcp.common.NullUtil;
import com.ibm.team.repository.rcp.core.internal.Messages;
import com.ibm.team.repository.rcp.core.utils.ClassIdentifier;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrefSerializableRegistry {
    private static final String ID = "id";
    private static final String CLASS = "class";
    private static SoftReference<Map<String, ClassIdentifier>> mapNamesOntoClasses = new SoftReference<Object>(null);
    private static SoftReference<Map<String, String>> mapClassesOntoNames = new SoftReference<Object>(null);
    private static IRegistryChangeListener registryChangeListener;

    private static void buildMaps() {
        HashMap<String, ClassIdentifier> namesOntoClasses = new HashMap<String, ClassIdentifier>();
        HashMap<String, String> classesOntoNames = new HashMap<String, String>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor("com.ibm.team.repository.rcp.core", "persistable");
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement next = elements[i];
            String bundle = next.getNamespaceIdentifier();
            String clazz = NullUtil.safeString((String)next.getAttribute(CLASS));
            String id = NullUtil.safeString((String)next.getAttribute(ID));
            ClassIdentifier classId = new ClassIdentifier(bundle, clazz);
            classesOntoNames.put(clazz, id);
            namesOntoClasses.put(id, classId);
            ++i;
        }
        mapNamesOntoClasses = new SoftReference(namesOntoClasses);
        mapClassesOntoNames = new SoftReference(classesOntoNames);
        if (registryChangeListener == null) {
            IRegistryChangeListener listener;
            registryChangeListener = listener = new IRegistryChangeListener(){

                public void registryChanged(IRegistryChangeEvent event) {
                    registryChangeListener = null;
                    mapNamesOntoClasses = new SoftReference<Object>(null);
                    mapClassesOntoNames = new SoftReference<Object>(null);
                    Platform.getExtensionRegistry().removeRegistryChangeListener((IRegistryChangeListener)this);
                }
            };
            registry.addRegistryChangeListener(registryChangeListener);
        }
    }

    private static Map<String, ClassIdentifier> getNamesOntoClasses() {
        Map<String, ClassIdentifier> next;
        while ((next = mapNamesOntoClasses.get()) == null) {
            PrefSerializableRegistry.buildMaps();
        }
        return next;
    }

    private static Map<String, String> getClassesOntoNames() {
        Map<String, String> next;
        while ((next = mapClassesOntoNames.get()) == null) {
            PrefSerializableRegistry.buildMaps();
        }
        return next;
    }

    public static ClassIdentifier lookupClass(String className) throws CoreException {
        ClassIdentifier result = PrefSerializableRegistry.getNamesOntoClasses().get(className);
        if (result == null) {
            throw new CoreException(StatusUtil.newStatus(PrefSerializableRegistry.class, NLS.bind((String)Messages.PrefSerializableRegistry_0, (Object)className, (Object[])new Object[0])));
        }
        return result;
    }

    public static String lookupName(ClassIdentifier className) throws CoreException {
        String result = PrefSerializableRegistry.getClassesOntoNames().get(className.getTypeName());
        if (result == null) {
            throw new CoreException(StatusUtil.newStatus(PrefSerializableRegistry.class, NLS.bind((String)Messages.PrefSerializableRegistry_1, (Object)className.getTypeName(), (Object[])new Object[0])));
        }
        return result;
    }
}

