/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.workspace;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.workspace.ReplaceComponentsCmdOptions;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.StringUtil;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsBaseline;
import com.ibm.team.filesystem.client.rest.parameters.ParmsBaselineSet;
import com.ibm.team.filesystem.client.rest.parameters.ParmsOutOfSyncInstructions;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPendingChangesDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceComponentReplaceWithBaseline;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceReplaceWithSnapshot;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceReplaceWithWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceUpdate;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceUpdateDilemmaHandler;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.WorkspaceUpdateResultDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplaceComponentsCmd
extends AbstractSubcommand {
    public void run(IClientConfiguration config) throws FileSystemClientException {
        WorkspaceUpdateResultDTO result;
        ISandbox[] sandboxes = config.getSandboxes();
        IFilesystemRestClient client = SubcommandUtil.startDaemon((ISandbox[])sandboxes, (IClientConfiguration)config);
        SubcommandUtil.registerSandboxes((IFilesystemRestClient)client, (ISandbox[])sandboxes, (IClientConfiguration)config);
        ICommandLine cli = config.getSubcommandCommandLine();
        ParmsWorkspaceUpdate parms = new ParmsWorkspaceUpdate();
        this.generateReplaceComponentParms(cli, client, parms, config);
        if (config.isDryRun()) {
            return;
        }
        try {
            result = client.postWorkspaceUpdate(parms, null);
        }
        catch (TeamRepositoryException e) {
            PermissionDeniedException pde = (PermissionDeniedException)SubcommandUtil.findExceptionByType(PermissionDeniedException.class, (TeamRepositoryException)e);
            if (pde != null) {
                throw StatusHelper.permissionFailure((TeamRepositoryException)pde, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
            }
            throw StatusHelper.wrap((String)Messages.ReplaceComponentsCmd_COULD_NOT_UPDATE, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
        }
        if (result.isCancelled() && result.getConfigurationsWithUnCheckedInChanges().size() > 0) {
            throw StatusHelper.uncheckedInChanges((String)NLS.bind((String)Messages.CreateBaselineCmd_ERROR_UNCOMMITTED_CHANGES_TO_LOCAL_FILESYSTEM, (Object)CommonOptions.OPT_OVERWRITE_UNCOMMITTED.getName()));
        }
        this.showResult(result, config);
    }

    private void showResult(WorkspaceUpdateResultDTO result, IClientConfiguration config) {
        IndentingPrintStream out = new IndentingPrintStream((OutputStream)config.getContext().stdout());
        if (result.getBackedUpToShed().size() > 0) {
            SubcommandUtil.showShedUpdate((String)Messages.AcceptResultDisplayer_SHED_MESSAGE, (IndentingPrintStream)out, (List)result.getBackedUpToShed());
        }
    }

    private void generateReplaceComponentParms(ICommandLine cli, IFilesystemRestClient client, ParmsWorkspaceUpdate parms, IClientConfiguration config) throws FileSystemClientException {
        parms.preoperationRefresh = SubcommandUtil.getPreopRefreshPolicy((IClientConfiguration)config);
        parms.workspaceUpdateDilemmaHandler = new ParmsWorkspaceUpdateDilemmaHandler();
        parms.workspaceUpdateDilemmaHandler.disconnectedComponentsDirection = "continue";
        parms.workspaceUpdateDilemmaHandler.componentFlowDirection = "no";
        parms.workspaceUpdateDilemmaHandler.componentReplacementCandidatesDirection = "continue";
        parms.workspaceUpdateDilemmaHandler.activeChangeSetsDirection = "no";
        parms.workspaceUpdateDilemmaHandler.activeChangeSetsOverlapDirection = "no";
        parms.outOfSyncInstructions = new ParmsOutOfSyncInstructions();
        parms.outOfSyncInstructions.outOfSyncNoPendingChanges = "load";
        parms.outOfSyncInstructions.outOfSyncWithPendingChanges = "load";
        parms.outOfSyncInstructions.deleteRemovedShares = true;
        parms.pendingChangesDilemmaHandler = new ParmsPendingChangesDilemmaHandler();
        parms.pendingChangesDilemmaHandler.pendingChangesInstruction = cli.hasOption((IOptionKey)CommonOptions.OPT_OVERWRITE_UNCOMMITTED) ? "no" : "cancel";
        ReplaceType replaceType = this.findType(cli.getOption((IOptionKey)ReplaceComponentsCmdOptions.OPT_REPLACE_TYPE));
        if (replaceType == ReplaceType.SNAPSHOT && cli.hasOption((IOptionKey)ReplaceComponentsCmdOptions.OPT_BASELINE)) {
            throw StatusHelper.argSyntax((String)Messages.ReplaceComponentsCmd_SNAPSHOT_INVALID_OPTION);
        }
        if (cli.hasOption((IOptionKey)CommonOptions.OPT_ALL) && cli.hasOption((IOptionKey)CommonOptions.OPT_COMPONENTS_SELECTOR)) {
            throw StatusHelper.argSyntax((String)Messages.ReplaceComponentsCmd_COMPONENT_SELECTOR_CANNOT_SPECIFY_BOTH);
        }
        if (!cli.hasOption((IOptionKey)CommonOptions.OPT_ALL) && !cli.hasOption((IOptionKey)CommonOptions.OPT_COMPONENTS_SELECTOR)) {
            throw StatusHelper.argSyntax((String)Messages.ReplaceComponentsCmd_COMPONENT_SELECTOR_SPECIFY_ONE);
        }
        ITeamRepository repo = RepoUtil.loginUrlArgAnc((IClientConfiguration)config);
        SubcommandUtil.loginToClient((IClientConfiguration)config, (ITeamRepository)repo, (IFilesystemRestClient)client);
        IWorkspaceConnection targetWsConn = this.getWorkspaceConnection(cli.getOption(CommonOptions.OPT_WORKSPACE), repo, config);
        IWorkspace targetWs = targetWsConn.getResolvedWorkspace();
        Map<String, String> componentIdsToName = this.getComponentsToBeReplaced(targetWsConn, repo, cli, config);
        if (replaceType == ReplaceType.WORKSPACE) {
            if (cli.hasOption((IOptionKey)ReplaceComponentsCmdOptions.OPT_BASELINE)) {
                parms.workspaceReplaceWithBaseline = this.generateBaselineParms(targetWsConn, cli.getOption((IOptionKey)ReplaceComponentsCmdOptions.OPT_REPLACE_ITEM), cli.getOption((IOptionKey)ReplaceComponentsCmdOptions.OPT_BASELINE), componentIdsToName, repo, config);
            } else {
                parms.workspaceReplaceWithWorkspace = this.generateWorkspaceParms(targetWs, cli.getOption((IOptionKey)ReplaceComponentsCmdOptions.OPT_REPLACE_ITEM), componentIdsToName, repo, config);
            }
        } else {
            parms.workspaceReplaceWithSnapshot = this.generateSnapshotParms(targetWs, cli.getOption((IOptionKey)ReplaceComponentsCmdOptions.OPT_REPLACE_ITEM), componentIdsToName, repo, config);
        }
    }

    private ParmsWorkspaceReplaceWithWorkspace[] generateWorkspaceParms(IWorkspace targetWs, String selector, Map<String, String> componentIdsToName, ITeamRepository repo, IClientConfiguration config) throws FileSystemClientException {
        IWorkspaceConnection sourceWsConn = this.getWorkspaceConnection(selector, repo, config);
        IWorkspace sourceWs = sourceWsConn.getResolvedWorkspace();
        List<IComponent> wsComponents = this.getComponents(sourceWsConn, repo, config);
        ArrayList<String> componentsSkipped = new ArrayList<String>(componentIdsToName.values());
        ArrayList<String> componentsToBeReplaced = new ArrayList<String>();
        for (IComponent comp : wsComponents) {
            if (!componentIdsToName.keySet().contains(comp.getItemId().getUuidValue())) continue;
            componentsToBeReplaced.add(comp.getItemId().getUuidValue());
            componentsSkipped.remove(componentIdsToName.get(comp.getItemId().getUuidValue()));
        }
        if (componentsSkipped.size() > 0) {
            IndentingPrintStream out = new IndentingPrintStream((OutputStream)config.getContext().stdout());
            out.println((CharSequence)NLS.bind((String)Messages.ReplaceComponentsCmd_COMPONENT_NOT_IN_WORKSPACE, (Object)AliasUtil.selector((String)sourceWs.getName(), (UUID)sourceWs.getItemId())));
            out.indent();
            for (String comp : componentsSkipped) {
                out.println((CharSequence)comp);
            }
        }
        ParmsWorkspaceReplaceWithWorkspace[] parms = new ParmsWorkspaceReplaceWithWorkspace[]{new ParmsWorkspaceReplaceWithWorkspace()};
        parms[0].sourceWorkspace = new ParmsWorkspace(repo.getRepositoryURI(), sourceWs.getItemId().getUuidValue());
        parms[0].workspace = new ParmsWorkspace(repo.getRepositoryURI(), targetWs.getItemId().getUuidValue());
        parms[0].componentItemIds = componentsToBeReplaced.toArray(new String[componentsToBeReplaced.size()]);
        return parms;
    }

    private ParmsWorkspaceComponentReplaceWithBaseline[] generateBaselineParms(IWorkspaceConnection targetWsConn, String wsSelector, String blSelector, Map<String, String> componentIdsToName, ITeamRepository repo, IClientConfiguration config) throws FileSystemClientException {
        List list;
        IWorkspace targetWs = targetWsConn.getResolvedWorkspace();
        IWorkspaceConnection sourceWsConn = this.getWorkspaceConnection(wsSelector, repo, config);
        List<IComponent> sourceWsComponents = this.getComponents(sourceWsConn, repo, config);
        ArrayList<IBaselineHandle> baselineHandles = new ArrayList<IBaselineHandle>();
        for (IComponentHandle iComponentHandle : sourceWsComponents) {
            if (!componentIdsToName.keySet().contains(iComponentHandle.getItemId().getUuidValue())) continue;
            IBaselineHandle baselineHandle = null;
            try {
                baselineHandle = RepoUtil.findNamedBaseline((ITeamRepository)sourceWsConn.teamRepository(), (IComponentHandle)iComponentHandle, (String)blSelector, (IClientConfiguration)config);
            }
            catch (RepoUtil.AmbiguousSelectorException e) {
                throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.ReplaceComponentsCmd_AMBIGUOUS_BASELINE, (Object)e.getSelector()));
            }
            catch (RepoUtil.UnmatchedSelectorException unmatchedSelectorException) {}
            if (baselineHandle == null) continue;
            baselineHandles.add(baselineHandle);
        }
        Object var11_13 = null;
        try {
            list = repo.itemManager().fetchCompleteItems(baselineHandles, 0, null);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.ReplaceComponentsCmd_UNKNOWN_BASELINE, (Object)blSelector));
        }
        ArrayList<String> baselineIds = new ArrayList<String>();
        for (IBaseline baseline : list) {
            IComponentHandle compHandle = baseline.getComponent();
            if (!componentIdsToName.keySet().contains(compHandle.getItemId().getUuidValue())) continue;
            baselineIds.add(baseline.getItemId().getUuidValue());
        }
        if (baselineIds.size() == 0) {
            config.getContext().stdout().println(NLS.bind((String)Messages.ReplaceComponentsCmd_BASELINE_NOT_IN_COMPONENT, (Object)blSelector));
        }
        ParmsWorkspaceComponentReplaceWithBaseline[] parms = new ParmsWorkspaceComponentReplaceWithBaseline[baselineIds.size()];
        int count = 0;
        for (String baselineId : baselineIds) {
            ParmsWorkspaceComponentReplaceWithBaseline replaceWithBaseline = new ParmsWorkspaceComponentReplaceWithBaseline();
            replaceWithBaseline.workspace = new ParmsWorkspace(repo.getRepositoryURI(), targetWs.getItemId().getUuidValue());
            replaceWithBaseline.baseline = new ParmsBaseline();
            replaceWithBaseline.baseline.baselineItemId = baselineId;
            replaceWithBaseline.baseline.repositoryUrl = repo.getRepositoryURI();
            parms[count++] = replaceWithBaseline;
        }
        return parms;
    }

    private ParmsWorkspaceReplaceWithSnapshot[] generateSnapshotParms(IWorkspace targetWs, String selector, Map<String, String> componentIdsToName, ITeamRepository repo, IClientConfiguration config) throws FileSystemClientException {
        IBaselineSetHandle ssHandle = null;
        try {
            ssHandle = RepoUtil.findNamedSnapshot((String)selector, (ITeamRepository)repo, (IClientConfiguration)config);
        }
        catch (RepoUtil.UnmatchedSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)((Object)e), (IClientConfiguration)config);
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.ReplaceComponentsCmd_UNKNOWN_SNAPSHOT, (Object)selector));
        }
        catch (RepoUtil.AmbiguousSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)((Object)e), (IClientConfiguration)config);
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.ReplaceComponentsCmd_AMBIGUOUS_SNAPSHOT, (Object)selector));
        }
        ArrayList<String> componentsToBeReplaced = new ArrayList<String>();
        ArrayList<String> componentsSkipped = new ArrayList<String>(componentIdsToName.values());
        IBaselineSet snapshot = null;
        try {
            snapshot = (IBaselineSet)repo.itemManager().fetchCompleteItem((IItemHandle)ssHandle, 0, null);
            List baselineHandles = snapshot.getBaselines();
            List baselines = repo.itemManager().fetchCompleteItems(baselineHandles, 0, null);
            for (IBaseline baseline : baselines) {
                IComponentHandle compHandle = baseline.getComponent();
                if (!componentIdsToName.keySet().contains(compHandle.getItemId().getUuidValue())) continue;
                componentsToBeReplaced.add(compHandle.getItemId().getUuidValue());
                componentsSkipped.remove(componentIdsToName.get(compHandle.getItemId().getUuidValue()));
            }
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)NLS.bind((String)Messages.ReplaceComponentsCmd_UNKNOWN_SNAPSHOT, (Object)selector), (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
        }
        if (componentsSkipped.size() > 0) {
            IndentingPrintStream out = new IndentingPrintStream((OutputStream)config.getContext().stdout());
            out.println((CharSequence)NLS.bind((String)Messages.ReplaceComponentsCmd_COMPONENT_NOT_IN_WORKSPACE, (Object)AliasUtil.selector((String)snapshot.getName(), (UUID)snapshot.getItemId())));
            out.indent();
            for (String comp : componentsSkipped) {
                out.println((CharSequence)comp);
            }
        }
        ParmsWorkspaceReplaceWithSnapshot[] parms = new ParmsWorkspaceReplaceWithSnapshot[]{new ParmsWorkspaceReplaceWithSnapshot()};
        parms[0].workspace = new ParmsWorkspace(repo.getRepositoryURI(), targetWs.getItemId().getUuidValue());
        parms[0].componentItemIds = componentsToBeReplaced.toArray(new String[componentsToBeReplaced.size()]);
        parms[0].baselineSet = new ParmsBaselineSet();
        parms[0].baselineSet.baselineSetItemId = ssHandle.getItemId().getUuidValue();
        parms[0].baselineSet.repositoryUrl = repo.getRepositoryURI();
        return parms;
    }

    private IWorkspaceConnection getWorkspaceConnection(String wsSelector, ITeamRepository repo, IClientConfiguration config) throws FileSystemClientException {
        try {
            return RepoUtil.findNamedWorkspaceConnection((String)wsSelector, (boolean)true, (boolean)true, (ITeamRepository)repo, (IClientConfiguration)config);
        }
        catch (RepoUtil.UnmatchedSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)((Object)e), (IClientConfiguration)config);
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.ReplaceComponentsCmd_UNKNOWN_WORKSPACE, (Object)e.getSelector()));
        }
        catch (RepoUtil.AmbiguousSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)((Object)e), (IClientConfiguration)config);
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.ReplaceComponentsCmd_AMBIGUOUS_WORKSPACE, (Object)e.getSelector()));
        }
    }

    private List<IComponent> getComponents(IWorkspaceConnection wsConn, ITeamRepository repo, IClientConfiguration config) throws FileSystemClientException {
        List wsComponents = null;
        try {
            List wsCompHandles = wsConn.getComponents();
            wsComponents = repo.itemManager().fetchCompleteItems(wsCompHandles, 0, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)NLS.bind((String)Messages.ReplaceComponentsCmd_CANNOT_LIST_COMPONENTS, (Object)wsConn.getName()), (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
        }
        return wsComponents;
    }

    private Map<String, String> getComponentsToBeReplaced(IWorkspaceConnection wsConn, ITeamRepository repo, ICommandLine cli, IClientConfiguration config) throws FileSystemClientException {
        HashMap<String, String> componentIdsToName;
        block5: {
            List<IComponent> components;
            block4: {
                components = this.getComponents(wsConn, repo, config);
                componentIdsToName = new HashMap<String, String>();
                if (!cli.hasOption((IOptionKey)CommonOptions.OPT_COMPONENTS_SELECTOR)) break block4;
                List componentSelectors = cli.getOptions((IOptionKey)CommonOptions.OPT_COMPONENTS_SELECTOR);
                for (String selector : componentSelectors) {
                    UUID uuid = RepoUtil.lookupUuid((String)selector);
                    int matched = 0;
                    for (IComponent comp : components) {
                        if ((uuid == null || !uuid.equals((Object)comp.getItemId())) && !selector.equals(comp.getName())) continue;
                        componentIdsToName.put(comp.getItemId().getUuidValue(), comp.getName());
                        ++matched;
                    }
                    if (matched == 0) {
                        throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.ReplaceComponentsCmd_UNKNOWN_COMPONENT, (Object)selector));
                    }
                    if (matched <= true) continue;
                    throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.ReplaceComponentsCmd_AMBIGUOUS_COMPONENT, (Object)selector));
                }
                break block5;
            }
            if (!cli.hasOption((IOptionKey)CommonOptions.OPT_ALL)) break block5;
            for (IComponent comp : components) {
                componentIdsToName.put(comp.getItemId().getUuidValue(), comp.getName());
            }
        }
        return componentIdsToName;
    }

    private ReplaceType findType(String typeString) throws FileSystemClientException {
        ReplaceType[] replaceTypeArray = ReplaceType.values();
        int n = replaceTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ReplaceType t = replaceTypeArray[n2];
            String[] stringArray = t.getNames();
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String candidate = stringArray[n4];
                if (candidate.equals(typeString)) {
                    return t;
                }
                ++n4;
            }
            ++n2;
        }
        throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ReplaceComponentsCmd_UNKNOWN_TYPE_STRING, (Object)typeString, (Object)StringUtil.join((String)typeString, (String[])ReplaceType.NAMES)));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ReplaceType {
        WORKSPACE("workspace", "workspace", "stream", "ws", "s"),
        SNAPSHOT("baselineset", "snapshot", "ss");

        static final String[] NAMES;
        final String[] typeStrings;
        final String wireName;

        static {
            NAMES = new String[]{ReplaceType.WORKSPACE.typeStrings[0], ReplaceType.WORKSPACE.typeStrings[1], ReplaceType.SNAPSHOT.typeStrings[0]};
        }

        private ReplaceType(String wireName, String ... t) {
            this.wireName = wireName;
            this.typeStrings = t;
        }

        String[] getNames() {
            return this.typeStrings;
        }

        String getWireName() {
            return this.wireName;
        }
    }
}

