/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.workspace;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.workspace.AddComponentsCmd;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IOptionSource;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.ICopyFileAreaView;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.common.internal.rest.client.workspace.PutWorkspaceResultDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveComponentsCmd
extends AddComponentsCmd
implements IOptionSource {
    public RemoveComponentsCmd() {
        super(Messages.RemoveComponentsCmd_WorkspaceToRemoveComponents, Messages.RemoveComponentsCmd_ComponentsToRemove, Messages.RemoveComponentsCmd_ComponentAlreadyFound, "removeComponent", Messages.RemoveComponentsCmd_CannotRemoveComponents);
    }

    @Override
    protected ITeamRepository login(IClientConfiguration config) throws FileSystemClientException {
        return RepoUtil.loginUrlArgAnc((IClientConfiguration)config);
    }

    @Override
    protected boolean alreadyContainsFilter(Set<UUID> alreadyHaveUUIDs, UUID uuid) {
        return !alreadyHaveUUIDs.contains(uuid);
    }

    @Override
    protected void putWorkspace(IClientConfiguration config, ITeamRepository repo, IWorkspace workspace, List<IComponent> filtered) throws FileSystemClientException, TeamRepositoryException {
        HashMap<UUID, IComponent> uuidMap = new HashMap<UUID, IComponent>();
        for (IComponent component : filtered) {
            uuidMap.put(component.getItemId(), component);
        }
        Path cwd = new Path(config.getContext().getCurrentWorkingDirectory());
        File cfaRoot = SubcommandUtil.findAncestorCFARoot((File)cwd.toFile());
        if (cfaRoot != null) {
            ISandbox sandbox = FileSystemCore.getSharingManager().getSandbox((IPath)new Path(cfaRoot.getAbsolutePath()), false);
            ICopyFileAreaView view = SubcommandUtil.getAffectedComponentsAndShares((IClientConfiguration)config, (ISandbox)sandbox, (IPath)cwd);
            Collection loadedWorkspaces = view.getLoadedWorkspaces();
            for (ICopyFileAreaView.IRepoView repoView : loadedWorkspaces) {
                Collection loadedComponents = view.getLoadedComponents(repoView);
                for (ItemId itemId : loadedComponents) {
                    IComponent component = (IComponent)uuidMap.get(itemId.getItemUUID());
                    if (component == null) continue;
                    for (IShare share : view.getLoadedShares(itemId)) {
                        IPath sharePath = share.getSandbox().getRoot().append(share.getPath());
                        if (!sharePath.isPrefixOf((IPath)cwd)) continue;
                        throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.RemoveComponentsCmd_CannotUnloadCWD, (Object)AliasUtil.selector((String)component.getName(), (UUID)component.getItemId())));
                    }
                }
            }
        }
        super.putWorkspace(config, repo, workspace, filtered);
    }

    @Override
    protected List<IComponent> findNamedComponents(IClientConfiguration config, List<String> componentStrings, IWorkspaceConnection workspaceConnection, ITeamRepository repo) throws FileSystemClientException, RepoUtil.UnmatchedSelectorException, RepoUtil.AmbiguousSelectorException {
        List found = RepoUtil.findNamedComponents(componentStrings, (boolean)false, (IWorkspaceConnection)workspaceConnection, (ITeamRepository)repo, (boolean)false, (IClientConfiguration)config);
        ArrayList<IComponent> components = new ArrayList<IComponent>();
        IWorkspace workspace = workspaceConnection.getResolvedWorkspace();
        int i = 0;
        while (i < componentStrings.size()) {
            IComponent component = (IComponent)found.get(i);
            if (component != null) {
                components.add(component);
            } else {
                String selector = componentStrings.get(i);
                config.getContext().stdout().println(NLS.bind((String)Messages.RemoveComponentsCmd_ComponentNotFoundInWorkspace, (Object)selector, (Object)AliasUtil.selector((String)workspace.getName(), (UUID)workspace.getItemId())));
            }
            ++i;
        }
        return components;
    }

    @Override
    protected IFilesystemRestClient getClient(ISandbox[] sandboxes, IClientConfiguration config) throws FileSystemClientException {
        IFilesystemRestClient client = super.getClient(sandboxes, config);
        SubcommandUtil.registerSandboxes((IFilesystemRestClient)client, (ISandbox[])sandboxes, (IClientConfiguration)config);
        return client;
    }

    @Override
    protected void printResult(IClientConfiguration config, List<IComponent> values, PutWorkspaceResultDTO result) throws FileSystemClientException {
        for (IComponent component : values) {
            config.getContext().stdout().println(NLS.bind((String)Messages.RemoveComponentsCmd_ComponentSuccessfullyRemoved, (Object)AliasUtil.selector((String)component.getName(), (UUID)component.getItemId())));
        }
    }
}

