/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.workspace;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.cliparser.IPositionalOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.OptionKey;
import com.ibm.team.filesystem.cli.core.cliparser.Options;
import com.ibm.team.filesystem.cli.core.cliparser.PositionalOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.exceptions.ConflictingOptionException;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IOptionSource;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsComponentChange;
import com.ibm.team.filesystem.client.rest.parameters.ParmsConfigurationChanges;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPutWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.core.ConfigurationDescriptorDTO;
import com.ibm.team.filesystem.common.internal.rest.client.workspace.PutWorkspaceResultDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddComponentsCmd
extends AbstractSubcommand
implements IOptionSource {
    public static final IOptionKey OPT_COMPONENTS = new OptionKey("components");
    private String workspaceHelp;
    private String componentsHelp;
    private String alreadyContainsMsg;
    private String componentChangeCmd;
    private String treMsg;

    public AddComponentsCmd() {
        this(Messages.AddComponentCommand_WorkspaceToAddComponents, Messages.AddComponentCommand_ComponentsToAdd, Messages.AddComponentCommand_SkippingComponentAlreadyFound, "addComponent", Messages.AddComponentCommand_CannotAddComponents);
    }

    public AddComponentsCmd(String workspaceHelp, String componentsHelp, String alreadyContainsMsg, String componentChangeCmd, String treMsg) {
        this.workspaceHelp = workspaceHelp;
        this.componentsHelp = componentsHelp;
        this.alreadyContainsMsg = alreadyContainsMsg;
        this.componentChangeCmd = componentChangeCmd;
        this.treMsg = treMsg;
    }

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption((IPositionalOptionDefinition)new PositionalOptionDefinition(CommonOptions.OPT_WORKSPACE, "workspace", 1, 1), this.workspaceHelp).addOption((IPositionalOptionDefinition)new PositionalOptionDefinition(OPT_COMPONENTS, "components", 1, -1), this.componentsHelp);
        return options;
    }

    public void run(IClientConfiguration config) throws FileSystemClientException {
        ICommandLine cli = config.getSubcommandCommandLine();
        ITeamRepository repo = this.login(config);
        IWorkspaceConnection workspaceConnection = null;
        try {
            String wsSelector = cli.getOption(CommonOptions.OPT_WORKSPACE);
            workspaceConnection = RepoUtil.findNamedWorkspaceConnection((String)wsSelector, (boolean)true, (boolean)true, (ITeamRepository)repo, (IClientConfiguration)config);
        }
        catch (RepoUtil.UnmatchedSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)((Object)e), (IClientConfiguration)config);
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.CreateBaselineCmd_1, (Object)e.getSelector()));
        }
        catch (RepoUtil.AmbiguousSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)((Object)e), (IClientConfiguration)config);
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.CreateBaselineCmd_0, (Object)e.getSelector()));
        }
        IWorkspace workspace = workspaceConnection.getResolvedWorkspace();
        List<IComponent> components = null;
        try {
            List componentStrings = cli.getOptions(OPT_COMPONENTS);
            components = this.findNamedComponents(config, componentStrings, workspaceConnection, repo);
        }
        catch (RepoUtil.UnmatchedSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)((Object)e), (IClientConfiguration)config);
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.ListRemoteFilesCmd_9, (Object)e.getSelector()));
        }
        catch (RepoUtil.AmbiguousSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)((Object)e), (IClientConfiguration)config);
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.AddComponentCommand_AmbiguousComponentSelector, (Object)e.getSelector()));
        }
        try {
            List alreadyHaveComponents = workspaceConnection.getComponents();
            HashSet<UUID> alreadyHaveUUIDs = new HashSet<UUID>(alreadyHaveComponents.size());
            for (IComponentHandle componentHandle : alreadyHaveComponents) {
                alreadyHaveUUIDs.add(componentHandle.getItemId());
            }
            ArrayList<IComponent> filtered = new ArrayList<IComponent>(components);
            Iterator iterator = filtered.iterator();
            while (iterator.hasNext()) {
                IComponent component = (IComponent)iterator.next();
                UUID uuid = component.getItemId();
                if (!this.alreadyContainsFilter(alreadyHaveUUIDs, uuid)) continue;
                config.getContext().stdout().println(NLS.bind((String)this.alreadyContainsMsg, (Object)AliasUtil.selector((String)component.getName(), (UUID)uuid), (Object)AliasUtil.selector((String)workspace.getName(), (UUID)workspace.getItemId())));
                iterator.remove();
            }
            if (!filtered.isEmpty()) {
                this.putWorkspace(config, repo, workspace, filtered);
            }
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)this.treMsg, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
        }
    }

    protected void putWorkspace(IClientConfiguration config, ITeamRepository repo, IWorkspace workspace, List<IComponent> filtered) throws FileSystemClientException, TeamRepositoryException {
        IFilesystemRestClient client = this.getClient(config.getSandboxes(), config);
        this.putWorkspace(config, client, repo, workspace, filtered);
    }

    protected ITeamRepository login(IClientConfiguration config) throws FileSystemClientException {
        ConnectionInfo connectionInfo = config.getConnectionInfo();
        ITeamRepository repo = RepoUtil.login((IClientConfiguration)config, (ConnectionInfo)connectionInfo);
        return repo;
    }

    protected IFilesystemRestClient getClient(ISandbox[] sandboxes, IClientConfiguration config) throws FileSystemClientException {
        return SubcommandUtil.startDaemon((ISandbox[])sandboxes, (IClientConfiguration)config);
    }

    protected boolean alreadyContainsFilter(Set<UUID> alreadyHaveUUIDs, UUID uuid) {
        return alreadyHaveUUIDs.contains(uuid);
    }

    private void putWorkspace(IClientConfiguration config, IFilesystemRestClient client, ITeamRepository repo, IWorkspace workspace, List<IComponent> values) throws TeamRepositoryException, FileSystemClientException {
        ParmsPutWorkspace parms = new ParmsPutWorkspace();
        parms.workspace = new ParmsWorkspace();
        parms.workspace.repositoryUrl = repo.getRepositoryURI();
        parms.workspace.workspaceItemId = workspace.getItemId().getUuidValue();
        parms.configurationChanges = new ParmsConfigurationChanges();
        parms.configurationChanges.components = new ParmsComponentChange[values.size()];
        int i = 0;
        while (i < values.size()) {
            ParmsComponentChange change = new ParmsComponentChange();
            change.cmd = this.componentChangeCmd;
            change.componentItemId = values.get(i).getItemId().getUuidValue();
            parms.configurationChanges.components[i] = change;
            ++i;
        }
        PutWorkspaceResultDTO result = client.postPutWorkspace(parms, null);
        this.printResult(config, values, result);
    }

    protected List<IComponent> findNamedComponents(IClientConfiguration config, List<String> componentStrings, IWorkspaceConnection workspaceConnection, ITeamRepository repo) throws FileSystemClientException, RepoUtil.UnmatchedSelectorException, RepoUtil.AmbiguousSelectorException {
        Map components = RepoUtil.findNamedComponents(componentStrings, (ITeamRepository)repo, (IClientConfiguration)config);
        return new ArrayList<IComponent>(components.values());
    }

    protected void printResult(IClientConfiguration config, List<IComponent> values, PutWorkspaceResultDTO result) throws FileSystemClientException {
        if (!result.isSetComponentsAdded()) {
            throw StatusHelper.failure((String)Messages.AddComponentCommand_CannotAddComponents, null);
        }
        HashMap<UUID, String> uuidToName = new HashMap<UUID, String>();
        for (IComponent component : values) {
            uuidToName.put(component.getItemId(), component.getName());
        }
        List componentsAdded = result.getComponentsAdded();
        for (ConfigurationDescriptorDTO componentDTO : componentsAdded) {
            UUID componentItemId = UUID.valueOf((String)componentDTO.getComponentItemId());
            config.getContext().stdout().println(NLS.bind((String)Messages.AddComponentCommand_ComponentSuccessfullyAdded, (Object)AliasUtil.selector((String)((String)uuidToName.get(componentItemId)), (UUID)componentItemId)));
        }
    }
}

