/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.subcommands.UndoCmdOpts;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.ICopyFileAreaView;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.PendingChangesUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ILocalChangeManager;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.operations.UndoChangesOperation;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.ProducesOrphansInConfigurationException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.osgi.util.NLS;

public class UndoCmd
extends AbstractSubcommand {
    public void run(IClientConfiguration config) throws FileSystemClientException {
        int maxChanges = -1;
        ICommandLine subargs = config.getSubcommandCommandLine();
        List changeSelectors = subargs.getOptions((IOptionKey)UndoCmdOpts.OPT_CHANGES);
        boolean verbose = subargs.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE);
        maxChanges = CommonOptions.getMaxChangesToInterpret((ICommandLine)subargs);
        ICopyFileAreaView cfaView = SubcommandUtil.getAffectedComponentsAndShares((IClientConfiguration)config);
        List workspaces = RepoUtil.getWorkspaceConnections((ICopyFileAreaView)cfaView, (boolean)true);
        ILocalChangeManager lcm = FileSystemCore.getSharingManager().getLocalChangeManager();
        for (IWorkspaceConnection wsConn : workspaces) {
            List cpHandles;
            try {
                cpHandles = wsConn.getComponents();
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)Messages.UndoCmd_12, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
            }
            for (IComponentHandle cpHandle : cpHandles) {
                lcm.syncPendingChanges((IContextHandle)wsConn.getResolvedWorkspace(), cpHandle, cfaView.getRoot(), null);
            }
        }
        LinkedList<ILocalChange> toUndoLocal = new LinkedList<ILocalChange>();
        HashMap toUndo = new HashMap();
        block15: for (String changeSelector : changeSelectors) {
            Object wsConn4;
            IPath changePath = SubcommandUtil.makeAbsolutePath((IClientConfiguration)config, (String)changeSelector);
            ISandbox sb = SubcommandUtil.findSandboxContaining((IPath)changePath);
            if (sb != null) {
                Object relativeChangePath = changePath.removeFirstSegments(sb.getRoot().segmentCount()).makeAbsolute();
                relativeChangePath = relativeChangePath.setDevice(null);
                Shareable changedItem = SharingManager.getInstance().findShareable(sb, (IPath)relativeChangePath, changePath.toFile().isDirectory() ? ResourceType.FOLDER : ResourceType.FILE);
                ILocalChange change = changedItem.getChange(null);
                if (change != null && change.getType() != 0) {
                    toUndoLocal.add(change);
                    continue;
                }
                for (IWorkspaceConnection wsConn2 : workspaces) {
                    List cpHandles;
                    try {
                        cpHandles = wsConn2.getComponents();
                    }
                    catch (TeamRepositoryException e) {
                        throw StatusHelper.wrap((String)Messages.UndoCmd_12, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
                    }
                    for (IComponentHandle cpHandle : cpHandles) {
                        ILocalChange[] localChanges;
                        ILocalChange[] iLocalChangeArray = localChanges = lcm.getPendingChanges((IContextHandle)wsConn2.getResolvedWorkspace(), cpHandle, cfaView.getRoot());
                        int n = localChanges.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ILocalChange localChange = iLocalChangeArray[n2];
                            if (localChange.getPath().equals(relativeChangePath)) {
                                toUndoLocal.add(localChange);
                                continue block15;
                            }
                            ++n2;
                        }
                    }
                }
            }
            HashMap<IWorkspaceConnection, Object> curSelectorToUndo = new HashMap<IWorkspaceConnection, Object>();
            for (IWorkspaceConnection wsConn3 : workspaces) {
                Map tmpToUndo;
                try {
                    tmpToUndo = RepoUtil.findChangesByPath((IClientConfiguration)config, (IWorkspaceConnection)wsConn3, (String)changeSelector);
                }
                catch (TeamRepositoryException e) {
                    throw StatusHelper.wrap((String)Messages.UndoCmd_2, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
                }
                if (tmpToUndo.isEmpty()) continue;
                curSelectorToUndo.put(wsConn3, tmpToUndo);
            }
            if (curSelectorToUndo.isEmpty()) {
                throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.UndoCmd_0, (Object)changeSelector));
            }
            boolean ambiguous = curSelectorToUndo.size() > 1;
            for (Object wsConn4 : curSelectorToUndo.keySet()) {
                Map tmpToUndo = (Map)curSelectorToUndo.get(wsConn4);
                ambiguous |= tmpToUndo.size() > 1;
                for (IChangeSetHandle csHandle : tmpToUndo.keySet()) {
                    ambiguous |= ((List)tmpToUndo.get(csHandle)).size() > 1;
                }
            }
            if (ambiguous) {
                throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.UndoCmd_3, (Object)changeSelector));
            }
            wsConn4 = curSelectorToUndo.keySet().iterator();
            while (wsConn4.hasNext()) {
                IWorkspaceConnection wsConn5 = (IWorkspaceConnection)wsConn4.next();
                if (!toUndo.containsKey(wsConn5)) {
                    toUndo.put(wsConn5, new HashMap());
                }
                Map csChangesDest = (Map)toUndo.get(wsConn5);
                Map csChangesSrc = (Map)curSelectorToUndo.get(wsConn5);
                for (IChangeSetHandle csHandle : csChangesSrc.keySet()) {
                    if (!csChangesDest.containsKey(csHandle)) {
                        csChangesDest.put(csHandle, new LinkedList());
                    }
                    List changesDest = (List)csChangesDest.get(csHandle);
                    changesDest.addAll((Collection)csChangesSrc.get(csHandle));
                }
            }
        }
        PendingChangesUtil.PendingChangesOptions options = new PendingChangesUtil.PendingChangesOptions();
        options.enablePrinter(0);
        options.enablePrinter(1);
        options.enablePrinter(2);
        options.enablePrinter(8);
        options.enablePrinter(4);
        options.enablePrinter(6);
        options.setMaxChanges(maxChanges);
        options.enableFilter(0);
        options.enableFilter(1);
        options.enableFilter(2);
        options.enableFilter(4);
        options.enableFilter(6);
        HashMap<IWorkspaceConnection, UndoChangesOperation> undoers = new HashMap<IWorkspaceConnection, UndoChangesOperation>();
        for (IWorkspaceConnection wsConn : toUndo.keySet()) {
            UndoChangesOperation undoer = new UndoChangesOperation(wsConn, null);
            Map csChanges = (Map)toUndo.get(wsConn);
            undoers.put(wsConn, undoer);
            ArrayList csHandles = new ArrayList(csChanges.keySet());
            if (verbose) {
                List changeSets;
                options.addFilter((IItemHandle)wsConn.getResolvedWorkspace(), 0);
                try {
                    changeSets = wsConn.teamRepository().itemManager().fetchPartialItems(csHandles, 0, Collections.singleton(IChangeSet.COMPONENT_PROPERTY), null);
                }
                catch (TeamRepositoryException e) {
                    throw StatusHelper.wrap((String)Messages.UndoCmd_8, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
                }
                for (IChangeSet cs : changeSets) {
                    options.addFilter((IItemHandle)cs.getComponent(), 1);
                }
            }
            for (IChangeSetHandle csHandle : csHandles) {
                List changes = (List)csChanges.get(csHandle);
                if (verbose) {
                    options.addFilter((IItemHandle)csHandle, 4);
                    for (IChange change : changes) {
                        options.addFilter((IItemHandle)change.item(), 6);
                    }
                }
                undoer.addChangesToUndo(csHandle, (Collection)changes);
            }
        }
        if (verbose) {
            for (ILocalChange localChange : toUndoLocal) {
                options.addFilter((IItemHandle)localChange.getShareable().getVersionable(null), 2);
                options.addFilter((IItemHandle)localChange.getComponent(), 1);
                options.addFilter((IItemHandle)localChange.getConnection(), 0);
            }
            IndentingPrintStream ps = new IndentingPrintStream((OutputStream)config.getContext().stdout());
            if (config.isDryRun()) {
                ps.println((CharSequence)Messages.UndoCmd_4);
            } else {
                ps.println((CharSequence)Messages.UndoCmd_5);
            }
            PendingChangesUtil.printPendingChanges((boolean)false, (PendingChangesUtil.PendingChangesOptions)options, (IndentingPrintStream)ps.indent(), (IClientConfiguration)config);
        }
        if (!config.isDryRun()) {
            try {
                lcm.undoChanges(toUndoLocal.toArray(new ILocalChange[0]), null, null);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)Messages.UndoCmd_14, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
            }
            for (IWorkspaceConnection wsConn : undoers.keySet()) {
                try {
                    ((UndoChangesOperation)undoers.get(wsConn)).run(null);
                }
                catch (ProducesOrphansInConfigurationException e) {
                    throw StatusHelper.orphan((String)Messages.UndoCmd_10, (ProducesOrphansInConfigurationException)e);
                }
                catch (TeamRepositoryException e) {
                    throw StatusHelper.wrap((String)Messages.UndoCmd_6, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
                }
            }
        }
    }
}

