/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.subcommands.StatusCmdOpts;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.ChoppingIndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.PendingChangesUtil;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICorruptCopyFileAreaEvent;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICorruptCopyFileAreaListener;
import java.io.OutputStream;
import org.eclipse.core.resources.ResourcesPlugin;

public class StatusCmd
extends AbstractSubcommand {
    public void run(IClientConfiguration config) throws FileSystemClientException {
        int chopsize = 80;
        int maxChanges = -1;
        boolean refreshLocal = true;
        ICommandLine subargs = config.getSubcommandCommandLine();
        boolean verbose = subargs.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE);
        boolean wide = subargs.hasOption((IOptionKey)CommonOptions.OPT_WIDE);
        chopsize = SubcommandUtil.getTerminalWidth();
        boolean xchangeset = subargs.hasOption((IOptionKey)StatusCmdOpts.OPT_EXPAND_CHANGESET);
        boolean xbaseline = subargs.hasOption((IOptionKey)StatusCmdOpts.OPT_EXPAND_BASELINE);
        boolean xitem = subargs.hasOption((IOptionKey)StatusCmdOpts.OPT_EXPAND_ID);
        maxChanges = CommonOptions.getMaxChangesToInterpret((ICommandLine)subargs);
        refreshLocal = !subargs.hasOption((IOptionKey)StatusCmdOpts.OPT_NO_LOCAL_REFRESH);
        ResourcesPlugin.getWorkspace();
        this.isCorrupt(verbose, config);
        PendingChangesUtil.PendingChangesOptions options = new PendingChangesUtil.PendingChangesOptions();
        options.setVerbose(verbose);
        options.enablePrinter(0);
        options.enablePrinter(1);
        options.enablePrinter(11);
        options.enablePrinter(2);
        options.enablePrinter(9);
        options.enablePrinter(8);
        options.enablePrinter(10);
        options.enablePrinter(4);
        options.enablePrinter(5);
        options.enablePrinter(3);
        if (xchangeset) {
            options.enablePrinter(7);
            options.enablePrinter(6);
            options.setMaxChanges(maxChanges);
        }
        if (xbaseline) {
            options.enablePrinter(12);
        }
        if (xitem) {
            options.enablePrinter(14);
        }
        if (verbose) {
            options.enablePrinter(13);
        }
        options.setFilesystemScan(refreshLocal);
        IndentingPrintStream ps = wide ? new IndentingPrintStream((OutputStream)config.getContext().stdout()) : new ChoppingIndentingPrintStream((OutputStream)config.getContext().stdout(), chopsize);
        PendingChangesUtil.printPendingChanges((boolean)true, (PendingChangesUtil.PendingChangesOptions)options, (IndentingPrintStream)ps, (IClientConfiguration)config);
    }

    private void isCorrupt(boolean verbose, IClientConfiguration config) {
        final boolean[] verdict = new boolean[1];
        ICorruptCopyFileAreaListener listener = new ICorruptCopyFileAreaListener(){

            public void corrupt(ICorruptCopyFileAreaEvent event) {
                verdict[0] = event.isCorrupt();
            }
        };
        ((SharingManager)FileSystemCore.getSharingManager()).addListener(listener);
        ((SharingManager)FileSystemCore.getSharingManager()).removeListener(listener);
        if (verdict[0]) {
            config.getContext().stdout().println(Messages.StatusCmd_0);
        } else if (verbose) {
            config.getContext().stdout().println(Messages.StatusCmd_1);
        }
    }
}

