/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.subcommands.ResolveCmdOpts;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.ChattyRepoRunnable;
import com.ibm.team.filesystem.cli.core.util.ICopyFileAreaView;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IFileSystemView;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.operations.ApplyAcceptedOperation;
import com.ibm.team.filesystem.client.internal.operations.MarkAsMergedOperation;
import com.ibm.team.filesystem.client.internal.operations.ResolveConflictsOperation;
import com.ibm.team.filesystem.client.operations.ApplyAcceptedDilemmaHandler;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.client.operations.MarkAsMergedDilemmaHandler;
import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.filesystem.common.ILogicalConflict;
import com.ibm.team.filesystem.common.ILogicalConflictReport;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IUpdateReport;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.io.OutputStream;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolveCmd
extends AbstractSubcommand {
    public void run(IClientConfiguration config) throws FileSystemClientException {
        ICommandLine subargs = config.getSubcommandCommandLine();
        Mode mode = Mode.MERGED;
        List resources = subargs.getOptions((IOptionKey)ResolveCmdOpts.OPT_TO_RESOLVE);
        if (resources.size() == 0) {
            throw StatusHelper.argSyntax((String)Messages.ResolveCmd_2);
        }
        int defined = 0;
        try {
            subargs.getOptions((IOptionKey)ResolveCmdOpts.OPT_RESOLVE_MERGED);
            ++defined;
            mode = Mode.MERGED;
        }
        catch (NoSuchElementException noSuchElementException) {}
        try {
            subargs.getOptions((IOptionKey)ResolveCmdOpts.OPT_RESOLVE_PROPOSED);
            ++defined;
            mode = Mode.PROPOSED;
        }
        catch (NoSuchElementException noSuchElementException) {}
        if (defined != 1) {
            throw StatusHelper.argSyntax((String)Messages.ResolveCmd_1);
        }
        ResourcesPlugin.getWorkspace();
        Resolver resolver = null;
        switch (mode) {
            case MERGED: {
                resolver = new MergedResolver();
                break;
            }
            case PROPOSED: {
                resolver = new ProposedResolver();
            }
        }
        ICopyFileAreaView cfa = SubcommandUtil.getAffectedComponentsAndShares((IClientConfiguration)config);
        ShareableItemToResolve[] paths = new ShareableItemToResolve[resources.size()];
        int i = 0;
        while (i < paths.length) {
            Path path = new Path((String)resources.get(i));
            IShareable shareable = cfa.findShareable(path.toString());
            if (shareable == null) {
                throw StatusHelper.disallowed((String)NLS.bind((String)Messages.PropertyListCmd_PathIsNotShared, (Object)path.toOSString()));
            }
            paths[i] = new ShareableItemToResolve(shareable);
            ++i;
        }
        List<ToResolve> workspaces = this.findToResolve(config, cfa, paths);
        this.ensureMatched(paths, config);
        this.resolve(resolver, workspaces, config);
    }

    private void resolve(Resolver resolver, List<ToResolve> workspaces, IClientConfiguration config) throws FileSystemClientException {
        for (ToResolve toResolve : workspaces) {
            ResolveConflictsOperation op = resolver.resolve(toResolve);
            try {
                op.run(null);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)Messages.ResolveCmd_4, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
            }
        }
    }

    private List<ToResolve> findToResolve(IClientConfiguration config, ICopyFileAreaView cfa, final ShareableItemToResolve[] paths) throws FileSystemClientException {
        final LinkedList<ToResolve> workspaces = new LinkedList<ToResolve>();
        ChattyRepoRunnable runnable = new ChattyRepoRunnable(config){

            public void run(ICopyFileAreaView cfa, ICopyFileAreaView.IRepoView view, IWorkspaceConnection wsConn) throws FileSystemClientException {
                ILogicalConflictReport conflictReport;
                IFileSystemView fsv = FileSystemCore.getFileSystemManager((ITeamRepository)wsConn.teamRepository()).getFileSystemView((IConnection)wsConn);
                try {
                    conflictReport = fsv.conflictReport(null);
                }
                catch (TeamRepositoryException e) {
                    throw StatusHelper.wrap((String)Messages.ResolveCmd_6, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)this.config.getContext().stderr()));
                }
                IUpdateReport report = conflictReport.conflictReport();
                ResolveCmd.this.findChangesToResolve(cfa, view, wsConn, report, conflictReport, paths, workspaces);
            }
        };
        cfa.runOnEachRepo((ICopyFileAreaView.IRepoRunnable)runnable, config, (IOptionKey)CommonOptions.OPT_USERNAME, (IOptionKey)CommonOptions.OPT_PASSWORD);
        if (runnable.hadLoginFailure()) {
            throw StatusHelper.login();
        }
        return workspaces;
    }

    private void ensureMatched(ShareableItemToResolve[] paths, IClientConfiguration config) throws FileSystemClientException {
        LinkedList<ShareableItemToResolve> unmatched = new LinkedList<ShareableItemToResolve>();
        ShareableItemToResolve[] shareableItemToResolveArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            ShareableItemToResolve path = shareableItemToResolveArray[n2];
            if (!path.matched) {
                unmatched.add(path);
            }
            ++n2;
        }
        if (unmatched.size() > 0) {
            config.getContext().stderr().println(Messages.ResolveCmd_7);
            for (ShareableItemToResolve path : unmatched) {
                config.getContext().stderr().println("  " + path.getPath().toOSString());
            }
            throw StatusHelper.ambiguousSelector((String)Messages.ResolveCmd_8);
        }
    }

    protected void findChangesToResolve(ICopyFileAreaView cfa, ICopyFileAreaView.IRepoView view, IWorkspaceConnection wsConn, IUpdateReport report, ILogicalConflictReport conflictReport, ShareableItemToResolve[] paths, LinkedList<ToResolve> workspaces) throws FileSystemClientException {
        LinkedList<ILogicalConflict> conflicts = new LinkedList<ILogicalConflict>();
        for (ItemId item : cfa.getLoadedComponents(view)) {
            for (ILogicalConflict conflict : conflictReport.getConflictsForComponent((IComponentHandle)item.toHandle())) {
                ShareableItemToResolve[] shareableItemToResolveArray = paths;
                int n = paths.length;
                int n2 = 0;
                while (n2 < n) {
                    ShareableItemToResolve path = shareableItemToResolveArray[n2];
                    if (!path.matched && path.matches(conflict)) {
                        path.matched = true;
                        conflicts.add(conflict);
                    }
                    ++n2;
                }
            }
        }
        if (conflicts.size() > 0) {
            workspaces.add(new ToResolve(wsConn, conflictReport, conflicts));
        }
    }

    private static class MergedResolver
    extends Resolver {
        private MergedResolver() {
        }

        protected ResolveConflictsOperation resolve(ToResolve toResolve) throws FileSystemClientException {
            return new MarkAsMergedOperation(toResolve.wsConn, toResolve.report, toResolve.changes, (MarkAsMergedDilemmaHandler)new MyMarkAsMergedDilemmaHandler());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Mode {
        MERGED,
        PROPOSED;

    }

    private static class MyApplyAcceptedDilemmaHandler
    extends ApplyAcceptedDilemmaHandler {
        private MyApplyAcceptedDilemmaHandler() {
        }

        public BackupDilemmaHandler getBackupDilemmaHandler() {
            return new BackupDilemmaHandler(){

                public boolean backupEnabled() {
                    return true;
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyMarkAsMergedDilemmaHandler
    extends MarkAsMergedDilemmaHandler {
        private MyMarkAsMergedDilemmaHandler() {
        }

        public int unmergedChanges(Collection<ILogicalChange> changes) {
            return 0;
        }

        public BackupDilemmaHandler getBackupDilemmaHandler() {
            return new BackupDilemmaHandler(){

                public boolean backupEnabled() {
                    return true;
                }
            };
        }
    }

    private static class ProposedResolver
    extends Resolver {
        private ProposedResolver() {
        }

        protected ResolveConflictsOperation resolve(ToResolve toResolve) throws FileSystemClientException {
            return new ApplyAcceptedOperation(toResolve.wsConn, toResolve.report, toResolve.changes, (ApplyAcceptedDilemmaHandler)new MyApplyAcceptedDilemmaHandler());
        }
    }

    private static abstract class Resolver {
        private Resolver() {
        }

        protected abstract ResolveConflictsOperation resolve(ToResolve var1) throws FileSystemClientException;
    }

    private static class ShareableItemToResolve {
        final IShareable shareable;
        UUID uuid = null;
        boolean matched = false;

        public ShareableItemToResolve(IShareable shareable) {
            this.shareable = shareable;
        }

        public UUID getUuid() throws FileSystemClientException {
            if (this.uuid == null) {
                IVersionableHandle handle = this.shareable.getRemote(null);
                if (handle == null) {
                    throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ResolveCmd_PATH_NOT_SHARED, (Object)this.shareable.getLocalPath().toOSString()));
                }
                this.uuid = handle.getItemId();
            }
            return this.uuid;
        }

        public boolean matches(ILogicalConflict conflict) throws FileSystemClientException {
            if (this.getUuid().equals((Object)conflict.item().getItemId())) {
                return true;
            }
            Collection versionables = conflict.conflictingItems();
            for (IVersionableHandle versionable : versionables) {
                if (!this.getUuid().equals((Object)versionable.getItemId())) continue;
                return true;
            }
            return false;
        }

        public IPath getPath() {
            return this.shareable.getLocalPath();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ToResolve {
        final IWorkspaceConnection wsConn;
        final ILogicalConflictReport report;
        final Collection<ILogicalConflict> changes;

        public ToResolve(IWorkspaceConnection wsConn, ILogicalConflictReport report, Collection<ILogicalConflict> changes) {
            this.wsConn = wsConn;
            this.report = report;
            this.changes = changes;
        }
    }
}

