/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.operations.RebuildCFAOperation;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.UUID;
import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public class RepairCmd
extends AbstractSubcommand {
    public void run(IClientConfiguration config) throws FileSystemClientException {
        config.getContext().stdout().println(Messages.RepairCmd_0);
        final ITeamRepository repo = RepoUtil.login((IClientConfiguration)config, (ConnectionInfo)config.getConnectionInfo());
        IRepositoryResolver resolver = new IRepositoryResolver(){

            public ITeamRepository getRepoFor(String uri, UUID id) {
                if (!$assertionsDisabled && !repo.getAliasRepositoryURIs().contains(uri)) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && !repo.getId().equals((Object)id)) {
                    throw new AssertionError();
                }
                return repo;
            }
        };
        File sandboxFile = SubcommandUtil.findAncestorCFARoot((String)config.getContext().getCurrentWorkingDirectory());
        if (sandboxFile == null) {
            throw StatusHelper.misconfiguredLocalFS((String)NLS.bind((String)Messages.RepairCmd_NO_SANDBOX_METADATA, (Object)config.getContext().getCurrentWorkingDirectory()));
        }
        Path sandboxPath = new Path(sandboxFile.getAbsolutePath());
        OperationParticipant participant = new OperationParticipant(config);
        RebuildCFAOperation.rebuildCFA((IPath)sandboxPath, (IRepositoryResolver)resolver, (RebuildCFAOperation.RebuildOperationParticipant)participant, null);
        if (participant.hadProblem()) {
            throw StatusHelper.failure((String)Messages.RepairCmd_6, null);
        }
        config.getContext().stdout().println(Messages.RepairCmd_1);
    }

    private class OperationParticipant
    extends RebuildCFAOperation.RebuildOperationParticipant {
        private boolean problem = false;
        private IClientConfiguration config = null;

        OperationParticipant(IClientConfiguration config) {
            this.config = config;
        }

        private void setProblem() {
            this.problem = true;
        }

        boolean hadProblem() {
            return this.problem;
        }

        public void noDescriptorsFound() {
            this.setProblem();
            this.config.getContext().stderr().println(Messages.RepairCmd_4);
        }

        public void ignoredErrors(IStatus status) throws FileSystemClientException {
            this.setProblem();
            LoggingHelper.log((IStatus)status);
            this.config.getContext().stderr().println(Messages.RepairCmd_5);
        }
    }
}

