/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.subcommands.MoveCmdOpts;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public class MoveCmd
extends AbstractSubcommand {
    public void run(IClientConfiguration config) throws FileSystemClientException {
        ResourceType sourceHint;
        ICommandLine subargs = config.getSubcommandCommandLine();
        IPath source = SubcommandUtil.makeAbsolutePath((IClientConfiguration)config, (String)subargs.getOption((IOptionKey)MoveCmdOpts.OPT_SOURCE));
        ISandbox sourceSandbox = SubcommandUtil.findSandboxContaining((IPath)source);
        if (sourceSandbox == null) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.MoveCmd_0, (Object)subargs.getOption((IOptionKey)MoveCmdOpts.OPT_SOURCE)));
        }
        IPath target = SubcommandUtil.makeAbsolutePath((IClientConfiguration)config, (String)subargs.getOption((IOptionKey)MoveCmdOpts.OPT_TARGET));
        ISandbox targetSandbox = SubcommandUtil.findSandboxContaining((IPath)target);
        if (targetSandbox == null) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.MoveCmd_1, (Object)subargs.getOption((IOptionKey)MoveCmdOpts.OPT_TARGET)));
        }
        if (!targetSandbox.equals(sourceSandbox)) {
            throw StatusHelper.argSyntax((String)Messages.MoveCmd_MOVE_ACROSS_SANDBOXES_NOT_ALLOWED);
        }
        source = source.removeFirstSegments(sourceSandbox.getRoot().segmentCount());
        target = target.removeFirstSegments(targetSandbox.getRoot().segmentCount());
        SharingManager sm = SharingManager.getInstance();
        Shareable src = sm.findShareable(sourceSandbox, source, sourceHint = source.toFile().isDirectory() ? ResourceType.FOLDER : ResourceType.FILE);
        if (src == null || !src.exists(null)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.MoveCmd_2, (Object)sourceSandbox.getRoot().append(source).toOSString()));
        }
        IShare share = src.getShare(null);
        if (share != null && share.getPath().equals((Object)src.getLocalPath())) {
            throw StatusHelper.moveFailure((String)NLS.bind((String)Messages.MoveCmd_9, (Object)sourceSandbox.getRoot().append(source).toOSString()));
        }
        ResourceType hint = target.toFile().isDirectory() ? ResourceType.FOLDER : ResourceType.FILE;
        Shareable tgt = sm.findShareable(targetSandbox, target, hint);
        if (tgt.exists(null)) {
            if (tgt.getResourceType(null) == ResourceType.FOLDER) {
                tgt = sm.findShareable(targetSandbox, target = new Path(String.valueOf(target.toPortableString()) + '/' + source.lastSegment()), sourceHint);
                if (tgt.exists(null)) {
                    throw StatusHelper.moveFailure((String)NLS.bind((String)Messages.MoveCmd_TARGET_FILE_OR_FOLDER_EXISTS, (Object)tgt.getLocalPath().toOSString()));
                }
            } else {
                throw StatusHelper.moveFailure((String)NLS.bind((String)Messages.MoveCmd_4, (Object)target));
            }
        }
        if ((target = target.makeAbsolute()).segmentCount() == 1) {
            throw StatusHelper.moveFailure((String)NLS.bind((String)Messages.MoveCmd_10, (Object)target));
        }
        if (src.getFullPath().isPrefixOf(target)) {
            throw StatusHelper.moveFailure((String)Messages.MoveCmd_5);
        }
        if (share != null) {
            try {
                LocalChangeManager.getInstance().refreshChanges(share, (IShareable)src, null);
            }
            catch (CoreException e) {
                throw StatusHelper.failure((String)NLS.bind((String)Messages.MoveCmd_6, (Object)source), (Throwable)e);
            }
        }
        if (config.isDryRun()) {
            return;
        }
        try {
            src.getFileStorage().move(tgt.getSandbox(), tgt.getLocalPath(), null);
        }
        catch (CoreException e) {
            String message = NLS.bind((String)Messages.MoveCmd_7, (Object)source, (Object)target);
            switch (e.getStatus().getCode()) {
                case 367: 
                case 374: {
                    message = NLS.bind((String)Messages.MoveCmd_8, (Object)target);
                }
            }
            throw StatusHelper.moveFailure((String)message);
        }
    }
}

