/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.cliparser.Options;
import com.ibm.team.filesystem.cli.core.cliparser.exceptions.ConflictingOptionException;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IOptionSource;
import com.ibm.team.filesystem.cli.core.subcommands.IRepositoryRecord;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;

public class LogoutCmd
extends AbstractSubcommand
implements IOptionSource {
    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false);
        options.setLongHelp(Messages.LogoutCmd_0);
        options.addOption((IOptionKey)CommonOptions.OPT_URI, "r", "repository", Messages.LogoutCmd_1, 1);
        return options;
    }

    public void run(IClientConfiguration config) throws FileSystemClientException {
        ICommandLine subargs = config.getSubcommandCommandLine();
        String repoURI = subargs.getOption((IOptionKey)CommonOptions.OPT_URI, null);
        if (repoURI == null) {
            throw StatusHelper.argSyntax((String)Messages.LogoutCmd_2);
        }
        IRepositoryRecord rec = config.getRepositoryRegistry().getRecordByURL(repoURI);
        if (rec == null) {
            rec = config.getRepositoryRegistry().getRecordByNickname(repoURI);
        }
        if (rec == null) {
            throw StatusHelper.argSyntax((String)(String.valueOf(Messages.LogoutCmd_3) + repoURI));
        }
        config.getRepositoryRegistry().removeRecord(rec);
        ITeamRepository repo = TeamPlatform.getTeamRepositoryService().getTeamRepository(rec.getUrl(), 4);
        if (repo != null) {
            repo.logout();
        }
        config.getContext().stdout().println(String.valueOf(Messages.LogoutCmd_4) + rec.getUrl());
    }
}

