/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.cliparser.OptionKey;
import com.ibm.team.filesystem.cli.core.cliparser.Options;
import com.ibm.team.filesystem.cli.core.cliparser.exceptions.ConflictingOptionException;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IOptionSource;
import com.ibm.team.filesystem.cli.core.subcommands.IRepositoryRegistry;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import java.io.IOException;
import org.eclipse.osgi.util.NLS;

public class LoginCmd
extends AbstractSubcommand
implements IOptionSource {
    public static final IOptionKey OPT_NICKNAME = new OptionKey("nick");
    public static final IOptionKey OPT_CACHE = new OptionKey("cache");

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false);
        options.setLongHelp(Messages.LoginCmd_0);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption(OPT_NICKNAME, "n", "nickname", Messages.LoginCmd_1, 1);
        options.addOption(OPT_CACHE, "c", "cache", Messages.LoginCmdOptions_CACHE_HELP, 0);
        return options;
    }

    public void run(IClientConfiguration config) throws FileSystemClientException {
        ICommandLine subargs = config.getSubcommandCommandLine();
        String url = subargs.getOption((IOptionKey)CommonOptions.OPT_URI, null);
        if (url == null) {
            throw StatusHelper.argSyntax((String)Messages.LoginCmd_2);
        }
        String nick = subargs.getOption(OPT_NICKNAME, null);
        String username = subargs.getOption((IOptionKey)CommonOptions.OPT_USERNAME, null);
        String password = subargs.getOption((IOptionKey)CommonOptions.OPT_PASSWORD, null);
        if (username == null) {
            username = System.getProperty("user.name");
        }
        if (username == null) {
            throw StatusHelper.argSyntax((String)Messages.LoginCmd_3);
        }
        String passwordToStore = password;
        if (password == null && config.mayInteract()) {
            try {
                password = config.getContext().getPassword(NLS.bind((String)Messages.LoginCmd_8, (Object)username, (Object)url), config.mayMaskPassword());
                if (subargs.hasOption(OPT_CACHE)) {
                    passwordToStore = password;
                }
            }
            catch (IOException e) {
                throw StatusHelper.failure((String)Messages.LoginCmd_5, (Throwable)e);
            }
        }
        if (password == null) {
            throw StatusHelper.argSyntax((String)Messages.LoginCmd_6);
        }
        ConnectionInfo info = new ConnectionInfo(url, username, password);
        RepoUtil.login((IClientConfiguration)config, (ConnectionInfo)info);
        IRepositoryRegistry repoReg = config.getRepositoryRegistry();
        repoReg.addRecord(url, nick, username, passwordToStore);
        config.getContext().stdout().println(NLS.bind((String)Messages.LoginCmd_7, (Object)url));
    }
}

