/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.subcommands.LoadCmd;
import com.ibm.team.filesystem.cli.client.internal.subcommands.LoadCmdOptions;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.TempHelper;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import java.io.File;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadCmdLauncher
extends AbstractSubcommand {
    public void run(IClientConfiguration config) throws FileSystemClientException {
        File cfaRoot;
        List cSelectors = null;
        ICommandLine subargs = config.getSubcommandCommandLine();
        String wsSelector = subargs.getOption(LoadCmdOptions.OPT_WORKSPACE_SELECTOR);
        ConnectionInfo connectionInfo = config.getConnectionInfo();
        String loadTargetStr = subargs.getOption(LoadCmdOptions.OPT_LOAD_TARGET, null);
        String alternativeName = subargs.getOption(LoadCmdOptions.OPT_ALTERNATIVE_NAME, null);
        boolean getAll = subargs.hasOption((IOptionKey)CommonOptions.OPT_ALL);
        if (getAll && alternativeName != null) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.LoadCmdLauncher_TOO_MANY_COMPONENTS, (Object)subargs.getDefinition().getOption(LoadCmdOptions.OPT_ALTERNATIVE_NAME).getName()));
        }
        if (subargs.hasOption(LoadCmdOptions.OPT_REMOTE_PATHS)) {
            cSelectors = subargs.getOptions(LoadCmdOptions.OPT_REMOTE_PATHS);
            if (cSelectors.size() > 1 && loadTargetStr != null) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.LoadCmdLauncher_TOO_MANY_REMOTE_PATHS, (Object)subargs.getDefinition().getOption(LoadCmdOptions.OPT_LOAD_TARGET).getName()));
            }
            if (cSelectors.size() > 1 && alternativeName != null) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.LoadCmdLauncher_TOO_MANY_REMOTE_PATHS, (Object)subargs.getDefinition().getOption(LoadCmdOptions.OPT_ALTERNATIVE_NAME).getName()));
            }
        }
        if (cSelectors == null && alternativeName != null) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.LoadCmdLauncher_NO_REMOTE_PATHS, (Object)subargs.getDefinition().getOption(LoadCmdOptions.OPT_ALTERNATIVE_NAME).getName()));
        }
        boolean loadCompRoots = subargs.hasOption(LoadCmdOptions.OPT_LOAD_COMPONENT_ROOTS);
        if (loadCompRoots && alternativeName != null) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.LoadCmdLauncher_SPECIFY_ONE_OF_COMPROOT_OR_ALTNAME, (Object)subargs.getDefinition().getOption(LoadCmdOptions.OPT_LOAD_COMPONENT_ROOTS).getName(), (Object)subargs.getDefinition().getOption(LoadCmdOptions.OPT_ALTERNATIVE_NAME).getName()));
        }
        boolean quiet = subargs.hasOption((IOptionKey)CommonOptions.OPT_QUIET);
        String dirStr = subargs.getOption((IOptionKey)CommonOptions.OPT_DIRECTORY, null);
        LoadRuleConfig loadRuleConfig = this.consumeLoadRuleArgs(subargs, cSelectors);
        Path loadTarget = null;
        File cwd = new File(config.getContext().getCurrentWorkingDirectory());
        File loc = dirStr == null ? cwd : new File(dirStr);
        File cfaAncestor = SubcommandUtil.findAncestorCFARoot((File)loc);
        if (cfaAncestor == null) {
            ResourceType resourceType = PathUtils.getResourceType((IPath)new Path(loc.getPath()), (IProgressMonitor)TempHelper.MONITOR);
            if (resourceType == null) {
                if (!loc.mkdirs()) {
                    throw StatusHelper.misconfiguredLocalFS((String)NLS.bind((String)Messages.LoadCmdLauncher_27, (Object)loc.getAbsolutePath()));
                }
            } else if (resourceType != ResourceType.FOLDER) {
                throw StatusHelper.misconfiguredLocalFS((String)NLS.bind((String)("What's your problem?" + resourceType), (Object)loc.getAbsolutePath()));
            }
            cfaRoot = loc;
        } else {
            if (!loc.equals(cfaAncestor)) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.LoadCmdLauncher_MUST_LOAD_IN_ROOT_OR_SPECIFY_PATH, (Object)cfaAncestor.getAbsolutePath(), (Object)config.getSubcommandCommandLine().getDefinition().getOption(LoadCmdOptions.OPT_LOAD_TARGET).getName()));
            }
            cfaRoot = cfaAncestor;
        }
        if (!SubcommandUtil.isEclipseWorkspaceRootSet()) {
            SubcommandUtil.initializeEclipseWorkspaceRoot((File)cfaRoot);
        }
        Path cfaRootPath = new Path(SubcommandUtil.canonicalize((File)cfaRoot).getAbsolutePath());
        if (loadTargetStr != null) {
            File loadTargetFile = new File(loadTargetStr);
            if (!loadTargetFile.isAbsolute()) {
                loadTargetFile = new File(cwd, loadTargetStr);
            }
            if (!cfaRootPath.isPrefixOf((IPath)(loadTarget = new Path(SubcommandUtil.canonicalize((File)loadTargetFile).getAbsolutePath())))) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.LoadCmdLauncher_LOAD_TARGET_PATH_NOT_DESCENDENT_OF_SANDBOX_PATH, (Object)loadTarget.toOSString(), (Object)cfaRootPath.toOSString()));
            }
            IShare[] iShareArray = SharingManager.getInstance().allShares(null);
            int n = iShareArray.length;
            int n2 = 0;
            while (n2 < n) {
                IShare share = iShareArray[n2];
                if (share.getShareable().getFullPath().isPrefixOf((IPath)loadTarget)) {
                    throw StatusHelper.collision((String)NLS.bind((String)Messages.LoadCmdLauncher_HAS_SHARED_ANCESTOR_PATH, (Object)share.getShareable().getLocalPath()));
                }
                ++n2;
            }
            loadTarget = loadTarget.removeFirstSegments(cfaRootPath.segmentCount());
        }
        new LoadCmd().run(config, (IPath)cfaRootPath, connectionInfo, wsSelector, cSelectors, getAll, loadCompRoots, (IPath)loadTarget, loadRuleConfig, quiet, alternativeName);
    }

    private LoadRuleConfig consumeLoadRuleArgs(ICommandLine subargs, List<String> cSelectors) throws FileSystemClientException {
        LoadRuleConfig rule;
        boolean hasLocal = subargs.hasOption(LoadCmdOptions.OPT_LOCAL_LOADRULE_PATH);
        boolean hasRemote = subargs.hasOption(LoadCmdOptions.OPT_REMOTE_LOADRULE_PATH);
        if (!hasLocal && !hasRemote) {
            return null;
        }
        if (hasLocal && hasRemote) {
            String remoteName = subargs.getDefinition().getOption(LoadCmdOptions.OPT_REMOTE_LOADRULE_PATH).getName();
            String localName = subargs.getDefinition().getOption(LoadCmdOptions.OPT_LOCAL_LOADRULE_PATH).getName();
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.LoadCmdLauncher_1, (Object)localName, (Object)remoteName));
        }
        if (cSelectors == null || cSelectors.size() != 1) {
            throw StatusHelper.argSyntax((String)Messages.LoadCmdLauncher_2);
        }
        if (hasRemote) {
            rule = new RemoteLoadRuleConfig();
            rule.remotePath = subargs.getOption(LoadCmdOptions.OPT_REMOTE_LOADRULE_PATH);
        } else {
            assert (hasLocal);
            rule = new LocalLoadRuleConfig();
            ((LocalLoadRuleConfig)rule).localPath = subargs.getOption(LoadCmdOptions.OPT_LOCAL_LOADRULE_PATH);
        }
        return rule;
    }

    public static class LoadRuleConfig {
    }

    public static class LocalLoadRuleConfig
    extends LoadRuleConfig {
        public String localPath;
    }

    public static class RemoteLoadRuleConfig
    extends LoadRuleConfig {
        public String remotePath;
    }
}

