/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.subcommands.DownloadProgressWriter;
import com.ibm.team.filesystem.cli.client.internal.subcommands.LoadCmdLauncher;
import com.ibm.team.filesystem.cli.client.internal.subcommands.LoadCmdOptions;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.StringUtil;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ILoadRule;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.TempHelper;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.filesystem.client.operations.ICollision;
import com.ibm.team.filesystem.client.operations.IDownloadListener;
import com.ibm.team.filesystem.client.operations.IInvalidLoadLocation;
import com.ibm.team.filesystem.client.operations.ILoadLocation;
import com.ibm.team.filesystem.client.operations.ILoadOperation;
import com.ibm.team.filesystem.client.operations.ILoadOverlap;
import com.ibm.team.filesystem.client.operations.IRemovedShare;
import com.ibm.team.filesystem.client.operations.IShareOutOfSync;
import com.ibm.team.filesystem.client.operations.LoadDilemmaHandler;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.ComponentNotInWorkspaceException;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadCmd {
    public void run(IClientConfiguration config, IPath cfaRoot, ConnectionInfo connectionInfo, String wsSelector, List<String> cSelectors, boolean getAll, boolean loadCompRoots, IPath relativeLoadTarget, LoadCmdLauncher.LoadRuleConfig loadRuleConfig, boolean quiet, String alternativeName) throws FileSystemClientException {
        IWorkspaceConnection wsConn;
        IWorkspace wsHandle;
        ITeamRepository repo = RepoUtil.login((IClientConfiguration)config, (ConnectionInfo)connectionInfo);
        try {
            wsHandle = RepoUtil.findNamedWorkspace((String)wsSelector, (boolean)true, (boolean)false, (ITeamRepository)repo, (IClientConfiguration)config);
        }
        catch (RepoUtil.UnmatchedSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)e, (IClientConfiguration)config);
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.LoadCmd_2, (Object)wsSelector));
        }
        catch (RepoUtil.AmbiguousSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)e, (IClientConfiguration)config);
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.LoadCmd_3, (Object)wsSelector));
        }
        IWorkspaceManager manager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
        try {
            wsConn = manager.getWorkspaceConnection((IWorkspaceHandle)wsHandle, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)NLS.bind((String)Messages.LoadCmd_4, (Object)wsSelector), (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
        }
        if (loadRuleConfig != null) {
            if (cSelectors.size() != 1) {
                String optName = config.getSubcommandCommandLine().getDefinition().getOption(LoadCmdOptions.OPT_REMOTE_LOADRULE_PATH).getName();
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.LoadCmd_0, (Object)optName, (Object)cSelectors.size()));
            }
            if (getAll) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.LoadCmd_GET_ALL_ARGUMENT_MAY_NOT_BE_SPECIFIED_WITH_LOAD_RULE, (Object)CommonOptions.OPT_ALL.getName()));
            }
        }
        if (relativeLoadTarget != null && (cSelectors == null || cSelectors.size() != 1)) {
            throw StatusHelper.argSyntax((String)Messages.LoadCmd_MULTIPLE_COMPONENTS_GIVEN_WITH_TARGET);
        }
        ISandbox sandbox = FileSystemCore.getSharingManager().getSandbox(cfaRoot, false);
        LoadProblemHandler handler = this.getHandler(config);
        ILoadOperation op = IOperationFactory.instance.getLoadOperation((LoadDilemmaHandler)handler);
        try {
            if (loadRuleConfig == null) {
                this.configureLoadOp(cSelectors, getAll, loadCompRoots, sandbox, relativeLoadTarget, wsConn, op, handler, alternativeName, config);
            } else {
                this.configureLoadOp(config, loadRuleConfig, sandbox, relativeLoadTarget, wsConn, cSelectors.get(0), op, handler);
            }
        }
        catch (RepoUtil.UnmatchedSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)e, (IClientConfiguration)config);
            throw StatusHelper.ambiguousSelector((String)Messages.LoadCmd_UNMATCHED_COMPONENT_SELECTOR);
        }
        catch (RepoUtil.AmbiguousSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)e, (IClientConfiguration)config);
            throw StatusHelper.ambiguousSelector((String)Messages.LoadCmd_AMBIGUOUS_COMPONENT_SELECTOR);
        }
        catch (TeamRepositoryException e1) {
            throw StatusHelper.wrap((String)Messages.LoadCmd_COULD_NOT_FIND_LOAD_ROOTS, (TeamRepositoryException)e1, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
        }
        if (op.getLoadRequests().size() == 0) {
            config.getContext().stderr().println(Messages.LoadCmd_NO_LOAD_REQUESTS);
            return;
        }
        try {
            DownloadProgressWriter writer = null;
            if (!quiet) {
                writer = new DownloadProgressWriter(config.getContext().stdout(), config.getContext().stderr(), false, quiet);
                op.setDownloadListener((IDownloadListener)writer);
            }
            op.run((IProgressMonitor)new NullProgressMonitor());
            if (writer != null) {
                writer.join();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String path = Messages.LoadCmd_UNKNOWN_FILESYSTEM_PATH;
            if (relativeLoadTarget != null) {
                path = relativeLoadTarget.toOSString();
            }
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.LoadCmd_CANNOT_LOAD_INTO_DIRECTORY_ANCESTOR_DIR_ALREADY_SHARED, (Object)path));
        }
        catch (OperationCanceledException e) {
            if (handler.failedDueToCollision() || handler.failedDueToOnDiskItem() || handler.failedDueToOverlappingShares() || handler.failedDueToOverlappingItems()) {
                StringBuffer msg = new StringBuffer(Messages.LoadCmd_7);
                if (handler.failedDueToCollision()) {
                    msg.append(Messages.LoadCmd_8);
                }
                if (handler.failedDueToOnDiskItem()) {
                    msg.append(Messages.LoadCmd_9);
                }
                if (handler.failedDueToOverlappingShares()) {
                    msg.append(Messages.LoadCmd_OVERLAPPING_SHARES_SUMMARY);
                } else if (handler.failedDueToOverlappingItems()) {
                    msg.append(Messages.LoadCmd_OVERLAPPING_ITEMS_SUMMARY);
                }
                throw StatusHelper.collision((String)msg.toString());
            }
            throw StatusHelper.failure((String)Messages.LoadCmd_10, (Throwable)e);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.LoadCmd_11, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
        }
        catch (FileSystemClientException e) {
            throw StatusHelper.wrap((String)Messages.LoadCmd_11, (FileSystemClientException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
        }
    }

    private void configureLoadOpForComponent(ISandbox sandbox, IPath relativeLoadTarget, IWorkspaceConnection wsConn, IComponent comp, boolean loadCompRoots, ILoadOperation op, String alternativeName) throws ItemNotFoundException, ComponentNotInWorkspaceException, TeamRepositoryException {
        if (loadCompRoots || alternativeName != null) {
            IFolder root = wsConn.configuration((IComponentHandle)comp).completeRootFolder(null);
            String compName = loadCompRoots ? comp.getName() : alternativeName;
            op.requestLoadAs(sandbox, relativeLoadTarget, compName, wsConn, (IComponentHandle)comp, (IVersionableHandle)root);
        } else {
            op.requestLoad(sandbox, relativeLoadTarget, wsConn, (IComponentHandle)comp, wsConn.configuration((IComponentHandle)comp).childEntriesForRoot(null).values());
        }
    }

    private void configureLoadOp(List<String> selectors, boolean getAll, boolean loadCompRoots, ISandbox sandbox, IPath relativeLoadTarget, IWorkspaceConnection wsConn, ILoadOperation op, LoadProblemHandler handler, String alternativeName, IClientConfiguration config2) throws FileSystemClientException, TeamRepositoryException, RepoUtil.UnmatchedSelectorException, RepoUtil.AmbiguousSelectorException {
        List comps = wsConn.teamRepository().itemManager().fetchCompleteItems(wsConn.getComponents(), 0, null);
        if (selectors == null || selectors.size() == 0) {
            if (relativeLoadTarget != null) {
                throw StatusHelper.argSyntax((String)Messages.LoadCmd_REMOTE_PATH_DISALLOWED);
            }
            for (IComponent comp : comps) {
                this.configureLoadOpForComponent(sandbox, relativeLoadTarget, wsConn, comp, loadCompRoots, op, alternativeName);
            }
            return;
        }
        OrderedComponentList ordering = new OrderedComponentList(comps, selectors.size());
        for (String selector : selectors) {
            IComponent comp2;
            String[] path = StringUtil.splitEscapedPath((String)selector);
            if (path.length == 0) {
                if (alternativeName != null) {
                    ICommandLine subargs = config2.getSubcommandCommandLine();
                    throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.LoadCmdLauncher_TOO_MANY_COMPONENTS, (Object)subargs.getDefinition().getOption(LoadCmdOptions.OPT_ALTERNATIVE_NAME).getName()));
                }
                for (IComponent comp2 : comps) {
                    this.configureLoadOpForComponent(sandbox, relativeLoadTarget, wsConn, comp2, loadCompRoots, op, alternativeName);
                }
                continue;
            }
            if (path.length == 1) {
                comp2 = RepoUtil.findNamedComponent((String)path[0], (List)comps, (boolean)true);
                this.configureLoadOpForComponent(sandbox, relativeLoadTarget, wsConn, comp2, loadCompRoots, op, alternativeName);
                ordering.add(comp2);
                continue;
            }
            comp2 = RepoUtil.findNamedComponent((String)path[0], (List)comps, (boolean)true);
            IConfiguration config = wsConn.configuration((IComponentHandle)comp2);
            String[] componentPath = new String[path.length - 1];
            System.arraycopy(path, 1, componentPath, 0, componentPath.length);
            IVersionableHandle remoteItem = config.resolvePath(comp2.getRootFolder(), componentPath, null);
            if (remoteItem == null) {
                String joinedPath = NLS.bind((String)Messages.LoadCmd_PATH_zero_is_path_separator_and_one_is_remainder_of_path, (Object)File.separator, (Object)StringUtil.join((String)File.separator, (String[])componentPath));
                throw StatusHelper.misconfiguredRemoteFS((String)NLS.bind((String)Messages.LoadCmd_WORKSPACE_DOES_NOT_CONTAIN_PATH, (Object)wsConn.getName(), (Object)joinedPath));
            }
            if (alternativeName != null) {
                op.requestLoadAs(sandbox, relativeLoadTarget, alternativeName, wsConn, (IComponentHandle)comp2, remoteItem);
            } else {
                op.requestLoad(sandbox, relativeLoadTarget, wsConn, (IComponentHandle)comp2, Collections.singletonList(remoteItem));
            }
            ordering.add(comp2);
        }
        handler.setOrdering(ordering.order(comps));
        if (getAll) {
            for (IComponent comp : ordering.getUnused()) {
                IConfiguration config = wsConn.configuration((IComponentHandle)comp);
                op.requestLoad(sandbox, null, wsConn, (IComponentHandle)comp, config.childEntriesForRoot(null).values());
            }
        }
    }

    private LoadProblemHandler getHandler(IClientConfiguration config) {
        ICommandLine subargs = config.getSubcommandCommandLine();
        return new OrderedLoadProblemHandler(subargs.hasOption(LoadCmdOptions.OPT_FORCE), config.getContext().stderr());
    }

    private void configureLoadOp(IClientConfiguration config, LoadCmdLauncher.LoadRuleConfig loadRuleConfig, ISandbox sandbox, IPath relativeLoadTarget, IWorkspaceConnection wsConn, String cSelector, ILoadOperation op, LoadProblemHandler handler) throws TeamRepositoryException, FileSystemClientException {
        String filename;
        InputStream in;
        IComponent cHandle;
        assert (loadRuleConfig != null);
        try {
            cHandle = RepoUtil.findNamedComponent((String)cSelector, (IWorkspaceConnection)wsConn, (boolean)true, (IClientConfiguration)config);
        }
        catch (RepoUtil.UnmatchedSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)e, (IClientConfiguration)config);
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.LoadCmd_MATCHES_NO_COMPONENTS, (Object)cSelector));
        }
        catch (RepoUtil.AmbiguousSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)e, (IClientConfiguration)config);
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.LoadCmd_MATCHES_TOO_MANY_COMPONENTS, (Object)cSelector));
        }
        ILoadRule loadRule = ILoadRule.loadRuleFactory.createLoadRule(wsConn, (IComponentHandle)cHandle);
        IConfiguration wsConfig = wsConn.configuration((IComponentHandle)cHandle);
        if (loadRuleConfig instanceof LoadCmdLauncher.RemoteLoadRuleConfig) {
            LoadCmdLauncher.RemoteLoadRuleConfig remoteRule = (LoadCmdLauncher.RemoteLoadRuleConfig)loadRuleConfig;
            String[] path = StringUtil.splitEscapedPath((String)remoteRule.remotePath);
            IVersionableHandle fileHandle = wsConfig.resolvePath(wsConfig.rootFolderHandle(null), path, null);
            if (fileHandle == null) {
                String componentName = cHandle.getItemId().getUuidValue();
                try {
                    IComponent comp = (IComponent)wsConn.teamRepository().itemManager().fetchCompleteItem((IItemHandle)cHandle, 0, null);
                    componentName = comp.getName();
                }
                catch (TeamRepositoryException e) {
                    LoggingHelper.log((IStatus)new Status(4, "com.ibm.team.filesystem.cli.client", Messages.LoadCmd_26, (Throwable)e));
                }
                throw StatusHelper.misconfiguredRemoteFS((String)NLS.bind((String)Messages.LoadCmd_27, (Object)StringUtil.createPathString((String[])path), (Object)componentName));
            }
            if (!(fileHandle instanceof IFileItemHandle)) {
                throw StatusHelper.misconfiguredRemoteFS((String)NLS.bind((String)Messages.LoadCmd_28, (Object)StringUtil.createPathString((String[])path)));
            }
            try {
                loadRule.addLoadRules((IFileItemHandle)fileHandle, null);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.misconfiguredRemoteFS((String)NLS.bind((String)Messages.LoadCmd_29, (Object)StringUtil.createPathString((String[])path), (Object)e.getMessage()));
            }
        }
        assert (loadRuleConfig instanceof LoadCmdLauncher.LocalLoadRuleConfig);
        LoadCmdLauncher.LocalLoadRuleConfig localRule = (LoadCmdLauncher.LocalLoadRuleConfig)loadRuleConfig;
        if ("-".equals(localRule.localPath)) {
            in = config.getContext().stdin();
            filename = Messages.LoadCmd_30;
        } else {
            try {
                filename = SubcommandUtil.canonicalize((String)localRule.localPath);
            }
            catch (FileSystemClientException fileSystemClientException) {
                filename = localRule.localPath;
            }
            Path localFile = new Path(filename);
            ResourceType resourceType = PathUtils.getResourceType((IPath)localFile, (IProgressMonitor)TempHelper.MONITOR);
            if (resourceType == null) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.LoadCmd_31, (Object)filename));
            }
            if (resourceType != ResourceType.FILE) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.LoadCmd_32, (Object)filename));
            }
            try {
                in = new FileInputStream(localFile.toFile());
            }
            catch (FileNotFoundException e) {
                throw StatusHelper.misconfiguredLocalFS((String)NLS.bind((String)Messages.LoadCmd_33, (Object)filename, (Object)e.getMessage()));
            }
        }
        try {
            loadRule.addLoadRules(in, Charset.defaultCharset().name(), null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.misconfiguredRemoteFS((String)NLS.bind((String)Messages.LoadCmd_34, (Object)filename, (Object)e.getMessage()));
        }
        op.requestLoad(sandbox, relativeLoadTarget, Collections.singleton(loadRule), null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class LoadProblemHandler
    extends LoadDilemmaHandler {
        boolean failedDueToMultiComponentCollision = false;
        boolean failedDueToOnDiskItem = false;
        boolean failedDueToOverlappingShares = false;
        boolean failedDueToOverlappingItems = false;

        LoadProblemHandler() {
        }

        public boolean failedDueToCollision() {
            return this.failedDueToMultiComponentCollision;
        }

        public boolean failedDueToOnDiskItem() {
            return this.failedDueToOnDiskItem;
        }

        public boolean failedDueToOverlappingShares() {
            return this.failedDueToOverlappingShares;
        }

        public boolean failedDueToOverlappingItems() {
            return this.failedDueToOverlappingItems;
        }

        public void setOrdering(List<IComponentHandle> componentOrdering) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OrderedComponentList {
        final ArrayList<UUID> contents;
        final Map<UUID, IComponent> unusedComps;

        public OrderedComponentList(List<IComponent> comps, int size) {
            this.contents = new ArrayList(size);
            this.unusedComps = new HashMap<UUID, IComponent>();
            for (IComponent comp : comps) {
                this.unusedComps.put(comp.getItemId(), comp);
            }
        }

        public void add(IComponent t) {
            if (this.contents.contains(t.getItemId())) {
                return;
            }
            this.contents.add(t.getItemId());
            this.unusedComps.remove(t.getItemId());
        }

        public List<IComponentHandle> order(List<IComponent> all) throws FileSystemClientException {
            HashMap<UUID, IComponent> map = new HashMap<UUID, IComponent>();
            for (IComponent comp : all) {
                map.put(comp.getItemId(), comp);
            }
            ArrayList<IComponentHandle> toReturn = new ArrayList<IComponentHandle>(all.size());
            for (UUID uuid : this.contents) {
                IComponent comp = (IComponent)map.get(uuid);
                if (comp == null) {
                    throw StatusHelper.internalError((String)Messages.LoadCmd_MISSING_COMPONENT);
                }
                toReturn.add((IComponentHandle)comp);
            }
            return toReturn;
        }

        public Collection<IComponent> getUnused() {
            return this.unusedComps.values();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OrderedLoadProblemHandler
    extends LoadProblemHandler {
        final PrintStream stderr;
        List<IComponentHandle> ordering;
        final boolean overwrite;
        final MultiStatus failures;

        public OrderedLoadProblemHandler(boolean force, PrintStream stderr) {
            this.overwrite = force;
            this.stderr = stderr;
            this.failures = new MultiStatus("com.ibm.team.filesystem.cli.client", -1, Messages.LoadCmd_15, null);
        }

        @Override
        public void setOrdering(List<IComponentHandle> ordering) {
            this.ordering = ordering;
        }

        public int collision(Collection<ICollision> collisions, Collection<IRemovedShare> removedShares, Collection<IShareOutOfSync> sharesOutOfSync) {
            for (ICollision collision : collisions) {
                ILoadLocation target = null;
                if (collision.getLocations().size() > 1) {
                    if (this.ordering == null) {
                        this.reportMulticomponentCollision(collision);
                        this.failedDueToMultiComponentCollision = true;
                        return 1;
                    }
                    try {
                        target = this.getPreferredLoadLocation(collision);
                    }
                    catch (FileSystemClientException e) {
                        this.failures.add(e.getStatus());
                        return 2;
                    }
                }
                if (collision.collidedWithExistingContent()) {
                    if (this.overwrite) {
                        if (target == null) {
                            target = this.getFirstLoadLocation(collision);
                        }
                    } else {
                        IShareable shareable = collision.getShareable();
                        this.stderr.println(NLS.bind((String)Messages.LoadCmd_16, (Object)shareable.getLocalPath()));
                        this.failedDueToOnDiskItem = true;
                        return 1;
                    }
                }
                collision.setLoadLocation(target);
            }
            return 0;
        }

        public int invalidLoadLocations(Collection<IInvalidLoadLocation> invalidLoadLocations) {
            for (IInvalidLoadLocation loc : invalidLoadLocations) {
                IndentingPrintStream err = new IndentingPrintStream((OutputStream)this.stderr);
                for (IShare share : loc.getSharesOverlapped()) {
                    if (!this.failedDueToOverlappingShares) {
                        this.failedDueToOverlappingShares = true;
                        err.println((CharSequence)Messages.LoadCmd_OVERLAPPING_SHARE_COMPLAINT);
                        err = err.indent();
                    }
                    err.println((CharSequence)share.getPath().toOSString());
                }
            }
            return 1;
        }

        public int overlappingLoadRequests(Collection<ILoadOverlap> foldersOverlapping) {
            HashSet<IComponentHandle> compHandleSet = null;
            IConnection conn = null;
            IndentingPrintStream err = new IndentingPrintStream((OutputStream)this.stderr);
            for (ILoadOverlap overlap : foldersOverlapping) {
                for (IShare share : overlap.getOverlappingShares()) {
                    if (!this.failedDueToOverlappingShares) {
                        this.failedDueToOverlappingShares = true;
                        err.println((CharSequence)Messages.LoadCmd_OVERLAPPING_SHARE_COMPLAINT);
                        err = err.indent();
                    }
                    err.println((CharSequence)share.getPath().toOSString());
                }
                if (this.failedDueToOverlappingShares || overlap.getOverlappingItems().isEmpty()) continue;
                if (!this.failedDueToOverlappingItems) {
                    this.failedDueToOverlappingItems = true;
                    conn = overlap.getConnection();
                    compHandleSet = new HashSet<IComponentHandle>();
                }
                compHandleSet.add(overlap.getComponent());
            }
            if (this.failedDueToOverlappingItems) {
                ArrayList arrayCompHandle = new ArrayList(compHandleSet);
                List compList = null;
                err.println((CharSequence)Messages.LoadCmd_OVERLAPPING_ITEM_COMPLAINT);
                err = err.indent();
                try {
                    compList = conn.teamRepository().itemManager().fetchCompleteItems(arrayCompHandle, 0, null);
                    for (IComponent component : compList) {
                        err.println((CharSequence)AliasUtil.selector((String)component.getName(), (UUID)component.getItemId()));
                    }
                }
                catch (TeamRepositoryException e) {
                    StatusHelper.wrap((String)Messages.LoadCmd_26, (TeamRepositoryException)e, (IndentingPrintStream)err);
                }
            }
            return 1;
        }

        private ILoadLocation getPreferredLoadLocation(ICollision collision) throws FileSystemClientException {
            for (IComponentHandle comp : this.ordering) {
                for (ILoadLocation location : collision.getLocations()) {
                    if (!comp.sameItemId((IItemHandle)location.getComponent())) continue;
                    collision.setLoadLocation(location);
                    return location;
                }
            }
            throw StatusHelper.failure((String)Messages.LoadCmd_18, null);
        }

        private ILoadLocation getFirstLoadLocation(ICollision c) {
            return (ILoadLocation)c.getLocations().iterator().next();
        }

        private void reportMulticomponentCollision(ICollision collision) {
            IndentingPrintStream err = new IndentingPrintStream((OutputStream)this.stderr);
            err.println((CharSequence)NLS.bind((String)Messages.LoadCmd_22, (Object)this.getFirstLoadLocation(collision).getLoadPath()));
            err = err.indent();
            for (ILoadLocation location : collision.getLocations()) {
                err.println((CharSequence)NLS.bind((String)Messages.LoadCmd_24, (Object)AliasUtil.selector((String)location.getComponent().getName(), (UUID)location.getComponent().getItemId())));
            }
        }
    }
}

