/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.subcommands.LastModCmdOpts;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.ISubcommand;
import com.ibm.team.filesystem.cli.core.util.ICopyFileAreaView;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LastModCmd
implements ISubcommand {
    private IClientConfiguration config;
    private static DateFormat shortDateFormat = new SimpleDateFormat("yyyyMMddhhmm");

    public void run(IClientConfiguration config) throws FileSystemClientException {
        this.config = config;
        this.execute();
    }

    private List<IShareable> consumeArguments(ICopyFileAreaView cfaView) throws FileSystemClientException {
        ICommandLine subargs = this.config.getSubcommandCommandLine();
        shortDateFormat = new SimpleDateFormat(subargs.getOption((IOptionKey)LastModCmdOpts.OPT_DATE_FORMAT, "yyyyMMddhhmm"));
        List paths = subargs.getOptions((IOptionKey)LastModCmdOpts.OPT_TO_CALCULATE);
        return this.findFoldersInCFA(cfaView, paths);
    }

    private List<IShareable> findFoldersInCFA(ICopyFileAreaView cfaView, List<String> strPaths) throws FileSystemClientException {
        Path cfaRoot = new Path(this.config.getContext().getCurrentWorkingDirectory());
        List paths = SubcommandUtil.makeAbsolutePaths((IClientConfiguration)this.config, strPaths);
        if (paths.contains(cfaRoot)) {
            IShare[] shares = cfaView.getLoadedShares();
            ArrayList<IShareable> commitRoots = new ArrayList<IShareable>(shares.length);
            IShare[] iShareArray = shares;
            int n = shares.length;
            int n2 = 0;
            while (n2 < n) {
                IShare share = iShareArray[n2];
                commitRoots.add(SubcommandUtil.makeShareable((IShare)share));
                ++n2;
            }
            return commitRoots;
        }
        ArrayList<IShareable> commitRoots = new ArrayList<IShareable>(strPaths.size());
        for (IPath path : paths) {
            IShareable shareable = cfaView.findShareable(path.toOSString());
            if (shareable.getShare(null) == null) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.LastModCmd_0, (Object)path));
            }
            commitRoots.add(shareable);
        }
        return commitRoots;
    }

    private Map<ItemId<IItem>, List<IShareable>> groupShareablesByConnection(List<IShareable> commitRoots) throws FileSystemClientException {
        HashMap<ItemId<IItem>, List<IShareable>> map = new HashMap<ItemId<IItem>, List<IShareable>>();
        for (IShareable shareable : commitRoots) {
            IShare share = shareable.getShare(null);
            IContextHandle handle = share.getSharingDescriptor().getConnectionHandle();
            ItemId id = ItemId.create((IItemHandle)handle);
            SubcommandUtil.addToMapOfLists(map, (Object)id, (Object)shareable);
        }
        return map;
    }

    private void verifyRoots(List<IShareable> commitRoots) throws FileSystemClientException {
        for (IShareable shareable : commitRoots) {
            if (!shareable.exists(null)) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.LastModCmd_1, (Object)shareable.getLocalPath().toPortableString()));
            }
            if (shareable.getShare(null) != null) continue;
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.LastModCmd_2, (Object)shareable.getLocalPath().toPortableString()));
        }
    }

    private void refreshRoots(List<IShareable> commitRoots) throws FileSystemClientException {
        LocalChangeManager.getInstance().refreshChanges(commitRoots, null);
    }

    private void execute() throws FileSystemClientException {
        ResourcesPlugin.getWorkspace().getRoot();
        ICopyFileAreaView cfaView = SubcommandUtil.getAffectedComponentsAndShares((IClientConfiguration)this.config);
        List<IShareable> commitRoots = this.consumeArguments(cfaView);
        this.refreshRoots(commitRoots);
        this.verifyRoots(commitRoots);
        Map groupedByConnection = RepoUtil.groupShareablesByWorkspaceConnection((IClientConfiguration)this.config, commitRoots);
        if (this.config.isDryRun()) {
            return;
        }
        for (Map.Entry entry : groupedByConnection.entrySet()) {
            this.commit((IWorkspaceConnection)entry.getKey(), (List)entry.getValue());
        }
    }

    private void commit(IWorkspaceConnection wsConn, List<IShareable> shareables) throws FileSystemClientException {
        Map<ItemId<IComponent>, List<IShareable>> groupedByComponent = this.groupByComponent(shareables);
        for (Map.Entry<ItemId<IComponent>, List<IShareable>> entry : groupedByComponent.entrySet()) {
            IComponentHandle compHandle = (IComponentHandle)entry.getKey().toHandle();
            IShareable[] toCommit = new IShareable[entry.getValue().size()];
            toCommit = entry.getValue().toArray(toCommit);
            ArrayList<IFolderHandle> folders = new ArrayList<IFolderHandle>(toCommit.length);
            ArrayList<IShareable> folderShareables = new ArrayList<IShareable>(toCommit.length);
            int i = 0;
            while (i < toCommit.length) {
                IShareable shareable = toCommit[i];
                IVersionableHandle handle = shareable.getVersionable(null);
                if (handle instanceof IFolderHandle) {
                    folders.add((IFolderHandle)handle);
                    folderShareables.add(shareable);
                } else {
                    StatusHelper.createException((String)NLS.bind((String)Messages.LastModCmd_5, (Object)shareable.getLocalPath().toPortableString()), (int)4, null);
                }
                ++i;
            }
            try {
                List baselines = wsConn.getMostRecentBaselinesAffecting(compHandle, folders, null);
                int i2 = 0;
                while (i2 < baselines.size()) {
                    IBaseline baseline = (IBaseline)baselines.get(i2);
                    IShareable shareable = (IShareable)folderShareables.get(i2);
                    this.config.getContext().stdout().println(NLS.bind((String)Messages.LastModCmd_6, (Object)shareable.getLocalPath().toOSString(), (Object)shortDateFormat.format(baseline.getCreationDate())));
                    ++i2;
                }
            }
            catch (TeamRepositoryException e) {
                StatusHelper.wrap((String)Messages.LastModCmd_8, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)this.config.getContext().stderr()));
            }
        }
    }

    private Map<ItemId<IComponent>, List<IShareable>> groupByComponent(List<IShareable> shareables) throws FileSystemClientException {
        HashMap<ItemId<IComponent>, List<IShareable>> grouped = new HashMap<ItemId<IComponent>, List<IShareable>>();
        for (IShareable shareable : shareables) {
            IComponentHandle comp = shareable.getShare(null).getSharingDescriptor().getComponent();
            ItemId id = new ItemId(IComponent.ITEM_TYPE, comp.getItemId());
            SubcommandUtil.addToMapOfLists(grouped, (Object)id, (Object)shareable);
        }
        return grouped;
    }
}

