/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.subcommands.HistoryCmdOpts;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.ICopyFileAreaView;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.PendingChangesUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IChangeHistory;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeHistoryEntry;
import com.ibm.team.scm.common.IChangeHistoryEntryChange;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryCmd
extends AbstractSubcommand {
    public void run(IClientConfiguration config) throws FileSystemClientException {
        ICommandLine cli = config.getSubcommandCommandLine();
        int maxResults = RepoUtil.getMaxResultsOption((ICommandLine)cli);
        ITeamRepository repo = RepoUtil.loginUrlArgAnc((IClientConfiguration)config);
        ArrayList<IWorkspaceConnection> workspaceConnections = null;
        if (cli.hasOption((IOptionKey)HistoryCmdOpts.OPT_WORKSPACE)) {
            try {
                String wsSelector = cli.getOption((IOptionKey)HistoryCmdOpts.OPT_WORKSPACE);
                workspaceConnections = new ArrayList<IWorkspaceConnection>();
                IWorkspaceConnection workspaceConnection = RepoUtil.findNamedWorkspaceConnection((String)wsSelector, (boolean)true, (boolean)true, (ITeamRepository)repo, (IClientConfiguration)config);
                workspaceConnections.add(workspaceConnection);
            }
            catch (RepoUtil.UnmatchedSelectorException e) {
                SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)e, (IClientConfiguration)config);
                throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.CreateWorkspaceCmd_2, (Object)e.getSelector(), (Object[])new Object[0]));
            }
            catch (RepoUtil.AmbiguousSelectorException e) {
                SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)e, (IClientConfiguration)config);
                throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.CreateWorkspaceCmd_1, (Object)e.getSelector(), (Object[])new Object[0]));
            }
        } else {
            ICopyFileAreaView cfaView = SubcommandUtil.getAffectedComponentsAndShares((IClientConfiguration)config);
            workspaceConnections = RepoUtil.getWorkspaceConnections((ICopyFileAreaView)cfaView, (boolean)false);
        }
        IWorkspaceConnection workspaceConnection = null;
        IComponentHandle componentHandle = null;
        IComponentHandle componentHandleForVersionable = null;
        if (cli.hasOption((IOptionKey)HistoryCmdOpts.OPT_COMPONENT)) {
            String componentString = cli.getOption((IOptionKey)HistoryCmdOpts.OPT_COMPONENT);
            HashMap<IWorkspaceConnection, Object> componentsMap = new HashMap<IWorkspaceConnection, Object>();
            for (IWorkspaceConnection wc : workspaceConnections) {
                IComponent foundComponent;
                try {
                    foundComponent = RepoUtil.findNamedComponent((String)componentString, (IWorkspaceConnection)wc, (boolean)false, (IClientConfiguration)config);
                }
                catch (RepoUtil.UnmatchedSelectorException e) {
                    SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)e, (IClientConfiguration)config);
                    throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.LoadCmd_MATCHES_NO_COMPONENTS, (Object)componentString, (Object[])new Object[0]));
                }
                catch (RepoUtil.AmbiguousSelectorException e) {
                    SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)e, (IClientConfiguration)config);
                    throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.LoadCmd_MATCHES_TOO_MANY_COMPONENTS, (Object)componentString, (Object[])new Object[0]));
                }
                if (foundComponent == null) continue;
                componentsMap.put(wc, foundComponent);
            }
            if (componentsMap.size() == 0) {
                SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)new RepoUtil.UnmatchedSelectorException(RepoUtil.SelectorException.Type.COMPONENT, componentString, Collections.EMPTY_LIST), (IClientConfiguration)config);
                throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.LoadCmd_MATCHES_NO_COMPONENTS, (Object)componentString, (Object[])new Object[0]));
            }
            if (componentsMap.size() > 1) {
                ArrayList<IWorkspace> workspaces = new ArrayList<IWorkspace>(componentsMap.size());
                for (IWorkspaceConnection wc : componentsMap.keySet()) {
                    workspaces.add(wc.getResolvedWorkspace());
                }
                SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)new RepoUtil.AmbiguousSelectorException(RepoUtil.SelectorException.Type.WORKSPACE, Messages.LockAcquireCmd_UNSPECIFIED, workspaces, workspaces), (IClientConfiguration)config);
                throw StatusHelper.ambiguousSelector((String)Messages.LockAcquireCmd_AMBIGUOUS_STREAM);
            }
            Map.Entry entry = componentsMap.entrySet().iterator().next();
            workspaceConnection = (IWorkspaceConnection)entry.getKey();
            componentHandleForVersionable = componentHandle = (IComponentHandle)entry.getValue();
        } else {
            ICopyFileAreaView cfaView = SubcommandUtil.getAffectedComponentsAndShares((IClientConfiguration)config);
            Collection loadedWorkspaces = cfaView.getLoadedWorkspaces();
            if (loadedWorkspaces.size() == 0) {
                SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)new RepoUtil.UnmatchedSelectorException(RepoUtil.SelectorException.Type.WORKSPACE, Messages.LockAcquireCmd_UNSPECIFIED, Collections.EMPTY_LIST), (IClientConfiguration)config);
                throw StatusHelper.ambiguousSelector((String)Messages.LockAcquireCmd_UNMATCHED_STREAM);
            }
            if (loadedWorkspaces.size() > 1) {
                List workspaces;
                ArrayList<IWorkspaceHandle> workspaceHandles = new ArrayList<IWorkspaceHandle>(loadedWorkspaces.size());
                for (ICopyFileAreaView.IRepoView repoView : loadedWorkspaces) {
                    workspaceHandles.add(repoView.getHandle());
                }
                try {
                    workspaces = repo.itemManager().fetchCompleteItems(workspaceHandles, 0, null);
                }
                catch (TeamRepositoryException e) {
                    throw StatusHelper.wrap(null, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
                }
                SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)new RepoUtil.AmbiguousSelectorException(RepoUtil.SelectorException.Type.WORKSPACE, Messages.LockAcquireCmd_UNSPECIFIED, workspaces, workspaces), (IClientConfiguration)config);
                throw StatusHelper.ambiguousSelector((String)Messages.LockAcquireCmd_AMBIGUOUS_STREAM);
            }
            ICopyFileAreaView.IRepoView repoView = (ICopyFileAreaView.IRepoView)loadedWorkspaces.iterator().next();
            workspaceConnection = (IWorkspaceConnection)workspaceConnections.get(0);
            boolean hasFile = cli.hasOption((IOptionKey)HistoryCmdOpts.OPT_FILE);
            if (!hasFile) {
                Collection loadedComponents = cfaView.getLoadedComponents(repoView);
                if (loadedComponents.size() == 0) {
                    SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)new RepoUtil.UnmatchedSelectorException(RepoUtil.SelectorException.Type.COMPONENT, Messages.LockAcquireCmd_UNSPECIFIED, Collections.EMPTY_LIST), (IClientConfiguration)config);
                    throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.LoadCmd_MATCHES_NO_COMPONENTS, (Object)Messages.LockAcquireCmd_UNSPECIFIED, (Object[])new Object[0]));
                }
                if (loadedComponents.size() > 1) {
                    List components;
                    ArrayList<IComponentHandle> componentHandles = new ArrayList<IComponentHandle>(loadedComponents.size());
                    for (ItemId componentId : loadedComponents) {
                        componentHandles.add((IComponentHandle)componentId.toHandle());
                    }
                    try {
                        components = repo.itemManager().fetchCompleteItems(componentHandles, 0, null);
                    }
                    catch (TeamRepositoryException e) {
                        throw StatusHelper.wrap(null, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
                    }
                    SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)new RepoUtil.AmbiguousSelectorException(RepoUtil.SelectorException.Type.COMPONENT, Messages.LockAcquireCmd_UNSPECIFIED, components, components), (IClientConfiguration)config);
                    throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.LoadCmd_MATCHES_TOO_MANY_COMPONENTS, (Object)Messages.LockAcquireCmd_UNSPECIFIED, (Object[])new Object[0]));
                }
                componentHandle = (IComponentHandle)((ItemId)loadedComponents.iterator().next()).toHandle();
            }
        }
        IVersionableHandle versionableHandle = null;
        boolean remotePath = cli.hasOption((IOptionKey)HistoryCmdOpts.OPT_REMOTE_PATH);
        if (cli.hasOption((IOptionKey)HistoryCmdOpts.OPT_FILE)) {
            String file = cli.getOption((IOptionKey)HistoryCmdOpts.OPT_FILE);
            List<String> strPaths = Collections.singletonList(file);
            List siloedItems = RepoUtil.findNamedVersionables((IClientConfiguration)config, (IWorkspaceConnection)workspaceConnection, (IComponentHandle)componentHandleForVersionable, (boolean)remotePath, strPaths, (boolean)true, (boolean)false, (boolean)false, (String)Messages.HistoryCmd_CANNOT_SHOW_HISTORY_FOR_FOLDER_PATH, (String)Messages.HistoryCmd_CANNOT_SHOW_HISTORY_FOR_FOLDERS);
            SiloedItemId siloedItem = (SiloedItemId)siloedItems.get(0);
            componentHandle = siloedItem.getComponentHandle();
            versionableHandle = siloedItem.toHandle();
        }
        boolean verbose = cli.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE);
        List<IChangeSetHandle> csHandles = null;
        csHandles = versionableHandle == null ? this.getComponentHistory(workspaceConnection, componentHandle, maxResults, config) : this.getFileHistory(workspaceConnection, componentHandle, versionableHandle, maxResults, config);
        PendingChangesUtil.PendingChangesOptions pcOptions = new PendingChangesUtil.PendingChangesOptions();
        if (verbose) {
            pcOptions.enablePrinter(6);
            pcOptions.enablePrinter(7);
        }
        for (IChangeSetHandle csHandle : csHandles) {
            PendingChangesUtil.printChangeSet((ITeamRepository)repo, (IChangeSetHandle)csHandle, (PendingChangesUtil.PendingChangesOptions)pcOptions, (IClientConfiguration)config);
        }
        if (csHandles.size() == maxResults) {
            config.getContext().stdout().println(Messages.HistoryCmd_10);
        }
    }

    private List<IChangeSetHandle> getComponentHistory(IWorkspaceConnection wsConn, IComponentHandle cpHandle, int maxResults, IClientConfiguration config) throws FileSystemClientException {
        ArrayList<IChangeSetHandle> toReturn = new ArrayList<IChangeSetHandle>();
        try {
            IChangeHistory history = wsConn.changeHistory(cpHandle);
            while (history != null) {
                List historyEntries = history.recent(null);
                ListIterator i = historyEntries.listIterator(historyEntries.size());
                while (i.previousIndex() != -1) {
                    IChangeHistoryEntry historyEntry = (IChangeHistoryEntry)i.previous();
                    if (!(historyEntry instanceof IChangeHistoryEntryChange)) continue;
                    toReturn.add(((IChangeHistoryEntryChange)historyEntry).changeSet());
                    if (maxResults != 0 && toReturn.size() >= maxResults) break;
                }
                if (maxResults == 0 || toReturn.size() < maxResults) {
                    history = history.previousHistory(null);
                    continue;
                }
                break;
            }
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.HistoryCmd_9, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
        }
        return toReturn;
    }

    private List<IChangeSetHandle> getFileHistory(IWorkspaceConnection workspaceConnection, IComponentHandle componentHandle, IVersionableHandle versionableHandle, int maxResults, IClientConfiguration config) throws FileSystemClientException {
        List historyChanges;
        IChangeHistory changeHistory;
        try {
            changeHistory = workspaceConnection.changeHistory(componentHandle);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.HistoryCmd_16, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
        }
        try {
            historyChanges = changeHistory.getHistoryFor(versionableHandle, maxResults == 0 ? Integer.MAX_VALUE : maxResults, true, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.HistoryCmd_25, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
        }
        new HashMap();
        ArrayList<IChangeSetHandle> changeSets = new ArrayList<IChangeSetHandle>(historyChanges.size());
        for (IChangeHistoryEntryChange historyChange : historyChanges) {
            changeSets.add(historyChange.changeSet());
        }
        return changeSets;
    }
}

