/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.subcommands.FlowWorkspaceTargetCmdOptions;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceTarget;
import com.ibm.team.filesystem.rcp.core.internal.rest.FilesystemRestClient;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.io.OutputStream;
import org.eclipse.osgi.util.NLS;

public class FlowWorkspaceTargetCmd
extends AbstractSubcommand {
    IWorkspaceConnection wsConn;
    IWorkspaceHandle target;

    protected void init(IClientConfiguration config) throws FileSystemClientException {
        ICommandLine cli = config.getSubcommandCommandLine();
        String uri = cli.getOption((IOptionKey)CommonOptions.OPT_URI, null);
        String wsSelector = cli.getOption(CommonOptions.OPT_WORKSPACE, null);
        this.wsConn = RepoUtil.findWorkspaceConnection((IClientConfiguration)config, (String)uri, (String)wsSelector);
        String targetSelector = cli.getOption((IOptionKey)FlowWorkspaceTargetCmdOptions.OPT_TARGET);
        try {
            this.target = RepoUtil.findNamedWorkspace((String)targetSelector, (boolean)true, (boolean)true, (ITeamRepository)this.wsConn.teamRepository(), (IClientConfiguration)config);
        }
        catch (RepoUtil.UnmatchedSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)e, (IClientConfiguration)config);
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.FlowTargetCmd_COULD_NOT_FIND_WORKSPACE, (Object)targetSelector));
        }
        catch (RepoUtil.AmbiguousSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)e, (IClientConfiguration)config);
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.FlowTargetCmd_MULTIPLE_WORKSPACE_MATCH, (Object)targetSelector));
        }
    }

    public void run(IClientConfiguration config) throws FileSystemClientException {
        this.init(config);
        FilesystemRestClient client = new FilesystemRestClient();
        if (!config.isDryRun()) {
            ParmsWorkspaceTarget parms = new ParmsWorkspaceTarget();
            parms.activeWorkspace = new ParmsWorkspace(this.wsConn);
            parms.targetWorkspace = new ParmsWorkspace(this.wsConn.teamRepository(), this.target);
            try {
                client.postSetWorkspaceTarget(parms, null);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)Messages.FlowTargetCmd_CHANGE_FAILED, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
            }
        }
        config.getContext().stdout().println(Messages.FlowTargetCmd_TARGET_SUCCESFULLY_CHANGED);
    }
}

