/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.subcommands.FlowComponentTargetCmdOptions;
import com.ibm.team.filesystem.cli.client.internal.subcommands.FlowWorkspaceTargetCmd;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.rest.parameters.ParmsComponentTarget;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.rcp.core.internal.rest.FilesystemRestClient;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class FlowComponentTargetCmd
extends FlowWorkspaceTargetCmd {
    public void run(IClientConfiguration config) throws FileSystemClientException {
        IComponentHandle compHandle;
        this.init(config);
        ICommandLine cli = config.getSubcommandCommandLine();
        String targetSelector = cli.getOption((IOptionKey)FlowComponentTargetCmdOptions.OPT_COMPONENT);
        try {
            List handles = RepoUtil.findNamedComponents(Collections.singletonList(targetSelector), (boolean)false, (IWorkspaceConnection)this.wsConn, (ITeamRepository)this.wsConn.teamRepository(), (boolean)true, (IClientConfiguration)config);
            assert (handles.size() == 1);
            compHandle = (IComponentHandle)handles.get(0);
        }
        catch (RepoUtil.UnmatchedSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)e, (IClientConfiguration)config);
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.FlowTargetCmd_COULD_NOT_FIND_WORKSPACE, (Object)targetSelector));
        }
        catch (RepoUtil.AmbiguousSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)e, (IClientConfiguration)config);
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.FlowTargetCmd_MULTIPLE_WORKSPACE_MATCH, (Object)targetSelector));
        }
        FilesystemRestClient client = new FilesystemRestClient();
        if (!config.isDryRun()) {
            ParmsComponentTarget parms = new ParmsComponentTarget();
            parms.activeWorkspace = new ParmsWorkspace(this.wsConn);
            parms.targetWorkspace = new ParmsWorkspace(this.wsConn.teamRepository(), this.target);
            parms.activeComponentItemIds = new String[]{compHandle.getItemId().getUuidValue()};
            try {
                client.postSetComponentTarget(parms, null);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)Messages.FlowTargetCmd_CHANGE_FAILED, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
            }
        }
        config.getContext().stdout().println(Messages.FlowTargetCmd_TARGET_SUCCESFULLY_CHANGED);
    }
}

