/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.internal.ClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.CLIBackupHandler;
import com.ibm.team.filesystem.cli.core.util.ICopyFileAreaView;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.PendingChangesUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.client.operations.DiscardDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IDiscardOperation;
import com.ibm.team.filesystem.client.operations.IShareOutOfSync;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.GapException;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.NWayConflictUnsupportedException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscardCmd
extends AbstractSubcommand {
    IClientConfiguration config;

    public void run(IClientConfiguration config) throws FileSystemClientException {
        this.config = config;
        int maxChanges = -1;
        ICommandLine subargs = config.getSubcommandCommandLine();
        if (!subargs.hasOption((IOptionKey)CommonOptions.OPT_CHANGESET_SELECTORS)) {
            throw StatusHelper.argSyntax((String)Messages.DiscardCmd_13);
        }
        List csSelectors = subargs.getOptions((IOptionKey)CommonOptions.OPT_CHANGESET_SELECTORS);
        boolean verbose = subargs.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE);
        maxChanges = CommonOptions.getMaxChangesToInterpret((ICommandLine)subargs);
        ICopyFileAreaView cfaView = SubcommandUtil.getAffectedComponentsAndShares((IClientConfiguration)config);
        List workspaces = RepoUtil.getWorkspaceConnections((ICopyFileAreaView)cfaView, (boolean)false);
        HashMap<IWorkspaceConnection, List> changeSets = new HashMap<IWorkspaceConnection, List>();
        for (String csSelector : csSelectors) {
            HashMap<IWorkspaceConnection, List> changeSetsTmp = new HashMap<IWorkspaceConnection, List>();
            for (IWorkspaceConnection wsConn : workspaces) {
                try {
                    changeSetsTmp.put(wsConn, RepoUtil.findNamedChangeSetsForWorkspace((IWorkspaceConnection)wsConn, (String)csSelector, (IClientConfiguration)config));
                }
                catch (TeamRepositoryException e) {
                    throw StatusHelper.wrap((String)Messages.DiscardCmd_2, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
                }
            }
            int numTmpChangesets = 0;
            for (IWorkspaceConnection wsConn : changeSetsTmp.keySet()) {
                numTmpChangesets += ((List)changeSetsTmp.get(wsConn)).size();
            }
            if (numTmpChangesets == 0) {
                RepoUtil.UnmatchedSelectorException e = new RepoUtil.UnmatchedSelectorException(RepoUtil.SelectorException.Type.CHANGESET, csSelector, Collections.EMPTY_LIST);
                SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)e, (IClientConfiguration)config);
                throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.DiscardCmd_3, (Object)e.getSelector()));
            }
            if (1 < numTmpChangesets) {
                IndentingPrintStream ps = new IndentingPrintStream((OutputStream)config.getContext().stdout());
                ps.println((CharSequence)Messages.DiscardCmd_4);
                PendingChangesUtil.PendingChangesOptions options = new PendingChangesUtil.PendingChangesOptions();
                options.setVerbose(verbose);
                options.enablePrinter(0);
                options.enablePrinter(1);
                options.enablePrinter(8);
                options.enablePrinter(4);
                options.enablePrinter(6);
                options.setMaxChanges(maxChanges);
                options.enablePrinter(7);
                options.enableFilter(0);
                options.enableFilter(1);
                options.enableFilter(4);
                for (IWorkspaceConnection wsConn : changeSetsTmp.keySet()) {
                    List changeSetsForCP;
                    options.addFilter((IItemHandle)wsConn.getResolvedWorkspace(), 0);
                    List csHandles = (List)changeSetsTmp.get(wsConn);
                    options.addFilters((Collection)csHandles, 4);
                    try {
                        changeSetsForCP = wsConn.teamRepository().itemManager().fetchPartialItems(csHandles, 0, Collections.singleton(IChangeSet.COMPONENT_PROPERTY), null);
                    }
                    catch (TeamRepositoryException e) {
                        throw StatusHelper.wrap((String)Messages.DiscardCmd_12, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
                    }
                    for (IChangeSet cs : changeSetsForCP) {
                        options.addFilter((IItemHandle)cs.getComponent(), 1);
                    }
                }
                PendingChangesUtil.printPendingChanges((boolean)false, (PendingChangesUtil.PendingChangesOptions)options, (IndentingPrintStream)ps.indent(), (IClientConfiguration)config);
                throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.DiscardCmd_5, (Object)csSelector));
            }
            for (IWorkspaceConnection wsConn : changeSetsTmp.keySet()) {
                if (!changeSets.containsKey(wsConn)) {
                    changeSets.put(wsConn, (List)changeSetsTmp.get(wsConn));
                    continue;
                }
                ((List)changeSets.get(wsConn)).addAll((Collection)changeSetsTmp.get(wsConn));
            }
        }
        if (verbose) {
            IndentingPrintStream ps = new IndentingPrintStream((OutputStream)config.getContext().stdout());
            if (config.isDryRun()) {
                ps.println((CharSequence)Messages.DiscardCmd_6);
            } else {
                ps.println((CharSequence)Messages.DiscardCmd_7);
            }
            PendingChangesUtil.PendingChangesOptions options = new PendingChangesUtil.PendingChangesOptions();
            options.setVerbose(verbose);
            options.enablePrinter(0);
            options.enablePrinter(1);
            options.enablePrinter(8);
            options.enablePrinter(4);
            options.enablePrinter(6);
            options.setMaxChanges(maxChanges);
            options.enablePrinter(7);
            options.enableFilter(0);
            options.enableFilter(1);
            options.enableFilter(4);
            for (IWorkspaceConnection wsConn : changeSets.keySet()) {
                List changeSetsForCP;
                options.addFilter((IItemHandle)wsConn.getResolvedWorkspace(), 0);
                List csHandles = (List)changeSets.get(wsConn);
                options.addFilters((Collection)csHandles, 4);
                try {
                    changeSetsForCP = wsConn.teamRepository().itemManager().fetchPartialItems(csHandles, 0, Collections.singleton(IChangeSet.COMPONENT_PROPERTY), null);
                }
                catch (TeamRepositoryException e) {
                    throw StatusHelper.wrap((String)Messages.DiscardCmd_12, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
                }
                for (IChangeSet cs : changeSetsForCP) {
                    options.addFilter((IItemHandle)cs.getComponent(), 1);
                }
            }
            PendingChangesUtil.printPendingChanges((boolean)false, (PendingChangesUtil.PendingChangesOptions)options, (IndentingPrintStream)ps.indent(), (IClientConfiguration)config);
        }
        CLIDiscardDilemmaHandler handler = new CLIDiscardDilemmaHandler();
        if (!config.isDryRun()) {
            for (Map.Entry entry : changeSets.entrySet()) {
                block29: {
                    IWorkspaceConnection workspaceConnection = (IWorkspaceConnection)entry.getKey();
                    List changesetHandles = (List)entry.getValue();
                    if (changesetHandles.isEmpty()) continue;
                    IDiscardOperation discardOperation = IOperationFactory.instance.getDiscardOperation((DiscardDilemmaHandler)handler);
                    discardOperation.discard(workspaceConnection, (Collection)changesetHandles);
                    discardOperation.setRefreshBeforeRun(((ClientConfiguration)config).getPersistentPreferences().getAutoRefresh());
                    try {
                        discardOperation.run(null);
                    }
                    catch (GapException gapException) {
                        throw StatusHelper.gap((String)Messages.DiscardCmd_9);
                    }
                    catch (NWayConflictUnsupportedException nWayConflictUnsupportedException) {
                        throw StatusHelper.nWayConflict((String)Messages.DiscardCmd_10);
                    }
                    catch (TeamRepositoryException e) {
                        throw StatusHelper.wrap((String)Messages.DiscardCmd_11, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        if (handler.uncommitted != null) {
                            this.complainAboutUncommitted(handler.uncommitted, config);
                        }
                        if (!handler.failedDueToOutOfSync()) break block29;
                        throw StatusHelper.outOfSync((String)Messages.LastModCmd_7);
                    }
                }
                if (handler.backupHandler.getSaved().size() <= 0) continue;
                SubcommandUtil.showShedUpdate((String)Messages.AcceptResultDisplayer_SHED_MESSAGE, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()), (CLIBackupHandler)handler.backupHandler);
            }
            config.getContext().stdout().println(Messages.DiscardCmd_CHANGESETS_SUCCESSFULLY_DISCARDED);
        }
    }

    private void complainAboutUncommitted(Map<ConfigurationDescriptor, Collection<ILocalChange>> uncommitted, IClientConfiguration config) throws FileSystemClientException {
        IndentingPrintStream ips = new IndentingPrintStream((OutputStream)config.getContext().stderr());
        ips.println((CharSequence)Messages.DiscardCmd_UNCOMMMITTED_CHANGE_WARNING);
        ips = ips.indent();
        TreeSet<String> localItems = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (Collection<ILocalChange> changes : uncommitted.values()) {
            for (ILocalChange change : changes) {
                localItems.add(change.getPath().toOSString());
            }
        }
        for (String path : localItems) {
            ips.println((CharSequence)path);
        }
        throw StatusHelper.disallowed((String)NLS.bind((String)Messages.DiscardCmd_UNCOMMITTED_ERROR, (Object)config.getContext().getAppName()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CLIDiscardDilemmaHandler
    extends DiscardDilemmaHandler {
        private Map<ConfigurationDescriptor, Collection<ILocalChange>> uncommitted = null;
        private CLIBackupHandler backupHandler = new CLIBackupHandler();
        boolean failedDueToOutOfSync = false;

        private CLIDiscardDilemmaHandler() {
        }

        public int uncheckedInChanges(Map<ConfigurationDescriptor, Collection<ILocalChange>> changes) {
            this.uncommitted = changes;
            return 1;
        }

        public BackupDilemmaHandler getBackupDilemmaHandler() {
            return this.backupHandler;
        }

        public OutOfSyncDilemmaHandler getOutOfSyncDilemmaHandler() {
            return new OutOfSyncDilemmaHandler(){

                public int outOfSync(Collection<IShareOutOfSync> sharesOutOfSync) {
                    ((CLIDiscardDilemmaHandler)CLIDiscardDilemmaHandler.this).DiscardCmd.this.config.getContext().stdout().println(Messages.CheckInCmd_15);
                    IndentingPrintStream out = new IndentingPrintStream((OutputStream)((CLIDiscardDilemmaHandler)CLIDiscardDilemmaHandler.this).DiscardCmd.this.config.getContext().stdout()).indent();
                    for (IShareOutOfSync oos : sharesOutOfSync) {
                        out.println((CharSequence)oos.getShare().getPath().toString());
                    }
                    CLIDiscardDilemmaHandler.this.failedDueToOutOfSync = true;
                    return 1;
                }

                public boolean willIgnoreAllSharesOutOfSync() {
                    return false;
                }
            };
        }

        public boolean failedDueToOutOfSync() {
            return this.failedDueToOutOfSync;
        }
    }
}

