/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.flowcommands.ChangeDisplayer;
import com.ibm.team.filesystem.cli.client.internal.subcommands.ConflictsCmdOpts;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.ChattyRepoRunnable;
import com.ibm.team.filesystem.cli.core.util.ICopyFileAreaView;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IFileSystemView;
import com.ibm.team.filesystem.client.internal.TempHelper;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ILogicalConflict;
import com.ibm.team.filesystem.common.ILogicalConflictReport;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IItemConflictReport;
import com.ibm.team.scm.common.dto.IUpdateReport;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.ItemLists;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public class ConflictsCmd
extends AbstractSubcommand {
    boolean verbose;
    boolean quiet;

    public void run(IClientConfiguration config) throws FileSystemClientException {
        IPath conflictRelativePath;
        ICommandLine subargs = config.getSubcommandCommandLine();
        this.verbose = subargs.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE);
        this.quiet = subargs.hasOption((IOptionKey)CommonOptions.OPT_QUIET);
        String mine = subargs.getOption((IOptionKey)ConflictsCmdOpts.OPT_CONFLICTS_MINE, null);
        String proposed = subargs.getOption((IOptionKey)ConflictsCmdOpts.OPT_CONFLICTS_PROPOSED, null);
        String ancestor = subargs.getOption((IOptionKey)ConflictsCmdOpts.OPT_CONFLICTS_ANCESTOR, null);
        if (mine != null && proposed != null || mine != null && ancestor != null || proposed != null && ancestor != null) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ConflictsCmd_1, (Object[])new String[]{ConflictsCmdOpts.OPT_CONFLICTS_MINE.getName(), ConflictsCmdOpts.OPT_CONFLICTS_PROPOSED.getName(), ConflictsCmdOpts.OPT_CONFLICTS_ANCESTOR.getName()}));
        }
        if (mine == null && proposed == null && ancestor == null) {
            this.showList(config);
            return;
        }
        Path path = mine != null ? new Path(mine) : (proposed != null ? new Path(proposed) : new Path(ancestor));
        IPath conflictPath = SubcommandUtil.makeAbsolutePath((IClientConfiguration)config, (String)path.toPortableString());
        if (!PathUtils.exists((IPath)conflictPath, (IProgressMonitor)TempHelper.MONITOR)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ConflictsCmd_PATH_DOES_NOT_EXIST, (Object)conflictPath.toOSString()));
        }
        ICopyFileAreaView cfa = SubcommandUtil.getAffectedComponentsAndShares((IClientConfiguration)config);
        try {
            conflictRelativePath = SubcommandUtil.makeRelativeToCFARoot((IPath)cfa.getRoot().getRoot(), (IPath)conflictPath);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ConflictsCmd_PATH_NOT_DESCENDENT_OF_SANDBOX_PATH, (Object)path, (Object)cfa.getRoot().getRoot()));
        }
        ConflictByPathResult result = this.findConflictByPath(config, cfa, conflictRelativePath);
        if (result == null) {
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.ConflictsCmd_2, (Object)conflictPath.toOSString()));
        }
        if (!result.logical.isChangeType(4)) {
            throw StatusHelper.argSyntax((String)Messages.ConflictsCmd_3);
        }
        IVersionableHandle state = mine != null ? result.report.getOriginalSelectedContributorState() : (proposed != null ? result.report.getProposedContributorState() : result.report.getCommonAncestorState());
        InputStream in = null;
        if (state instanceof IFileItemHandle) {
            IFileItemHandle fileItemHandle = (IFileItemHandle)state;
            in = RepoUtil.findContentFor((ITeamRepository)result.wsConn.teamRepository(), (IPath)conflictPath, (IFileItemHandle)fileItemHandle, (IClientConfiguration)config);
        } else if (state instanceof ISymbolicLinkHandle) {
            ISymbolicLink symbolicLink;
            ISymbolicLinkHandle symbolicLinkHandle = (ISymbolicLinkHandle)state;
            try {
                symbolicLink = (ISymbolicLink)SCMPlatform.getWorkspaceManager((ITeamRepository)result.wsConn.teamRepository()).versionableManager().fetchCompleteState((IVersionableHandle)symbolicLinkHandle, (IProgressMonitor)TempHelper.MONITOR);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)Messages.ConflictsCmd_4, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
            }
            in = new ByteArrayInputStream(symbolicLink.getTarget().getBytes());
        } else {
            throw StatusHelper.failure((String)Messages.ConflictsCmd_4, null);
        }
        try {
            RepoUtil.transfer((InputStream)in, (OutputStream)config.getContext().stdout());
        }
        catch (IOException e) {
            throw StatusHelper.failure((String)Messages.ConflictsCmd_4, (Throwable)e);
        }
    }

    private ConflictByPathResult findConflictByPath(IClientConfiguration config, ICopyFileAreaView cfa, IPath item) throws FileSystemClientException {
        final String[] segments = item.segments();
        final ConflictByPathResult[] result = new ConflictByPathResult[1];
        ChattyRepoRunnable runnable = new ChattyRepoRunnable(config){

            public void run(ICopyFileAreaView cfa, ICopyFileAreaView.IRepoView view, IWorkspaceConnection wsConn) throws FileSystemClientException {
                ILogicalConflictReport conflictReport;
                IFileSystemView fsv = FileSystemCore.getFileSystemManager((ITeamRepository)wsConn.teamRepository()).getFileSystemView((IConnection)wsConn);
                try {
                    conflictReport = fsv.conflictReport(null);
                }
                catch (TeamRepositoryException e) {
                    throw StatusHelper.wrap((String)Messages.ConflictsCmd_6, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)this.config.getContext().stderr()));
                }
                IUpdateReport report = conflictReport.conflictReport();
                for (IComponentHandle comp : ItemLists.idsToHandles((Collection)cfa.getLoadedComponents(view))) {
                    for (ILogicalConflict conflict : conflictReport.getConflictsForComponent(comp)) {
                        if (!Arrays.equals(segments, conflict.getPathHint())) continue;
                        for (IItemConflictReport itemReport : report.getConflictsForComponent(comp)) {
                            if (!conflict.item().sameItemId((IItemHandle)itemReport.item())) continue;
                            result[0] = new ConflictByPathResult(wsConn, conflict, itemReport);
                            return;
                        }
                    }
                }
            }
        };
        cfa.runOnEachRepo((ICopyFileAreaView.IRepoRunnable)runnable, config, (IOptionKey)CommonOptions.OPT_USERNAME, (IOptionKey)CommonOptions.OPT_USERNAME);
        if (runnable.hadLoginFailure()) {
            throw StatusHelper.login(null, null);
        }
        return result[0];
    }

    protected void showList(IClientConfiguration config) throws FileSystemClientException {
        final boolean[] hasConflicts = new boolean[1];
        ICopyFileAreaView cfa = SubcommandUtil.getAffectedComponentsAndShares((IClientConfiguration)config);
        ChattyRepoRunnable runnable = new ChattyRepoRunnable(config){

            public void run(ICopyFileAreaView cfa, ICopyFileAreaView.IRepoView view, IWorkspaceConnection wsConn) throws FileSystemClientException {
                IUpdateReport report = wsConn.conflictReport();
                if (!hasConflicts[0]) {
                    for (ItemId itemId : cfa.getLoadedComponents(view)) {
                        boolean bl = hasConflicts[0] = report.getConflictsForComponent((IComponentHandle)itemId.toHandle()).size() > 0;
                    }
                }
                ChangeDisplayer.showConflicts(wsConn, new IndentingPrintStream((OutputStream)this.config.getContext().stdout()), this.config);
            }
        };
        cfa.runOnEachRepo((ICopyFileAreaView.IRepoRunnable)runnable, config, (IOptionKey)CommonOptions.OPT_USERNAME, (IOptionKey)CommonOptions.OPT_PASSWORD);
        if (runnable.hadLoginFailure()) {
            if (hasConflicts[0]) {
                throw StatusHelper.login((String)Messages.ConflictsCmd_8, null);
            }
            throw StatusHelper.login((String)Messages.ConflictsCmd_9, null);
        }
        if (hasConflicts[0]) {
            throw StatusHelper.conflict((String)Messages.ConflictsCmd_10);
        }
    }

    private static class ConflictByPathResult {
        final IWorkspaceConnection wsConn;
        final ILogicalConflict logical;
        final IItemConflictReport report;

        ConflictByPathResult(IWorkspaceConnection wsConn, ILogicalConflict logical, IItemConflictReport report) {
            this.wsConn = wsConn;
            this.logical = logical;
            this.report = report;
        }
    }
}

