/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.subcommands.CompareCmdOpts;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.StringUtil;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.internal.snapshot.FlowType;
import com.ibm.team.filesystem.client.internal.snapshot.ISnapshot;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotId;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotSyncReport;
import com.ibm.team.filesystem.common.changemodel.IPathResolver;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogBaselineEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogChangeSetEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogComponentEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogEntryDTO;
import com.ibm.team.filesystem.rcp.core.internal.changelog.BaseChangeLogEntryVisitor;
import com.ibm.team.filesystem.rcp.core.internal.changelog.ChangeLogCustomizer;
import com.ibm.team.filesystem.rcp.core.internal.changelog.ChangeLogEntryVisitor;
import com.ibm.team.filesystem.rcp.core.internal.changelog.ChangeLogStreamOutput;
import com.ibm.team.filesystem.rcp.core.internal.changelog.GenerateChangeLogOperation;
import com.ibm.team.filesystem.rcp.core.internal.changelog.IChangeLogOutput;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.CopyFileAreaPathResolver;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.FallbackPathResolver;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.SnapshotPathResolver;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponentHandle;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.osgi.util.NLS;

public class CompareCmd
extends AbstractSubcommand {
    public void run(IClientConfiguration config) throws FileSystemClientException {
        ChangeLogEntryDTO changelog;
        SnapshotSyncReport stefansSyncReport;
        ICommandLine subargs = config.getSubcommandCommandLine();
        ITeamRepository repo = RepoUtil.loginUrlArgAnc((IClientConfiguration)config);
        String componentSelector = subargs.getOption((IOptionKey)CompareCmdOpts.OPT_COMPONENT, null);
        CompareType type1 = this.findType(subargs.getOption((IOptionKey)CompareCmdOpts.OPT_COMPARE_TYPE_1));
        IItemHandle item1 = this.resolveItem(repo, type1, subargs.getOption((IOptionKey)CompareCmdOpts.OPT_COMPARE_ITEM_1), componentSelector, config);
        CompareType type2 = this.findType(subargs.getOption((IOptionKey)CompareCmdOpts.OPT_COMPARE_TYPE_2));
        IItemHandle item2 = this.resolveItem(repo, type2, subargs.getOption((IOptionKey)CompareCmdOpts.OPT_COMPARE_ITEM_2), componentSelector, config);
        SnapshotId snapshotId1 = SnapshotId.getSnapshotId((IItemHandle)item1);
        SnapshotId snapshotId2 = SnapshotId.getSnapshotId((IItemHandle)item2);
        try {
            stefansSyncReport = SnapshotSyncReport.compare((ISnapshot)snapshotId1.getSnapshot(null), (ISnapshot)snapshotId2.getSnapshot(null), null, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)"Compare failed", (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
        }
        GenerateChangeLogOperation clOp = new GenerateChangeLogOperation();
        ChangeLogCustomizer customizer = this.createChangeLogParms2(subargs);
        ArrayList<Object> pathResolvers = new ArrayList<Object>();
        pathResolvers.add(CopyFileAreaPathResolver.create());
        pathResolvers.add(SnapshotPathResolver.create((SnapshotId)snapshotId1));
        pathResolvers.add(SnapshotPathResolver.create((SnapshotId)snapshotId2));
        FallbackPathResolver pathResolver = new FallbackPathResolver(pathResolvers, true);
        clOp.setChangeLogRequest(repo, stefansSyncReport, (IPathResolver)pathResolver, customizer);
        try {
            changelog = clOp.run(null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)"Failed to generate change log", (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
        }
        boolean shouldShowContrib = this.findShouldShowContrib(subargs);
        boolean shouldShowDate = this.findShouldShowDate(subargs);
        boolean shouldShowChangeSetWorkItems = this.findShouldShowChangeSetWorkItems(subargs);
        boolean shouldShowFlowDirection = this.findShouldShowFlowDirection(subargs);
        CLIChangeLogEntryVisitor visitor = new CLIChangeLogEntryVisitor((IChangeLogOutput)new ChangeLogStreamOutput(config.getContext().stdout()));
        visitor.setShowBaselineCreationDate(shouldShowDate);
        visitor.setShowChangeSetCreationDate(shouldShowDate);
        visitor.setShowBaselineCreator(shouldShowContrib);
        visitor.setShowChangeSetCreator(shouldShowContrib);
        visitor.setContributorFormat(subargs.getOption((IOptionKey)CompareCmdOpts.OPT_FMT_CONTRIB, visitor.getContribFormat()));
        visitor.setDateFormat(subargs.getOption((IOptionKey)CompareCmdOpts.OPT_FMT_DATE, visitor.getDateFormat()));
        visitor.setShowChangeSetWorkItems(shouldShowChangeSetWorkItems);
        visitor.setShowDirectionNodes(shouldShowFlowDirection);
        ChangeLogEntryVisitor.acceptInto((ChangeLogEntryDTO)changelog, (ChangeLogEntryVisitor)visitor);
    }

    private ChangeLogCustomizer createChangeLogParms2(ICommandLine subargs) throws FileSystemClientException {
        String filter;
        ChangeLogCustomizer customizer = new ChangeLogCustomizer();
        String show = subargs.getOption((IOptionKey)CompareCmdOpts.OPT_SHOW, "dcbsw");
        if (show.contains("A")) {
            customizer.setIncludeDirection(true);
            customizer.setIncludeBaselines(true);
            customizer.setIncludeChangeSets(true);
            customizer.setIncludeComponents(true);
            customizer.setIncludePaths(true);
            customizer.setIncludeWorkItems(true);
        } else {
            SwitchString ss = new SwitchString(show);
            customizer.setIncludeDirection(ss.contains("d"));
            customizer.setIncludeBaselines(ss.contains("b"));
            customizer.setIncludeChangeSets(ss.contains("s"));
            customizer.setIncludeComponents(ss.contains("c"));
            customizer.setIncludePaths(ss.contains("f"));
            customizer.setIncludeWorkItems(ss.contains("w"));
            if (ss.getRemainder().length() > 0) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.CompareCmd_BAD_INCLUDE_SWITCHES, (Object)ss.getRemainder()));
            }
        }
        String dir = subargs.getOption((IOptionKey)CompareCmdOpts.OPT_DIRECTIONS, null);
        if (dir == null || "b".equals(dir)) {
            customizer.setFlowsToInclude(FlowType.Both);
        } else if ("i".equals(dir)) {
            customizer.setFlowsToInclude(FlowType.Incoming);
        } else if ("o".equals(dir)) {
            customizer.setFlowsToInclude(FlowType.Outgoing);
        } else {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.CompareCmd_BAD_FLOW_DIRECTION, (Object[])new String[]{dir, "b", "i", "o"}));
        }
        String reroot = subargs.getOption((IOptionKey)CompareCmdOpts.OPT_REROOT, null);
        if (reroot != null) {
            if ("r".equals(reroot = reroot.trim())) {
                customizer.setWorkItemRerootDepth("clentry_root");
            } else if ("d".equals(reroot)) {
                customizer.setWorkItemRerootDepth("clentry_direction");
            } else if ("c".equals(reroot)) {
                customizer.setWorkItemRerootDepth("clentry_component");
            } else if ("b".equals(reroot)) {
                customizer.setWorkItemRerootDepth("clentry_baseline");
            } else {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.CompareCmd_UNKNWON_REROOT_TYPE, (Object[])new String[]{reroot, "r", "d", "c", "b"}));
            }
        }
        if ((filter = subargs.getOption((IOptionKey)CompareCmdOpts.OPT_PRUNE, null)) != null) {
            SwitchString ss = new SwitchString(filter);
            customizer.setPruneEmptyDirections(ss.contains("d"));
            customizer.setPruneUnchangedComponents(ss.contains("c"));
            if (ss.getRemainder().length() > 0) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.CompareCmd_BAD_PRUNE_SWITCHES, (Object)ss.getRemainder()));
            }
        }
        return customizer;
    }

    private boolean findShouldShowFlowDirection(ICommandLine subargs) {
        String show = subargs.getOption((IOptionKey)CompareCmdOpts.OPT_SHOW, "dcbsw");
        return show.contains("d") || "A".equals(show);
    }

    private boolean findShouldShowContrib(ICommandLine subargs) {
        String display = subargs.getOption((IOptionKey)CompareCmdOpts.OPT_DISPLAY, "cd");
        return display.contains("c");
    }

    private boolean findShouldShowDate(ICommandLine subargs) {
        String display = subargs.getOption((IOptionKey)CompareCmdOpts.OPT_DISPLAY, "cd");
        return display.contains("d");
    }

    private boolean findShouldShowChangeSetWorkItems(ICommandLine subargs) {
        String display = subargs.getOption((IOptionKey)CompareCmdOpts.OPT_DISPLAY, "cd");
        return display.contains("i");
    }

    private IItemHandle resolveItem(ITeamRepository repo, CompareType type, String itemSelector, String componentSelector, IClientConfiguration config) throws FileSystemClientException {
        switch (type) {
            case WORKSPACE: {
                try {
                    return RepoUtil.findNamedWorkspace((String)itemSelector, (boolean)true, (boolean)true, (ITeamRepository)repo, (IClientConfiguration)config);
                }
                catch (RepoUtil.UnmatchedSelectorException e) {
                    SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)e, (IClientConfiguration)config);
                    throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.CompareCmd_UNMATCHED_REMOTE_WORKSPACE, (Object)itemSelector));
                }
                catch (RepoUtil.AmbiguousSelectorException e) {
                    SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)e, (IClientConfiguration)config);
                    throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.CompareCmd_AMBIGUOUS_REMOTE_WORKSPACE, (Object)itemSelector));
                }
            }
            case BASELINE: {
                IComponentHandle compHandle = null;
                if (componentSelector != null) {
                    try {
                        compHandle = (IComponentHandle)RepoUtil.findNamedComponents(Collections.singletonList(componentSelector), (ITeamRepository)repo, (IClientConfiguration)config).get(componentSelector);
                    }
                    catch (RepoUtil.UnmatchedSelectorException e) {
                        SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)e, (IClientConfiguration)config);
                        throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.CompareCmd_UNMATCHED_COMPONENT, (Object)componentSelector));
                    }
                    catch (RepoUtil.AmbiguousSelectorException e) {
                        SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)e, (IClientConfiguration)config);
                        throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.CompareCmd_AMBIGUOUS_COMPONENT, (Object)componentSelector));
                    }
                }
                try {
                    return RepoUtil.findNamedBaseline((ITeamRepository)repo, compHandle, (String)itemSelector, (IClientConfiguration)config);
                }
                catch (RepoUtil.UnmatchedSelectorException e) {
                    SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)e, (IClientConfiguration)config);
                    throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.CompareCmd_UNMATCHED_BASELINE, (Object)itemSelector));
                }
                catch (RepoUtil.AmbiguousSelectorException e) {
                    SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)e, (IClientConfiguration)config);
                    throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.CompareCmd_AMBIGUOUS_BASELINE, (Object)itemSelector));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.CompareCmd_UNMATCHED_BASELINE_OR_COMP_MISSING, (Object)itemSelector, (Object)CompareCmdOpts.OPT_COMPONENT.getLongOpt()));
                }
            }
            case SNAPSHOT: {
                try {
                    return RepoUtil.findNamedSnapshot((String)itemSelector, (ITeamRepository)repo, (IClientConfiguration)config);
                }
                catch (RepoUtil.UnmatchedSelectorException e) {
                    SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)e, (IClientConfiguration)config);
                    throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.CompareCmd_UNMATCHED_SNAPSHOT, (Object)itemSelector));
                }
                catch (RepoUtil.AmbiguousSelectorException e) {
                    SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)e, (IClientConfiguration)config);
                    throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.CompareCmd_AMBIGUOUS_SNAPSHOT, (Object)itemSelector));
                }
            }
        }
        return null;
    }

    private CompareType findType(String typeString) throws FileSystemClientException {
        CompareType[] compareTypeArray = CompareType.values();
        int n = compareTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            CompareType t = compareTypeArray[n2];
            String[] stringArray = t.getNames();
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String candidate = stringArray[n4];
                if (candidate.equals(typeString)) {
                    return t;
                }
                ++n4;
            }
            ++n2;
        }
        throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.CompareCmd_UNKNOWN_TYPE_STRING, (Object)typeString, (Object)StringUtil.join((String)typeString, (String[])CompareType.NAMES)));
    }

    private static class CLIChangeLogEntryVisitor
    extends BaseChangeLogEntryVisitor {
        public CLIChangeLogEntryVisitor(IChangeLogOutput out) {
            this.setOutput(out);
        }

        private static String selector(ChangeLogEntryDTO dto) {
            return AliasUtil.selector((String)dto.getEntryName(), (UUID)UUID.valueOf((String)dto.getItemId()));
        }

        protected String findComponentName(ChangeLogComponentEntryDTO dto) {
            return CLIChangeLogEntryVisitor.selector((ChangeLogEntryDTO)dto);
        }

        protected String findChangeSetName(ChangeLogChangeSetEntryDTO dto) {
            String alias = AliasUtil.alias((String)dto.getItemId());
            if (alias != null && alias.length() > 0) {
                return NLS.bind((String)Messages.CompareCmd_CHANGESET_ALIAS_AND_NAME, (Object)alias, (Object)super.findChangeSetName(dto));
            }
            return super.findChangeSetName(dto);
        }

        protected String findBaselineName(ChangeLogBaselineEntryDTO dto) {
            String alias = AliasUtil.alias((String)dto.getItemId());
            if (alias != null && alias.length() > 0) {
                return NLS.bind((String)Messages.CompareCmd_CHANGESET_ALIAS_AND_NAME, (Object)alias, (Object)super.findBaselineName(dto));
            }
            return super.findBaselineName(dto);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum CompareType {
        WORKSPACE("workspace", "workspace", "stream", "ws", "s"),
        BASELINE("baseline", "baseline", "bl"),
        SNAPSHOT("baselineset", "snapshot", "ss");

        static final String[] NAMES;
        final String[] typeStrings;
        final String wireName;

        static {
            NAMES = new String[]{CompareType.WORKSPACE.typeStrings[0], CompareType.WORKSPACE.typeStrings[1], CompareType.BASELINE.typeStrings[0], CompareType.SNAPSHOT.typeStrings[0]};
        }

        private CompareType(String wireName, String ... t) {
            this.wireName = wireName;
            this.typeStrings = t;
        }

        String[] getNames() {
            return this.typeStrings;
        }

        String getWireName() {
            return this.wireName;
        }
    }

    private static class SwitchString {
        String switches;

        SwitchString(String switches) {
            this.switches = switches;
        }

        public boolean contains(String s) {
            if (this.switches.contains(s)) {
                this.switches = this.switches.replace(s, "");
                return true;
            }
            return false;
        }

        public String getRemainder() {
            return this.switches;
        }
    }
}

