/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.subcommands.CheckInCmdOptions;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.internal.ClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.ICopyFileAreaView;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.PendingChangesUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Sandbox;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.TempHelper;
import com.ibm.team.filesystem.client.internal.utils.ExceptionUtil;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IEncodingUploadFailure;
import com.ibm.team.filesystem.client.operations.ILineDelimiterUploadFailure;
import com.ibm.team.filesystem.client.operations.IShareOutOfSync;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.utils.ContentLineDelimiterError;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.ItemAlreadyInActiveChangeSetException;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.io.File;
import java.io.OutputStream;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckInCmd
extends AbstractSubcommand {
    IClientConfiguration config;
    DelimiterControl delimPolicy = DelimiterControl.FAIL_ON_ERROR;
    String csSelector = null;
    List<IShareable> failedUploads = new LinkedList<IShareable>();
    List<String> rewrittenUploads = new LinkedList<String>();
    List<String> skippedUploads = new LinkedList<String>();

    private List<IShareable> consumeArguments(ICopyFileAreaView cfaView) throws FileSystemClientException {
        ICommandLine subargs = this.config.getSubcommandCommandLine();
        if (!subargs.hasOption((IOptionKey)CheckInCmdOptions.OPT_TO_COMMIT)) {
            throw StatusHelper.argSyntax((String)Messages.CheckInCmd_0);
        }
        List paths = subargs.getOptions((IOptionKey)CheckInCmdOptions.OPT_TO_COMMIT);
        this.csSelector = subargs.getOption((IOptionKey)CheckInCmdOptions.OPT_COMMIT_TARGET, null);
        if (subargs.hasOption((IOptionKey)CheckInCmdOptions.OPT_DELIM_CONSISTENT) && subargs.hasOption((IOptionKey)CheckInCmdOptions.OPT_DELIM_NONE)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.CheckInCmd_MAY_NOT_SPECIFY_BOTH_DELIM_ARGS, (Object)CheckInCmdOptions.OPT_DELIM_CONSISTENT.toString(), (Object)CheckInCmdOptions.OPT_DELIM_NONE.toString()));
        }
        if (subargs.hasOption((IOptionKey)CheckInCmdOptions.OPT_DELIM_CONSISTENT)) {
            this.delimPolicy = DelimiterControl.REWRITE;
        } else if (subargs.hasOption((IOptionKey)CheckInCmdOptions.OPT_DELIM_NONE)) {
            this.delimPolicy = DelimiterControl.SET_NO_DELIM;
        }
        return this.findCommitRoots(cfaView, paths);
    }

    private List<IShareable> findCommitRoots(ICopyFileAreaView cfaView, List<String> strPaths) throws FileSystemClientException {
        Path cwd = new Path(this.config.getContext().getCurrentWorkingDirectory());
        List paths = SubcommandUtil.makeAbsolutePaths((IClientConfiguration)this.config, strPaths);
        if (paths.contains(cfaView.getRoot().getRoot())) {
            IShare[] shares = cfaView.getLoadedShares();
            ArrayList<IShareable> commitRoots = new ArrayList<IShareable>(shares.length);
            IShare[] iShareArray = shares;
            int n = shares.length;
            int n2 = 0;
            while (n2 < n) {
                IShare share = iShareArray[n2];
                commitRoots.add(SubcommandUtil.makeShareable((IShare)share));
                ++n2;
            }
            return commitRoots;
        }
        for (IPath path : paths) {
            File otherCfaRoot;
            if (cwd.isPrefixOf(path) || (otherCfaRoot = SubcommandUtil.findAncestorCFARoot((File)path.toFile())) == null) continue;
            Sandbox sb = new Sandbox((IPath)new Path(otherCfaRoot.getAbsolutePath()));
            SharingManager.getInstance().register((ISandbox)sb, false, null);
        }
        ArrayList<IShareable> commitRoots = new ArrayList<IShareable>(strPaths.size());
        for (IPath path : paths) {
            IPath sharePath;
            IShareable newShareable;
            IVersionableHandle verHandle;
            IShareable shareable = cfaView.findShareable(path.toOSString());
            if (shareable == null || shareable.getShare(null) == null) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.CheckInCmd_1, (Object)path));
            }
            IPath localPath = shareable.getLocalPath();
            IPath sharedPath = shareable.getShare(null).getPath();
            if (!sharedPath.equals((Object)localPath) && (verHandle = (newShareable = cfaView.findShareable((sharePath = path.removeLastSegments(1)).toOSString())).getRemote(null)) == null) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.CheckInCmd_PATH_NOT_IN_REMOTE, (Object)shareable.getFullPath().toPortableString()));
            }
            commitRoots.add(shareable);
        }
        return commitRoots;
    }

    public void run(IClientConfiguration config) throws FileSystemClientException {
        this.config = config;
        ResourcesPlugin.getWorkspace().getRoot();
        ICopyFileAreaView cfaView = SubcommandUtil.getAffectedComponentsAndShares((IClientConfiguration)config);
        List<IShareable> commitRoots = this.consumeArguments(cfaView);
        this.verifyRoots(commitRoots);
        Map groupedByConnection = RepoUtil.groupShareablesByWorkspaceConnection((IClientConfiguration)config, commitRoots);
        if (config.isDryRun()) {
            return;
        }
        LinkedList<Status> displayExceptions = new LinkedList<Status>();
        IndentingPrintStream out = new IndentingPrintStream((OutputStream)config.getContext().stdout());
        out.println((CharSequence)Messages.CheckInCmd_19);
        for (Map.Entry entry : groupedByConnection.entrySet()) {
            Collection<IChangeSetHandle> csHandles = this.commit(config, (IWorkspaceConnection)entry.getKey(), (List)entry.getValue());
            try {
                this.showCommit((IWorkspaceConnection)entry.getKey(), new ArrayList<IChangeSetHandle>(csHandles), config);
            }
            catch (FileSystemClientException e) {
                displayExceptions.add(new Status(4, "com.ibm.team.filesystem.cli.client", Messages.CheckInCmd_20, (Throwable)e));
            }
            catch (TeamRepositoryException e) {
                displayExceptions.add(new Status(4, "com.ibm.team.filesystem.cli.client", Messages.CheckInCmd_21, (Throwable)e));
            }
        }
        if (displayExceptions.size() > 0) {
            config.getContext().stderr().println(Messages.CheckInCmd_22);
            if (displayExceptions.size() == 1) {
                LoggingHelper.log((IStatus)((IStatus)displayExceptions.get(0)));
            } else {
                LoggingHelper.log((IStatus)new MultiStatus("com.ibm.team.filesystem.cli.client", -1, displayExceptions.toArray(new IStatus[0]), Messages.CheckInCmd_23, null));
            }
        }
    }

    private void showCommit(IWorkspaceConnection wsConn, List<IChangeSetHandle> csHandles, IClientConfiguration config) throws TeamRepositoryException, FileSystemClientException {
        PendingChangesUtil.PendingChangesOptions opts = new PendingChangesUtil.PendingChangesOptions();
        if (csHandles.isEmpty()) {
            return;
        }
        IItemManager man = wsConn.teamRepository().itemManager();
        List csComplete = man.fetchCompleteItems(csHandles, 0, null);
        opts.enableFilter(1);
        opts.enableFilter(4);
        opts.addFilters(csHandles, 4);
        for (IChangeSet cs : csComplete) {
            opts.addFilter((IItemHandle)cs.getComponent(), 1);
        }
        opts.enablePrinter(0);
        opts.enablePrinter(1);
        opts.enablePrinter(8);
        opts.enablePrinter(4);
        PendingChangesUtil.printWorkspace((IWorkspaceConnection)wsConn, (PendingChangesUtil.PendingChangesOptions)opts, (IClientConfiguration)config);
        if (this.rewrittenUploads.size() > 0) {
            IndentingPrintStream ips = new IndentingPrintStream((OutputStream)config.getContext().stderr());
            ips.println((CharSequence)Messages.CheckInCmd_ENCODING_CHANGED_MESSAGE);
            ips = ips.indent();
            for (String path : this.rewrittenUploads) {
                ips.println((CharSequence)path);
            }
        }
    }

    private void verifyRoots(List<IShareable> commitRoots) throws FileSystemClientException {
        for (IShareable shareable : commitRoots) {
            if (!shareable.exists(null)) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.CheckInCmd_3, (Object)shareable.getLocalPath().toPortableString()));
            }
            if (shareable.getShare(null) != null) continue;
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.CheckInCmd_4, (Object)shareable.getLocalPath().toPortableString()));
        }
        if (this.csSelector != null) {
            IComponentHandle compHandle = null;
            for (IShareable shareable : commitRoots) {
                ISharingDescriptor desc = shareable.getShare(null).getSharingDescriptor();
                if (compHandle == null) {
                    compHandle = desc.getComponent();
                    continue;
                }
                if (compHandle.sameItemId((IItemHandle)desc.getComponent())) continue;
                throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.CheckInCmd_26, (Object)commitRoots.get(0).getLocalPath(), (Object)shareable.getLocalPath()));
            }
        }
    }

    private IChangeSetHandle findActiveChangeSet(IWorkspaceConnection wsConn, IComponentHandle comp, String csSelector) throws FileSystemClientException {
        UUID uuid = RepoUtil.lookupUuid((String)csSelector);
        if (uuid == null) {
            throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.CheckInCmd_34, (Object)csSelector));
        }
        List candidates = wsConn.activeChangeSets(comp);
        for (IChangeSetHandle csHandle : candidates) {
            if (!uuid.equals((Object)csHandle.getItemId())) continue;
            return csHandle;
        }
        throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.CheckInCmd_30, (Object)csSelector));
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private Collection<IChangeSetHandle> commit(IClientConfiguration config, IWorkspaceConnection wsConn, List<IShareable> shareables) throws FileSystemClientException {
        groupedByComponent = this.groupByComponent(shareables);
        csHandles = new ArrayList<IChangeSetHandle>(groupedByComponent.size());
        for (Map.Entry<ItemId<IComponent>, List<IShareable>> entry : groupedByComponent.entrySet()) {
            block15: {
                compHandle = (IComponentHandle)entry.getKey().toHandle();
                toCommit = new IShareable[entry.getValue().size()];
                toCommit = entry.getValue().toArray(toCommit);
                handler = new FailProblemHandler();
                op = IOperationFactory.instance.getCheckinOperation((CommitDilemmaHandler)handler);
                if (this.csSelector == null) {
                    op.requestCheckin(toCommit, null, "", null);
                } else {
                    csHandle = this.findActiveChangeSet(wsConn, compHandle, this.csSelector);
                    op.requestCheckin(toCommit, csHandle, null, null);
                }
                op.setRefreshBeforeRun(true);
                atomicMaximum = ((ClientConfiguration)config).getPersistentPreferences().getAtomicCommitMaximum();
                if (atomicMaximum != -1) {
                    op.enableNonAtomicCommit(atomicMaximum);
                }
                try {
                    op.run(null);
                    csHandles.addAll(op.getCommittedChangeSets());
                    continue;
                }
                catch (ItemAlreadyInActiveChangeSetException e) {
                    desc = e.getErrorDescription();
                    throw StatusHelper.disallowed((String)NLS.bind((String)Messages.CheckInCmd_38, (Object[])new String[]{desc.getItemsPathInConfiguration(), AliasUtil.alias((IItemHandle)desc.getAttemptedTargetChangeSet()), AliasUtil.alias((IItemHandle)desc.getChangeSetWhichContainsItem())}));
                }
                catch (FileSystemClientException e) {
                    type = this.computeErrorType(e);
                    if (type == ErrorType.OTHER_CAUSE) {
                        throw e;
                    }
                    if (type == ErrorType.UNSUPPORTED_CHARSET) {
                        throw StatusHelper.failure((String)Messages.CheckInCmd_INVALID_ENCODING, null);
                    }
                    if (this.failedUploads.size() <= 0) break block15;
                    err = new IndentingPrintStream((OutputStream)config.getContext().stderr());
                    err.println((CharSequence)Messages.CheckInCmd_17);
                    err = err.indent();
                    ** for (s /* !! */  : this.failedUploads)
                }
lbl-1000:
                // 1 sources

                {
                    err.println((CharSequence)s /* !! */ .getLocalPath().toString());
                    continue;
                }
            }
            if (this.skippedUploads.size() > 0) {
                err = new IndentingPrintStream((OutputStream)config.getContext().stderr());
                err.println((CharSequence)TempHelper.translate((String)"Uploads skipped. Invalid encoding or line delimiter during checkin for:"));
                err = err.indent();
                for (IShareable s : this.skippedUploads) {
                    err.println((CharSequence)s /* !! */ );
                }
            }
            if (type == ErrorType.ENTIRELY_DUE_TO_CHAR_CONVERSION) {
                throw StatusHelper.malformedInput((String)Messages.CheckInCmd_7);
            }
            throw e;
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)Messages.CheckInCmd_8, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
            }
            catch (OperationCanceledException v0) {
                if (!handler.failedDueToOutOfSync()) continue;
                throw StatusHelper.outOfSync((String)Messages.CheckInCmd_9);
            }
        }
        return csHandles;
    }

    private ErrorType computeErrorType(FileSystemClientException e) {
        List exceptions = ExceptionUtil.flattenThrowable((Throwable)e);
        if (exceptions.size() <= 0) {
            return ErrorType.OTHER_CAUSE;
        }
        boolean hasCharConversionError = false;
        boolean hasOtherError = false;
        for (Throwable t : exceptions) {
            if (t instanceof CharacterCodingException || t instanceof ContentLineDelimiterError) {
                hasCharConversionError = true;
                continue;
            }
            if (t instanceof UnsupportedCharsetException) {
                return ErrorType.UNSUPPORTED_CHARSET;
            }
            hasOtherError = true;
        }
        if (hasOtherError) {
            if (hasCharConversionError) {
                return ErrorType.PARTIALLY_DUE_TO_CHAR_CONVERSION;
            }
            return ErrorType.OTHER_CAUSE;
        }
        return ErrorType.ENTIRELY_DUE_TO_CHAR_CONVERSION;
    }

    private Map<ItemId<IComponent>, List<IShareable>> groupByComponent(List<IShareable> shareables) throws FileSystemClientException {
        HashMap<ItemId<IComponent>, List<IShareable>> grouped = new HashMap<ItemId<IComponent>, List<IShareable>>();
        for (IShareable shareable : shareables) {
            IComponentHandle comp = shareable.getShare(null).getSharingDescriptor().getComponent();
            ItemId id = new ItemId(IComponent.ITEM_TYPE, comp.getItemId());
            SubcommandUtil.addToMapOfLists(grouped, (Object)id, (Object)shareable);
        }
        return grouped;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum DelimiterControl {
        FAIL_ON_ERROR,
        SET_NO_DELIM,
        REWRITE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ErrorType {
        ENTIRELY_DUE_TO_CHAR_CONVERSION,
        PARTIALLY_DUE_TO_CHAR_CONVERSION,
        UNSUPPORTED_CHARSET,
        OTHER_CAUSE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FailProblemHandler
    extends CommitDilemmaHandler {
        boolean failedDueToOutOfSync = false;
        volatile boolean failedDueToMixedLineDelim = false;

        private FailProblemHandler() {
        }

        public OutOfSyncDilemmaHandler getOutOfSyncDilemmaHandler() {
            return new OutOfSyncDilemmaHandler(){

                public int outOfSync(Collection<IShareOutOfSync> sharesOutOfSync) {
                    ((FailProblemHandler)FailProblemHandler.this).CheckInCmd.this.config.getContext().stdout().println(Messages.CheckInCmd_15);
                    IndentingPrintStream out = new IndentingPrintStream((OutputStream)((FailProblemHandler)FailProblemHandler.this).CheckInCmd.this.config.getContext().stdout()).indent();
                    for (IShareOutOfSync oos : sharesOutOfSync) {
                        out.println((CharSequence)oos.getShare().getPath().toString());
                    }
                    FailProblemHandler.this.failedDueToOutOfSync = true;
                    return 1;
                }

                public boolean willIgnoreAllSharesOutOfSync() {
                    return false;
                }
            };
        }

        public boolean failedDueToOutOfSync() {
            return this.failedDueToOutOfSync;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int lineDelimiterErrors(Collection<? extends ILineDelimiterUploadFailure> failedFiles, IProgressMonitor monitor) {
            switch (CheckInCmd.this.delimPolicy) {
                case FAIL_ON_ERROR: {
                    this.failedDueToMixedLineDelim = true;
                    List<IShareable> list = CheckInCmd.this.failedUploads;
                    synchronized (list) {
                        for (ILineDelimiterUploadFailure iLineDelimiterUploadFailure : failedFiles) {
                            CheckInCmd.this.failedUploads.add(iLineDelimiterUploadFailure.getShareable());
                        }
                    }
                    return 2;
                }
                case REWRITE: {
                    for (ILineDelimiterUploadFailure iLineDelimiterUploadFailure : failedFiles) {
                        iLineDelimiterUploadFailure.setForceConsistentDelimiters(true);
                    }
                    return 0;
                }
                case SET_NO_DELIM: {
                    for (ILineDelimiterUploadFailure iLineDelimiterUploadFailure : failedFiles) {
                        iLineDelimiterUploadFailure.setForceConsistentDelimiters(false);
                    }
                    return 0;
                }
            }
            throw new IllegalStateException("Unknown policy: " + (Object)((Object)CheckInCmd.this.delimPolicy));
        }

        public BackupDilemmaHandler getBackupDilemmaHandler() {
            return new BackupDilemmaHandler(){

                public boolean backupEnabled() {
                    return true;
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int encodingErrors(Collection<? extends IEncodingUploadFailure> failedFiles, IProgressMonitor monitor) {
            int result = super.encodingErrors(failedFiles, monitor);
            List<IShareable> list = CheckInCmd.this.failedUploads;
            synchronized (list) {
                if (result == 0) {
                    for (IEncodingUploadFailure iEncodingUploadFailure : failedFiles) {
                        if (iEncodingUploadFailure.isSkipFailure()) {
                            CheckInCmd.this.skippedUploads.add(iEncodingUploadFailure.getShareable().getLocalPath().toPortableString());
                            continue;
                        }
                        CheckInCmd.this.rewrittenUploads.add(iEncodingUploadFailure.getShareable().getLocalPath().toPortableString());
                    }
                } else {
                    for (IEncodingUploadFailure iEncodingUploadFailure : failedFiles) {
                        CheckInCmd.this.failedUploads.add(iEncodingUploadFailure.getShareable());
                    }
                }
            }
            return result;
        }
    }
}

