/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.subcommands.AnnotateCmdOptions;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.ICopyFileAreaView;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.StringUtil;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.TempHelper;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.internal.rest.IFilesystemRestService;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.workitem.common.model.IWorkItem;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotateCmd
extends AbstractSubcommand {
    private final int NUMBER_OF_PRINT_COLUMNS = 7;

    public void run(IClientConfiguration config) throws FileSystemClientException {
        ICommandLine subargs = config.getSubcommandCommandLine();
        List pathNames = subargs.getOptions((IOptionKey)AnnotateCmdOptions.OPT_PATH);
        for (String pathName : pathNames) {
            IShare share;
            IPath annotatePath = SubcommandUtil.makeAbsolutePath((IClientConfiguration)config, (String)pathName);
            if (!PathUtils.exists((IPath)annotatePath, (IProgressMonitor)TempHelper.MONITOR)) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.AnnotateCmd_PathDoesNotExist, (Object)annotatePath.toOSString()));
            }
            File pathToRoot = SubcommandUtil.findAncestorCFARoot((String)annotatePath.toString());
            if (pathToRoot == null) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.AnnotateCmd_PathIsNotShared, (Object)annotatePath.toPortableString()));
            }
            ICopyFileAreaView cfaView = SubcommandUtil.getAffectedComponentsAndShares((IClientConfiguration)config);
            IShareable shareable = cfaView.findShareable(annotatePath.toString());
            if (!shareable.exists(null) || (share = shareable.getShare(null)) == null) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.AnnotateCmd_PathIsNotShared, (Object)shareable.getFullPath().toPortableString()));
            }
            IVersionableHandle verHandle = shareable.getRemote(null);
            if (verHandle == null) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.AnnotateCmd_NoRemotePath, (Object)shareable.getFullPath().toPortableString()));
            }
            if (!(verHandle instanceof IFileItemHandle)) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.AnnotateCmd_MUST_BE_FILE, (Object)shareable.getFullPath().toPortableString()));
            }
            ITeamRepository repo = RepoUtil.loginUrlArgAnc((IClientConfiguration)config);
            List<IChangeSetHandle> csHandles = this.getChangeSetHandles(repo, share, verHandle, config);
            try {
                this.PrintAnnotations(repo, shareable, csHandles, config);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap(null, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
            }
        }
    }

    private List<IChangeSetHandle> getChangeSetHandles(ITeamRepository repo, IShare share, IVersionableHandle verHandle, IClientConfiguration config) throws FileSystemClientException {
        String[] result;
        IFilesystemRestService service = (IFilesystemRestService)((IClientLibraryContext)repo).getServiceInterface(IFilesystemRestService.class);
        IFilesystemRestService.ParmsGetBlame parms = new IFilesystemRestService.ParmsGetBlame();
        parms.fileItemId = verHandle.getItemId().getUuidValue();
        parms.workspaceItemId = share.getSharingDescriptor().getConnectionHandle().getItemId().getUuidValue();
        parms.componentItemId = share.getSharingDescriptor().getComponent().getItemId().getUuidValue();
        try {
            result = service.getBlame(parms);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.AnnotateCmd_ServiceError, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
        }
        ArrayList<IChangeSetHandle> csHandles = new ArrayList<IChangeSetHandle>();
        int count = 0;
        while (count < result.length) {
            IChangeSetHandle csHandle = (IChangeSetHandle)IChangeSet.ITEM_TYPE.createItemHandle(UUID.valueOf((String)result[count]), null);
            csHandles.add(csHandle);
            ++count;
        }
        return csHandles;
    }

    private void PrintAnnotations(ITeamRepository repo, IShareable shareable, List<IChangeSetHandle> csHandles, IClientConfiguration config) throws FileSystemClientException, TeamRepositoryException {
        List csList = repo.itemManager().fetchCompleteItems(csHandles, 0, null);
        ArrayList<IContributorHandle> contribHandles = new ArrayList<IContributorHandle>();
        for (IChangeSet cs : csList) {
            contribHandles.add(cs.getAuthor());
        }
        List contributors = repo.itemManager().fetchCompleteItems(contribHandles, 0, null);
        Map wi2cs = RepoUtil.getWorkItemsForChangeSets((ITeamRepository)repo, Collections.singletonList(IWorkItem.ID_PROPERTY), csHandles, (IClientConfiguration)config);
        IFileItemHandle fileHandle = (IFileItemHandle)shareable.getRemote(null);
        InputStream stream = RepoUtil.findContentFor((ITeamRepository)repo, (IPath)shareable.getFullPath(), (IFileItemHandle)fileHandle, (IClientConfiguration)config);
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        String line = null;
        int count = 0;
        ArrayList<String> strings = new ArrayList<String>(csHandles.size() * 7);
        try {
            try {
                while ((line = reader.readLine()) != null) {
                    assert (count <= csHandles.size());
                    IChangeSet cs = (IChangeSet)csList.get(count);
                    String wiString = this.getWorkItemIds(wi2cs, cs.getItemId());
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                    String alias = AliasUtil.alias((UUID)cs.getItemId());
                    if (alias == null) {
                        alias = "";
                    }
                    strings.add(Integer.toString(count + 1));
                    strings.add(((IContributor)contributors.get(count)).getName());
                    strings.add(alias);
                    strings.add(df.format(cs.getLastChangeDate()));
                    strings.add(wiString);
                    strings.add(cs.getComment().substring(0, cs.getComment().length() > 20 ? 20 : cs.getComment().length()));
                    strings.add(line);
                    ++count;
                }
            }
            catch (IOException e) {
                throw StatusHelper.failure((String)Messages.AnnotateCmd_IOReadError, (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        IndentingPrintStream ps = new IndentingPrintStream((OutputStream)config.getContext().stdout());
        StringUtil.printTable((IndentingPrintStream)ps, (int)7, (boolean)true, (CharSequence[])strings.toArray(new String[strings.size()]));
    }

    private String getWorkItemIds(Map<UUID, List<IWorkItem>> wi2cs, UUID csHandleItemId) {
        StringBuffer wiString = new StringBuffer();
        List<IWorkItem> wi = wi2cs.get(csHandleItemId);
        if (wi != null) {
            int[] wiIds = new int[wi.size()];
            int index = 0;
            while (index < wi.size()) {
                wiIds[index] = wi.get(index).getId();
                ++index;
            }
            Arrays.sort(wiIds);
            index = 0;
            while (index < wiIds.length) {
                if (wiString.length() > 0) {
                    wiString.append(",");
                }
                wiString.append(wiIds[index]);
                ++index;
            }
        }
        return wiString.toString();
    }
}

