/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.subcommands.AcceptCmdOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.StructuredBaselineUpdateReportDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.StructuredComponentConflictItemDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.StructuredComponentUpdateReportDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.StructuredWorkspaceUpdateReportDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.WorkspaceUpdateResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ConfigurationDescriptorDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ChangeFolderSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ChangeSetSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ChangeSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.WorkItemSyncDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IWorkspace;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceptResultDisplayer {
    public static void showResult(ITeamRepository repo, boolean flowedComponents, WorkspaceUpdateResultDTO result, boolean verbose, IClientConfiguration config) throws FileSystemClientException {
        HashMap<String, ArrayList<StructuredWorkspaceUpdateReportDTO>> repos = new HashMap<String, ArrayList<StructuredWorkspaceUpdateReportDTO>>();
        for (StructuredWorkspaceUpdateReportDTO report : result.getStructuredResult()) {
            ArrayList<StructuredWorkspaceUpdateReportDTO> reports = (ArrayList<StructuredWorkspaceUpdateReportDTO>)repos.get(report.getRepositoryUrl());
            if (reports == null) {
                reports = new ArrayList<StructuredWorkspaceUpdateReportDTO>(result.getStructuredResult().size());
                repos.put(report.getRepositoryUrl(), reports);
            }
            reports.add(report);
        }
        IndentingPrintStream out = new IndentingPrintStream((OutputStream)config.getContext().stdout());
        for (List reports : repos.values()) {
            boolean showRepo = true;
            for (StructuredWorkspaceUpdateReportDTO report : reports) {
                if (showRepo) {
                    String repoName = report.getRepositoryName();
                    if (repoName == null) {
                        repoName = report.getRepositoryUrl();
                    }
                    out.println((CharSequence)NLS.bind((String)Messages.AcceptResultDisplayer_REPOSITORY_DESCRIPTION, (Object)repoName));
                    showRepo = false;
                }
                AcceptResultDisplayer.showWorkspaceUpdateReport(report, out.indent(), verbose);
            }
        }
        HashMap<String, Map<String, Map<String, WarningType>>> warnings = AcceptResultDisplayer.populateWarnings(result);
        if (!flowedComponents && warnings.size() > 0) {
            AcceptResultDisplayer.showRemainingComponentOperations(repo, warnings, out, config);
        }
        if (result.getBackedUpToShed().size() > 0) {
            SubcommandUtil.showShedUpdate((String)Messages.AcceptResultDisplayer_SHED_MESSAGE, (IndentingPrintStream)out, (List)result.getBackedUpToShed());
        }
        if (repos.size() == 0) {
            out.println((CharSequence)Messages.AcceptResultDisplayer_WORKSPACE_UNCHANGED);
        }
    }

    private static void showRemainingComponentOperations(ITeamRepository repo, HashMap<String, Map<String, Map<String, WarningType>>> warnings, IndentingPrintStream out, IClientConfiguration config) throws FileSystemClientException {
        out.println((CharSequence)NLS.bind((String)Messages.AcceptResultDisplayer_COMPONENT_CHANGE_TITLE, (Object)AcceptCmdOptions.OPT_FLOW_COMPONENTS.getName()));
        Map<UUID, String> names = AcceptResultDisplayer.fetchNames(repo, warnings, config);
        for (Map.Entry<String, Map<String, Map<String, WarningType>>> repoEntry : warnings.entrySet()) {
            IndentingPrintStream repoOut = out.indent();
            repoOut.println((CharSequence)repoEntry.getKey());
            for (Map.Entry<String, Map<String, WarningType>> wsEntry : repoEntry.getValue().entrySet()) {
                IndentingPrintStream wsOut = repoOut.indent();
                String name = names.get(UUID.valueOf((String)wsEntry.getKey()));
                wsOut.println((CharSequence)AliasUtil.selector((AliasUtil.IAliasOptions)config.getAliasConfig(), (String)name, (UUID)UUID.valueOf((String)wsEntry.getKey())));
                IndentingPrintStream compOut = wsOut.indent();
                for (Map.Entry<String, WarningType> compEntry : wsEntry.getValue().entrySet()) {
                    String msg;
                    name = names.get(UUID.valueOf((String)compEntry.getKey()));
                    switch (compEntry.getValue()) {
                        case ADD: {
                            msg = NLS.bind((String)Messages.AcceptResultDisplayer_COMP_ADD, (Object)AliasUtil.selector((AliasUtil.IAliasOptions)config.getAliasConfig(), (String)name, (UUID)UUID.valueOf((String)compEntry.getKey())));
                            break;
                        }
                        case DELETE: {
                            msg = NLS.bind((String)Messages.AcceptResultDisplayer_COMP_DELETE, (Object)AliasUtil.selector((AliasUtil.IAliasOptions)config.getAliasConfig(), (String)name, (UUID)UUID.valueOf((String)compEntry.getKey())));
                            break;
                        }
                        case REPLACE: {
                            msg = NLS.bind((String)Messages.AcceptResultDisplayer_COMP_REPLACE, (Object)AliasUtil.selector((AliasUtil.IAliasOptions)config.getAliasConfig(), (String)name, (UUID)UUID.valueOf((String)compEntry.getKey())));
                            break;
                        }
                        default: {
                            msg = NLS.bind((String)Messages.AcceptResultDisplayer_ERROR_MSG, (Object)name);
                        }
                    }
                    compOut.println((CharSequence)msg);
                }
            }
        }
    }

    private static Map<UUID, String> fetchNames(ITeamRepository repo, HashMap<String, Map<String, Map<String, WarningType>>> warnings, IClientConfiguration config) throws FileSystemClientException {
        List items;
        LinkedList<IItemHandle> itemHandles = new LinkedList<IItemHandle>();
        for (Map.Entry<String, Map<String, Map<String, WarningType>>> repoEntry : warnings.entrySet()) {
            for (Map.Entry<String, Map<String, WarningType>> wsEntry : repoEntry.getValue().entrySet()) {
                itemHandles.add(IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)wsEntry.getKey()), null));
                for (Map.Entry<String, WarningType> compEntry : wsEntry.getValue().entrySet()) {
                    itemHandles.add(IComponent.ITEM_TYPE.createItemHandle(UUID.valueOf((String)compEntry.getKey()), null));
                }
            }
        }
        try {
            items = repo.itemManager().fetchCompleteItems(itemHandles, 0, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.AcceptResultDisplayer_FETCH_FAILURE, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
        }
        HashMap<UUID, String> names = new HashMap<UUID, String>();
        for (IItem item : items) {
            String name = item instanceof IWorkspace ? ((IWorkspace)item).getName() : (item instanceof IComponent ? ((IComponent)item).getName() : NLS.bind((String)Messages.AcceptResultDisplayer_UNKNOWN_INTERNAL_CLASS, (Object)item.getClass().getSimpleName()));
            names.put(item.getItemId(), name);
        }
        return names;
    }

    private static HashMap<String, Map<String, Map<String, WarningType>>> populateWarnings(WorkspaceUpdateResultDTO result) {
        HashMap<String, Map<String, Map<String, WarningType>>> toReturn = new HashMap<String, Map<String, Map<String, WarningType>>>();
        AcceptResultDisplayer.populateWarning(result.getComponentFlowAdditions(), toReturn, WarningType.ADD);
        AcceptResultDisplayer.populateWarning(result.getComponentFlowDeletions(), toReturn, WarningType.DELETE);
        AcceptResultDisplayer.populateWarning(result.getComponentReplacementCandidates(), toReturn, WarningType.REPLACE);
        return toReturn;
    }

    private static void populateWarning(List<ConfigurationDescriptorDTO> comps, HashMap<String, Map<String, Map<String, WarningType>>> toReturn, WarningType type) {
        for (ConfigurationDescriptorDTO comp : comps) {
            String contextId;
            Map<String, WarningType> containedComps;
            String url = comp.getConnection().getRepositoryURL();
            Map<String, Map<String, WarningType>> ws = toReturn.get(url);
            if (ws == null) {
                ws = new HashMap<String, Map<String, WarningType>>();
                toReturn.put(url, ws);
            }
            if ((containedComps = ws.get(contextId = comp.getConnection().getContextItemId())) == null) {
                containedComps = new HashMap<String, WarningType>();
                ws.put(contextId, containedComps);
            }
            containedComps.put(comp.getComponentItemId(), type);
        }
    }

    private static HashSet<String> extractConflicts(StructuredComponentUpdateReportDTO compDto) {
        HashSet<String> conflicts = new HashSet<String>();
        for (StructuredComponentConflictItemDTO confDto : compDto.getConflictedItems()) {
            conflicts.add(confDto.getConflictedItemId());
        }
        return conflicts;
    }

    private static void showWorkspaceUpdateReport(StructuredWorkspaceUpdateReportDTO dto, IndentingPrintStream out, boolean verbose) {
        out.println((CharSequence)NLS.bind((String)Messages.AcceptResultDisplayer_WORKSPACE_DESCRIPTION, (Object)AliasUtil.selector((String)dto.getWorkspaceName(), (UUID)UUID.valueOf((String)dto.getWorkspaceItemId()))));
        out = out.indent();
        for (StructuredComponentUpdateReportDTO compDto : dto.getComponents()) {
            List baselineDtos;
            out.println((CharSequence)NLS.bind((String)Messages.AcceptResultDisplayer_COMPONENT_DESCRIPTION, (Object)AliasUtil.selector((String)compDto.getComponentName(), (UUID)UUID.valueOf((String)compDto.getComponentItemId()))));
            IndentingPrintStream compOut = out.indent();
            HashSet<String> conflictIds = AcceptResultDisplayer.extractConflicts(compDto);
            List csDtos = compDto.getAcceptedChangeSets();
            if (!csDtos.isEmpty()) {
                compOut.println((CharSequence)Messages.AcceptResultDisplayer_CHANGE_SET_LIST_HEADING);
                IndentingPrintStream csOut = compOut.indent();
                for (ChangeSetSyncDTO csDto : csDtos) {
                    AcceptResultDisplayer.showChangeSet(csDto, csOut, conflictIds, verbose, false);
                }
            }
            if ((baselineDtos = compDto.getAcceptedBaselines()).isEmpty()) continue;
            compOut.println((CharSequence)Messages.AcceptResultDisplayer_LIST_OF_ACCEPTED_BASELINES);
            IndentingPrintStream blOut = compOut.indent();
            for (StructuredBaselineUpdateReportDTO blDto : baselineDtos) {
                AcceptResultDisplayer.showBaseline(blDto, blOut);
            }
        }
    }

    private static void showBaseline(StructuredBaselineUpdateReportDTO blDto, IndentingPrintStream blOut) {
        String alias = AliasUtil.alias((String)blDto.getBaselineItemId());
        String id = Long.toString(blDto.getBaselineId());
        String name = blDto.getBaselineName();
        blOut.println((CharSequence)NLS.bind((String)Messages.AcceptResultDisplayer_BASELINE_DESCRIPTION, (Object[])new String[]{alias, id, name}));
    }

    public static String getChangeSetFlags(boolean hasConflict, boolean hasCollision, boolean isActive) {
        StringBuilder flags = new StringBuilder();
        flags.append(hasCollision ? "!" : "-");
        flags.append(hasConflict ? "#" : "-");
        flags.append(isActive ? "@" : "$");
        return flags.toString();
    }

    private static void showChangeSet(ChangeSetSyncDTO csDto, IndentingPrintStream csOut, Set<String> conflictIds, boolean verbose, boolean hasCollision) {
        String alias = AliasUtil.alias((String)csDto.getChangeSetItemId());
        String author = csDto.getAuthorContributorName();
        String csComment = "";
        csComment = csDto.getChangeSetComment();
        csComment = csComment == null || csComment.length() < 1 ? Messages.AcceptResultDisplayer_DEFAULT_COMMENT_TEXT : (verbose ? NLS.bind((String)Messages.AcceptResultDisplayer_COMMENT_WRAPPER, (Object)csComment) : NLS.bind((String)Messages.AcceptResultDisplayer_COMMENT_WRAPPER, (Object)SubcommandUtil.sanitizeText((String)csComment, (int)60, (boolean)true)));
        LinkedList<String> changePrintList = new LinkedList<String>();
        boolean hasConflicted = false;
        for (ChangeFolderSyncDTO folder : csDto.getChanges()) {
            for (ChangeSyncDTO change : folder.getChanges()) {
                String newPath;
                String currentPath = AcceptResultDisplayer.standardizeDisplayPath(change.getPathHint(), "folder".equals(change.getVersionableItemType()));
                if (change.isMoveType() && (newPath = change.getNewPathHint()) != null) {
                    currentPath = NLS.bind((String)Messages.AcceptResultDisplayer_FILE_OR_FOLDER_MOVED, (Object)currentPath, (Object)AcceptResultDisplayer.standardizeDisplayPath(newPath, "folder".equals(change.getVersionableItemType())));
                }
                changePrintList.add(NLS.bind((String)Messages.AcceptResultDisplayer_CHANGE_PATH, (Object)AcceptResultDisplayer.getFlagsFor(change, conflictIds), (Object)currentPath));
                boolean bl = hasConflicted = hasConflicted || conflictIds.contains(change.getVersionableItemId());
            }
        }
        String flags = AcceptResultDisplayer.getChangeSetFlags(hasConflicted, hasCollision, csDto.isIsActive());
        csOut.println((CharSequence)NLS.bind((String)Messages.AcceptResultDisplayer_CHANGESET_DESCRIPTION, (Object[])new String[]{alias, author, flags, csComment}));
        IndentingPrintStream changeOut = csOut.indent();
        changeOut.println((CharSequence)Messages.ResumeCmd_CHANGES);
        changeOut = changeOut.indent();
        for (String changePrint : changePrintList) {
            changeOut.println((CharSequence)changePrint);
        }
        List workItems = csDto.getWorkItems();
        if (workItems.size() > 0) {
            IndentingPrintStream workItemOut = csOut.indent();
            workItemOut.println(Messages.AcceptResultDisplayer_WORKITEM);
            workItemOut = workItemOut.indent();
            for (WorkItemSyncDTO workItem : workItems) {
                String workItemLabel = null;
                workItemLabel = verbose ? workItem.getLabel() : SubcommandUtil.sanitizeText((String)workItem.getLabel(), (int)60, (boolean)true);
                if (workItem.isSetId()) {
                    workItemOut.println((CharSequence)AliasUtil.selector((int)workItem.getId(), (String)workItemLabel, (UUID)UUID.valueOf((String)workItem.getWorkItemItemId())));
                    continue;
                }
                workItemOut.println((CharSequence)AliasUtil.selector((String)workItemLabel, (UUID)UUID.valueOf((String)workItem.getWorkItemItemId())));
            }
        }
    }

    private static String standardizeDisplayPath(String path, boolean isFolder) {
        Path newpath = new Path(path);
        if (!newpath.isAbsolute()) {
            newpath = new Path(File.separator).append((IPath)newpath);
        }
        if (isFolder && !newpath.hasTrailingSeparator()) {
            newpath = newpath.addTrailingSeparator();
        }
        path = newpath.toOSString();
        return path;
    }

    private static String getFlagsFor(ChangeSyncDTO changeDto, Set<String> conflictIds) {
        char[] cType = new char[]{'-', '-', '-'};
        if (conflictIds.contains(changeDto.getVersionableItemId())) {
            cType[0] = 33;
        }
        if (!changeDto.isNoopType()) {
            if (changeDto.isAddType()) {
                cType[1] = 97;
            } else if (changeDto.isDeleteType()) {
                cType[1] = 100;
            } else {
                if (changeDto.isMoveType()) {
                    cType[1] = 109;
                }
                if (changeDto.isModifyType()) {
                    cType[2] = 99;
                }
            }
        }
        return new String(cType);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum WarningType {
        ADD,
        DELETE,
        REPLACE;

    }
}

