/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.flowcommands.conflicthandlers.InPlaceConflictHandler;
import com.ibm.team.filesystem.cli.client.internal.subcommands.AcceptCmdOptions;
import com.ibm.team.filesystem.cli.client.internal.subcommands.AcceptResultDisplayer;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IUuidAliasRegistry;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.ICopyFileAreaView;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsAcceptChangeSets;
import com.ibm.team.filesystem.client.rest.parameters.ParmsActivate;
import com.ibm.team.filesystem.client.rest.parameters.ParmsAutoMerge;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCommitDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsConflictedItemToResolve;
import com.ibm.team.filesystem.client.rest.parameters.ParmsLineDelimiterDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsOutOfSyncInstructions;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPendingChangesDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsStructuredResultOptions;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceAcceptDetailed;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceUpdate;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceUpdateDilemmaHandler;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.StructuredComponentConflictItemDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.StructuredComponentUpdateReportDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.StructuredWorkspaceUpdateReportDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.WorkspaceUpdateResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.conflict.ResolveAutoMergeResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.BaselineSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ComponentSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.SyncViewDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.WorkspaceSyncDTO;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentFlowUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.internal.FlowUtils;
import com.ibm.team.scm.common.ActiveChangeSetsException;
import com.ibm.team.scm.common.GapException;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.NWayConflictUnsupportedException;
import com.ibm.team.scm.common.WorkspaceComparisonFlags;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceptCmd
extends AbstractSubcommand {
    private boolean automergeDisabled = true;
    private ITeamRepository repo;

    public void run(IClientConfiguration config) throws FileSystemClientException {
        WorkspaceUpdateResultDTO result;
        ISandbox[] sandboxes = config.getSandboxes();
        IFilesystemRestClient client = SubcommandUtil.startDaemon((ISandbox[])sandboxes, (IClientConfiguration)config);
        SubcommandUtil.registerSandboxes((IFilesystemRestClient)client, (ISandbox[])sandboxes, (IClientConfiguration)config);
        ICommandLine subcmd = config.getSubcommandCommandLine();
        this.automergeDisabled = subcmd.hasOption((IOptionKey)AcceptCmdOptions.OPT_DISABLE_AUTOMERGE);
        if (this.automergeDisabled && subcmd.hasOption((IOptionKey)AcceptCmdOptions.OPT_INPLACE_CONFLICT_HANDLER)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.AcceptCmd2_INVALID_INPLACE_CONFLICT_MARKER_REQUEST, (Object)AcceptCmdOptions.OPT_INPLACE_CONFLICT_HANDLER.getName(), (Object)AcceptCmdOptions.OPT_DISABLE_AUTOMERGE.getName()));
        }
        ParmsWorkspaceUpdate parms = new ParmsWorkspaceUpdate();
        this.generateAcceptParms(config, client, subcmd, sandboxes, parms);
        if (config.isDryRun()) {
            return;
        }
        try {
            result = client.postWorkspaceUpdate(parms, null);
        }
        catch (TeamRepositoryException e) {
            if (this.isActiveChangeSetsException(e)) {
                throw StatusHelper.disallowed((String)Messages.AcceptCmd2_CANNOT_ACCEPT_ACTIVE_CS);
            }
            PermissionDeniedException pde = (PermissionDeniedException)SubcommandUtil.findExceptionByType(PermissionDeniedException.class, (TeamRepositoryException)e);
            if (pde != null) {
                throw StatusHelper.permissionFailure((TeamRepositoryException)pde, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
            }
            GapException gap = (GapException)((Object)SubcommandUtil.findExceptionByType(GapException.class, (TeamRepositoryException)e));
            if (gap != null) {
                throw StatusHelper.gap((String)Messages.AcceptCmd2_CANNOT_CREATE_GAP_IN_REMOTE_WORKSPACE);
            }
            NWayConflictUnsupportedException nway = (NWayConflictUnsupportedException)SubcommandUtil.findExceptionByType(NWayConflictUnsupportedException.class, (TeamRepositoryException)e);
            if (nway != null) {
                throw StatusHelper.nWayConflict((String)Messages.AcceptCmd2_ACCEPT_WOULD_CAUSE_NWAY_CONFLICT);
            }
            throw StatusHelper.wrap((String)Messages.AcceptCmd2_COULD_NOT_UPDATE, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
        }
        if (result.isCancelled()) {
            List outOfSyncShareList = result.getOutOfSyncShares();
            if (outOfSyncShareList.size() > 0) {
                IndentingPrintStream err = new IndentingPrintStream((OutputStream)config.getContext().stderr());
                err.println((CharSequence)Messages.CheckInCmd_15);
                for (ShareDTO share : outOfSyncShareList) {
                    err.println((CharSequence)AliasUtil.selector((String)share.getComponentName(), (UUID)UUID.valueOf((String)share.getComponentItemId())));
                }
                throw StatusHelper.outOfSync((String)Messages.CheckInCmd_9);
            }
            if (result.getConfigurationsWithUnCheckedInChanges().size() > 0) {
                throw StatusHelper.uncheckedInChanges((String)NLS.bind((String)Messages.AcceptCmd2_UNCHECKEDIN_ITEMS_PRESENT, (Object)CommonOptions.OPT_OVERWRITE_UNCOMMITTED.getName()));
            }
        }
        List<String> unresolvedWorkspaces = this.autoresolve(client, result, config);
        boolean verbose = subcmd.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE);
        AcceptResultDisplayer.showResult(this.repo, this.isFlowingComponents(config), result, verbose, config);
        if (unresolvedWorkspaces.size() > 0) {
            if (subcmd.hasOption((IOptionKey)AcceptCmdOptions.OPT_INPLACE_CONFLICT_HANDLER)) {
                this.markInPlaceConflicts(config, result, verbose);
            }
            IndentingPrintStream out = new IndentingPrintStream((OutputStream)config.getContext().stdout());
            out.println((CharSequence)Messages.AcceptCmd_CONFLICT_MESSAGE);
            out = out.indent();
            for (String workspace : unresolvedWorkspaces) {
                out.println((CharSequence)workspace);
            }
            config.getContext().stdout().println(NLS.bind((String)Messages.AcceptCmd_CONFLICT_GUIDANCE, (Object)config.getContext().getAppName()));
            throw StatusHelper.conflict(null);
        }
    }

    private void markInPlaceConflicts(IClientConfiguration config, WorkspaceUpdateResultDTO updateResult, boolean verbose) throws FileSystemClientException {
        File cfaRootPath = SubcommandUtil.findAncestorCFARoot((String)config.getContext().getCurrentWorkingDirectory());
        Path cfaRoot = new Path(cfaRootPath.getAbsolutePath());
        List workspaces = updateResult.getStructuredResult();
        for (StructuredWorkspaceUpdateReportDTO ws : workspaces) {
            List componentHandles;
            if (!ws.isHasConflicts()) continue;
            IWorkspaceConnection wsConn = RepoUtil.findWorkspaceConnection((IClientConfiguration)config, (String)ws.getRepositoryUrl(), (String)ws.getWorkspaceItemId());
            try {
                componentHandles = wsConn.getComponents();
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)NLS.bind((String)Messages.AcceptCmd2_CANNOT_LIST_COMPONENTS, (Object)wsConn.getName()), (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
            }
            InPlaceConflictHandler handler = new InPlaceConflictHandler();
            handler.configureVerbose(verbose);
            handler.handleConflicts((IPath)cfaRoot, wsConn, componentHandles, config);
        }
    }

    private List<String> autoresolve(IFilesystemRestClient client, WorkspaceUpdateResultDTO updateResult, IClientConfiguration config) {
        ArrayList<String> unresolvedWorkspaces = new ArrayList<String>();
        if (this.automergeDisabled) {
            return this.hasConflicts(updateResult);
        }
        List workspaces = updateResult.getStructuredResult();
        for (StructuredWorkspaceUpdateReportDTO ws : workspaces) {
            if (!ws.isHasConflicts()) continue;
            LinkedList<ParmsConflictedItemToResolve> conflictedParms = new LinkedList<ParmsConflictedItemToResolve>();
            for (StructuredComponentUpdateReportDTO comp : ws.getComponents()) {
                List conflicts = comp.getConflictedItems();
                for (StructuredComponentConflictItemDTO conflict : conflicts) {
                    conflictedParms.add(new ParmsConflictedItemToResolve(comp.getComponentItemId(), conflict.getConflictedItemId()));
                }
            }
            if (conflictedParms.size() <= 0) continue;
            ParmsAutoMerge pam = new ParmsAutoMerge();
            pam.workspace = new ParmsWorkspace();
            pam.workspace.repositoryUrl = ws.getRepositoryUrl();
            pam.workspace.workspaceItemId = ws.getWorkspaceItemId();
            pam.itemsToResolve = conflictedParms.toArray(new ParmsConflictedItemToResolve[conflictedParms.size()]);
            pam.missingRequiredChangesDilemmaHandler = "continue";
            pam.pendingChangesDilemmaHandler = new ParmsPendingChangesDilemmaHandler();
            pam.pendingChangesDilemmaHandler.pendingChangesInstruction = "continue";
            pam.pendingChangesDilemmaHandler.commitDilemmaHandler = new ParmsCommitDilemmaHandler();
            pam.pendingChangesDilemmaHandler.commitDilemmaHandler.lineDelimiterDilemmaHandler = new ParmsLineDelimiterDilemmaHandler();
            pam.pendingChangesDilemmaHandler.commitDilemmaHandler.lineDelimiterDilemmaHandler.generalLineDelimiterErrorInstruction = "continue";
            ResolveAutoMergeResultDTO mergeResult = null;
            try {
                mergeResult = client.postAutoResolve(pam, null);
            }
            catch (TeamRepositoryException e) {
                config.getContext().stderr().println(NLS.bind((String)Messages.AcceptCmd_CONFLICT_RESOLUTION_FAILED, (Object)ws.getWorkspaceName()));
                LoggingHelper.log((IStatus)FileSystemStatus.getStatusFor((Throwable)e));
            }
            if (mergeResult != null && mergeResult.getNumberConflictsResolved() == pam.itemsToResolve.length) continue;
            unresolvedWorkspaces.add(ws.getWorkspaceName());
        }
        return unresolvedWorkspaces;
    }

    private List<String> hasConflicts(WorkspaceUpdateResultDTO result) {
        ArrayList<String> unresolvedWorkspaces = new ArrayList<String>();
        for (StructuredWorkspaceUpdateReportDTO wsReport : result.getStructuredResult()) {
            if (!wsReport.isHasConflicts()) continue;
            unresolvedWorkspaces.add(wsReport.getWorkspaceName());
        }
        return unresolvedWorkspaces;
    }

    private boolean isActiveChangeSetsException(TeamRepositoryException e) {
        int tries = 0;
        for (Throwable cause = e; cause != null; cause = cause.getCause()) {
            if (!(cause instanceof ActiveChangeSetsException)) continue;
            return true;
        }
        return false;
    }

    private boolean isFlowingComponents(IClientConfiguration config) {
        return config.getSubcommandCommandLine().hasOption((IOptionKey)AcceptCmdOptions.OPT_FLOW_COMPONENTS);
    }

    private void generateAcceptParms(IClientConfiguration config, IFilesystemRestClient client, ICommandLine subcmd, ISandbox[] sandboxes, ParmsWorkspaceUpdate parms) throws FileSystemClientException {
        parms.preoperationRefresh = SubcommandUtil.getPreopRefreshPolicy((IClientConfiguration)config);
        Mode mode = Mode.UNSET;
        int modeCount = 0;
        if (subcmd.hasOption((IOptionKey)AcceptCmdOptions.OPT_MODE_BASELINES)) {
            mode = Mode.BASELINE;
            ++modeCount;
        }
        if (subcmd.hasOption((IOptionKey)AcceptCmdOptions.OPT_MODE_COMPONENTS)) {
            mode = Mode.COMPONENT;
            ++modeCount;
        }
        if (subcmd.hasOption((IOptionKey)AcceptCmdOptions.OPT_MODE_CHANGESETS)) {
            mode = Mode.CS;
            ++modeCount;
        }
        if (modeCount > 1) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.AcceptCmd2_USE_SINGLE_MODE_ARGUMENT, (Object[])new String[]{AcceptCmdOptions.OPT_MODE_BASELINES.getName(), AcceptCmdOptions.OPT_MODE_COMPONENTS.getName(), AcceptCmdOptions.OPT_MODE_CHANGESETS.getName()}));
        }
        parms.outOfSyncInstructions = new ParmsOutOfSyncInstructions();
        parms.outOfSyncInstructions.outOfSyncNoPendingChanges = "cancel";
        parms.outOfSyncInstructions.outOfSyncWithPendingChanges = "cancel";
        parms.pendingChangesDilemmaHandler = new ParmsPendingChangesDilemmaHandler();
        parms.pendingChangesDilemmaHandler.pendingChangesInstruction = subcmd.hasOption((IOptionKey)CommonOptions.OPT_OVERWRITE_UNCOMMITTED) ? "no" : "cancel";
        ArrayList<ParmsWorkspace> targetWs = new ArrayList<ParmsWorkspace>(1);
        this.repo = RepoUtil.loginUrlArgAnc((IClientConfiguration)config);
        SubcommandUtil.loginToClient((IClientConfiguration)config, (ITeamRepository)this.repo, (IFilesystemRestClient)client);
        String targetSelector = subcmd.getOption(CommonOptions.OPT_STREAM_TARGET_SELECTOR, null);
        if (targetSelector == null) {
            ICopyFileAreaView cfaView = SubcommandUtil.getAffectedComponentsAndShares((IClientConfiguration)config);
            for (ICopyFileAreaView.IRepoView repoView : cfaView.getLoadedWorkspaces()) {
                ParmsWorkspace parm = new ParmsWorkspace();
                parm.repositoryUrl = repoView.getURI();
                parm.workspaceItemId = repoView.getHandle().getItemId().getUuidValue();
                targetWs.add(parm);
            }
        } else {
            IWorkspace wsHandle;
            try {
                wsHandle = RepoUtil.findNamedWorkspace((String)targetSelector, (boolean)true, (boolean)false, (ITeamRepository)this.repo, (IClientConfiguration)config);
            }
            catch (RepoUtil.UnmatchedSelectorException e) {
                SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)e, (IClientConfiguration)config);
                throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.AcceptCmd2_UNKNOWN_REMOTE_WORKSPACE, (Object)e.getSelector()));
            }
            catch (RepoUtil.AmbiguousSelectorException e) {
                SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)e, (IClientConfiguration)config);
                throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.AcceptCmd2_AMBIGUOUS_REMOTE_WORKSPACE_SELECTOR, (Object)e.getSelector()));
            }
            ParmsWorkspace parm = new ParmsWorkspace();
            parm.repositoryUrl = this.repo.getRepositoryURI();
            parm.workspaceItemId = wsHandle.getItemId().getUuidValue();
            targetWs.add(parm);
        }
        IWorkspaceConnection sourceWsConn = null;
        String sourceSelector = subcmd.getOption(CommonOptions.OPT_STREAM_SOURCE_SELECTOR, null);
        if (sourceSelector != null) {
            try {
                IWorkspace wsHandle = RepoUtil.findNamedWorkspace((String)sourceSelector, (boolean)true, (boolean)true, (ITeamRepository)this.repo, (IClientConfiguration)config);
                sourceWsConn = RepoUtil.findNamedWorkspaceConnection((String)wsHandle.getItemId().getUuidValue(), (boolean)true, (boolean)true, (ITeamRepository)this.repo, (IClientConfiguration)config);
            }
            catch (RepoUtil.UnmatchedSelectorException e) {
                SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)e, (IClientConfiguration)config);
                throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.AcceptCmd2_UNKNOWN_REMOTE_WORKSPACE, (Object)e.getSelector()));
            }
            catch (RepoUtil.AmbiguousSelectorException e) {
                SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)e, (IClientConfiguration)config);
                throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.AcceptCmd2_AMBIGUOUS_REMOTE_WORKSPACE_SELECTOR, (Object)e.getSelector()));
            }
        }
        List selectors = Collections.EMPTY_LIST;
        if (subcmd.hasOption((IOptionKey)AcceptCmdOptions.OPT_SELECTORS)) {
            selectors = subcmd.getOptions((IOptionKey)AcceptCmdOptions.OPT_SELECTORS);
        }
        parms.structuredResultOptions = new ParmsStructuredResultOptions();
        parms.workspaceUpdateDilemmaHandler = new ParmsWorkspaceUpdateDilemmaHandler();
        parms.workspaceUpdateDilemmaHandler.disconnectedComponentsDirection = "continue";
        String compStrategy = "no";
        if (this.isFlowingComponents(config)) {
            compStrategy = "continue";
        }
        parms.workspaceUpdateDilemmaHandler.componentFlowDirection = compStrategy;
        parms.workspaceUpdateDilemmaHandler.componentReplacementCandidatesDirection = compStrategy;
        if (mode == Mode.UNSET && selectors.size() == 0) {
            SyncViewDTO syncView;
            ArrayList<ParmsWorkspaceAcceptDetailed> updates = new ArrayList<ParmsWorkspaceAcceptDetailed>(targetWs.size());
            ParmsActivate activator = new ParmsActivate(targetWs.toArray(new ParmsWorkspace[targetWs.size()]));
            try {
                client.postActivate(activator, null);
                syncView = client.getJoinSyncView(null);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)Messages.AcceptCmd2_SYNC_VIEW_FAILURE, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
            }
            for (ParmsWorkspace target : targetWs) {
                updates.addAll(this.generateDefaultFlowAcceptParms(sourceWsConn, target, syncView, this.repo, config));
            }
            parms.workspaceAcceptDetailed = updates.toArray(new ParmsWorkspaceAcceptDetailed[updates.size()]);
        } else if ((mode == Mode.UNSET || mode == Mode.CS) && selectors.size() > 0) {
            if (targetWs.size() != 1) {
                throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.AcceptCmd2_TOO_MANY_WORKSPACES, (Object)subcmd.getDefinition().getOption(CommonOptions.OPT_STREAM_TARGET_SELECTOR).getName()));
            }
            ParmsAcceptChangeSets update = new ParmsAcceptChangeSets();
            update.workspace = (ParmsWorkspace)targetWs.get(0);
            update.changeSetItemIds = AcceptCmd.normalizeCsUuidAndAlias(sourceWsConn, AcceptCmd.findNamedWorkspaceConnection(((ParmsWorkspace)targetWs.get((int)0)).workspaceItemId, ((ParmsWorkspace)targetWs.get((int)0)).repositoryUrl, true, false, config), selectors, config);
            parms.acceptChangeSets = new ParmsAcceptChangeSets[]{update};
        } else if (mode == Mode.COMPONENT) {
            if (selectors.size() < 1) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.AcceptCmd2_NO_COMPONENTS_SPECIFIED, (Object)AcceptCmdOptions.OPT_MODE_COMPONENTS.getName()));
            }
            if (targetWs.size() != 1) {
                throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.AcceptCmd2_TOO_MANY_WORKSPACES_FOR_COMPONENT, (Object)subcmd.getDefinition().getOption(CommonOptions.OPT_STREAM_TARGET_SELECTOR).getName()));
            }
            parms.workspaceAcceptDetailed = this.generateComponentFlowAcceptParms(config, (ParmsWorkspace)targetWs.get(0), sourceWsConn, selectors, client, this.repo);
        } else if (mode == Mode.BASELINE) {
            if (selectors.size() < 1) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.AcceptCmd2_NO_BASELINES_SPECIFIED, (Object)AcceptCmdOptions.OPT_MODE_BASELINES.getName()));
            }
            if (targetWs.size() != 1) {
                throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.AcceptCmd2_TOO_MANY_WORKSPACES_FOR_BASELINE, (Object)subcmd.getDefinition().getOption(CommonOptions.OPT_STREAM_TARGET_SELECTOR).getName()));
            }
            parms.workspaceAcceptDetailed = this.generateBaselineAcceptParms(config, (ParmsWorkspace)targetWs.get(0), sourceWsConn, selectors, client, this.repo);
        } else {
            throw StatusHelper.internalError((String)Messages.AcceptCmd2_UNEXPECTED_CASE);
        }
    }

    private static String[] normalizeCsUuidAndAlias(IWorkspaceConnection srcWsConn, IWorkspaceConnection wsConn, List<String> csSelectors, IClientConfiguration config) throws FileSystemClientException {
        ArrayList<String> normalized = new ArrayList<String>();
        int i = 0;
        while (i < csSelectors.size()) {
            String selector = csSelectors.get(i);
            UUID uuid = RepoUtil.lookupUuid((String)selector);
            if (uuid == null) {
                List<IChangeSet> changes;
                if (srcWsConn == null) {
                    srcWsConn = AcceptCmd.getCurrentCollaboration(wsConn, config);
                }
                if ((changes = AcceptCmd.findChangeSetByWorkitem(srcWsConn, wsConn, selector, config)).size() == 0) {
                    throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.AcceptCmd2_CANNOT_FIND_CHANGE_SET, (Object)selector));
                }
                for (IChangeSet cs : changes) {
                    normalized.add(cs.getItemId().getUuidValue());
                }
            } else {
                normalized.add(uuid.getUuidValue());
            }
            ++i;
        }
        String[] str = new String[normalized.size()];
        return normalized.toArray(str);
    }

    private List<ParmsWorkspaceAcceptDetailed> generateDefaultFlowAcceptParms(IWorkspaceConnection sourceWsConn, ParmsWorkspace target, SyncViewDTO syncView, ITeamRepository repo, IClientConfiguration config) throws FileSystemClientException {
        List<String> components;
        HashMap<Object, List<String>> componentFlows = new HashMap<Object, List<String>>();
        if (sourceWsConn != null) {
            List<IComponentHandle> sourceWsCompHandles = AcceptCmd.getComponents(sourceWsConn, config);
            IWorkspaceConnection targetWsConn = AcceptCmd.findNamedWorkspaceConnection(target.workspaceItemId, target.repositoryUrl, true, false, config);
            List<IComponentHandle> targetWsCompHandles = AcceptCmd.getComponents(targetWsConn, config);
            String sourceWsId = sourceWsConn.getResolvedWorkspace().getItemId().getUuidValue();
            components = new ArrayList();
            for (IComponentHandle targetCompHandle : targetWsCompHandles) {
                for (IComponentHandle sourceCompHandle : sourceWsCompHandles) {
                    if (!targetCompHandle.getItemId().getUuidValue().equals(sourceCompHandle.getItemId().getUuidValue())) continue;
                    components.add(targetCompHandle.getItemId().getUuidValue());
                }
            }
            if (components.size() > 0) {
                componentFlows.put(sourceWsId, components);
            }
        } else {
            for (WorkspaceSyncDTO wsSync : syncView.getWorkspaces()) {
                if (!wsSync.getWorkspaceItemId().equals(target.workspaceItemId)) continue;
                for (ComponentSyncDTO compSync : wsSync.getComponents()) {
                    components = (List)componentFlows.get(compSync.getTargetWorkspaceItemId());
                    if (components == null) {
                        components = new ArrayList();
                        componentFlows.put(compSync.getTargetWorkspaceItemId(), components);
                    }
                    components.add(compSync.getComponentItemId());
                }
            }
        }
        ArrayList<ParmsWorkspaceAcceptDetailed> parms = new ArrayList<ParmsWorkspaceAcceptDetailed>(componentFlows.size());
        for (Map.Entry entry : componentFlows.entrySet()) {
            ParmsWorkspaceAcceptDetailed detailed = new ParmsWorkspaceAcceptDetailed();
            detailed.workspace = target;
            detailed.sourceWorkspace = new ParmsWorkspace(repo.getRepositoryURI(), (String)entry.getKey());
            detailed.componentItemIds = ((List)entry.getValue()).toArray(new String[((List)entry.getValue()).size()]);
            parms.add(detailed);
        }
        return parms;
    }

    private SyncViewDTO getSyncView(IFilesystemRestClient client, ParmsWorkspace ws, IClientConfiguration config) throws FileSystemClientException {
        try {
            ParmsActivate activator = new ParmsActivate(new ParmsWorkspace[]{ws});
            client.postActivate(activator, null);
            return client.getJoinSyncView(null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.AcceptCmd2_SYNC_VIEW_FAILURE, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
        }
    }

    private ParmsWorkspaceAcceptDetailed[] generateComponentFlowAcceptParms(IClientConfiguration config, ParmsWorkspace targetWs, IWorkspaceConnection sourceWsConn, List<String> selectors, IFilesystemRestClient client, ITeamRepository repo) throws FileSystemClientException {
        ArrayList<ParmsWorkspaceAcceptDetailed> parms = new ArrayList<ParmsWorkspaceAcceptDetailed>(5);
        HashSet<String> selectorSet = new HashSet<String>(selectors);
        HashMap componentFlows = new HashMap();
        String wsName = null;
        if (sourceWsConn != null) {
            Iterator<String> targetWsComponents;
            wsName = sourceWsConn.getName();
            List<IComponentHandle> sourceWsCompHandles = AcceptCmd.getComponents(sourceWsConn, config);
            IWorkspaceConnection targetWsConn = AcceptCmd.findNamedWorkspaceConnection(targetWs.workspaceItemId, targetWs.repositoryUrl, true, false, config);
            try {
                targetWsComponents = targetWsConn.teamRepository().itemManager().fetchPartialItems(targetWsConn.getComponents(), 0, Collections.singleton(IComponent.NAME_PROPERTY), null);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)NLS.bind((String)Messages.AcceptCmd2_CANNOT_LIST_COMPONENTS, (Object)targetWsConn.getName()), (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
            }
            String sourceWsId = sourceWsConn.getResolvedWorkspace().getItemId().getUuidValue();
            HashSet<String> components = new HashSet<String>();
            Iterator iterator = targetWsComponents.iterator();
            block2: while (iterator.hasNext()) {
                IComponent targetComponent = (IComponent)iterator.next();
                for (IComponentHandle sourceCompHandle : sourceWsCompHandles) {
                    if (!targetComponent.getItemId().getUuidValue().equals(sourceCompHandle.getItemId().getUuidValue())) continue;
                    String matchedSelector = AcceptCmd.matchesSelector(config, targetComponent.getItemId().getUuidValue(), targetComponent.getName(), selectorSet);
                    if (matchedSelector == null) continue block2;
                    selectorSet.remove(matchedSelector);
                    components.add(targetComponent.getItemId().getUuidValue());
                    continue block2;
                }
            }
            if (components.size() > 0) {
                componentFlows.put(sourceWsId, components);
            }
        } else {
            SyncViewDTO syncView = this.getSyncView(client, targetWs, config);
            block4: for (WorkspaceSyncDTO wsSync : syncView.getWorkspaces()) {
                if (!wsSync.getWorkspaceItemId().equals(targetWs.workspaceItemId)) continue;
                wsName = wsSync.getWorkspaceName();
                for (ComponentSyncDTO compSync : wsSync.getComponents()) {
                    String matchedSelector = AcceptCmd.matchesSelector(config, compSync.getComponentItemId(), compSync.getComponentName(), selectorSet);
                    if (matchedSelector != null) {
                        selectorSet.remove(matchedSelector);
                        HashSet<String> components = (HashSet<String>)componentFlows.get(compSync.getTargetWorkspaceItemId());
                        if (components == null) {
                            components = new HashSet<String>();
                            componentFlows.put(compSync.getTargetWorkspaceItemId(), components);
                        }
                        components.add(compSync.getComponentItemId());
                    }
                    if (selectorSet.size() == 0) break block4;
                }
            }
        }
        if (selectorSet.size() > 0) {
            IndentingPrintStream err = new IndentingPrintStream((OutputStream)config.getContext().stderr());
            err.println((CharSequence)Messages.AcceptCmd2_MISSING_COMPONENT_SELECTOR_LIST_START);
            err = err.indent();
            for (String componentSelector : selectorSet) {
                err.println((CharSequence)componentSelector);
            }
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.AcceptCmd2_MISSING_COMPONENT_SELECTOR_MESSAGE, (Object)wsName));
        }
        for (Map.Entry entry : componentFlows.entrySet()) {
            ParmsWorkspaceAcceptDetailed detailed = new ParmsWorkspaceAcceptDetailed();
            detailed.workspace = targetWs;
            detailed.sourceWorkspace = new ParmsWorkspace(repo.getRepositoryURI(), (String)entry.getKey());
            detailed.componentItemIds = ((HashSet)entry.getValue()).toArray(new String[((HashSet)entry.getValue()).size()]);
            parms.add(detailed);
        }
        return parms.toArray(new ParmsWorkspaceAcceptDetailed[parms.size()]);
    }

    private ParmsWorkspaceAcceptDetailed[] generateBaselineAcceptParms(IClientConfiguration config, ParmsWorkspace targetWs, IWorkspaceConnection sourceWsConn, List<String> selectors, IFilesystemRestClient client, ITeamRepository repo) throws FileSystemClientException {
        HashSet<String> selectorSet = new HashSet<String>(selectors);
        HashMap<String, Object> ws2Baseline = new HashMap<String, Object>();
        String wsName = null;
        if (sourceWsConn != null) {
            wsName = sourceWsConn.getName();
            List<IComponentHandle> sourceWsCompHandles = AcceptCmd.getComponents(sourceWsConn, config);
            IWorkspaceConnection targetWsConn = AcceptCmd.findNamedWorkspaceConnection(targetWs.workspaceItemId, targetWs.repositoryUrl, true, false, config);
            Iterator<String> targetWsCompHandles = AcceptCmd.getComponents(targetWsConn, config);
            String sourceWsId = sourceWsConn.getResolvedWorkspace().getItemId().getUuidValue();
            HashSet baselines = new HashSet();
            Iterator iterator = targetWsCompHandles.iterator();
            block3: while (iterator.hasNext()) {
                IComponentHandle targetCompHandle = (IComponentHandle)iterator.next();
                for (IComponentHandle sourceCompHandle : sourceWsCompHandles) {
                    if (!targetCompHandle.getItemId().getUuidValue().equals(sourceCompHandle.getItemId().getUuidValue())) continue;
                    for (String selector : selectors) {
                        IBaselineHandle baselineHandle = null;
                        try {
                            baselineHandle = RepoUtil.findNamedBaseline((ITeamRepository)sourceWsConn.teamRepository(), (IComponentHandle)sourceCompHandle, (String)selector, (IClientConfiguration)config);
                        }
                        catch (RepoUtil.AmbiguousSelectorException e) {
                            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.AcceptCmd2_AMBIGUOUS_BASELINE, (Object)e.getSelector()));
                        }
                        catch (RepoUtil.UnmatchedSelectorException unmatchedSelectorException) {}
                        if (baselineHandle == null) continue;
                        selectorSet.remove(selector);
                        baselines.add(baselineHandle.getItemId().getUuidValue());
                    }
                    continue block3;
                }
            }
            if (baselines.size() > 0) {
                ws2Baseline.put(sourceWsId, baselines);
            }
        } else {
            SyncViewDTO syncView = this.getSyncView(client, targetWs, config);
            for (WorkspaceSyncDTO wsSync : syncView.getWorkspaces()) {
                if (!wsSync.getWorkspaceItemId().equals(targetWs.workspaceItemId)) continue;
                wsName = wsSync.getWorkspaceName();
                for (ComponentSyncDTO compSync : wsSync.getComponents()) {
                    for (BaselineSyncDTO blSync : compSync.getIncomingBaselines()) {
                        String matchedSelector = AcceptCmd.matchesSelector(config, blSync, selectors);
                        if (matchedSelector == null) continue;
                        selectorSet.remove(matchedSelector);
                        HashSet<String> baselines = (HashSet<String>)ws2Baseline.get(compSync.getTargetWorkspaceItemId());
                        if (baselines == null) {
                            baselines = new HashSet<String>();
                            ws2Baseline.put(compSync.getTargetWorkspaceItemId(), baselines);
                        }
                        baselines.add(blSync.getBaselineItemId());
                    }
                }
            }
        }
        if (selectorSet.size() > 0) {
            IndentingPrintStream err = new IndentingPrintStream((OutputStream)config.getContext().stderr());
            err.println((CharSequence)Messages.AcceptCmd2_MISSING_BASELINE_SELECTOR_START);
            err = err.indent();
            for (String blSelector : selectorSet) {
                err.println((CharSequence)blSelector);
            }
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.AcceptCmd2_MISSING_BASELINE_SELECTOR_MESSAGE, (Object)wsName));
        }
        ParmsWorkspaceAcceptDetailed[] parms = new ParmsWorkspaceAcceptDetailed[ws2Baseline.size()];
        int i = 0;
        for (Map.Entry entry : ws2Baseline.entrySet()) {
            ParmsWorkspaceAcceptDetailed detailed = new ParmsWorkspaceAcceptDetailed();
            detailed.workspace = targetWs;
            detailed.sourceWorkspace = new ParmsWorkspace(repo.getRepositoryURI(), (String)entry.getKey());
            detailed.baselineItemIds = ((HashSet)entry.getValue()).toArray(new String[((HashSet)entry.getValue()).size()]);
            parms[i++] = detailed;
        }
        return parms;
    }

    private static String matchesSelector(IClientConfiguration config, String componentItemId, String componentName, HashSet<String> selectors) {
        String compAlias = null;
        try {
            IUuidAliasRegistry.IUuidAlias alias = config.getAliasRegistry().findAliasByUuid(componentItemId);
            compAlias = alias.getMonicker();
        }
        catch (IUuidAliasRegistry.NoSuchAliasException noSuchAliasException) {}
        for (String selector : selectors) {
            if (!componentItemId.equals(selector) && !selector.equals(compAlias) && !selector.equals(componentName)) continue;
            return selector;
        }
        return null;
    }

    private static String matchesSelector(IClientConfiguration config, BaselineSyncDTO blSync, List<String> selectors) {
        String baselineNumber = Integer.toString(blSync.getId());
        for (String selector : selectors) {
            IUuidAliasRegistry.IUuidAlias alias;
            try {
                alias = config.getAliasRegistry().findAliasByName(selector);
            }
            catch (IUuidAliasRegistry.NoSuchAliasException noSuchAliasException) {
                alias = null;
            }
            if (!blSync.getBaselineItemId().equals(selector) && !blSync.getBaselineName().equals(selector) && !baselineNumber.equals(selector) && (alias == null || !alias.getUuid().getUuidValue().equals(blSync.getBaselineItemId()))) continue;
            return selector;
        }
        return null;
    }

    private static IWorkspaceConnection findNamedWorkspaceConnection(String workspaceItemId, String repoUri, boolean findWorkspace, boolean findStream, IClientConfiguration config) throws FileSystemClientException {
        ITeamRepository repository = null;
        try {
            repository = TeamPlatform.getTeamRepositoryService().getTeamRepository(repoUri);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.AcceptCmd2_INVALID_URI, (Object)repoUri));
        }
        IWorkspaceConnection wsConn = null;
        try {
            wsConn = RepoUtil.findNamedWorkspaceConnection((String)workspaceItemId, (boolean)findWorkspace, (boolean)findStream, (ITeamRepository)repository, (IClientConfiguration)config);
        }
        catch (RepoUtil.UnmatchedSelectorException e) {
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.AcceptCmd2_UNKNOWN_REMOTE_WORKSPACE, (Object)e.getSelector()));
        }
        catch (RepoUtil.AmbiguousSelectorException e) {
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.AcceptCmd2_AMBIGUOUS_REMOTE_WORKSPACE_SELECTOR, (Object)e.getSelector()));
        }
        return wsConn;
    }

    private static IWorkspaceConnection getCurrentCollaboration(IWorkspaceConnection wsConn, IClientConfiguration config) throws FileSystemClientException {
        IWorkspaceHandle collabHandle = ComponentFlowUtil.getCurrentCollaboration((IWorkspaceConnection)wsConn);
        if (collabHandle == null) {
            collabHandle = FlowUtils.getDefaultFlowTarget((IWorkspaceConnection)wsConn);
        }
        if (collabHandle == null) {
            throw StatusHelper.disallowed((String)Messages.AcceptCmd2_NO_COLLABORATION_FOUND);
        }
        return AcceptCmd.findNamedWorkspaceConnection(collabHandle.getItemId().getUuidValue(), wsConn.teamRepository().getRepositoryURI(), true, true, config);
    }

    /*
     * Unable to fully structure code
     */
    private static List<IChangeSet> findChangeSetByWorkitem(IWorkspaceConnection srcWsConn, IWorkspaceConnection trgWsConn, String selector, IClientConfiguration config) throws FileSystemClientException {
        block6: {
            try {
                report = trgWsConn.compareTo((IFlowNodeConnection)srcWsConn, WorkspaceComparisonFlags.CHANGE_SET_COMPARISON_ONLY, Collections.EMPTY_LIST, null);
                incomingChanges = trgWsConn.teamRepository().itemManager().fetchPartialItems(report.incomingChangeSets(), 0, (Collection)Collections.EMPTY_LIST, null);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)NLS.bind((String)Messages.AcceptCmd2_CANNOT_FIND_CHANGE_SET, (Object)selector), (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
            }
            toReturn = new LinkedList<IChangeSet>();
            try {
                RepoUtil.findNamedChangeSetByWorkItem((IWorkspaceConnection)trgWsConn, (String)selector, (List)incomingChanges, toReturn, (IClientConfiguration)config);
                break block6;
            }
            catch (RepoUtil.UnmatchedSelectorException v0) {
                throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.AcceptCmd2_CANNOT_FIND_CHANGE_SET, (Object)selector));
            }
            catch (RepoUtil.AmbiguousSelectorException e) {
                ** for (matched : e.getMatched())
            }
lbl-1000:
            // 1 sources

            {
                toReturn.add((IChangeSet)matched);
                continue;
            }
        }
        return toReturn;
    }

    private static List<IComponentHandle> getComponents(IWorkspaceConnection wsConn, IClientConfiguration config) throws FileSystemClientException {
        List wsCompHandles;
        try {
            wsCompHandles = wsConn.getComponents();
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)NLS.bind((String)Messages.AcceptCmd2_CANNOT_LIST_COMPONENTS, (Object)wsConn.getName()), (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
        }
        return wsCompHandles;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Mode {
        UNSET,
        WS,
        CS,
        BASELINE,
        COMPONENT;

    }
}

