/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.sharecommand;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.sharecommand.CliShareDilemmaHandler;
import com.ibm.team.filesystem.cli.client.internal.sharecommand.IShareWriter;
import com.ibm.team.filesystem.cli.client.internal.sharecommand.ShareCmdOpts;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.TempHelper;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.filesystem.client.operations.IShareOperation;
import com.ibm.team.filesystem.client.operations.ShareDilemmaHandler;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShareCmd
extends AbstractSubcommand {
    boolean hasWorkspaceRoot = false;
    IPath shareRoot = null;
    List<IPath> toShare = null;

    public void run(IClientConfiguration config) throws FileSystemClientException {
        ICommandLine cli = config.getSubcommandCommandLine();
        ConnectionInfo info = config.getConnectionInfo();
        List projectRoots = cli.getOptions((IOptionKey)ShareCmdOpts.OPT_TO_SHARE);
        this.initializeRoots(config, projectRoots);
        if (config.getContext().getDaemon() == null) {
            SubcommandUtil.initializeEclipseWorkspaceRoot((File)this.shareRoot.toFile());
        }
        IShareWriter writer = this.getWriter(config);
        writer.validated(this.shareRoot, this.toShare, this.hasWorkspaceRoot);
        this.doShare(config, info, cli.getOption((IOptionKey)ShareCmdOpts.OPT_WORKSPACE_SELECTOR), cli.getOption((IOptionKey)ShareCmdOpts.OPT_COMPONENT_SELECTOR), cli.hasOption((IOptionKey)ShareCmdOpts.OPT_IGNORE_EXISTING_SHARE), writer);
    }

    private void initializeRoots(IClientConfiguration config, List<String> projectRoots) throws FileSystemClientException {
        List roots = SubcommandUtil.makeAbsolutePaths((IClientConfiguration)config, projectRoots);
        IPath commonParent = ((IPath)roots.get(0)).removeLastSegments(1);
        for (IPath root : roots) {
            IPath potentialParent = root.removeLastSegments(1);
            if (potentialParent == null) {
                potentialParent = new Path(config.getContext().getCurrentWorkingDirectory());
            }
            if (commonParent == null) {
                commonParent = potentialParent;
            }
            if (!commonParent.equals((Object)potentialParent)) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ShareCmd_1, (Object)commonParent, (Object)root));
            }
            if (PathUtils.getResourceType((IPath)root, (IProgressMonitor)TempHelper.MONITOR) == ResourceType.FOLDER) continue;
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ShareCmd_2, (Object)root));
        }
        File workspaceRoot = SubcommandUtil.findAncestorCFARoot((File)commonParent.toFile());
        if (workspaceRoot != null && !commonParent.toFile().equals(workspaceRoot)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ShareCmd_3, (Object)commonParent, (Object)workspaceRoot));
        }
        this.hasWorkspaceRoot = workspaceRoot != null;
        this.shareRoot = commonParent;
        this.toShare = roots;
    }

    IShareWriter getWriter(IClientConfiguration config) {
        DefaultShareWriter writer = new DefaultShareWriter(config.getContext().stdout());
        ICommandLine cli = config.getSubcommandCommandLine();
        writer.setVerbose(cli.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE));
        return writer;
    }

    private void doShare(final IClientConfiguration config, ConnectionInfo info, String wsSelector, String compSelector, final boolean ignoreExistingShare, final IShareWriter writer) throws FileSystemClientException {
        final ITeamRepository repo = RepoUtil.login((IClientConfiguration)config, (ConnectionInfo)info);
        final IWorkspaceConnection ws = ShareCmd.findWorkspace(wsSelector, repo, config);
        final IComponentHandle comp = ShareCmd.findComponent(compSelector, ws, repo, config);
        final FileSystemClientException[] exception = new FileSystemClientException[1];
        new Runnable(){

            public void run() {
                IShareOperation shareOp = IOperationFactory.instance.getShareOperation((ShareDilemmaHandler)new CliShareDilemmaHandler());
                try {
                    try {
                        shareOp.share(ws, null, comp, ShareCmd.this.toShare, ignoreExistingShare, null);
                        config.getContext().stdout().println(Messages.ShareCmd_16);
                        shareOp.run(null);
                        writer.successfulShare(shareOp, repo);
                        return;
                    }
                    catch (TeamRepositoryException e) {
                        throw StatusHelper.wrap((String)Messages.ShareCmd_10, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
                    }
                }
                catch (FileSystemClientException e) {
                    if (e.getStatus() != null && e.getStatus().getCode() == 204) {
                        e = StatusHelper.disallowed((String)NLS.bind((String)Messages.ShareCmd_11, (Object)ShareCmdOpts.OPT_IGNORE_EXISTING_SHARE.getLongOpt()));
                    }
                    exception[0] = e;
                    return;
                }
            }
        }.run();
        if (exception[0] != null) {
            throw exception[0];
        }
    }

    private static IWorkspaceConnection findWorkspace(String wsSelector, ITeamRepository repo, IClientConfiguration config) throws FileSystemClientException {
        try {
            return RepoUtil.findNamedWorkspaceConnection((String)wsSelector, (boolean)true, (boolean)false, (ITeamRepository)repo, (IClientConfiguration)config);
        }
        catch (RepoUtil.UnmatchedSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)((Object)e), (IClientConfiguration)config);
            throw StatusHelper.ambiguousSelector((String)Messages.ShareCmd_12);
        }
        catch (RepoUtil.AmbiguousSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)((Object)e), (IClientConfiguration)config);
            throw StatusHelper.ambiguousSelector((String)Messages.ShareCmd_13);
        }
    }

    private static IComponentHandle findComponent(String compSelector, IWorkspaceConnection ws, ITeamRepository repo, IClientConfiguration config) throws FileSystemClientException {
        try {
            return (IComponentHandle)RepoUtil.findNamedComponents(Collections.singletonList(compSelector), (boolean)false, (IWorkspaceConnection)ws, (ITeamRepository)repo, (boolean)true, (IClientConfiguration)config).get(0);
        }
        catch (RepoUtil.UnmatchedSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)((Object)e), (IClientConfiguration)config);
            throw StatusHelper.ambiguousSelector((String)Messages.ShareCmd_14);
        }
        catch (RepoUtil.AmbiguousSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)((Object)e), (IClientConfiguration)config);
            throw StatusHelper.ambiguousSelector((String)Messages.ShareCmd_15);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultShareWriter
    implements IShareWriter {
        boolean verbose = false;
        IndentingPrintStream out;

        DefaultShareWriter(PrintStream stdout) {
            this.out = new IndentingPrintStream((OutputStream)stdout);
        }

        @Override
        public void setVerbose(boolean isVerbose) {
            this.verbose = isVerbose;
        }

        @Override
        public void validated(IPath shareRoot, List<IPath> toShare, boolean hasWorkspaceRoot) {
            if (!this.verbose) {
                return;
            }
            if (hasWorkspaceRoot) {
                this.out.println((CharSequence)NLS.bind((String)Messages.ShareCmd_4, (Object)shareRoot));
            } else {
                this.out.println((CharSequence)NLS.bind((String)Messages.ShareCmd_5, (Object)shareRoot));
            }
            IndentingPrintStream indented = this.out.indent();
            for (IPath share : toShare) {
                indented.println((CharSequence)share.toString());
            }
        }

        @Override
        public void successfulShare(IShareOperation shareOp, ITeamRepository repo) {
            this.out.println((CharSequence)Messages.ShareCmd_6);
        }
    }
}

