/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.property;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.INamedOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.cliparser.IPositionalOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.NamedOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.OptionKey;
import com.ibm.team.filesystem.cli.core.cliparser.Options;
import com.ibm.team.filesystem.cli.core.cliparser.PositionalOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.exceptions.ConflictingOptionException;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IOptionSource;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.internal.TempHelper;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsLineDelimiterDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsLineDelimiterErrorInstructions;
import com.ibm.team.filesystem.client.rest.parameters.ParmsOutOfSyncInstructions;
import com.ibm.team.filesystem.client.rest.parameters.ParmsResourcePropertyChange;
import com.ibm.team.filesystem.client.rest.parameters.ParmsResourcePropertyUpdates;
import com.ibm.team.filesystem.common.internal.rest.client.core.PathDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.LineDelimiterErrorDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.ResourcePropertyChangeResultDTO;
import com.ibm.team.filesystem.rcp.core.internal.resources.ResourceUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.CoreUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertySetCmd
extends AbstractSubcommand
implements IOptionSource {
    public static final OptionKey OPT_FILES = new OptionKey("files");
    public static final OptionKey OPT_KEY = new OptionKey("key");
    public static final OptionKey OPT_VALUE = new OptionKey("value");
    public static final NamedOptionDefinition OPT_FORCE = new NamedOptionDefinition("f", "force", 0);

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption((IPositionalOptionDefinition)new PositionalOptionDefinition((IOptionKey)OPT_KEY, "key", 1, 1), Messages.PropertySetCmd_KeyHelp);
        options.addOption((IPositionalOptionDefinition)new PositionalOptionDefinition((IOptionKey)OPT_VALUE, "value", 1, 1), Messages.PropertySetCmd_ValueHelp);
        options.addOption((IPositionalOptionDefinition)new PositionalOptionDefinition((IOptionKey)OPT_FILES, "files", 1, -1), Messages.PropertyListCmd_ListPropertiesHelp);
        options.addOption((INamedOptionDefinition)OPT_FORCE, Messages.PropertySetCmd_OPT_FORCE_HELP);
        return options;
    }

    public void run(IClientConfiguration config) throws FileSystemClientException {
        ICommandLine cli = config.getSubcommandCommandLine();
        List strPaths = cli.getOptions((IOptionKey)OPT_FILES);
        List paths = SubcommandUtil.makeAbsolutePaths((IClientConfiguration)config, (List)strPaths);
        String key = cli.getOption((IOptionKey)OPT_KEY);
        String value = cli.getOption((IOptionKey)OPT_VALUE);
        boolean force = cli.hasOption((IOptionKey)OPT_FORCE);
        try {
            this.setProperty(config, key, value, paths, force);
        }
        catch (TeamRepositoryException e) {
            StatusHelper.wrap((String)Messages.PropertySetCmd_CouldNotSetProperties, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setProperty(IClientConfiguration config, String key, String value, List<IPath> paths, boolean force) throws TeamRepositoryException, FileSystemClientException {
        String path;
        String normalizedValue = value;
        if (key.equals("jazz.executable")) {
            throw StatusHelper.inappropriateArgument((String)Messages.PropertySetCmd_SetExecutable);
        }
        if (key.equals("jazz.line-delimiter")) {
            if (value.equalsIgnoreCase("platform")) {
                normalizedValue = "platform";
            } else if (value.equalsIgnoreCase("cr")) {
                normalizedValue = "cr";
            } else if (value.equalsIgnoreCase("lf")) {
                normalizedValue = "lf";
            } else if (value.equalsIgnoreCase("crlf")) {
                normalizedValue = "crlf";
            } else {
                if (!value.equalsIgnoreCase("none")) throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.PropertySetCmd_InvalidLineDelimiter, (Object)value));
                normalizedValue = "none";
            }
        } else if (key.equals("jazz.mime")) {
            boolean isValidMimeType = ResourceUtil.validMimeType((String)value);
            if (!isValidMimeType) {
                throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.PropertySetCmd_InvalidMIME, (Object)value));
            }
        } else {
            if (!key.equals("jazz.encoding")) throw StatusHelper.inappropriateArgument((String)Messages.PropertySetCmd_SetUserDefined);
            throw StatusHelper.inappropriateArgument((String)Messages.PropertySetCmd_SetEncoding);
        }
        IFilesystemRestClient client = SubcommandUtil.startDaemon((ISandbox[])config.getSandboxes(), (IClientConfiguration)config);
        ITeamRepository repo = RepoUtil.loginUrlArgAnc((IClientConfiguration)config);
        SubcommandUtil.loginToClient((IClientConfiguration)config, (ITeamRepository)repo, (IFilesystemRestClient)client);
        ParmsResourcePropertyUpdates parms = new ParmsResourcePropertyUpdates();
        parms.lineDelimiterDilemmaHandler = new ParmsLineDelimiterDilemmaHandler();
        parms.lineDelimiterDilemmaHandler.generalLineDelimiterErrorInstruction = "cancel";
        if (force) {
            parms.lineDelimiterDilemmaHandler.generalLineDelimiterErrorInstruction = "continue";
            parms.lineDelimiterDilemmaHandler.lineDelimiterErrorInstructions = new ParmsLineDelimiterErrorInstructions[paths.size()];
        }
        parms.outOfSyncInstructions = new ParmsOutOfSyncInstructions();
        parms.outOfSyncInstructions.outOfSyncNoPendingChanges = "cancel";
        parms.outOfSyncInstructions.outOfSyncWithPendingChanges = "cancel";
        parms.resourcePropertyChanges = new ParmsResourcePropertyChange[paths.size()];
        int i = 0;
        while (i < paths.size()) {
            IPath path2 = paths.get(i);
            if (!PathUtils.exists((IPath)path2, (IProgressMonitor)TempHelper.MONITOR)) {
                throw StatusHelper.disallowed((String)NLS.bind((String)Messages.PropertyListCmd_PathDoesNotExist, (Object)path2.toOSString()));
            }
            ParmsResourcePropertyChange change = new ParmsResourcePropertyChange();
            File cfaRootFile = SubcommandUtil.findAncestorCFARoot((File)path2.toFile());
            if (cfaRootFile == null) {
                throw StatusHelper.disallowed((String)NLS.bind((String)Messages.PropertySetCmd_CouldNotFindSandboxForPath, (Object)path2.toOSString()));
            }
            Path cfaRoot = new Path(cfaRootFile.getAbsolutePath());
            String cfaPath = cfaRoot.toPortableString();
            String filePath = path2.toPortableString().substring(cfaPath.length());
            change.sandboxPath = cfaPath;
            change.filePath = filePath;
            if (key.equals("jazz.line-delimiter")) {
                change.lineDelimiter = normalizedValue;
            } else if (key.equals("jazz.mime")) {
                change.mimeType = normalizedValue;
            }
            parms.resourcePropertyChanges[i] = change;
            if (force) {
                ParmsLineDelimiterErrorInstructions parmsLineDelimiterErrorInstructions = new ParmsLineDelimiterErrorInstructions();
                parmsLineDelimiterErrorInstructions.sandboxPath = cfaPath;
                parmsLineDelimiterErrorInstructions.filePath = filePath;
                parmsLineDelimiterErrorInstructions.forceConsistentDelimiters = true;
                parms.lineDelimiterDilemmaHandler.lineDelimiterErrorInstructions[i] = parmsLineDelimiterErrorInstructions;
            }
            ++i;
        }
        ResourcePropertyChangeResultDTO result = client.postResourceProperties(parms, null);
        ArrayList<LineDelimiterErrorDTO> lineDelimiterFailures = new ArrayList<LineDelimiterErrorDTO>();
        for (LineDelimiterErrorDTO ldError : result.getLineDelimiterFailures()) {
            boolean error = true;
            if (force && ldError.getLineDelimiter().equals(normalizedValue)) {
                error = false;
            }
            if (!error) continue;
            path = CoreUtil.translatePathToString((PathDTO)ldError.getFileName());
            config.getContext().stderr().println(NLS.bind((String)Messages.PropertySetCmd_PathContainsInconsistentDelimiters, (Object[])new String[]{path, key, value}));
            lineDelimiterFailures.add(ldError);
        }
        List outOfSyncShares = result.getOutOfSyncShares();
        for (ShareDTO shareOutOfSync : outOfSyncShares) {
            path = CoreUtil.translatePathToString((PathDTO)shareOutOfSync.getPath());
            config.getContext().stderr().println(NLS.bind((String)Messages.PropertySetCmd_PathIsOutOfSync, (Object[])new String[]{path, key, value}));
        }
        if (lineDelimiterFailures.size() > 0) {
            throw StatusHelper.malformedInput((String)NLS.bind((String)Messages.PropertySetCmd_NResourcesHaveInconsistentDelimiters, (Object)Integer.toString(lineDelimiterFailures.size())));
        }
        if (outOfSyncShares.size() > 0) {
            throw StatusHelper.outOfSync((String)NLS.bind((String)Messages.PropertySetCmd_NSharesAreOutOfSync, (Object)Integer.toString(outOfSyncShares.size())));
        }
        config.getContext().stdout().println(NLS.bind((String)Messages.PropertySetCmd_KeySuccessfullySetToValue, (Object)key, (Object)value));
    }
}

