/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.property;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.cliparser.IPositionalOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.OptionKey;
import com.ibm.team.filesystem.cli.core.cliparser.Options;
import com.ibm.team.filesystem.cli.core.cliparser.PositionalOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.exceptions.ConflictingOptionException;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IOptionSource;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.StringUtil;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IContentProperties;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.TempHelper;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsResourceProperties;
import com.ibm.team.filesystem.common.internal.rest.client.resource.FilePropertiesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.ResourcePropertiesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.ResourcesDTO;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyListCmd
extends AbstractSubcommand
implements IOptionSource {
    private static final int PROPERTY_UNAVAILABLE = 1;
    private static final int FILE_IS_NOT_SHARED = 2;
    private static final int FILE_DOES_NOT_EXIST = 3;
    public static final String PROPERTY_EXECUTABLE = "jazz.executable";
    public static final String PROPERTY_MIME = "jazz.mime";
    public static final String PROPERTY_LINE_DELIMITER = "jazz.line-delimiter";
    public static final String PROPERTY_ENCODING = "jazz.encoding";
    public static final OptionKey OPT_FILES = new OptionKey("files");

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption((IPositionalOptionDefinition)new PositionalOptionDefinition((IOptionKey)OPT_FILES, "files", 1, -1), Messages.PropertyListCmd_ListPropertiesHelp);
        return options;
    }

    public void run(IClientConfiguration config) throws FileSystemClientException {
        ICommandLine cli = config.getSubcommandCommandLine();
        List strPaths = cli.getOptions((IOptionKey)OPT_FILES);
        List paths = SubcommandUtil.makeAbsolutePaths((IClientConfiguration)config, (List)strPaths);
        MapEntryComparator mapEntryComparator = new MapEntryComparator();
        ArrayList<Map.Entry<String, Map<String, String>>> properties = new ArrayList<Map.Entry<String, Map<String, String>>>();
        ArrayList<IStatus> stats = new ArrayList<IStatus>();
        String key = this.getKey(cli);
        try {
            Map<String, Map<String, String>> map = this.getProperties(config, key, paths, stats);
            properties.addAll(map.entrySet());
            Collections.sort(properties, mapEntryComparator);
        }
        catch (TeamRepositoryException e) {
            StatusHelper.wrap((String)Messages.PropertyListCmd_CouldNotFetchProperty, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
        }
        IndentingPrintStream out = new IndentingPrintStream((OutputStream)config.getContext().stdout());
        int i = 0;
        while (i < properties.size()) {
            Map.Entry fileProperties = (Map.Entry)properties.get(i);
            out.println((CharSequence)fileProperties.getKey());
            ArrayList map = new ArrayList(((Map)fileProperties.getValue()).entrySet());
            Collections.sort(map, mapEntryComparator);
            int maxWidth = 0;
            int j = 0;
            while (j < map.size()) {
                maxWidth = Math.max(maxWidth, ((String)((Map.Entry)map.get(j)).getKey()).length());
                ++j;
            }
            IndentingPrintStream indent = out.indent();
            for (Map.Entry entry : map) {
                indent.println((CharSequence)NLS.bind((String)Messages.PropertyListCmd_KeyValue, (Object)StringUtil.pad((CharSequence)((CharSequence)entry.getKey()), (int)maxWidth), entry.getValue()));
            }
            ++i;
        }
        if (stats.size() > 0) {
            Collections.sort(stats, new StatusComparator());
            for (IStatus status : stats) {
                config.getContext().stderr().println(status.getMessage());
            }
            IStatus mostSevere = (IStatus)stats.get(stats.size() - 1);
            switch (mostSevere.getCode()) {
                case 1: {
                    throw StatusHelper.propertiesUnavailable((String)NLS.bind((String)Messages.PropertyListCmd_CouldNotGetProperty, (Object)key));
                }
                case 2: {
                    throw StatusHelper.inappropriateArgument((String)Messages.PropertyListCmd_FileIsNotShared);
                }
                case 3: {
                    throw StatusHelper.disallowed((String)Messages.PropertyListCmd_FileDoesNotExist);
                }
            }
        }
    }

    public String getKey(ICommandLine cli) {
        return null;
    }

    public Map<String, Map<String, String>> getProperties(IClientConfiguration config, String key, List<IPath> paths, List<IStatus> stats) throws TeamRepositoryException, FileSystemClientException {
        Map<String, ResourcePropertiesDTO> resourceProperties = this.getResourceProperties(config, paths, stats);
        HashMap<String, Map<String, String>> properties = new HashMap<String, Map<String, String>>(resourceProperties.size());
        for (String string : resourceProperties.keySet()) {
            HashMap map = new HashMap();
            properties.put(string, map);
        }
        for (Map.Entry entry : resourceProperties.entrySet()) {
            IContentProperties contentProperties;
            String path = (String)entry.getKey();
            ResourcePropertiesDTO resourcePropertiesDTO = (ResourcePropertiesDTO)entry.getValue();
            Map map = (Map)properties.get(path);
            if (key == null) {
                contentProperties = this.getContentProperties(path);
                this.put(map, PROPERTY_ENCODING, PropertyListCmd.getEncoding(contentProperties), false, path, stats);
                this.put(map, PROPERTY_EXECUTABLE, PropertyListCmd.getExecutable(resourcePropertiesDTO), false, path, stats);
                this.put(map, PROPERTY_LINE_DELIMITER, PropertyListCmd.getLineDelimiter(resourcePropertiesDTO), false, path, stats);
                this.put(map, PROPERTY_MIME, PropertyListCmd.getMime(resourcePropertiesDTO), false, path, stats);
                continue;
            }
            if (PROPERTY_ENCODING.equals(key)) {
                contentProperties = this.getContentProperties(path);
                this.put(map, key, PropertyListCmd.getEncoding(contentProperties), true, path, stats);
                continue;
            }
            if (PROPERTY_EXECUTABLE.equals(key)) {
                this.put(map, PROPERTY_EXECUTABLE, PropertyListCmd.getExecutable(resourcePropertiesDTO), true, path, stats);
                continue;
            }
            if (PROPERTY_LINE_DELIMITER.equals(key)) {
                this.put(map, key, PropertyListCmd.getLineDelimiter(resourcePropertiesDTO), true, path, stats);
                continue;
            }
            if (PROPERTY_MIME.equals(key)) {
                this.put(map, key, PropertyListCmd.getMime(resourcePropertiesDTO), true, path, stats);
                continue;
            }
            this.put(map, key, null, true, path, stats);
        }
        return properties;
    }

    private IContentProperties getContentProperties(String path) throws FileSystemClientException {
        Path cfaRoot = new Path(SubcommandUtil.findAncestorCFARoot((String)path).getAbsolutePath());
        ISandbox sandbox = FileSystemCore.getSharingManager().getSandbox((IPath)cfaRoot, false);
        IShareable shareable = sandbox.findShareable((IPath)new Path(path.substring(cfaRoot.toOSString().length())), ResourceType.FILE);
        ResourceType resourceType = shareable.getResourceType((IProgressMonitor)TempHelper.MONITOR);
        if (resourceType != ResourceType.FILE) {
            return null;
        }
        return SharingManager.getInstance().getContentExaminer().findStoredProperties(shareable, null);
    }

    private void put(Map<String, String> map, String key, String value, boolean logWarning, String path, List<IStatus> stats) {
        if (value == null) {
            if (logWarning) {
                stats.add((IStatus)new FileSystemStatus(2, 1, NLS.bind((String)Messages.PropertyListCmd_CouldNotGetPropertyForPath, (Object)key, (Object)path)));
            }
        } else {
            map.put(key, value);
        }
    }

    private static String getMime(ResourcePropertiesDTO resourceProperties) {
        FilePropertiesDTO fileProperties = resourceProperties.getFileProperties();
        if (fileProperties != null) {
            return fileProperties.getContentType();
        }
        return null;
    }

    private static String getLineDelimiter(ResourcePropertiesDTO resourceProperties) {
        FilePropertiesDTO fileProperties = resourceProperties.getFileProperties();
        if (fileProperties != null) {
            return fileProperties.getLineDelimiter();
        }
        return null;
    }

    private static String getExecutable(ResourcePropertiesDTO resourceProperties) {
        FilePropertiesDTO fileProperties = resourceProperties.getFileProperties();
        if (fileProperties != null) {
            return Boolean.toString(fileProperties.isExecutable());
        }
        return null;
    }

    private static String getEncoding(IContentProperties contentProperties) {
        if (contentProperties == null) {
            return null;
        }
        return contentProperties.getEncoding();
    }

    private Map<String, ResourcePropertiesDTO> getResourceProperties(IClientConfiguration config, List<IPath> paths, List<IStatus> stats) throws TeamRepositoryException, FileSystemClientException {
        ArrayList<String> validPaths = new ArrayList<String>();
        int i = 0;
        while (i < paths.size()) {
            IPath path = paths.get(i);
            String osString = path.toOSString();
            if (PathUtils.exists((IPath)path, (IProgressMonitor)TempHelper.MONITOR)) {
                validPaths.add(osString);
            } else {
                stats.add((IStatus)new FileSystemStatus(4, 3, NLS.bind((String)Messages.PropertyListCmd_PathDoesNotExist, (Object)osString)));
            }
            ++i;
        }
        IFilesystemRestClient client = SubcommandUtil.startDaemon((ISandbox[])config.getSandboxes(), (IClientConfiguration)config);
        ParmsResourceProperties parms = new ParmsResourceProperties(false, validPaths.toArray(new String[validPaths.size()]));
        ResourcesDTO resourcesDTO = client.getResourceProperties(parms, null);
        HashMap<String, ResourcePropertiesDTO> resourceProperties = new HashMap<String, ResourcePropertiesDTO>(validPaths.size());
        for (ResourcePropertiesDTO dto : resourcesDTO.getResourceProperties()) {
            if (dto.getShare() == null) {
                stats.add((IStatus)new FileSystemStatus(4, 2, NLS.bind((String)Messages.PropertyListCmd_PathIsNotShared, (Object)dto.getFullPath())));
                continue;
            }
            String fullPath = dto.getFullPath();
            resourceProperties.put(fullPath, dto);
        }
        return resourceProperties;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MapEntryComparator
    implements Comparator<Map.Entry<String, ?>> {
        private MapEntryComparator() {
        }

        @Override
        public int compare(Map.Entry<String, ?> o1, Map.Entry<String, ?> o2) {
            return o1.getKey().compareToIgnoreCase(o2.getKey());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class StatusComparator
    implements Comparator<IStatus> {
        private StatusComparator() {
        }

        @Override
        public int compare(IStatus o1, IStatus o2) {
            int compare = o1.getSeverity() - o2.getSeverity();
            if (compare == 0) {
                compare = o1.getCode() - o2.getCode();
            }
            if (compare == 0) {
                compare = o1.getMessage().compareTo(o2.getMessage());
            }
            return compare;
        }
    }
}

