/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.lock;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.lock.LockAcquireCmd;
import com.ibm.team.filesystem.cli.client.internal.lock.LockListCmd;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.INamedOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.cliparser.NamedOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.Options;
import com.ibm.team.filesystem.cli.core.cliparser.exceptions.ConflictingOptionException;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IOptionSource;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsLockDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsUnlock;
import com.ibm.team.filesystem.client.rest.parameters.ParmsUnlockResources;
import com.ibm.team.filesystem.client.rest.parameters.ParmsVersionable;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.internal.rest.client.locks.LockEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.locks.UnlockResourcesResultDTO;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.CoreUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockReleaseCmd
extends LockAcquireCmd
implements IOptionSource {
    private static final NamedOptionDefinition OPT_FORCE = new NamedOptionDefinition("f", "force", 0);

    @Override
    public Options getOptions() throws ConflictingOptionException {
        Options options = super.getOptions();
        options.addOption((INamedOptionDefinition)OPT_FORCE, Messages.LockReleaseCmd_OPT_FORCE_HELP);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_VERBOSE, CommonOptions.OPT_VERBOSE_HELP);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_WIDE, CommonOptions.OPT_WIDE_HELP);
        return options;
    }

    public LockReleaseCmd() {
        super(Messages.LockReleaseCmd_OPT_FILES_TO_UNLOCK_HELP, Messages.LockReleaseCmd_UNLOCKING_FOLDER_PATH_IS_UNSUPPORTED, Messages.LockReleaseCmd_UNLOCKING_FOLDERS_IS_UNSUPPORTED);
    }

    @Override
    protected void lock(ICommandLine cli, ITeamRepository repo, IFilesystemRestClient client, List<IWorkspace> targetStreams, List<SiloedItemId<IVersionable>> siloedItems, IClientConfiguration config) throws FileSystemClientException {
        ArrayList<ParmsUnlock> locks = new ArrayList<ParmsUnlock>();
        for (IWorkspace targetStream : targetStreams) {
            for (SiloedItemId<IVersionable> siloedItem : siloedItems) {
                ParmsUnlock lock = new ParmsUnlock();
                lock.workspace = new ParmsWorkspace();
                lock.workspace.repositoryUrl = repo.getRepositoryURI();
                lock.workspace.workspaceItemId = targetStream.getItemId().getUuidValue();
                lock.componentItemId = siloedItem.getComponentUUID().getUuidValue();
                lock.versionable = new ParmsVersionable();
                IItemType itemType = siloedItem.getItemType();
                lock.versionable.versionableItemType = CoreUtil.getVersionableItemType((IItemType)itemType);
                lock.versionable.itemId = siloedItem.getItemUUID().getUuidValue();
                locks.add(lock);
            }
        }
        ParmsUnlockResources parms = new ParmsUnlockResources();
        parms.locks = locks.toArray(new ParmsUnlock[locks.size()]);
        (parms.lockDilemmaHandler = new ParmsLockDilemmaHandler()).currentUserDoesntOwnLock = cli.hasOption((IOptionKey)OPT_FORCE) ? "continue" : "no";
        try {
            UUID componentUuid;
            Cloneable componentHandles;
            ITeamRepository repository;
            Object uri;
            UnlockResourcesResultDTO result = client.postUnlockResources(parms, null);
            HashMap<UUID, IWorkspaceConnection> workspaceConnections = new HashMap<UUID, IWorkspaceConnection>();
            HashMap<UUID, IComponent> components = new HashMap<UUID, IComponent>();
            HashMap<Object, ITeamRepository> repos = new HashMap<Object, ITeamRepository>();
            HashMap repoToWorkspaceUuids = new HashMap();
            HashMap<Object, Cloneable> repoToComponentUuids = new HashMap<Object, Cloneable>();
            List currentUserDoesntOwnLocks = result.getCurrentUserDoesntOwnLocks();
            for (LockEntryDTO lockEntryDTO : currentUserDoesntOwnLocks) {
                UUID workspaceUuid;
                HashMap<UUID, IWorkspaceHandle> workspaceHandles;
                uri = lockEntryDTO.getRepositoryItemId();
                if (!repos.containsKey(uri)) {
                    repository = TeamPlatform.getTeamRepositoryService().getTeamRepository((String)uri, 0);
                    repos.put(uri, repository);
                }
                if ((workspaceHandles = (HashMap<UUID, IWorkspaceHandle>)repoToWorkspaceUuids.get(uri)) == null) {
                    workspaceHandles = new HashMap<UUID, IWorkspaceHandle>();
                    repoToWorkspaceUuids.put(uri, workspaceHandles);
                }
                if (!workspaceHandles.containsKey(workspaceUuid = UUID.valueOf((String)lockEntryDTO.getWorkspaceItemId()))) {
                    IWorkspaceHandle workspaceHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(workspaceUuid, null);
                    workspaceHandles.put(workspaceUuid, workspaceHandle);
                }
                if ((componentHandles = (HashMap)repoToComponentUuids.get(uri)) == null) {
                    componentHandles = new HashMap();
                    repoToComponentUuids.put(uri, componentHandles);
                }
                if (componentHandles.containsKey(componentUuid = UUID.valueOf((String)lockEntryDTO.getComponentItemId()))) continue;
                IComponentHandle componentHandle = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(componentUuid, null);
                componentHandles.put(componentUuid, componentHandle);
            }
            for (Map.Entry entry : repos.entrySet()) {
                uri = (String)entry.getKey();
                repository = (ITeamRepository)entry.getValue();
                ArrayList<IWorkspaceHandle> workspaceHandles = new ArrayList<IWorkspaceHandle>(((Map)repoToWorkspaceUuids.get(uri)).values());
                componentHandles = new ArrayList(((Map)repoToComponentUuids.get(uri)).values());
                LockListCmd.fetchCompleteItems(repository, workspaceConnections, components, new HashMap<UUID, IContributor>(), workspaceHandles, (Collection<IComponentHandle>)((Object)componentHandles), Collections.EMPTY_LIST, config);
            }
            HashMap<IWorkspaceConnection, Map<IComponent, List<IItemHandle>[]>> hashMap = new HashMap<IWorkspaceConnection, Map<IComponent, List<IItemHandle>[]>>();
            for (LockEntryDTO entry : currentUserDoesntOwnLocks) {
                IComponent component;
                List[] versionableAndContributorList;
                UUID workspaceUuid = UUID.valueOf((String)entry.getWorkspaceItemId());
                IWorkspaceConnection workspaceConnection = (IWorkspaceConnection)workspaceConnections.get(workspaceUuid);
                HashMap<IComponent, List[]> componentToVersionables = (HashMap<IComponent, List[]>)hashMap.get(workspaceConnection);
                if (componentToVersionables == null) {
                    componentToVersionables = new HashMap<IComponent, List[]>();
                    hashMap.put(workspaceConnection, componentToVersionables);
                }
                if ((versionableAndContributorList = (List[])componentToVersionables.get(component = (IComponent)components.get(componentUuid = UUID.valueOf((String)entry.getComponentItemId())))) == null) {
                    versionableAndContributorList = new List[]{new ArrayList()};
                    componentToVersionables.put(component, versionableAndContributorList);
                }
                UUID versionableUuid = UUID.valueOf((String)entry.getVersionableItemId());
                IVersionableHandle versionableHandle = (IVersionableHandle)IFileItem.ITEM_TYPE.createItemHandle(versionableUuid, null);
                versionableAndContributorList[0].add(versionableHandle);
            }
            boolean verbose = cli.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE);
            boolean wide = cli.hasOption((IOptionKey)CommonOptions.OPT_WIDE);
            int width = SubcommandUtil.getTerminalWidth();
            LockListCmd.printLockEntries(config.getContext().stderr(), hashMap, verbose, wide, width);
            if (currentUserDoesntOwnLocks.size() > 0) {
                throw StatusHelper.inappropriateArgument((String)Messages.LockReleaseCmd_SOME_FILES_COULD_NOT_BE_UNLOCKED);
            }
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.inappropriateArgument((String)e.getLocalizedMessage());
        }
        config.getContext().stdout().println(Messages.LockReleaseCmd_LOCKS_SUCCESSFULLY_RELEASED);
    }
}

