/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.lock;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.lock.LockEntry;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.INamedOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.cliparser.NamedOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.Options;
import com.ibm.team.filesystem.cli.core.cliparser.exceptions.ConflictingOptionException;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IOptionSource;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.ChoppingIndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.ICopyFileAreaView;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.StringUtil;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentFlowUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.ComponentNotInWorkspaceException;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.dto.IComponentLockReport;
import com.ibm.team.scm.common.dto.ILockSearchCriteria;
import com.ibm.team.scm.common.dto.INameItemPair;
import com.ibm.team.scm.common.dto.IStreamLockReport;
import com.ibm.team.scm.common.dto.IVersionableLock;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockListCmd
extends AbstractSubcommand
implements IOptionSource {
    private static final String LOCAL = "L";
    private static final String REMOTE = "R";
    private static final String UNKNOWN = "U";
    private static final NamedOptionDefinition OPT_OWNER = new NamedOptionDefinition("o", "owner", 1);
    private static final NamedOptionDefinition OPT_COMPONENT = new NamedOptionDefinition("c", "component", 1);

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_STREAM_SELECTOR, CommonOptions.OPT_STREAM_SELECTOR_HELP);
        options.addOption((INamedOptionDefinition)OPT_COMPONENT, CommonOptions.OPT_COMPONENT_SELECTOR_HELP);
        options.addOption((INamedOptionDefinition)OPT_OWNER, Messages.LockListCmd_OptOwnerUserIdHelp);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_MAXRESULTS, CommonOptions.OPT_MAXRESULTS_HELP);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_VERBOSE, CommonOptions.OPT_VERBOSE_HELP);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_WIDE, CommonOptions.OPT_WIDE_HELP);
        return options;
    }

    public void run(IClientConfiguration config) throws FileSystemClientException {
        ICommandLine cli = config.getSubcommandCommandLine();
        ITeamRepository repo = RepoUtil.loginUrlArgAnc((IClientConfiguration)config);
        IFilesystemRestClient client = SubcommandUtil.startDaemon((ISandbox[])config.getSandboxes(), (IClientConfiguration)config);
        SubcommandUtil.registerSandboxes((IFilesystemRestClient)client, (ISandbox[])config.getSandboxes(), (IClientConfiguration)config);
        ArrayList<IWorkspace> streams = new ArrayList<IWorkspace>();
        ArrayList<Object> componentsCriteria = new ArrayList<Object>();
        IContributor ownerHandle = null;
        boolean hasOptionStream = cli.hasOption((IOptionKey)CommonOptions.OPT_STREAM_SELECTOR);
        boolean hasOptionComponent = cli.hasOption((IOptionKey)OPT_COMPONENT);
        boolean hasOptionOwner = cli.hasOption((IOptionKey)OPT_OWNER);
        boolean verbose = cli.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE);
        boolean wide = cli.hasOption((IOptionKey)CommonOptions.OPT_WIDE);
        int width = SubcommandUtil.getTerminalWidth();
        if (hasOptionStream || hasOptionComponent || hasOptionOwner) {
            if (hasOptionStream) {
                try {
                    String wsSelector = cli.getOption((IOptionKey)CommonOptions.OPT_STREAM_SELECTOR);
                    IWorkspaceConnection workspaceConnection = RepoUtil.findNamedWorkspaceConnection((String)wsSelector, (boolean)false, (boolean)true, (ITeamRepository)repo, (IClientConfiguration)config);
                    streams.add(workspaceConnection.getResolvedWorkspace());
                }
                catch (RepoUtil.UnmatchedSelectorException e) {
                    SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)((Object)e), (IClientConfiguration)config);
                    throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.CreateWorkspaceCmd_2, (Object)e.getSelector()));
                }
                catch (RepoUtil.AmbiguousSelectorException e) {
                    SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)((Object)e), (IClientConfiguration)config);
                    throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.CreateWorkspaceCmd_1, (Object)e.getSelector()));
                }
            }
            if (hasOptionComponent) {
                try {
                    String componentSelector = cli.getOption((IOptionKey)OPT_COMPONENT);
                    Map map = RepoUtil.findNamedComponents(Collections.singletonList(componentSelector), (ITeamRepository)repo, (IClientConfiguration)config);
                    componentsCriteria.addAll(map.values());
                }
                catch (RepoUtil.UnmatchedSelectorException e) {
                    SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)((Object)e), (IClientConfiguration)config);
                    throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.ListRemoteFilesCmd_9, (Object)e.getSelector()));
                }
                catch (RepoUtil.AmbiguousSelectorException e) {
                    SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)((Object)e), (IClientConfiguration)config);
                    throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.AddComponentCommand_AmbiguousComponentSelector, (Object)e.getSelector()));
                }
            }
            if (hasOptionOwner) {
                String ownerId = cli.getOption((IOptionKey)OPT_OWNER);
                try {
                    ownerHandle = repo.contributorManager().fetchContributorByUserId(ownerId, null);
                }
                catch (ItemNotFoundException itemNotFoundException) {
                    RepoUtil.UnmatchedSelectorException e = new RepoUtil.UnmatchedSelectorException(RepoUtil.SelectorException.Type.CONTRIBUTOR, ownerId, Collections.EMPTY_LIST);
                    SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)((Object)e), (IClientConfiguration)config);
                    throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.ListRemoteFilesCmd_9, (Object)e.getSelector()));
                }
                catch (TeamRepositoryException e) {
                    throw StatusHelper.wrap(null, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
                }
            }
        } else {
            ICopyFileAreaView cfaView = SubcommandUtil.getAffectedComponentsAndShares((IClientConfiguration)config);
            Collection loadedWorkspaces = cfaView.getLoadedWorkspaces();
            for (ICopyFileAreaView.IRepoView repoView : loadedWorkspaces) {
                Collection loadedComponents = cfaView.getLoadedComponents(repoView);
                for (ItemId componentId : loadedComponents) {
                    componentsCriteria.add((IComponentHandle)componentId.toHandle());
                }
            }
            List workspaceConnections = RepoUtil.getWorkspaceConnections((ICopyFileAreaView)cfaView, (boolean)true);
            ArrayList<Object> collaborationHandles = new ArrayList<Object>();
            for (IWorkspaceConnection workspaceConnection : workspaceConnections) {
                IWorkspaceHandle collaboration = ComponentFlowUtil.getCurrentCollaboration((IWorkspaceConnection)workspaceConnection);
                if (collaboration == null) continue;
                collaborationHandles.add(collaboration);
            }
            try {
                List collaborations = repo.itemManager().fetchCompleteItems(collaborationHandles, 0, null);
                for (IWorkspace workspace : collaborations) {
                    if (!workspace.isStream()) continue;
                    streams.add(workspace);
                }
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap(null, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
            }
        }
        ILockSearchCriteria criteria = ILockSearchCriteria.FACTORY.newInstance();
        criteria.getStreams().addAll(streams);
        criteria.getComponents().addAll(componentsCriteria);
        if (ownerHandle != null) {
            criteria.setContributor((IContributorHandle)ownerHandle);
        }
        int maxResult = RepoUtil.getMaxResultsOption((ICommandLine)cli);
        Collection streamLockReports = null;
        try {
            streamLockReports = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).findLocks(criteria, maxResult, null).getReports();
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap(null, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
        }
        HashMap<UUID, IWorkspaceConnection> workspaceConnections = new HashMap<UUID, IWorkspaceConnection>();
        HashMap<UUID, IComponent> components = new HashMap<UUID, IComponent>();
        HashMap<UUID, IContributor> contributorsMap = new HashMap<UUID, IContributor>();
        LockListCmd.fetchCompleteItems(repo, streamLockReports, workspaceConnections, components, contributorsMap, config);
        HashMap<IWorkspaceConnection, Map<IComponent, List<IItemHandle>[]>> workspaceToComponents = new HashMap<IWorkspaceConnection, Map<IComponent, List<IItemHandle>[]>>();
        for (IStreamLockReport streamLockReport : streamLockReports) {
            IWorkspaceHandle streamHandle = streamLockReport.getStream();
            IWorkspaceConnection workspaceConnection = (IWorkspaceConnection)workspaceConnections.get(streamHandle.getItemId());
            HashMap<IComponent, List[]> componentToVersionables = (HashMap<IComponent, List[]>)workspaceToComponents.get(workspaceConnection);
            if (componentToVersionables == null) {
                componentToVersionables = new HashMap<IComponent, List[]>();
                workspaceToComponents.put(workspaceConnection, componentToVersionables);
            }
            for (IComponentLockReport componentLockReport : streamLockReport.getComponentLocks()) {
                IComponentHandle componentHandle = componentLockReport.getComponent();
                IComponent component = (IComponent)components.get(componentHandle.getItemId());
                List[] versionableAndContributorList = (List[])componentToVersionables.get(component);
                if (versionableAndContributorList == null) {
                    versionableAndContributorList = new List[]{new ArrayList(), new ArrayList()};
                    componentToVersionables.put(component, versionableAndContributorList);
                }
                for (IVersionableLock versionableLock : componentLockReport.getLocks()) {
                    IVersionableHandle versionableHandle = versionableLock.getVersionable();
                    IContributorHandle contributorHandle = versionableLock.getContributor();
                    IContributor contributor = (IContributor)contributorsMap.get(contributorHandle.getItemId());
                    versionableAndContributorList[0].add(versionableHandle);
                    versionableAndContributorList[1].add(contributor);
                }
            }
        }
        LockListCmd.printLockEntries(config.getContext().stdout(), workspaceToComponents, verbose, wide, width);
    }

    public static void printLockEntries(OutputStream out, Map<IWorkspaceConnection, Map<IComponent, List<IItemHandle>[]>> workspaceToComponents, boolean verbose, boolean wide, int width) throws FileSystemClientException {
        List<LockEntry> lockEntries = LockListCmd.getLockEntries(workspaceToComponents, verbose);
        Collections.sort(lockEntries);
        LockListCmd.printLockEntries(out, lockEntries, wide, width);
    }

    public static void printLockEntries(OutputStream out, List<LockEntry> lockEntries, boolean wide, int width) {
        ArrayList<String> strings = new ArrayList<String>(lockEntries.size() * 5);
        for (LockEntry entry : lockEntries) {
            strings.add(entry.getNameSource());
            if (entry.getVersionable() != null) {
                strings.add(AliasUtil.selector((String)entry.getVersionableName(), (UUID)entry.getVersionable().getItemId()));
            }
            if (entry.getOwner() == null) {
                strings.add(Messages.LockListCmd_Unknown);
            } else {
                strings.add(entry.getOwner().getUserId());
            }
            strings.add(AliasUtil.selector((String)entry.getComponent().getName(), (UUID)entry.getComponent().getItemId()));
            strings.add(AliasUtil.selector((String)entry.getStream().getName(), (UUID)entry.getStream().getItemId()));
        }
        IndentingPrintStream ps = wide ? new IndentingPrintStream(out) : new ChoppingIndentingPrintStream(out, width);
        StringUtil.printTable((IndentingPrintStream)ps, (int)5, (boolean)true, (CharSequence[])strings.toArray(new String[strings.size()]));
    }

    public static List<LockEntry> getLockEntries(Map<IWorkspaceConnection, Map<IComponent, List<IItemHandle>[]>> workspaceToComponents, boolean verbose) throws FileSystemClientException {
        ArrayList<LockEntry> lockEntries = new ArrayList<LockEntry>();
        for (Map.Entry<IWorkspaceConnection, Map<IComponent, List<IItemHandle>[]>> workspaceEntry : workspaceToComponents.entrySet()) {
            IWorkspaceConnection workspaceConnection = workspaceEntry.getKey();
            Map<IComponent, List<IItemHandle>[]> componentToVersionables = workspaceEntry.getValue();
            IWorkspace stream = workspaceConnection.getResolvedWorkspace();
            for (Map.Entry<IComponent, List<IItemHandle>[]> componentEntry : componentToVersionables.entrySet()) {
                IComponent component = componentEntry.getKey();
                List<IItemHandle>[] versionableAndContributorList = componentEntry.getValue();
                List<IItemHandle> versionableHandles = versionableAndContributorList[0];
                List<IItemHandle> contributors = versionableAndContributorList.length > 1 ? versionableAndContributorList[1] : Collections.EMPTY_LIST;
                ArrayList<IVersionableHandle> toFetch = new ArrayList<IVersionableHandle>();
                ArrayList<IContributor> contributorsOfFetch = new ArrayList<IContributor>();
                int i = 0;
                while (i < versionableHandles.size()) {
                    IPath path;
                    IVersionableHandle versionableHandle = (IVersionableHandle)versionableHandles.get(i);
                    IContributor contributor = null;
                    if (contributors.size() - 1 >= i) {
                        contributor = (IContributor)contributors.get(i);
                    }
                    if ((path = LockListCmd.getLocalPath((IComponentHandle)component, versionableHandle)) == null) {
                        toFetch.add(versionableHandle);
                        contributorsOfFetch.add(contributor);
                    } else {
                        LockEntry entry = new LockEntry(stream, component, versionableHandle, LOCAL, path.toOSString(), contributor);
                        lockEntries.add(entry);
                    }
                    ++i;
                }
                if (toFetch.isEmpty()) continue;
                IConfiguration configuration = null;
                try {
                    configuration = workspaceConnection.configuration((IComponentHandle)component);
                }
                catch (ItemNotFoundException e) {
                    throw StatusHelper.itemNotFound((String)e.getLocalizedMessage());
                }
                catch (ComponentNotInWorkspaceException e) {
                    throw StatusHelper.itemNotFound((String)e.getLocalizedMessage());
                }
                try {
                    LockEntry entry;
                    String name;
                    String nameSource;
                    if (verbose) {
                        List ancestorReports = configuration.locateAncestors(toFetch, null);
                        int i2 = 0;
                        while (i2 < ancestorReports.size()) {
                            IAncestorReport ancestorReport = (IAncestorReport)ancestorReports.get(i2);
                            List nameItemPairs = ancestorReport.getNameItemPairs();
                            nameSource = UNKNOWN;
                            name = Messages.LockListCmd_Unknown;
                            if (nameItemPairs.size() > 1) {
                                StringBuilder path = new StringBuilder();
                                int j = 1;
                                while (j < nameItemPairs.size()) {
                                    INameItemPair pair = (INameItemPair)nameItemPairs.get(j);
                                    path.append('/');
                                    path.append(pair.getName());
                                    ++j;
                                }
                                nameSource = REMOTE;
                                name = path.toString();
                            }
                            entry = new LockEntry(stream, component, (IVersionableHandle)toFetch.get(i2), nameSource, name, (IContributor)contributorsOfFetch.get(i2));
                            lockEntries.add(entry);
                            ++i2;
                        }
                        continue;
                    }
                    List fetchedItems = configuration.fetchCompleteItems(toFetch, null);
                    int i3 = 0;
                    while (i3 < fetchedItems.size()) {
                        IVersionableHandle versionableHandle = (IVersionableHandle)toFetch.get(i3);
                        IVersionable versionable = (IVersionable)fetchedItems.get(i3);
                        nameSource = UNKNOWN;
                        name = Messages.LockListCmd_Unknown;
                        if (versionable != null) {
                            versionableHandle = versionable;
                            nameSource = REMOTE;
                            name = versionable.getName();
                        }
                        entry = new LockEntry(stream, component, versionableHandle, nameSource, name, (IContributor)contributorsOfFetch.get(i3));
                        lockEntries.add(entry);
                        ++i3;
                    }
                }
                catch (TeamRepositoryException e) {
                    throw StatusHelper.itemNotFound((String)e.getLocalizedMessage());
                }
            }
        }
        return lockEntries;
    }

    private static IPath getLocalPath(IComponentHandle componentHandle, IVersionableHandle versionableHandle) throws FileSystemClientException {
        Collection shareables = SharingManager.getInstance().findShareables(componentHandle, versionableHandle, null);
        Iterator iterator = shareables.iterator();
        if (iterator.hasNext()) {
            IShareable shareable = (IShareable)iterator.next();
            return shareable.getLocalPath();
        }
        return null;
    }

    private static void fetchCompleteItems(ITeamRepository repo, Collection<IStreamLockReport> streamLockReports, Map<UUID, IWorkspaceConnection> workspaceConnections, Map<UUID, IComponent> components, Map<UUID, IContributor> contributors, IClientConfiguration config) throws FileSystemClientException {
        ArrayList<IWorkspaceHandle> streamHandlesList = new ArrayList<IWorkspaceHandle>();
        HashMap<UUID, IComponentHandle> componentHandles = new HashMap<UUID, IComponentHandle>();
        HashMap<UUID, IContributorHandle> contributorHandles = new HashMap<UUID, IContributorHandle>();
        for (IStreamLockReport streamLockReport : streamLockReports) {
            IWorkspaceHandle streamHandle = streamLockReport.getStream();
            streamHandlesList.add(streamHandle);
            for (IComponentLockReport componentLockReport : streamLockReport.getComponentLocks()) {
                IComponentHandle componentHandle = componentLockReport.getComponent();
                componentHandles.put(componentHandle.getItemId(), componentHandle);
                for (IVersionableLock versionableLock : componentLockReport.getLocks()) {
                    IContributorHandle contributorHandle = versionableLock.getContributor();
                    contributorHandles.put(contributorHandle.getItemId(), contributorHandle);
                }
            }
        }
        LockListCmd.fetchCompleteItems(repo, workspaceConnections, components, contributors, streamHandlesList, componentHandles.values(), contributorHandles.values(), config);
    }

    public static void fetchCompleteItems(ITeamRepository repo, Map<UUID, IWorkspaceConnection> workspaceConnections, Map<UUID, IComponent> components, Map<UUID, IContributor> contributors, List<IWorkspaceHandle> streamHandlesList, Collection<IComponentHandle> componentHandles, Collection<IContributorHandle> contributorHandles, IClientConfiguration config) throws FileSystemClientException {
        try {
            List fetchedConnections = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnections(streamHandlesList, null);
            int i = 0;
            while (i < streamHandlesList.size()) {
                IWorkspaceConnection workspaceConnection = (IWorkspaceConnection)fetchedConnections.get(i);
                if (workspaceConnection == null) {
                    throw StatusHelper.itemNotFound((String)streamHandlesList.get(i).toString());
                }
                workspaceConnections.put(workspaceConnection.getResolvedWorkspace().getItemId(), workspaceConnection);
                ++i;
            }
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap(null, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
        }
        ArrayList<Object> toFetch = new ArrayList<Object>(componentHandles.size() + contributorHandles.size());
        toFetch.addAll(componentHandles);
        toFetch.addAll(contributorHandles);
        try {
            List fetchedItems = repo.itemManager().fetchCompleteItems(toFetch, 0, null);
            int i = 0;
            while (i < fetchedItems.size()) {
                IItem item = (IItem)fetchedItems.get(i);
                if (item == null) {
                    throw StatusHelper.itemNotFound((String)((IItemHandle)toFetch.get(i)).toString());
                }
                if (i < componentHandles.size()) {
                    components.put(item.getItemId(), (IComponent)item);
                } else {
                    contributors.put(item.getItemId(), (IContributor)item);
                }
                ++i;
            }
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap(null, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
        }
    }
}

