/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.lock;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.INamedOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.cliparser.IPositionalOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.NamedOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.Options;
import com.ibm.team.filesystem.cli.core.cliparser.PositionalOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.exceptions.ConflictingOptionException;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IOptionSource;
import com.ibm.team.filesystem.cli.core.util.ICopyFileAreaView;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsLock;
import com.ibm.team.filesystem.client.rest.parameters.ParmsLockResources;
import com.ibm.team.filesystem.client.rest.parameters.ParmsVersionable;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentFlowUtil;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.CoreUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.LockOperationFailureException;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockAcquireCmd
extends AbstractSubcommand
implements IOptionSource {
    private static final PositionalOptionDefinition OPT_FILES = new PositionalOptionDefinition("files", 1, -1);
    private static final NamedOptionDefinition OPT_COMPONENT = new NamedOptionDefinition("c", "component", 1);
    private static final NamedOptionDefinition OPT_REMOTE_PATH = new NamedOptionDefinition("R", "remotePath", 0);
    private String filesHelpMsg;
    private String lockingFolderPathMsg;
    private String lockingFolderMsg;

    public LockAcquireCmd() {
        this(Messages.LockAcquireCmd_OPT_FILES_HELP, Messages.LockAcquireCmd_LockingFolderPathIsUnsupported, Messages.LockAcquireCmd_LockingFoldersIsUnsupported);
    }

    protected LockAcquireCmd(String filesHelpMsg, String lockingFolderPathMsg, String lockingFolderMsg) {
        this.filesHelpMsg = filesHelpMsg;
        this.lockingFolderPathMsg = lockingFolderPathMsg;
        this.lockingFolderMsg = lockingFolderMsg;
    }

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_STREAM_SELECTOR, CommonOptions.OPT_STREAM_SELECTOR_HELP);
        options.addOption((INamedOptionDefinition)OPT_COMPONENT, Messages.LockAcquireCmd_OPT_COMPONENT_HELP);
        options.addOption((INamedOptionDefinition)OPT_REMOTE_PATH, Messages.LockAcquireCmd_OPT_REMOTEPATH_HELP);
        options.addOption((IPositionalOptionDefinition)OPT_FILES, this.filesHelpMsg);
        return options;
    }

    public void run(IClientConfiguration config) throws FileSystemClientException {
        ICommandLine cli = config.getSubcommandCommandLine();
        ITeamRepository repo = RepoUtil.loginUrlArgAnc((IClientConfiguration)config);
        IFilesystemRestClient client = SubcommandUtil.startDaemon((ISandbox[])config.getSandboxes(), (IClientConfiguration)config);
        SubcommandUtil.registerSandboxes((IFilesystemRestClient)client, (ISandbox[])config.getSandboxes(), (IClientConfiguration)config);
        ArrayList<IWorkspace> targetStreams = new ArrayList<IWorkspace>();
        if (cli.hasOption((IOptionKey)CommonOptions.OPT_STREAM_SELECTOR)) {
            try {
                String wsSelector = cli.getOption((IOptionKey)CommonOptions.OPT_STREAM_SELECTOR);
                IWorkspace workspace = RepoUtil.findNamedWorkspace((String)wsSelector, (boolean)false, (boolean)true, (ITeamRepository)repo, (IClientConfiguration)config);
                targetStreams.add(workspace);
            }
            catch (RepoUtil.UnmatchedSelectorException e) {
                SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)((Object)e), (IClientConfiguration)config);
                throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.CreateWorkspaceCmd_2, (Object)e.getSelector()));
            }
            catch (RepoUtil.AmbiguousSelectorException e) {
                SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)((Object)e), (IClientConfiguration)config);
                throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.CreateWorkspaceCmd_1, (Object)e.getSelector()));
            }
        }
        ICopyFileAreaView cfaView = SubcommandUtil.getAffectedComponentsAndShares((IClientConfiguration)config);
        List workspaceConnections = RepoUtil.getWorkspaceConnections((ICopyFileAreaView)cfaView, (boolean)true);
        ArrayList<IWorkspaceHandle> collaborationHandles = new ArrayList<IWorkspaceHandle>();
        for (IWorkspaceConnection workspaceConnection : workspaceConnections) {
            IWorkspaceHandle collaboration = ComponentFlowUtil.getCurrentCollaboration((IWorkspaceConnection)workspaceConnection);
            if (collaboration == null) continue;
            collaborationHandles.add(collaboration);
        }
        try {
            List fetchedWorkspaces = repo.itemManager().fetchCompleteItems(collaborationHandles, 0, null);
            targetStreams.addAll(fetchedWorkspaces);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap(null, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
        }
        Iterator iterator = targetStreams.iterator();
        while (iterator.hasNext()) {
            IWorkspace targetStream = (IWorkspace)iterator.next();
            if (targetStream.isStream()) continue;
            iterator.remove();
        }
        if (targetStreams.isEmpty()) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)((Object)new RepoUtil.UnmatchedSelectorException(RepoUtil.SelectorException.Type.STREAM, Messages.LockAcquireCmd_UNSPECIFIED, Collections.EMPTY_LIST)), (IClientConfiguration)config);
            throw StatusHelper.ambiguousSelector((String)Messages.LockAcquireCmd_UNMATCHED_STREAM);
        }
        IComponent componentHandle = null;
        IWorkspaceConnection targetConnection = null;
        if (cli.hasOption((IOptionKey)OPT_COMPONENT)) {
            String componentString = cli.getOption((IOptionKey)OPT_COMPONENT);
            if (targetStreams.size() > 1) {
                SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)((Object)new RepoUtil.AmbiguousSelectorException(RepoUtil.SelectorException.Type.STREAM, Messages.LockAcquireCmd_UNSPECIFIED, targetStreams, targetStreams)), (IClientConfiguration)config);
                throw StatusHelper.ambiguousSelector((String)Messages.LockAcquireCmd_AMBIGUOUS_STREAM);
            }
            try {
                targetConnection = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection((IWorkspaceHandle)targetStreams.get(0), null);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap(null, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
            }
            try {
                componentHandle = RepoUtil.findNamedComponent((String)componentString, (IWorkspaceConnection)targetConnection, (boolean)true, (IClientConfiguration)config);
            }
            catch (RepoUtil.UnmatchedSelectorException e) {
                SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)((Object)e), (IClientConfiguration)config);
                throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.LoadCmd_MATCHES_NO_COMPONENTS, (Object)componentString));
            }
            catch (RepoUtil.AmbiguousSelectorException e) {
                SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)((Object)e), (IClientConfiguration)config);
                throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.LoadCmd_MATCHES_TOO_MANY_COMPONENTS, (Object)componentString));
            }
        }
        List strPaths = cli.getOptions((IOptionKey)OPT_FILES);
        boolean remotePath = cli.hasOption((IOptionKey)OPT_REMOTE_PATH);
        List siloedItems = RepoUtil.findNamedVersionables((IClientConfiguration)config, (IWorkspaceConnection)targetConnection, componentHandle, (boolean)remotePath, (List)strPaths, (boolean)true, (boolean)false, (boolean)true, (String)this.lockingFolderPathMsg, (String)this.lockingFolderMsg);
        this.lock(cli, repo, client, targetStreams, siloedItems, config);
    }

    /*
     * Unable to fully structure code
     */
    protected void lock(ICommandLine cli, ITeamRepository repo, IFilesystemRestClient client, List<IWorkspace> targetStreams, List<SiloedItemId<IVersionable>> siloedItems, IClientConfiguration config) throws FileSystemClientException {
        locks = new ArrayList<ParmsLock>();
        for (IWorkspace targetStream : targetStreams) {
            for (SiloedItemId<IVersionable> siloedItem : siloedItems) {
                lock = new ParmsLock();
                lock.workspace = new ParmsWorkspace();
                lock.workspace.repositoryUrl = repo.getRepositoryURI();
                lock.workspace.workspaceItemId = targetStream.getItemId().getUuidValue();
                lock.componentItemId = siloedItem.getComponentUUID().getUuidValue();
                lock.versionable = new ParmsVersionable();
                itemType = siloedItem.getItemType();
                lock.versionable.versionableItemType = CoreUtil.getVersionableItemType((IItemType)itemType);
                lock.versionable.itemId = siloedItem.getItemUUID().getUuidValue();
                locks.add(lock);
            }
        }
        parms = new ParmsLockResources();
        parms.locks = locks.toArray(new ParmsLock[locks.size()]);
        try {
            client.postLockResources(parms, null);
        }
        catch (LockOperationFailureException e) {
            var14_18 = strings = e.getMessage().split("\r\n|\r|\n");
            var13_17 = strings.length;
            var12_15 = 0;
            ** while (var12_15 < var13_17)
        }
lbl-1000:
        // 1 sources

        {
            s = var14_18[var12_15];
            config.getContext().stderr().println(s);
            ++var12_15;
            continue;
        }
lbl31:
        // 1 sources

        throw StatusHelper.inappropriateArgument((String)Messages.LockAcquireCmd_ALREADY_LOCKED);
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap(null, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
        }
        config.getContext().stdout().println(Messages.LockAcquireCmd_LOCKS_SUCCESSFULLY_ACQUIRED);
    }
}

