/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.listcommand;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.INamedOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.cliparser.IPositionalOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.Options;
import com.ibm.team.filesystem.cli.core.cliparser.PositionalOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.exceptions.ConflictingOptionException;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IOptionSource;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IBaselineSetSearchCriteria;
import java.io.OutputStream;
import java.text.DateFormat;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class ListSnapshotsCmd
extends AbstractSubcommand
implements IOptionSource {
    public void run(IClientConfiguration config) throws FileSystemClientException {
        IWorkspaceConnection workspaceConnection;
        ConnectionInfo info = config.getConnectionInfo();
        ITeamRepository repo = RepoUtil.login((IClientConfiguration)config, (ConnectionInfo)info);
        ICommandLine cli = config.getSubcommandCommandLine();
        try {
            String wsSelector = cli.getOption(CommonOptions.OPT_WORKSPACE);
            workspaceConnection = RepoUtil.findNamedWorkspaceConnection((String)wsSelector, (boolean)true, (boolean)true, (ITeamRepository)repo, (IClientConfiguration)config);
        }
        catch (RepoUtil.UnmatchedSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)((Object)e), (IClientConfiguration)config);
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.CreateBaselineCmd_1, (Object)e.getSelector()));
        }
        catch (RepoUtil.AmbiguousSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)((Object)e), (IClientConfiguration)config);
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.CreateBaselineCmd_0, (Object)e.getSelector()));
        }
        int maxResults = RepoUtil.getMaxResultsOption((ICommandLine)cli);
        IBaselineSetSearchCriteria criteria = IBaselineSetSearchCriteria.FACTORY.newInstance();
        criteria.setOwnerWorkspaceOptional((IWorkspaceHandle)workspaceConnection.getResolvedWorkspace());
        List snapshots = null;
        try {
            List handles = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).findBaselineSets(criteria, maxResults, null);
            snapshots = repo.itemManager().fetchCompleteItems(handles, 0, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.ListSnapshotsCmd_1, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
        }
        IndentingPrintStream printStream = new IndentingPrintStream((OutputStream)config.getContext().stdout());
        DateFormat format = DateFormat.getDateTimeInstance(2, 3);
        boolean verbose = cli.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE);
        String message = Messages.ListSnapshotsCmd_0;
        for (IBaselineSet snapshot : snapshots) {
            String comment = null;
            if (verbose) {
                comment = snapshot.getComment();
                message = Messages.ListSnapshotsCmd_3;
                if (comment.length() == 0) {
                    message = Messages.ListSnapshotsCmd_4;
                }
            }
            printStream.println((CharSequence)NLS.bind((String)message, (Object[])new String[]{AliasUtil.selector((String)snapshot.getName(), (UUID)snapshot.getItemId()), format.format(snapshot.getCreationDate()), comment}));
        }
    }

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(true);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption((IPositionalOptionDefinition)new PositionalOptionDefinition(CommonOptions.OPT_WORKSPACE, "workspace", 1, 1), Messages.ListSnapshotsCmd_5);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_VERBOSE, Messages.ListSnapshotsCmd_2);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_MAXRESULTS, CommonOptions.OPT_MAXRESULTS_HELP);
        return options;
    }
}

