/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.listcommand;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.listcommand.ListRemoteFilesOptions;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.StringUtil;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.ComponentNotInWorkspaceException;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.util.NLS;

public class ListRemoteFilesCmd
extends AbstractSubcommand {
    static final int DEPTH_INFINITE = -1;

    public void run(IClientConfiguration config) throws FileSystemClientException {
        IFolderHandle root;
        IConfiguration compConfig;
        ICommandLine cli = config.getSubcommandCommandLine();
        int depth = -1;
        String depthString = cli.getOption(ListRemoteFilesOptions.OPT_DEPTH, null);
        if (depthString != null && !"-".equals(depthString)) {
            try {
                depth = Integer.parseInt(depthString);
            }
            catch (NumberFormatException numberFormatException) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ListRemoteFilesCmd_5, (Object)depthString));
            }
        }
        ConnectionInfo info = config.getConnectionInfo();
        ITeamRepository repo = RepoUtil.login((IClientConfiguration)config, (ConnectionInfo)info);
        String wsSelector = cli.getOption(CommonOptions.OPT_WORKSPACE);
        IWorkspaceConnection wsConn = this.findNamedWorkspaceConnection(wsSelector, repo, config);
        String cSelector = cli.getOption((IOptionKey)CommonOptions.OPT_COMPONENT_SELECTOR);
        IComponentHandle cHandle = this.findNamedComponent(cSelector, wsConn, config);
        try {
            compConfig = wsConn.configuration(cHandle);
        }
        catch (ItemNotFoundException e) {
            throw StatusHelper.failure((String)NLS.bind((String)Messages.ListRemoteFilesCmd_0, (Object)wsConn.getName(), (Object)cSelector), (Throwable)e);
        }
        catch (ComponentNotInWorkspaceException e) {
            throw StatusHelper.failure((String)NLS.bind((String)Messages.ListRemoteFilesCmd_1, (Object)wsConn.getName(), (Object)cSelector), (Throwable)e);
        }
        IndentingPrintStream out = new IndentingPrintStream((OutputStream)config.getContext().stdout());
        String[] segments = new String[]{};
        try {
            root = compConfig.rootFolderHandle(null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.ListRemoteFilesCmd_6, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
        }
        String rootPath = cli.getOption(ListRemoteFilesOptions.OPT_REMOTE_PATH, null);
        if (rootPath != null) {
            IVersionableHandle remoteRoot;
            segments = StringUtil.splitEscapedPath((String)rootPath);
            try {
                remoteRoot = compConfig.resolvePath(root, segments, null);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)NLS.bind((String)Messages.ListRemoteFilesCmd_2, (Object)StringUtil.createPathString((String[])segments)), (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
            }
            if (remoteRoot == null) {
                throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.ListRemoteFilesCmd_3, (Object)StringUtil.createPathString((String[])segments)));
            }
            if (remoteRoot instanceof IFileItemHandle) {
                out.println((CharSequence)StringUtil.createPathString((String[])segments));
                return;
            }
            if (remoteRoot instanceof IFolderHandle) {
                root = (IFolderHandle)remoteRoot;
            } else {
                throw StatusHelper.failure((String)NLS.bind((String)Messages.ListRemoteFilesCmd_4, (Object)remoteRoot.getClass().getName()), null);
            }
        }
        this.showFiles(wsConn, compConfig, root, segments, depth, out, config);
    }

    private void showFiles(IWorkspaceConnection wsConn, IConfiguration compConfig, IFolderHandle root, String[] rootPath, int maxDepth, IndentingPrintStream out, IClientConfiguration config) throws FileSystemClientException {
        out.println((CharSequence)this.toPath(rootPath, true));
        List<IFolderHandle> folders = Collections.singletonList(root);
        List<String[]> ancestorPaths = Collections.singletonList(rootPath);
        int depth = 0;
        while (folders.size() > 0 && (maxDepth == -1 || depth++ < maxDepth)) {
            List offspring;
            try {
                offspring = compConfig.childEntries(folders, null);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)Messages.ListRemoteFilesCmd_8, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
            }
            assert (folders.size() == offspring.size());
            assert (folders.size() == ancestorPaths.size());
            int folderCount = 0;
            int i = 0;
            while (i < folders.size()) {
                String ancestor = this.toPath(ancestorPaths.get(i), true);
                for (Map.Entry entry : ((Map)offspring.get(i)).entrySet()) {
                    boolean isFolder = entry.getValue() instanceof IFolderHandle;
                    out.println((CharSequence)(String.valueOf(ancestor) + (String)entry.getKey() + (isFolder ? Character.valueOf('/') : "")));
                    if (!isFolder) continue;
                    ++folderCount;
                }
                ++i;
            }
            if (maxDepth != -1 && depth >= maxDepth) break;
            ArrayList<IFolderHandle> nextFolders = new ArrayList<IFolderHandle>(folderCount);
            ArrayList<String[]> nextAncestorPaths = new ArrayList<String[]>(folderCount);
            int i2 = 0;
            while (i2 < folders.size()) {
                for (Map.Entry entry : ((Map)offspring.get(i2)).entrySet()) {
                    if (!(entry.getValue() instanceof IFolderHandle)) continue;
                    nextFolders.add((IFolderHandle)((IVersionableHandle)entry.getValue()));
                    nextAncestorPaths.add(this.copyWithNewSegment(ancestorPaths.get(i2), (String)entry.getKey()));
                }
                ++i2;
            }
            folders = nextFolders;
            ancestorPaths = nextAncestorPaths;
        }
    }

    private String[] copyWithNewSegment(String[] segments, String newSegment) {
        if (segments.length == 0) {
            return new String[]{newSegment};
        }
        String[] newSegments = new String[segments.length + 1];
        System.arraycopy(segments, 0, newSegments, 0, segments.length);
        newSegments[segments.length] = newSegment;
        return newSegments;
    }

    private String toPath(String[] path, boolean isFolder) {
        return String.valueOf(StringUtil.createPathString((String[])path)) + (isFolder ? Character.valueOf('/') : "");
    }

    private IWorkspaceConnection findNamedWorkspaceConnection(String wsSelector, ITeamRepository repo, IClientConfiguration config) throws FileSystemClientException {
        try {
            return RepoUtil.findNamedWorkspaceConnection((String)wsSelector, (boolean)true, (boolean)true, (ITeamRepository)repo, (IClientConfiguration)config);
        }
        catch (RepoUtil.UnmatchedSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)((Object)e), (IClientConfiguration)config);
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.CreateBaselineCmd_1, (Object)e.getSelector()));
        }
        catch (RepoUtil.AmbiguousSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)((Object)e), (IClientConfiguration)config);
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.CreateBaselineCmd_0, (Object)e.getSelector()));
        }
    }

    private IComponentHandle findNamedComponent(String cSelector, IWorkspaceConnection workspaceConnection, IClientConfiguration config) throws FileSystemClientException {
        List cHandles;
        try {
            cHandles = RepoUtil.findNamedComponents(Collections.singletonList(cSelector), (boolean)false, (IWorkspaceConnection)workspaceConnection, (ITeamRepository)workspaceConnection.teamRepository(), (boolean)true, (IClientConfiguration)config);
        }
        catch (RepoUtil.UnmatchedSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)((Object)e), (IClientConfiguration)config);
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.ListRemoteFilesCmd_9, (Object)e.getSelector()));
        }
        catch (RepoUtil.AmbiguousSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)((Object)e), (IClientConfiguration)config);
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.ListRemoteFilesCmd_10, (Object)e.getSelector()));
        }
        switch (cHandles.size()) {
            case 0: {
                throw StatusHelper.failure((String)NLS.bind((String)Messages.ListRemoteFilesCmd_11, (Object)cSelector), null);
            }
            case 1: {
                return (IComponentHandle)cHandles.get(0);
            }
        }
        throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.ListRemoteFilesCmd_12, (Object)cSelector));
    }
}

