/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.listcommand;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.cliparser.INamedOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.cliparser.Options;
import com.ibm.team.filesystem.cli.core.cliparser.exceptions.ConflictingOptionException;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IOptionSource;
import com.ibm.team.filesystem.cli.core.subcommands.IRepositoryRecord;
import com.ibm.team.filesystem.cli.core.subcommands.IRepositoryRegistry;
import com.ibm.team.filesystem.client.FileSystemClientException;
import org.eclipse.osgi.util.NLS;

public class ListCredentialsCmd
extends AbstractSubcommand
implements IOptionSource {
    public void run(IClientConfiguration config) throws FileSystemClientException {
        IRepositoryRegistry repoReg = config.getRepositoryRegistry();
        if (config.getSubcommandCommandLine().hasOption((IOptionKey)CommonOptions.OPT_VERBOSE)) {
            config.getContext().stdout().println(Messages.ListRepositoriesCmd_0);
        }
        for (IRepositoryRecord rec : repoReg) {
            String nick;
            String userName = rec.getUsername();
            if (userName == null) {
                userName = Messages.ListRepositoriesCmd_1;
            }
            if ((nick = rec.getNickname()) == null) {
                nick = Messages.ListRepositoriesCmd_2;
            }
            String password = Messages.ListRepositoriesCmd_3;
            if (rec.getPassword() == null) {
                password = Messages.ListRepositoriesCmd_4;
            }
            config.getContext().stdout().println(NLS.bind((String)Messages.ListRepositoriesCmd_5, (Object[])new Object[]{rec.getUrl(), userName, nick, password}));
        }
    }

    public Options getOptions() throws ConflictingOptionException {
        Options opts = new Options(false);
        opts.addOption((INamedOptionDefinition)CommonOptions.OPT_VERBOSE, Messages.ListRepositoriesCmd_6);
        return opts;
    }
}

