/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.listcommand;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.PendingChangesUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class ListComponentsCmd
extends AbstractSubcommand {
    public void run(IClientConfiguration config) throws FileSystemClientException {
        ConnectionInfo info = config.getConnectionInfo();
        ITeamRepository repo = RepoUtil.login((IClientConfiguration)config, (ConnectionInfo)info);
        ICommandLine cli = config.getSubcommandCommandLine();
        String wsSelector = cli.getOption(CommonOptions.OPT_WORKSPACE);
        boolean isSnapshot = cli.hasOption(CommonOptions.OPT_ISSNAPSHOT);
        if (isSnapshot) {
            ListComponentsCmd.listComponentsForSnapshot(repo, cli, wsSelector, config);
        } else {
            ListComponentsCmd.listComponentsForWorkspace(repo, cli, wsSelector, config);
        }
    }

    private static void listComponentsForSnapshot(ITeamRepository repo, ICommandLine cli, String selector, IClientConfiguration config) throws FileSystemClientException {
        try {
            IBaselineSetHandle snapshotHandle = RepoUtil.findNamedSnapshot((String)selector, (ITeamRepository)repo, (IClientConfiguration)config);
            try {
                IBaselineSet snapshot = (IBaselineSet)repo.itemManager().fetchCompleteItem((IItemHandle)snapshotHandle, 0, null);
                List baselineHandles = snapshot.getBaselines();
                List baselines = repo.itemManager().fetchCompleteItems(baselineHandles, 0, null);
                ArrayList<IComponentHandle> componentHandles = new ArrayList<IComponentHandle>();
                HashMap<UUID, IBaseline> componentToBaseline = new HashMap<UUID, IBaseline>();
                for (IBaseline baseline : baselines) {
                    IComponentHandle component = baseline.getComponent();
                    componentHandles.add(component);
                    componentToBaseline.put(component.getItemId(), baseline);
                }
                List components = repo.itemManager().fetchCompleteItems(componentHandles, 0, null);
                boolean verbose = cli.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE);
                IndentingPrintStream snapshotPS = new IndentingPrintStream((OutputStream)config.getContext().stdout());
                IndentingPrintStream componentPS = snapshotPS.indent();
                IndentingPrintStream baselinePS = componentPS.indent();
                snapshotPS.println((CharSequence)NLS.bind((String)Messages.ListComponentsCmd_Snapshot, (Object)AliasUtil.selector((String)snapshot.getName(), (UUID)snapshot.getItemId())));
                ArrayList sortedComponents = new ArrayList(components);
                Collections.sort(sortedComponents, new Comparator<IComponent>(){

                    @Override
                    public int compare(IComponent o1, IComponent o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
                int i = 0;
                while (i < sortedComponents.size()) {
                    IComponent component = (IComponent)sortedComponents.get(i);
                    componentPS.println((CharSequence)NLS.bind((String)Messages.ListComponentsCmd_Component, (Object)AliasUtil.selector((String)component.getName(), (UUID)component.getItemId())));
                    if (verbose) {
                        IBaseline baseline = (IBaseline)componentToBaseline.get(component.getItemId());
                        baselinePS.println((CharSequence)NLS.bind((String)Messages.ListComponentsCmd_Baseline, (Object)AliasUtil.selector((int)baseline.getId(), (String)baseline.getName(), (UUID)baseline.getItemId())));
                    }
                    ++i;
                }
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)Messages.ListComponentsCmd_UnableToGetSnapshotTRE, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
            }
        }
        catch (RepoUtil.UnmatchedSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)((Object)e), (IClientConfiguration)config);
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.ListComponentsCmd_SnapshotNotFound, (Object)e.getSelector()));
        }
        catch (RepoUtil.AmbiguousSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)((Object)e), (IClientConfiguration)config);
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.ListComponentsCmd_SnapshotSelectorIsAmbiguous, (Object)e.getSelector()));
        }
    }

    private static void listComponentsForWorkspace(ITeamRepository repo, ICommandLine cli, String wsSelector, IClientConfiguration config) throws FileSystemClientException {
        IWorkspaceConnection workspaceConnection;
        try {
            workspaceConnection = RepoUtil.findNamedWorkspaceConnection((String)wsSelector, (boolean)true, (boolean)true, (ITeamRepository)repo, (IClientConfiguration)config);
        }
        catch (RepoUtil.UnmatchedSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)((Object)e), (IClientConfiguration)config);
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.CreateBaselineCmd_1, (Object)e.getSelector()));
        }
        catch (RepoUtil.AmbiguousSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)((Object)e), (IClientConfiguration)config);
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.CreateBaselineCmd_0, (Object)e.getSelector()));
        }
        PendingChangesUtil.PendingChangesOptions options = new PendingChangesUtil.PendingChangesOptions();
        options.enablePrinter(1);
        if (cli.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE)) {
            options.enablePrinter(11);
        }
        PendingChangesUtil.printWorkspace((IWorkspaceConnection)workspaceConnection, (PendingChangesUtil.PendingChangesOptions)options, (IClientConfiguration)config);
    }
}

