/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.listcommand;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.listcommand.ListCmdContribOptions;
import com.ibm.team.filesystem.cli.client.internal.listcommand.ListStreamsOptions;
import com.ibm.team.filesystem.cli.client.internal.writers.ListCmdWriter;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.process.client.IProcessClientService;
import com.ibm.team.process.client.IProcessItemService;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.repository.client.IContributorManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IWorkspaceSearchCriteria;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListCmd
extends AbstractSubcommand {
    private static final String LIST_PROJECT_AREAS_ID = "com.ibm.team.filesystem.cli.client.list/com.ibm.team.filesystem.cli.client.list-projectareas";
    private static final String LIST_TEAM_AREAS_ID = "com.ibm.team.filesystem.cli.client.list/com.ibm.team.filesystem.cli.client.list-teamareas";
    private static final String LIST_STREAMS_ID = "com.ibm.team.filesystem.cli.client.list/com.ibm.team.filesystem.cli.client.list-streams";
    private static final String LIST_WORKSPACES_ID = "com.ibm.team.filesystem.cli.client.list/com.ibm.team.filesystem.cli.client.list-workspaces";

    public void run(IClientConfiguration config) throws FileSystemClientException {
        String id;
        ICommandLine subargs = config.getSubcommandCommandLine();
        ConnectionInfo connection = config.getConnectionInfo();
        boolean verbose = subargs.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE);
        String contribName = connection.getUsername();
        if (subargs.hasOption(ListCmdContribOptions.OPT_CONTRIB)) {
            contribName = subargs.getOption(ListCmdContribOptions.OPT_CONTRIB);
        }
        if (LIST_PROJECT_AREAS_ID.equals(id = config.getSubcommandDefinition().getId())) {
            this.listProjectAreas(config, connection, verbose);
        } else if (LIST_TEAM_AREAS_ID.equals(id)) {
            this.listTeamAreas(config, connection, contribName, verbose);
        } else if (LIST_STREAMS_ID.equals(id)) {
            int maxResults = RepoUtil.getMaxResultsOption((ICommandLine)subargs);
            String projectAreaName = "";
            if (subargs.hasOption(ListStreamsOptions.OPT_PROJECTAREA)) {
                if (subargs.hasOption(ListCmdContribOptions.OPT_CONTRIB)) {
                    throw StatusHelper.argSyntax((String)Messages.ListCmd_MUTUALLYEXCLUSIVE_CONTRIB_PROJECTAREA);
                }
                projectAreaName = subargs.getOption(ListStreamsOptions.OPT_PROJECTAREA);
            }
            this.listStreams(config, connection, contribName, projectAreaName, maxResults, verbose);
        } else if (LIST_WORKSPACES_ID.equals(id)) {
            int maxResults = RepoUtil.getMaxResultsOption((ICommandLine)subargs);
            this.listWorkspaces(config, connection, contribName, maxResults, verbose);
        } else {
            throw StatusHelper.configurationFailure((String)NLS.bind((String)Messages.ListCmd_1, (Object)id));
        }
    }

    private void listProjectAreas(IClientConfiguration config, ConnectionInfo connection, boolean verbose) throws FileSystemClientException {
        List projectAreas;
        ITeamRepository repo = RepoUtil.login((IClientConfiguration)config, (ConnectionInfo)connection);
        IProcessItemService itemService = (IProcessItemService)repo.getClientLibrary(IProcessItemService.class);
        try {
            projectAreas = itemService.findAllProjectAreas(IProcessClientService.ALL_PROPERTIES, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)NLS.bind((String)Messages.ListCmd_3, (Object)e.getMessage()), (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
        }
        for (IProjectArea projectArea : projectAreas) {
            List teamAreas;
            config.getContext().stdout().println(projectArea.getName());
            if (!verbose) continue;
            try {
                teamAreas = repo.itemManager().fetchPartialItems(projectArea.getTeamAreas(), 0, Collections.singletonList("name"), null);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)NLS.bind((String)Messages.ListCmd_4, (Object)projectArea.getName()), (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
            }
            for (ITeamArea teamArea : teamAreas) {
                config.getContext().stdout().println("    " + teamArea.getName());
            }
        }
    }

    private void listTeamAreas(IClientConfiguration config, ConnectionInfo connection, String contribId, boolean verbose) throws FileSystemClientException {
        ITeamRepository repo = RepoUtil.login((IClientConfiguration)config, (ConnectionInfo)connection);
        List<ITeamArea> teamAreas = this.findTeamAreasFor(config, connection, contribId, repo);
        for (ITeamArea teamArea : teamAreas) {
            config.getContext().stdout().println(teamArea.getName());
        }
    }

    private List<ITeamArea> findTeamAreasFor(IClientConfiguration config, ConnectionInfo connection, String contribName, ITeamRepository repo) throws FileSystemClientException {
        List projectAreas;
        IContributor currentContributor = this.getContributor(connection, contribName, repo, config);
        IProcessItemService itemService = (IProcessItemService)repo.getClientLibrary(IProcessItemService.class);
        try {
            projectAreas = itemService.findAllProjectAreas(IProcessClientService.ALL_PROPERTIES, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)NLS.bind((String)Messages.ListCmd_6, (Object)e.getMessage()), (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
        }
        ArrayList<ITeamArea> toReturn = new ArrayList<ITeamArea>(projectAreas.size());
        for (IProjectArea projectArea : projectAreas) {
            List teamAreas;
            try {
                teamAreas = itemService.findTeamAreas(currentContributor, (IProjectAreaHandle)projectArea, IProcessClientService.ALL_PROPERTIES, null);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)Messages.ListCmd_7, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
            }
            toReturn.addAll(teamAreas);
        }
        return toReturn;
    }

    private void listStreams(IClientConfiguration config, ConnectionInfo connection, String contribName, String projectAreaName, int maxResults, boolean verbose) throws FileSystemClientException {
        List streams;
        DefaultListCmdWriter writer = new DefaultListCmdWriter();
        writer.setVerbose(verbose);
        ITeamRepository repo = RepoUtil.login((IClientConfiguration)config, (ConnectionInfo)connection);
        IWorkspaceSearchCriteria criteria = IWorkspaceSearchCriteria.FACTORY.newInstance().setKind(1);
        if (projectAreaName.length() != 0) {
            List teamAreas;
            IProjectArea projectArea = this.getProjectArea(repo, projectAreaName, config);
            if (projectArea == null) {
                throw StatusHelper.failure((String)NLS.bind((String)Messages.ListCmd_NOPROJECTAREA, (Object)projectAreaName), null);
            }
            criteria.getFilterByOwnerOptional().addAll(Collections.singleton(projectArea));
            try {
                teamAreas = repo.itemManager().fetchCompleteItems(projectArea.getTeamAreas(), 0, null);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)NLS.bind((String)Messages.ListCmd_4, (Object)projectArea.getName()), (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
            }
            criteria.getFilterByOwnerOptional().addAll(teamAreas);
        } else {
            List<ITeamArea> teamAreas = this.findTeamAreasFor(config, connection, contribName, repo);
            if (teamAreas.size() == 0) {
                config.getContext().stderr().println(Messages.ListCmd_9);
                return;
            }
            criteria.getFilterByOwnerOptional().addAll(teamAreas);
        }
        try {
            List handles = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).findWorkspaces(criteria, maxResults, null);
            streams = repo.itemManager().fetchCompleteItems(handles, 0, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.ListCmd_10, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
        }
        writer.listStreams(config, repo, streams);
    }

    private void listWorkspaces(IClientConfiguration config, ConnectionInfo connection, String contribId, int maxResults, boolean verbose) throws FileSystemClientException {
        List auditables;
        ITeamRepository repo = RepoUtil.login((IClientConfiguration)config, (ConnectionInfo)connection);
        IContributor currentContributor = this.getContributor(connection, contribId, repo, config);
        IWorkspaceSearchCriteria criteria = IWorkspaceSearchCriteria.FACTORY.newInstance().setKind(2);
        criteria.getFilterByOwnerOptional().add(currentContributor);
        try {
            List handles = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).findWorkspaces(criteria, maxResults, null);
            auditables = repo.itemManager().fetchCompleteItems(handles, 0, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.ListCmd_12, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
        }
        HashMap<UUID, IComponent> components = new HashMap<UUID, IComponent>();
        HashMap<UUID, List> ws2component = new HashMap<UUID, List>();
        if (verbose) {
            LinkedList allComponentHandles = new LinkedList();
            for (IWorkspace workspace : auditables) {
                IWorkspaceConnection wsConn;
                IWorkspaceManager manager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
                try {
                    wsConn = manager.getWorkspaceConnection((IWorkspaceHandle)workspace, null);
                }
                catch (TeamRepositoryException e) {
                    throw StatusHelper.wrap((String)NLS.bind((String)Messages.ListCmd_13, (Object)workspace.getName()), (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
                }
                try {
                    List handles = wsConn.getComponents();
                    ws2component.put(workspace.getItemId(), handles);
                    allComponentHandles.addAll(handles);
                }
                catch (TeamRepositoryException e) {
                    throw StatusHelper.wrap((String)NLS.bind((String)Messages.ListCmd_14, (Object)workspace.getName()), (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
                }
            }
            List allComponents = null;
            try {
                allComponents = repo.itemManager().fetchPartialItems(allComponentHandles, 0, Collections.singletonList(IComponent.NAME_PROPERTY), null);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)Messages.ListCmd_15, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
            }
            for (IComponent comp : allComponents) {
                components.put(comp.getItemId(), comp);
            }
        }
        IndentingPrintStream out = new IndentingPrintStream((OutputStream)config.getContext().stdout());
        for (IWorkspace workspace : auditables) {
            out.println((CharSequence)AliasUtil.selector((AliasUtil.IAliasOptions)config.getAliasConfig(), (String)workspace.getName(), (UUID)workspace.getItemId()));
            if (!verbose) continue;
            IndentingPrintStream verboseOut = out.indent();
            for (IComponentHandle handle : (List)ws2component.get(workspace.getItemId())) {
                String output = AliasUtil.selector((AliasUtil.IAliasOptions)config.getAliasConfig(), (String)((IComponent)components.get(handle.getItemId())).getName(), (UUID)handle.getItemId());
                verboseOut.println((CharSequence)output);
            }
        }
    }

    private IContributor getContributor(ConnectionInfo info, String contribName, ITeamRepository repo, IClientConfiguration config) throws FileSystemClientException {
        if (info.getUsername().equals(contribName)) {
            return repo.loggedInContributor();
        }
        IContributorManager lookup = repo.contributorManager();
        try {
            return lookup.fetchContributorByUserId(contribName, null);
        }
        catch (ItemNotFoundException itemNotFoundException) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ListCmd_21, (Object)contribName));
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.ListCmd_22, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
        }
    }

    private IProjectArea getProjectArea(ITeamRepository repo, String projectAreaName, IClientConfiguration config) throws FileSystemClientException {
        List projectAreas;
        IProcessItemService itemService = (IProcessItemService)repo.getClientLibrary(IProcessItemService.class);
        try {
            projectAreas = itemService.findAllProjectAreas(IProcessClientService.ALL_PROPERTIES, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)NLS.bind((String)Messages.ListCmd_6, (Object)e.getMessage()), (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
        }
        IProjectArea projectArea = null;
        for (IProjectArea pa : projectAreas) {
            if (!pa.getName().equals(projectAreaName)) continue;
            projectArea = pa;
        }
        return projectArea;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultListCmdWriter
    extends ListCmdWriter {
        private DefaultListCmdWriter() {
        }

        @Override
        public void listStreams(IClientConfiguration config, ITeamRepository repo, Collection<IWorkspace> streams) {
            super.listStreams(config, repo, streams);
            HashMap<String, Integer> count = new HashMap<String, Integer>();
            for (IWorkspace workspace : streams) {
                String name = workspace.getName();
                if (count.containsKey(name)) {
                    count.put(name, (Integer)count.get(name) + 1);
                    continue;
                }
                count.put(name, 1);
            }
            boolean verbose = this.getVerbose();
            for (IWorkspace workspace : streams) {
                boolean showUUID;
                String name = workspace.getName();
                boolean bl = showUUID = verbose || (Integer)count.get(name) > 1;
                if (showUUID) {
                    config.getContext().stdout().println(AliasUtil.selector((AliasUtil.IAliasOptions)config.getAliasConfig(), (String)name, (UUID)workspace.getItemId()));
                    continue;
                }
                config.getContext().stdout().println(name);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ListableThing {
        PROJECT_AREAS,
        TEAM_AREAS,
        STREAMS,
        WORKSPACES,
        CONTRIBUTORS;

    }
}

