/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.handler;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UncheckedInChangesHandler {
    private int uncheckedInChanges;
    private Map<ConfigurationDescriptor, Collection<ILocalChange>> map = new HashMap<ConfigurationDescriptor, Collection<ILocalChange>>();

    public UncheckedInChangesHandler(int uncheckedInChanges) {
        this.uncheckedInChanges = uncheckedInChanges;
    }

    public int uncheckedInChanges(Map<ConfigurationDescriptor, Collection<ILocalChange>> changes) {
        for (Map.Entry<ConfigurationDescriptor, Collection<ILocalChange>> entry : changes.entrySet()) {
            Collection<ILocalChange> localChanges = this.map.get(entry.getKey());
            if (localChanges == null) {
                localChanges = new ArrayList<ILocalChange>();
                this.map.put(entry.getKey(), localChanges);
            }
            localChanges.addAll(entry.getValue());
        }
        return this.uncheckedInChanges;
    }

    public void throwExceptions() throws FileSystemClientException {
        if (this.uncheckedInChanges == 1 && !this.map.isEmpty()) {
            ArrayList<String> paths = new ArrayList<String>();
            for (Map.Entry<ConfigurationDescriptor, Collection<ILocalChange>> entry : this.map.entrySet()) {
                for (ILocalChange localChange : entry.getValue()) {
                    paths.add(localChange.getPath().toOSString());
                }
            }
            Collections.sort(paths);
            StringBuilder builder = new StringBuilder(Messages.UncheckedInChangesHandler_0);
            for (String path : paths) {
                builder.append("\n");
                builder.append(path);
            }
            throw StatusHelper.uncheckedInChanges((String)builder.toString());
        }
    }
}

