/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.flowcommands.conflicthandlers;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.flowcommands.conflicthandlers.AbstractConflictHandler;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.filesystem.common.ILogicalConflict;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IVersionableManager;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IItemConflictReport;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.compare.rangedifferencer.RangeDifferencer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InPlaceConflictHandler
extends AbstractConflictHandler {
    public static final String MARKER_MY_SECTION = "<<<<<<< mine";
    public static final String MARKER_PROPOSED = "=======";
    public static final String MARKER_END = ">>>>>>> proposed";
    private Map<UUID, IItemConflictReport> indexedConflicts = null;

    private IItemConflictReport findConflictFor(IVersionableHandle item) {
        IItemConflictReport report2;
        if (this.indexedConflicts == null) {
            this.indexedConflicts = new HashMap<UUID, IItemConflictReport>();
            for (IItemConflictReport report2 : this.getReport().conflicts()) {
                UUID key = report2.item().getItemId();
                this.indexedConflicts.put(key, report2);
            }
        }
        if ((report2 = this.indexedConflicts.get(item.getItemId())) == null) {
            throw new IllegalStateException(NLS.bind((String)Messages.InPlaceConflictHandler_0, (Object)item.getItemId().getUuidValue()));
        }
        return report2;
    }

    public void writeDiff(IPath toWrite, BufferedReader ancestorReader, BufferedReader leftReader, BufferedReader rightReader, OutputStreamWriter output) throws FileSystemClientException, IOException {
        LineRangeComparator ancestor = this.streamToComparator(ancestorReader);
        LineRangeComparator left = this.streamToComparator(leftReader);
        LineRangeComparator right = this.streamToComparator(rightReader);
        Writer writer = new Writer(output);
        if (left == null || right == null) {
            if (left != null) {
                writer.write(left);
            } else {
                assert (right != null);
                writer.write(right);
            }
            return;
        }
        RangeDifference[] diffs = RangeDifferencer.findRanges((IRangeComparator)ancestor, (IRangeComparator)left, (IRangeComparator)right);
        RangeDifference[] rangeDifferenceArray = diffs;
        int n = diffs.length;
        int n2 = 0;
        while (n2 < n) {
            RangeDifference diff = rangeDifferenceArray[n2];
            switch (diff.kind()) {
                case 0: {
                    writer.write(ancestor, diff.ancestorStart(), diff.ancestorEnd());
                    break;
                }
                case 3: {
                    writer.write(left, diff.leftStart(), diff.leftEnd());
                    break;
                }
                case 2: {
                    writer.write(right, diff.rightStart(), diff.rightEnd());
                    break;
                }
                case 4: {
                    writer.write(left, diff.leftStart(), diff.leftEnd());
                    break;
                }
                case 1: {
                    writer.write(MARKER_MY_SECTION);
                    writer.write(left, diff.leftStart(), diff.leftEnd());
                    writer.write(MARKER_PROPOSED);
                    writer.write(right, diff.rightStart(), diff.rightEnd());
                    writer.write(MARKER_END);
                    break;
                }
                default: {
                    throw StatusHelper.failure((String)("Unexpected RangeDifference.kind(): " + diff.kind()), null);
                }
            }
            ++n2;
        }
    }

    private LineRangeComparator streamToComparator(BufferedReader reader) throws IOException {
        String line;
        if (reader == null) {
            return null;
        }
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            lines.add(line);
        }
        return new LineRangeComparator(lines.toArray(new String[lines.size()]));
    }

    @Override
    protected void writeConflict(IPath cfaRoot, IPath myPath, IPath proposedPath, IWorkspaceConnection wsConn, ILogicalChange change, IClientConfiguration config) throws FileSystemClientException {
        List fetched;
        OutputStream bytes;
        BufferedReader right;
        BufferedReader left;
        BufferedReader ancestor;
        OutputStreamWriter out;
        ILogicalConflict conflict;
        block9: {
            if (change.kind() != 1) {
                return;
            }
            conflict = (ILogicalConflict)change;
            if (conflict.conflictType() != 9) {
                return;
            }
            Assert.isNotNull((Object)myPath);
            out = null;
            ancestor = null;
            left = null;
            right = null;
            try {
                bytes = this.findOutputStreamFor(cfaRoot, myPath, conflict);
                if (bytes != null) break block9;
                this.safeClose(out);
                this.safeClose(ancestor);
                this.safeClose(left);
                this.safeClose(right);
                return;
            }
            catch (Throwable throwable) {
                this.safeClose(out);
                this.safeClose(ancestor);
                this.safeClose(left);
                this.safeClose(right);
                throw throwable;
            }
        }
        ITeamRepository repo = wsConn.teamRepository();
        IItemConflictReport conflictReport = this.findConflictFor(conflict.item());
        ArrayList<IVersionableHandle> items = new ArrayList<IVersionableHandle>(3);
        items.add(conflictReport.getCommonAncestorState());
        items.add(conflictReport.getOriginalSelectedContributorState());
        items.add(conflictReport.getProposedContributorState());
        try {
            IVersionableManager versionableManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).versionableManager();
            fetched = versionableManager.fetchCompleteStates(items, null);
            ancestor = this.fetchReaderForFileItem(repo, (IFileItem)fetched.get(0));
            left = this.fetchReaderForFileItem(repo, (IFileItem)fetched.get(1));
            right = this.fetchReaderForFileItem(repo, (IFileItem)fetched.get(2));
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)NLS.bind((String)Messages.InPlaceConflictHandler_3, (Object)myPath), (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
        }
        Assert.isTrue((left != null && right != null ? 1 : 0) != 0);
        out = new OutputStreamWriter(bytes, this.getEncodingFor(fetched));
        IPath path = cfaRoot.append(myPath);
        try {
            this.writeDiff(path, ancestor, left, right, out);
        }
        catch (IOException e) {
            throw StatusHelper.failure((String)NLS.bind((String)Messages.InPlaceConflictHandler_3, (Object)myPath), (Throwable)e);
        }
        this.safeClose(out);
        this.safeClose(ancestor);
        this.safeClose(left);
        this.safeClose(right);
    }

    private Charset getEncodingFor(List<IFileItem> fetched) {
        int[] order;
        int[] nArray = order = new int[]{1, 2};
        int n = order.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            IFileItem item = fetched.get(i);
            if (item != null && item.getContent() != null) {
                String encoding = item.getContent().getCharacterEncoding();
                try {
                    return Charset.forName(encoding);
                }
                catch (IllegalCharsetNameException illegalCharsetNameException) {
                }
                catch (UnsupportedCharsetException unsupportedCharsetException) {}
            }
            ++n2;
        }
        return Charset.defaultCharset();
    }

    private BufferedReader fetchReaderForFileItem(ITeamRepository repo, IFileItem item) throws TeamRepositoryException {
        if (item == null || item.getContent() == null) {
            return null;
        }
        Charset cs = Charset.defaultCharset();
        try {
            cs = Charset.forName(item.getContent().getCharacterEncoding());
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {}
        InputStream stream = FileSystemCore.getContentManager((ITeamRepository)repo).retrieveContentStream((IFileItemHandle)item, item.getContent(), null);
        return new BufferedReader(new InputStreamReader(stream, cs));
    }

    private OutputStream findOutputStreamFor(IPath cfaRoot, IPath path, ILogicalConflict conflictReport) throws FileSystemClientException {
        if (conflictReport.beforeState() == null || conflictReport.afterState() == null) {
            return null;
        }
        try {
            return new FileOutputStream(cfaRoot.append(path).toFile());
        }
        catch (FileNotFoundException e) {
            throw StatusHelper.failure((String)NLS.bind((String)Messages.InPlaceConflictHandler_4, (Object)path), (Throwable)e);
        }
    }

    private final void safeClose(Closeable toClose) {
        if (toClose != null) {
            try {
                toClose.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static class LineRangeComparator
    implements IRangeComparator {
        private final String[] lines;

        public LineRangeComparator(String[] lines) {
            this.lines = lines;
        }

        public int getRangeCount() {
            return this.lines.length;
        }

        public boolean rangesEqual(int thisIndex, IRangeComparator other, int otherIndex) {
            if (thisIndex > this.getRangeCount()) {
                return false;
            }
            if (otherIndex > other.getRangeCount()) {
                return false;
            }
            LineRangeComparator otherLrc = (LineRangeComparator)other;
            String s1 = this.lines[thisIndex];
            String s2 = otherLrc.lines[otherIndex];
            if (s1.length() == s2.length() && s1.hashCode() == s2.hashCode()) {
                return s1.equals(s2);
            }
            return false;
        }

        public boolean skipRangeComparison(int length, int maxLength, IRangeComparator other) {
            return false;
        }
    }

    static final class Writer {
        private static final String NEWLINE = System.getProperty("line.separator");
        final OutputStreamWriter out;

        public Writer(OutputStreamWriter output) {
            this.out = output;
        }

        public void write(String s) throws IOException {
            this.out.write(s);
            this.out.write(NEWLINE);
        }

        public void write(LineRangeComparator comp, int start, int end) throws IOException {
            int i = start;
            while (i < end) {
                this.write(comp.lines[i]);
                ++i;
            }
        }

        public void write(LineRangeComparator comp) throws IOException {
            int i = 0;
            while (i < comp.lines.length) {
                this.write(comp.lines[i]);
                ++i;
            }
        }
    }
}

