/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.flowcommands;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.flowcommands.AbstractFlowGroup;
import com.ibm.team.filesystem.cli.client.internal.flowcommands.RefreshHelper;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.cli.core.util.WorkspaceComponentGrouping;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.Sandbox;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.TempHelper;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFlowTable;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.WorkspaceComparisonFlags;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import com.ibm.team.workitem.common.model.IWorkItem;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class FlowCmd
extends AbstractSubcommand {
    protected IPath cwd = null;
    protected ISandbox cfaRoot = null;
    protected boolean quiet;
    protected boolean verbose;
    protected boolean usingScratchCFA;

    FlowCmd() {
    }

    protected final Collection<WorkspaceComponentGrouping> findSubject(IClientConfiguration config, String srcSelector) throws FileSystemClientException {
        if (srcSelector == null) {
            assert (this.cfaRoot != null);
            if (config.getSubcommandCommandLine().hasOption((IOptionKey)CommonOptions.OPT_URI)) {
                throw StatusHelper.argSyntax((String)Messages.FlowCmd_1);
            }
            Map rootShares = SubcommandUtil.getAffectedShareRoots((ISandbox)this.cfaRoot, (IPath)this.cwd);
            HashMap connections = new HashMap();
            ArrayList<WorkspaceComponentGrouping> groupings = new ArrayList<WorkspaceComponentGrouping>();
            for (Map.Entry entry : rootShares.entrySet()) {
                ISharingDescriptor desc = ((IShare)entry.getKey()).getSharingDescriptor();
                String repoURI = desc.getRepositoryUri();
                IContextHandle context = desc.getConnectionHandle();
                HashMap<UUID, WorkspaceComponentGrouping> byWorkspace = (HashMap<UUID, WorkspaceComponentGrouping>)connections.get(repoURI);
                WorkspaceComponentGrouping grouping = null;
                if (byWorkspace != null) {
                    grouping = (WorkspaceComponentGrouping)byWorkspace.get(context.getItemId());
                }
                if (grouping == null) {
                    IWorkspaceConnection wsConn;
                    if (!desc.associatedWithWorkspace()) {
                        throw StatusHelper.internalError((String)NLS.bind((String)Messages.FlowCmd_2, (Object)desc.getRepositoryUri(), (Object)desc.getConnectionName()));
                    }
                    ConnectionInfo info = config.getConnectionInfo(repoURI, null, (IOptionKey)CommonOptions.OPT_USERNAME, (IOptionKey)CommonOptions.OPT_PASSWORD);
                    ITeamRepository repo = RepoUtil.login((IClientConfiguration)config, (ConnectionInfo)info);
                    try {
                        wsConn = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection((IWorkspaceHandle)context, null);
                    }
                    catch (TeamRepositoryException e) {
                        throw StatusHelper.wrap((String)NLS.bind((String)Messages.FlowCmd_3, (Object)repo.getRepositoryURI(), (Object)desc.getConnectionName()), (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
                    }
                    LinkedList comps = new LinkedList();
                    grouping = new WorkspaceComponentGrouping(wsConn, comps, config);
                    byWorkspace = new HashMap<UUID, WorkspaceComponentGrouping>();
                    byWorkspace.put(context.getItemId(), grouping);
                    connections.put(repoURI, byWorkspace);
                    groupings.add(grouping);
                }
                grouping.addComponent(desc.getComponent());
            }
            return groupings;
        }
        ITeamRepository repo = RepoUtil.login((IClientConfiguration)config, (ConnectionInfo)config.getConnectionInfo());
        try {
            IWorkspaceConnection wsConn = RepoUtil.findNamedWorkspaceConnection((String)srcSelector, (boolean)true, (boolean)true, (ITeamRepository)repo, (IClientConfiguration)config);
            return Collections.singletonList(new WorkspaceComponentGrouping(wsConn, wsConn.getComponents(), config));
        }
        catch (RepoUtil.UnmatchedSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)e, (IClientConfiguration)config);
            throw StatusHelper.ambiguousSelector((String)Messages.FlowCmd_4);
        }
        catch (RepoUtil.AmbiguousSelectorException e) {
            SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)e, (IClientConfiguration)config);
            throw StatusHelper.ambiguousSelector((String)Messages.FlowCmd_5);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.FlowCmd_6, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
        }
    }

    private List<AbstractFlowGroup> getCollaboration(List<AbstractFlowGroup> toFlow, IWorkspaceConnection wsConn, Collection<IComponentHandle> components, IClientConfiguration config) throws FileSystemClientException {
        LinkedList<IComponentHandle> nonCollabCompHandles = new LinkedList<IComponentHandle>();
        IFlowTable flowTable = wsConn.getFlowTable();
        for (IComponentHandle component : components) {
            IWorkspaceHandle componentCollab = this.findCollaboration(wsConn, flowTable, component);
            if (componentCollab == null) {
                nonCollabCompHandles.add(component);
                continue;
            }
            this.updateFlowGroups(toFlow, wsConn, component, componentCollab, config);
        }
        if (nonCollabCompHandles.size() > 0) {
            List nonCollabComponents;
            IndentingPrintStream err = new IndentingPrintStream((OutputStream)config.getContext().stderr());
            try {
                nonCollabComponents = wsConn.teamRepository().itemManager().fetchCompleteItems(nonCollabCompHandles, 0, null);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)Messages.FlowCmd_ERR_FETCH_COMPONENT, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
            }
            err.println((CharSequence)Messages.FlowCmd_NO_DEFAULT_COLLABORATION);
            err = err.indent();
            for (IComponent component : nonCollabComponents) {
                err.println((CharSequence)AliasUtil.selector((String)component.getName(), (UUID)component.getItemId()));
            }
            throw StatusHelper.misconfiguredLocalFS((String)NLS.bind((String)Messages.FlowCmd_NO_DEFAULT_COLLABORATION_ERROR, (Object)wsConn.getName()));
        }
        return toFlow;
    }

    private void updateFlowGroups(List<AbstractFlowGroup> toFlow, IWorkspaceConnection subject, IComponentHandle component, IWorkspaceHandle collabHandle, IClientConfiguration config) throws FileSystemClientException {
        IWorkspaceConnection collab;
        IContextHandle subjectHandle = subject.getContextHandle();
        for (AbstractFlowGroup flow : toFlow) {
            if (!flow.sameSubjectAndCollab(subjectHandle.getItemId(), collabHandle.getItemId())) continue;
            flow.includedComponents.add(component);
            return;
        }
        try {
            collab = SCMPlatform.getWorkspaceManager((ITeamRepository)subject.teamRepository()).getWorkspaceConnection(collabHandle, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)NLS.bind((String)Messages.FlowCmd_9, (Object)collabHandle.getItemId()), (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
        }
        AbstractFlowGroup group = this.createFlowGroup(subject, collab);
        group.includedComponents.add(component);
        toFlow.add(group);
    }

    protected final AbstractFlowGroup createFlowGroup(IWorkspaceConnection start, IWorkspaceConnection collab) {
        return this.createFlowGroup(start, new LinkedList<IComponentHandle>(), collab);
    }

    protected abstract AbstractFlowGroup createFlowGroup(IWorkspaceConnection var1, List<IComponentHandle> var2, IWorkspaceConnection var3);

    protected abstract IWorkspaceHandle findCollaboration(IWorkspaceConnection var1, IFlowTable var2, IComponentHandle var3);

    protected abstract IWorkspaceHandle findTargetWorkspace(IWorkspaceConnection var1, IFlowTable var2) throws FileSystemClientException;

    protected void pruneChangeSets(List<AbstractFlowGroup> toFlow, List<String> csSelectors, IClientConfiguration config) throws FileSystemClientException, RepoUtil.UnmatchedSelectorException {
        Assert.isTrue((csSelectors != null ? 1 : 0) != 0);
        HashSet<String> selectorSet = new HashSet<String>();
        selectorSet.addAll(csSelectors);
        HashSet matchedSelectors = new HashSet();
        for (AbstractFlowGroup flow : toFlow) {
            List<Object> csHandles = new ArrayList<IChangeSetHandle>(flow.getAllChangesToFlow());
            try {
                csHandles = RepoUtil.pruneToNamedChangeSets((IWorkspaceConnection)flow.getSource(), csHandles, selectorSet, matchedSelectors, (IClientConfiguration)config);
            }
            catch (RepoUtil.UnmatchedSelectorException unmatchedSelectorException) {
                csHandles = null;
            }
            flow.setChangesToFlow(csHandles);
        }
        HashSet<String> unmatched = new HashSet<String>();
        unmatched.addAll(csSelectors);
        unmatched.removeAll(matchedSelectors);
        if (unmatched.size() > 0) {
            throw new RepoUtil.UnmatchedSelectorException(RepoUtil.SelectorException.Type.CHANGESET, unmatched, null);
        }
    }

    protected final List<AbstractFlowGroup> findCollaboration(Collection<WorkspaceComponentGrouping> workspaces, String collabSelector, IClientConfiguration config) throws FileSystemClientException {
        LinkedList<AbstractFlowGroup> toFlow = new LinkedList<AbstractFlowGroup>();
        if (collabSelector != null) {
            IWorkspaceConnection collab;
            if (workspaces.size() > 1) {
                throw StatusHelper.argSyntax((String)Messages.FlowCmd_11);
            }
            WorkspaceComponentGrouping grouping = workspaces.iterator().next();
            try {
                collab = RepoUtil.findNamedWorkspaceConnection((String)collabSelector, (boolean)true, (boolean)true, (ITeamRepository)grouping.getWorkspaceConnection().teamRepository(), (IClientConfiguration)config);
            }
            catch (RepoUtil.UnmatchedSelectorException e) {
                SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)e, (IClientConfiguration)config);
                throw StatusHelper.ambiguousSelector((String)Messages.FlowCmd_12);
            }
            catch (RepoUtil.AmbiguousSelectorException e) {
                SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)e, (IClientConfiguration)config);
                throw StatusHelper.ambiguousSelector((String)Messages.FlowCmd_13);
            }
            IWorkspaceConnection source = grouping.getWorkspaceConnection();
            return Collections.singletonList(this.findFlowTargetsForWorkspace(source, collab, grouping.getComponents(), config));
        }
        for (WorkspaceComponentGrouping wsComp : workspaces) {
            this.getCollaboration(toFlow, wsComp.getWorkspaceConnection(), wsComp.getComponents(), config);
        }
        return toFlow;
    }

    private AbstractFlowGroup findFlowTargetsForWorkspace(IWorkspaceConnection source, IWorkspaceConnection target, Collection<IComponentHandle> includeComponents, IClientConfiguration config) throws FileSystemClientException {
        List components;
        IFlowTable flowTable = source.getFlowTable();
        IWorkspaceHandle currentCollab = this.findTargetWorkspace(source, flowTable);
        IWorkspaceHandle targetWS = (IWorkspaceHandle)target.getContextHandle();
        try {
            components = source.getComponents();
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.FlowCmd_15, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
        }
        ArrayList<UUID> includeComponentUUIDs = new ArrayList<UUID>(includeComponents.size());
        for (IComponentHandle component : includeComponents) {
            includeComponentUUIDs.add(component.getItemId());
        }
        ArrayList<IComponentHandle> componentsToFlow = new ArrayList<IComponentHandle>();
        for (IComponentHandle component : components) {
            IWorkspaceHandle componentCollab;
            if (!includeComponentUUIDs.contains(component.getItemId()) || (componentCollab = this.findCollaboration(source, flowTable, component)) != null && currentCollab != null && !currentCollab.sameItemId((IItemHandle)componentCollab) && !targetWS.sameItemId((IItemHandle)componentCollab)) continue;
            componentsToFlow.add(component);
        }
        return this.createFlowGroup(source, componentsToFlow, target);
    }

    protected abstract IOptionKey getFlowSourceOptKey();

    protected void setCfaRoot(IClientConfiguration config) throws FileSystemClientException {
        File pathToRoot;
        String pathToCwd;
        ICommandLine subargs = config.getSubcommandCommandLine();
        if (subargs.hasOption((IOptionKey)CommonOptions.OPT_DIRECTORY)) {
            pathToCwd = subargs.getOption((IOptionKey)CommonOptions.OPT_DIRECTORY);
            pathToRoot = SubcommandUtil.findAncestorCFARoot((String)pathToCwd);
            if (pathToRoot == null) {
                throw StatusHelper.misconfiguredLocalFS((String)NLS.bind((String)Messages.FlowCmd_16, (Object)pathToRoot));
            }
            if (!PathUtils.exists((IPath)new Path(pathToCwd), (IProgressMonitor)TempHelper.MONITOR)) {
                throw StatusHelper.argSyntax((String)(String.valueOf(Messages.FlowCmd_17) + pathToCwd));
            }
        } else if (subargs.hasOption(this.getFlowSourceOptKey())) {
            pathToRoot = config.getConfigDirectory();
            pathToCwd = pathToRoot.getPath();
            this.usingScratchCFA = true;
        } else {
            pathToRoot = SubcommandUtil.findAncestorCFARoot((String)config.getContext().getCurrentWorkingDirectory());
            if (pathToRoot == null) {
                throw StatusHelper.argSyntax((String)Messages.FlowCmd_18);
            }
            pathToCwd = config.getContext().getCurrentWorkingDirectory();
            if (!PathUtils.exists((IPath)new Path(config.getContext().getCurrentWorkingDirectory()), (IProgressMonitor)TempHelper.MONITOR)) {
                throw StatusHelper.argSyntax((String)(String.valueOf(Messages.FlowCmd_19) + pathToCwd));
            }
        }
        if (config.getContext().getDaemon() == null) {
            SubcommandUtil.initializeEclipseWorkspaceRoot((File)pathToRoot);
        }
        if (!this.usingScratchCFA) {
            this.cfaRoot = new Sandbox((IPath)new Path(pathToRoot.getAbsolutePath()));
            SharingManager.getInstance().register(this.cfaRoot, true, null);
        }
        this.cwd = new Path(SubcommandUtil.canonicalize((String)pathToCwd));
    }

    public void run(IClientConfiguration config) throws FileSystemClientException {
        ICommandLine subargs = config.getSubcommandCommandLine();
        List csSelectors = null;
        boolean includeBaselines = true;
        if (subargs.hasOption((IOptionKey)CommonOptions.OPT_CHANGESET_SELECTORS)) {
            csSelectors = subargs.getOptions((IOptionKey)CommonOptions.OPT_CHANGESET_SELECTORS);
            includeBaselines = false;
        }
        includeBaselines = csSelectors == null;
        this.quiet = subargs.hasOption((IOptionKey)CommonOptions.OPT_QUIET);
        this.verbose = subargs.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE);
        if (this.quiet && this.verbose) {
            throw StatusHelper.argSyntax((String)Messages.FlowCmd_22);
        }
        this.setCfaRoot(config);
        this.handleArguments(subargs);
        if (!this.usingScratchCFA) {
            RefreshHelper.refresh(this.cfaRoot.getRoot());
        }
        List<AbstractFlowGroup> toFlow = this.findFlows(config);
        for (AbstractFlowGroup flow : toFlow) {
            try {
                flow.syncReport = flow.getSubject().compareTo((IFlowNodeConnection)flow.getCollab(), includeBaselines ? WorkspaceComparisonFlags.INCLUDE_BASELINE_INFO : WorkspaceComparisonFlags.CHANGE_SET_COMPARISON_ONLY, flow.getExcludedComponents(config), null);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)Messages.FlowCmd_23, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
            }
        }
        if (csSelectors != null) {
            try {
                this.pruneChangeSets(toFlow, csSelectors, config);
            }
            catch (RepoUtil.UnmatchedSelectorException e) {
                SubcommandUtil.displaySelectorException((RepoUtil.SelectorException)e, (IClientConfiguration)config);
                throw StatusHelper.ambiguousSelector((String)Messages.FlowCmd_24);
            }
        }
        if (!subargs.hasOption((IOptionKey)CommonOptions.OPT_QUIET)) {
            for (AbstractFlowGroup flow : toFlow) {
                this.showChanges(flow, this.verbose, config);
            }
        }
        this.flow(toFlow, config);
    }

    protected final boolean hasMismatchedComponents(IChangeHistorySyncReport syncReport) {
        HashSet<UUID> localUuids = new HashSet<UUID>();
        for (IComponentHandle cHandle : syncReport.localComponents()) {
            localUuids.add(cHandle.getItemId());
        }
        HashSet<UUID> remoteUuids = new HashSet<UUID>();
        for (IComponentHandle cHandle : syncReport.remoteComponents()) {
            remoteUuids.add(cHandle.getItemId());
        }
        return !localUuids.equals(remoteUuids);
    }

    protected void handleArguments(ICommandLine subargs) {
    }

    protected abstract void flow(List<AbstractFlowGroup> var1, IClientConfiguration var2) throws FileSystemClientException;

    protected abstract List<AbstractFlowGroup> findFlows(IClientConfiguration var1) throws FileSystemClientException;

    protected void showChanges(AbstractFlowGroup flow, boolean verbose, IClientConfiguration config) throws FileSystemClientException {
        List components;
        Object compHandle;
        List changes;
        List baselines;
        ITeamRepository repo = flow.getSource().teamRepository();
        IndentingPrintStream out = new IndentingPrintStream((OutputStream)config.getContext().stdout());
        out.println((CharSequence)this.findFlowDescription(flow));
        try {
            ArrayList<String> blProps = new ArrayList<String>(4);
            blProps.add(IBaseline.ID_PROPERTY);
            blProps.add(IBaseline.NAME_PROPERTY);
            blProps.add(IBaseline.COMMENT_PROPERTY);
            blProps.add(IBaseline.COMPONENT_PROPERTY);
            baselines = repo.itemManager().fetchPartialItems(flow.getBaselinesToFlow(), 0, blProps, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.FlowCmd_26, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
        }
        try {
            ArrayList<String> csProps = new ArrayList<String>(2);
            csProps.add(IChangeSet.COMMENT_PROPERTY);
            csProps.add(IChangeSet.COMPONENT_PROPERTY);
            changes = repo.itemManager().fetchPartialItems(flow.getChangesToFlow(), 0, csProps, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.FlowCmd_27, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
        }
        ArrayList<String> wiProps = new ArrayList<String>(2);
        wiProps.add(IWorkItem.SUMMARY_PROPERTY);
        wiProps.add(IWorkItem.ID_PROPERTY);
        HashMap<UUID, IComponent> componentsByUUID = new HashMap<UUID, IComponent>();
        HashMap<UUID, IComponentHandle> componentUUIDs = new HashMap<UUID, IComponentHandle>();
        for (IBaseline baseline : baselines) {
            compHandle = baseline.getComponent();
            componentUUIDs.put(compHandle.getItemId(), (IComponentHandle)compHandle);
        }
        for (IChangeSetHandle cs : changes) {
            compHandle = ((IChangeSet)cs).getComponent();
            componentUUIDs.put(cs.getItemId(), (IComponentHandle)compHandle);
        }
        try {
            ArrayList comps = new ArrayList(componentUUIDs.size());
            comps.addAll(componentUUIDs.values());
            components = repo.itemManager().fetchPartialItems(comps, 0, Collections.singletonList(IComponent.NAME_PROPERTY), null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.FlowCmd_28, (TeamRepositoryException)e, (IndentingPrintStream)new IndentingPrintStream((OutputStream)config.getContext().stderr()));
        }
        for (IComponent comp : components) {
            componentsByUUID.put(comp.getItemId(), comp);
        }
        IndentingPrintStream indented = out.indent();
        if (baselines.size() == 0) {
            indented.println((CharSequence)Messages.FlowCmd_29);
        } else {
            indented.println((CharSequence)Messages.FlowCmd_30);
            indented = indented.indent();
            for (IBaseline baseline : baselines) {
                String cName = ((IComponent)componentsByUUID.get(baseline.getComponent().getItemId())).getName();
                String blId = Integer.toString(baseline.getId());
                String blName = baseline.getName();
                indented.println((CharSequence)NLS.bind((String)Messages.FlowCmd_31, (Object[])new Object[]{cName, blId, blName}));
                String comment = baseline.getComment();
                if (!verbose) {
                    comment = SubcommandUtil.sanitizeText((String)comment, (int)60, (boolean)true);
                }
                if (comment.length() == 0) continue;
                indented.indent().println((CharSequence)NLS.bind((String)Messages.FlowCmd_32, (Object)comment));
            }
        }
    }

    protected abstract String findFlowDescription(AbstractFlowGroup var1);
}

